/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.ReadHeadFileException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class Head
extends JPanel
implements Printable,
Serializable {
    private static final Logger _LOG = Logger.getLogger(Head.class.getPackage().getName());
    private List rows = new ArrayList();
    private MyTableHeader focusedHeader = null;
    private MyTableHeader editingHeader = null;
    private MyHeaderEditor editor = new MyHeaderEditor();
    private int focusedCol = -1;
    private int editingCol = -1;
    public boolean printing = false;

    public Head() {
        super(new GridBagLayout());
        this.init();
    }

    public Head(File file) throws ReadHeadFileException {
        super(new GridBagLayout());
        this.init();
        if (!this.read(file)) {
            throw new ReadHeadFileException();
        }
    }

    public Head(InputStream is) throws ReadHeadFileException {
        super(new GridBagLayout());
        this.init();
        if (!this.read(is)) {
            throw new ReadHeadFileException();
        }
    }

    private void init() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getRowCount(); ++i) {
            MyTableHeader header = (MyTableHeader)this.getRow(i).getColumnHeader().getView();
            header.setEnabled(enabled);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public JScrollPane getRow(int i) {
        return (JScrollPane)this.rows.get(i);
    }

    public Component getSelectedRow() {
        if (this.focusedHeader == null) {
            return null;
        }
        return (Component)this.rows.get(this.getRowPosition(this.focusedHeader));
    }

    public Component addRow() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        MyTableHeader header = new MyTableHeader(model);
        header.setPreferredSize(new Dimension(10, 50));
        JScrollPane scpane = (JScrollPane)this.createRow(header);
        this.addRow(scpane);
        return scpane;
    }

    public void removeRow(Component component) {
        MyTableHeader header = (MyTableHeader)((JScrollPane)component).getColumnHeader().getView();
        if (header == this.editingHeader) {
            this.editingHeader = null;
            this.editingCol = -1;
        }
        if (header == this.focusedHeader) {
            this.focusedHeader = null;
            this.focusedCol = -1;
        }
        this.rows.remove(component);
        this.remove(component);
        this.revalidate();
        this.repaint();
    }

    public void setPrinting(boolean value) {
        this.printing = value;
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        this.printing = true;
        Graphics2D g = (Graphics2D)graphics;
        g.translate(pf.getImageableX(), pf.getImageableY());
        Rectangle rect = this.getBounds();
        double sx = pf.getImageableWidth() / rect.getWidth();
        double sy = pf.getImageableHeight() / rect.getHeight();
        double scale = Math.min(sx, sy);
        g.scale(scale, scale);
        this.print(g);
        this.printing = false;
        return 0;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JScrollPane scpane = (JScrollPane)this.getComponent(i);
            scpane.setCursor(cursor);
            scpane.getColumnHeader().getView().setCursor(cursor);
            scpane.getViewport().getView().setCursor(cursor);
        }
    }

    public int getRowPosition(MyTableHeader header) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (header != this.getRow(i).getColumnHeader().getView()) continue;
            return i;
        }
        return -1;
    }

    public void setPreferredRowSize(JScrollPane scpane, Dimension d) {
        scpane.getColumnHeader().setPreferredSize(d);
        MyTableHeader header = (MyTableHeader)scpane.getColumnHeader().getView();
        header.setPreferredSize(d);
        header.resizeAndRepaint();
    }

    public void scale(double scale) {
        this.scaleTextFont(scale);
        this.scaleRowHeight(scale);
    }

    public void storeProperties() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.getRowTableHeader(i).storeProperties();
        }
    }

    public void restoreProperties() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.getRowTableHeader(i).restoreProperties();
            Dimension d = new Dimension(0, this.getRowTableHeader(i).getSavedHeight());
            this.setPreferredRowSize(this.getRow(i), d);
        }
    }

    public void refresh() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            MyTableHeader header = (MyTableHeader)this.getRow(i).getColumnHeader().getView();
            this.setPreferredRowSize(this.getRow(i), header.getPreferredSize());
        }
        this.revalidate();
        this.repaint();
    }

    public boolean read(File file) {
        try {
            return this.read(new FileInputStream(file.getAbsolutePath()));
        }
        catch (FileNotFoundException ex) {
            _LOG.log(Level.INFO, "Probleme de lecture d'un fichier Head AMDEC", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(InputStream is) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            this.readObject(ois);
            boolean bl = true;
            return bl;
        }
        catch (ClassNotFoundException ex) {
            _LOG.log(Level.INFO, "Probleme de lecture d'un flux Head AMDEC", ex);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            _LOG.log(Level.INFO, "Probleme de lecture d'un flux Head AMDEC", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean write(File file) {
        try {
            return this.write(new FileOutputStream(file.getAbsolutePath()));
        }
        catch (FileNotFoundException ex) {
            _LOG.log(Level.INFO, "Probleme d'\u00e9criture d'un fichier Head AMDEC", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(OutputStream os) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(os);
            this.writeObject(oos);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            _LOG.log(Level.INFO, "Probleme d'\u00e9criture d'un flux Head AMDEC", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addRow(Component row) {
        this.rows.add(row);
        this.add(row, new GridBagConstraints(0, this.getRowCount() - 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
    }

    protected Component createRow(MyTableHeader header) {
        JTable table = new JTable(null, header.getColumnModel());
        table.setTableHeader(header);
        table.setPreferredScrollableViewportSize(new Dimension(0, 0));
        table.setEnabled(true);
        table.setFocusable(false);
        JScrollPane scpane = new JScrollPane(table);
        scpane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scpane;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int len = this.rows.size();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            MyTableHeader header = (MyTableHeader)((JScrollPane)this.rows.get(i)).getColumnHeader().getView();
            header.writeObject(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.rows.clear();
        this.removeAll();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            MyTableHeader header = new MyTableHeader();
            header.readObject(in);
            JScrollPane row = (JScrollPane)this.createRow(header);
            this.addRow(row);
        }
    }

    private void scaleRowHeight(double scale) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            MyTableHeader header = (MyTableHeader)this.getRow(i).getColumnHeader().getView();
            Dimension d = header.getPreferredSize();
            d.setSize(0.0, d.getHeight() * scale);
            this.setPreferredRowSize(this.getRow(i), d);
        }
    }

    private void scaleTextFont(double scale) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            JTable table = this.getRowTable(i);
            Font f = table.getFont();
            table.setFont(new Font(f.getFamily(), f.getStyle(), (int)((double)f.getSize() * scale)));
        }
    }

    private JTable getRowTable(int i) {
        return (JTable)this.getRow(i).getViewport().getView();
    }

    private MyTableHeader getRowTableHeader(int i) {
        return (MyTableHeader)this.getRowTable(i).getTableHeader();
    }

    public class MyHeaderEditor
    extends DefaultCellEditor {
        public MyHeaderEditor() {
            super(new JTextField());
            Head.this.setBorder(new LineBorder(Color.black, 2));
            ((JTextField)this.editorComponent).setHorizontalAlignment(0);
            this.editorComponent.addKeyListener(new MyKeyListener());
        }
    }

    public class MyHeaderRenderer
    extends DefaultTableCellRenderer {
        public MyHeaderRenderer() {
            this.setBorder(new LineBorder(Color.black, 1));
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(Head.this.printing ? null : new LineBorder(Color.black, 1));
            this.setFont(table.getFont());
            this.setBackground(Color.white);
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public class PopupMouseListener
    implements MouseListener {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() != 1) {
                return;
            }
            if ((e.getButton() & 2) == 0) {
                return;
            }
            final Point p = e.getPoint();
            final MyTableHeader header = (MyTableHeader)e.getSource();
            JPopupMenu popup = new JPopupMenu();
            JMenuItem split = new JMenuItem(Messages.getString("Head.2"));
            split.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TableColumn column;
                    TableColumnModel model = header.getColumnModel();
                    int idx = header.columnAtPoint(p);
                    TableColumn[] columns = new TableColumn[model.getColumnCount() - idx];
                    int count = model.getColumnCount();
                    for (int c = count - 1; c >= idx; --c) {
                        column = model.getColumn(c);
                        model.removeColumn(column);
                        column.setModelIndex(c + 1);
                        columns[c - idx] = column;
                    }
                    int width = columns[0].getWidth() / 2 - 1;
                    columns[0].setPreferredWidth(width);
                    column = new TableColumn(idx, width);
                    column.setHeaderValue(Messages.getString("Head.1"));
                    column.setHeaderRenderer(new MyHeaderRenderer());
                    model.addColumn(column);
                    for (int c = 0; c < columns.length; ++c) {
                        model.addColumn(columns[c]);
                    }
                    header.resizeAndRepaint();
                }
            });
            JMenuItem remove = new JMenuItem(Messages.getString("Head.4"));
            remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TableColumnModel model = header.getColumnModel();
                    int idx = header.columnAtPoint(p);
                    model.removeColumn(model.getColumn(idx));
                    if (model.getColumnCount() == 0) {
                        Head.this.removeRow(Head.this.getRow(Head.this.getRowPosition(header)));
                    }
                }
            });
            popup.add(split);
            popup.add(remove);
            popup.show((Component)e.getSource(), e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class ResizeMouseMotionListener
    implements MouseMotionListener,
    MouseListener {
        private Cursor oldCursor = null;
        private int lastY = 0;
        private boolean initDrawGhost = true;
        private int resizedRow = -1;
        private int startPos = -1;
        final int offset = 5;

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.oldCursor == null) {
                return;
            }
            MyTableHeader header = (MyTableHeader)e.getSource();
            Rectangle rect = Head.this.getBounds();
            Point p = SwingUtilities.convertPoint(header, e.getPoint(), Head.this);
            Graphics2D g = (Graphics2D)Head.this.getGraphics();
            g.setXORMode(Color.white);
            if (!this.initDrawGhost) {
                g.drawLine(0, this.lastY, rect.width, this.lastY);
            }
            this.initDrawGhost = false;
            this.lastY = (int)p.getY();
            g.drawLine(0, this.lastY, rect.width, this.lastY);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.closedVerticalSide(e) != -1) {
                return;
            }
            if (this.closedHorizontalSide(e) != -1) {
                if (this.oldCursor == null) {
                    this.oldCursor = Head.this.getCursor();
                }
                Head.this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                Cursor cursor = this.oldCursor;
                this.oldCursor = null;
                Head.this.setCursor(cursor);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int height = 0;
            Point p = SwingUtilities.convertPoint((MyTableHeader)e.getSource(), e.getPoint(), Head.this);
            this.startPos = p.y;
            for (int i = 0; i < Head.this.getRowCount(); ++i) {
                MyTableHeader header = (MyTableHeader)Head.this.getRow(i).getColumnHeader().getView();
                if (Math.abs(p.getY() - (double)height - header.getBounds().getHeight()) < 5.0) {
                    this.resizedRow = i;
                    break;
                }
                height = (int)((double)height + header.getBounds().getHeight());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MyTableHeader header = (MyTableHeader)e.getSource();
            if (this.closedHorizontalSide(e) == -1 && this.oldCursor != null) {
                Head.this.setCursor(this.oldCursor);
            }
            if (this.resizedRow != -1) {
                Point p = SwingUtilities.convertPoint(header, e.getPoint(), Head.this);
                int diff = p.y - this.startPos;
                JScrollPane scpane = Head.this.getRow(this.resizedRow);
                Dimension dim = new Dimension(10, scpane.getPreferredSize().height + diff);
                scpane.getColumnHeader().getView();
                Head.this.setPreferredRowSize(scpane, dim);
                if (this.resizedRow < Head.this.getRowCount() - 1) {
                    scpane = Head.this.getRow(this.resizedRow + 1);
                    dim = new Dimension(10, scpane.getPreferredSize().height - diff);
                    scpane.getColumnHeader().getView();
                }
            }
            this.initDrawGhost = true;
            this.resizedRow = -1;
            JScrollPane scpane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, Head.this);
            scpane.revalidate();
            scpane.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public int closedHorizontalSide(MouseEvent e) {
            MyTableHeader header = (MyTableHeader)e.getSource();
            Rectangle rect = header.getBounds();
            if (Math.abs(e.getY() - rect.y) < 5) {
                return rect.y;
            }
            if (Math.abs(e.getY() - rect.y - rect.height) < 5) {
                return rect.y + rect.height;
            }
            return -1;
        }

        public int closedVerticalSide(MouseEvent e) {
            MyTableHeader header = (MyTableHeader)e.getSource();
            TableColumnModel cm = header.getColumnModel();
            for (int i = 0; i < cm.getColumnCount(); ++i) {
                Rectangle rect = header.getHeaderRect(i);
                if (Math.abs(e.getX() - rect.x) < 5) {
                    return rect.x;
                }
                if (Math.abs(e.getX() - rect.x - rect.width) >= 5) continue;
                return rect.x + rect.width;
            }
            return -1;
        }
    }

    public class FocusMouseMotionListener
    implements MouseMotionListener {
        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((MyTableHeader)e.getSource(), e.getPoint(), Head.this);
            if (Head.this.getComponentAt(p) == null) {
                return;
            }
            MyTableHeader header = (MyTableHeader)((JScrollPane)Head.this.getComponentAt(p)).getColumnHeader().getView();
            int col = header.columnAtPoint(e.getPoint());
            if (header == Head.this.focusedHeader && col == Head.this.focusedCol) {
                return;
            }
            if (Head.this.focusedCol != -1) {
                Head.this.focusedHeader.removeFocus();
            }
            Head.this.focusedHeader = header;
            Head.this.focusedCol = Head.this.focusedHeader.columnAtPoint(e.getPoint());
            Head.this.focusedHeader.repaint(Head.this.focusedHeader.getHeaderRect(Head.this.focusedCol));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    public class MyFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public class MyMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                MyTableHeader header = (MyTableHeader)e.getSource();
                header.startCellEditing(header.columnAtPoint(e.getPoint()));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (Head.this.editingCol != -1) {
                Head.this.editingHeader.stopCellEditing();
            }
            if (Head.this.focusedCol != -1) {
                Head.this.focusedHeader.removeFocus();
            }
            Head.this.focusedHeader = (MyTableHeader)e.getSource();
            Head.this.focusedCol = Head.this.focusedHeader.columnAtPoint(e.getPoint());
            Head.this.focusedHeader.repaint(Head.this.focusedHeader.getHeaderRect(Head.this.focusedCol));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class MyTableHeader
    extends JTableHeader
    implements Serializable {
        private Font svTableFont;
        private int svHeight;
        private boolean listenerAdded;
        private MyMouseListener mListener;
        private MyFocusListener fListener;
        private FocusMouseMotionListener fmmListener;
        private ResizeMouseMotionListener rmmListener;
        private PopupMouseListener pListener;

        public MyTableHeader() {
            super(new DefaultTableColumnModel());
            this.listenerAdded = false;
            this.mListener = new MyMouseListener();
            this.fListener = new MyFocusListener();
            this.fmmListener = new FocusMouseMotionListener();
            this.rmmListener = new ResizeMouseMotionListener();
            this.pListener = new PopupMouseListener();
            this.init();
        }

        public MyTableHeader(TableColumnModel cm) {
            super(cm);
            this.listenerAdded = false;
            this.mListener = new MyMouseListener();
            this.fListener = new MyFocusListener();
            this.fmmListener = new FocusMouseMotionListener();
            this.rmmListener = new ResizeMouseMotionListener();
            this.pListener = new PopupMouseListener();
            this.init();
            cm.addColumn(this.createColumn(Messages.getString("Head.1"), 0, 0));
        }

        protected void init() {
            this.setReorderingAllowed(false);
            this.setEnabled(true);
            this.setFocusable(true);
            this.addListeners();
        }

        protected void addListeners() {
            if (this.listenerAdded) {
                return;
            }
            this.listenerAdded = true;
            this.addMouseListener(this.mListener);
            this.addFocusListener(this.fListener);
            this.addMouseMotionListener(this.fmmListener);
            this.addMouseListener(this.rmmListener);
            this.addMouseMotionListener(this.rmmListener);
            this.addMouseListener(this.pListener);
        }

        public void removeListeners() {
            if (!this.listenerAdded) {
                return;
            }
            this.listenerAdded = false;
            this.removeMouseListener(this.mListener);
            this.removeFocusListener(this.fListener);
            this.removeMouseMotionListener(this.fmmListener);
            this.removeMouseListener(this.rmmListener);
            this.removeMouseMotionListener(this.rmmListener);
            this.removeMouseListener(this.pListener);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.addListeners();
            } else {
                this.removeListeners();
            }
        }

        public void startCellEditing(int col) {
            if (!this.isEnabled()) {
                return;
            }
            Head.this.editingHeader = this;
            Head.this.editingCol = col;
            TableColumn column = this.getColumnModel().getColumn(Head.this.editingCol);
            JTextField comp = (JTextField)Head.this.editor.getComponent();
            comp.setBounds(this.getHeaderRect(Head.this.editingCol));
            comp.setText(column.getHeaderValue().toString());
            this.add(comp);
            comp.repaint();
            comp.requestFocus();
        }

        public boolean stopCellEditing() {
            TableColumn column = this.getColumnModel().getColumn(Head.this.editingCol);
            JTextField comp = (JTextField)Head.this.editor.getComponent();
            column.setHeaderValue(comp.getText());
            this.removeEditor();
            return true;
        }

        public void cancelCellEditing() {
            this.removeEditor();
        }

        public void removeEditor() {
            JTextField comp = (JTextField)Head.this.editor.getComponent();
            this.remove(comp);
            this.repaint(this.getHeaderRect(Head.this.editingCol));
            Head.this.editingHeader = null;
            Head.this.editingCol = -1;
        }

        public void removeFocus() {
            Rectangle rect = Head.this.focusedHeader.getHeaderRect(Head.this.focusedCol);
            Head.this.focusedCol = -1;
            Head.this.focusedHeader = null;
            this.repaint(rect);
        }

        public void storeProperties() {
            this.svHeight = (int)this.getPreferredSize().getHeight();
            this.svTableFont = this.getTable().getFont();
        }

        public void restoreProperties() {
            this.getTable().setFont(this.svTableFont);
        }

        public int getSavedHeight() {
            return this.svHeight;
        }

        protected TableColumn createColumn(String label, int modelIndex, int width) {
            TableColumn column = new TableColumn(modelIndex, width);
            column.setHeaderValue(label);
            column.setHeaderRenderer(new MyHeaderRenderer());
            return column;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            int height = this.getPreferredSize().height;
            out.writeInt(height);
            int columnCount = this.getColumnModel().getColumnCount();
            out.writeInt(columnCount);
            for (int col = 0; col < columnCount; ++col) {
                TableColumn column = this.getColumnModel().getColumn(col);
                out.writeInt(column.getPreferredWidth());
                out.writeObject(column.getHeaderValue());
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int height = in.readInt();
            this.setPreferredSize(new Dimension(10, height));
            TableColumnModel cm = this.getColumnModel();
            int columnCount = in.readInt();
            for (int col = 0; col < columnCount; ++col) {
                int width = in.readInt();
                String label = (String)in.readObject();
                TableColumn column = this.createColumn(label, col, width);
                cm.addColumn(column);
            }
        }
    }

    public class MyKeyListener
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            MyTableHeader header = (MyTableHeader)((Component)e.getSource()).getParent();
            if (e.getKeyChar() == '\n') {
                header.stopCellEditing();
                e.consume();
            }
            if (e.getKeyChar() == '\u001b') {
                header.cancelCellEditing();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

