/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.TableToolTip;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReferenceTableModel;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.table.TableColumn;

class TableToolTipUI
extends BasicToolTipUI {
    static TableToolTipUI sharedInstance = new TableToolTipUI();
    static TableToolTip tip;
    protected CellRendererPane rendererPane;
    protected JScrollPane scpane;
    protected JTable table = new JTable();

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public TableToolTipUI() {
        this.table.setModel(new ExternalFmeaReferenceTableModel());
        this.table.setAutoResizeMode(0);
        this.scpane = new JScrollPane(this.table);
        this.scpane.setHorizontalScrollBarPolicy(31);
        this.scpane.setVerticalScrollBarPolicy(21);
        this.scpane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scpane.getViewport().setBackground(Color.WHITE);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        tip = (TableToolTip)c;
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        this.rendererPane.paintComponent(g, this.scpane, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FmeaTable owner = (FmeaTable)((TableToolTip)c).getComponent();
        String text = ((TableToolTip)c).getTipText();
        if (text == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(text);
        int row = Integer.valueOf(tok.nextToken());
        int col = Integer.valueOf(tok.nextToken());
        FmeaAttribute att = owner.getFmeaTableModel().getAttributeAt(row, col);
        if (!(att instanceof FmeaExternalRefAttribute)) {
            return null;
        }
        FmeaExternalRefAttribute attribute = (FmeaExternalRefAttribute)att;
        Collection<ExternalFmeaReference> refs = attribute.getExternalReferences();
        ExternalFmeaReferenceTableModel model = (ExternalFmeaReferenceTableModel)this.table.getModel();
        model.setReferences(new ArrayList<ExternalFmeaReference>(refs));
        this.resizeTableToContent(this.table);
        return this.scpane.getPreferredSize();
    }

    private void resizeTableToContent(JTable tbl) {
        FontMetrics fm = tbl.getFontMetrics(tbl.getFont());
        int totalW = 0;
        for (int col = 0; col < tbl.getColumnCount(); ++col) {
            TableColumn tableCol = tbl.getColumnModel().getColumn(col);
            int w = fm.stringWidth(tableCol.getHeaderValue().toString()) + 20;
            if (tbl.getRowCount() <= 0) continue;
            for (int row = 0; row < tbl.getRowCount(); ++row) {
                w = Math.max(w, fm.stringWidth(tbl.getValueAt(row, col).toString()) + 10);
            }
            tableCol.setPreferredWidth(w);
            totalW += w;
        }
        if (totalW != 0) {
            int h = tbl.getTableHeader().getPreferredSize().height;
            int row = 0;
            while (row < tbl.getRowCount()) {
                ++row;
                h += tbl.getRowHeight();
            }
            Dimension dim = new Dimension(totalW, h);
            tbl.setPreferredScrollableViewportSize(dim);
        }
    }
}

