/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.dialog.DictionnaryDlg;
import com.dassault.cecilia.dbobj.fmea.model.DefaultDictionnary;
import com.dassault.cecilia.dbobj.fmea.model.Dictionnary;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DictionnaryManagerPanel
extends JDialog {
    private boolean _canceled = true;
    private boolean _writeAccess = true;
    Comparator _comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Dictionnary)o1).getName().compareToIgnoreCase(((Dictionnary)o2).getName());
        }
    };
    private DictionnaryTableModel dataModel = new DictionnaryTableModel();
    private JTable table = new JTable(this.dataModel);
    private JScrollPane scrollpane = new JScrollPane(this.table);
    private JButton bAdd = new JButton(Messages.getString("DictionnaryManagerPanel.3"));
    private JButton bEdit = new JButton(Messages.getString("DictionnaryManagerPanel.4"));
    private JButton bRemove = new JButton(Messages.getString("DictionnaryManagerPanel.5"));
    private JButton bOk = new JButton(Messages.getString("DictionnaryManagerPanel.6"));
    private JButton bCancel = new JButton(Messages.getString("DictionnaryManagerPanel.7"));

    public DictionnaryManagerPanel(Window owner, String title) throws HeadlessException {
        super(owner, title);
        this.setModal(true);
        this.updateComponentStates();
        JPanel tPanel = new JPanel();
        tPanel.setLayout(new GridBagLayout());
        tPanel.add((Component)this.scrollpane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel bPanel = new JPanel(new GridBagLayout());
        bPanel.add((Component)this.bAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bOk, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bCancel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)tPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.getContentPane().add(panel);
        this.defineListeners();
        this.pack();
        this.setSize(500, 250);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    public void setDictionnaries(Collection<Dictionnary> dictionnaries) {
        ArrayList<Dictionnary> lst = new ArrayList<Dictionnary>(dictionnaries);
        Collections.sort(lst, this._comparator);
        this.dataModel.setDictionnaries(lst);
    }

    public Collection<Dictionnary> getDictionnaries() {
        return new ArrayList<Dictionnary>(this.dataModel.getDictionnaries());
    }

    public boolean canceled() {
        return this._canceled;
    }

    public void setWriteAccess(boolean b) {
        this._writeAccess = b;
        this.updateComponentStates();
    }

    public void updateComponentStates() {
        int count = this.table.getSelectedRowCount();
        this.bAdd.setEnabled(this._writeAccess);
        this.bEdit.setEnabled(count != 0);
        this.bRemove.setEnabled(this._writeAccess && count != 0);
    }

    protected void defineListeners() {
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryManagerPanel.this.doAddDictionnary();
            }
        });
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryManagerPanel.this.doEditDictionnary();
            }
        });
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryManagerPanel.this.doRemoveDictionnaries();
            }
        });
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryManagerPanel.this._canceled = false;
                DictionnaryManagerPanel.this.setVisible(false);
                DictionnaryManagerPanel.this.dispose();
            }
        });
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryManagerPanel.this._canceled = true;
                DictionnaryManagerPanel.this.setVisible(false);
                DictionnaryManagerPanel.this.dispose();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DictionnaryManagerPanel.this.updateComponentStates();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DictionnaryManagerPanel.this._writeAccess && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    DictionnaryManagerPanel.this.doEditDictionnary();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAddDictionnary() {
        DictionnaryDlg dlg = new DictionnaryDlg(Messages.getString("DictionnaryManagerPanel.8") + " ", true);
        try {
            dlg.setNames(this.getDictionnaryNames());
            dlg.setDefaultCloseOperation(2);
            dlg.setWriteAccess(this._writeAccess);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return;
            }
            String name = dlg.getName();
            String description = dlg.getDescription();
            Collection entries = dlg.getEntries();
            DefaultDictionnary dico = new DefaultDictionnary(name, description, entries);
            this.dataModel.addDictionnary(dico);
        }
        finally {
            dlg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doEditDictionnary() {
        if (this.table.getSelectedRowCount() == 0) {
            return;
        }
        int row = this.table.getSelectedRow();
        Dictionnary dico = this.dataModel.getDictionnary(row);
        DictionnaryDlg dlg = new DictionnaryDlg(Messages.getString("DictionnaryManagerPanel.10") + " '" + dico.getName() + "'", false);
        try {
            dlg.setNames(this.getDictionnaryNames());
            dlg.setName(dico.getName());
            dlg.setDescription(dico.getDescriptionKey());
            dlg.setEntries(dico.getEntries());
            dlg.setDefaultCloseOperation(2);
            dlg.setWriteAccess(this._writeAccess);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return;
            }
            String name = dlg.getName();
            String description = dlg.getDescription();
            Collection entries = dlg.getEntries();
            dico = new DefaultDictionnary(name, description, entries);
            this.dataModel.modifyDictionnary(row, dico);
        }
        finally {
            dlg.dispose();
        }
    }

    private void doRemoveDictionnaries() {
        if (this.table.getSelectedRowCount() == 0) {
            return;
        }
        this.dataModel.removeDictionnaries(this.table.getSelectedRows());
    }

    private Collection getDictionnaryNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator<Dictionnary> i = this.getDictionnaries().iterator();
        while (i.hasNext()) {
            names.add(i.next().getName());
        }
        return names;
    }

    public static void main(String[] args) throws HeadlessException {
    }

    private class DictionnaryTableModel
    extends AbstractTableModel {
        List<Dictionnary> _data = new ArrayList<Dictionnary>();

        private DictionnaryTableModel() {
        }

        public void setDictionnaries(List data) {
            this._data = data;
            this.fireTableDataChanged();
        }

        public List getDictionnaries() {
            return this._data;
        }

        public Dictionnary getDictionnary(int row) {
            return this._data.get(row);
        }

        public void addDictionnary(Dictionnary dico) {
            this._data.add(dico);
            Collections.sort(this._data, DictionnaryManagerPanel.this._comparator);
            this.fireTableDataChanged();
        }

        public void removeDictionnaries(int[] rows) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this._data.remove(rows[i]);
            }
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        }

        public void modifyDictionnary(int row, Dictionnary dico) {
            this._data.remove(row);
            this._data.add(dico);
            Collections.sort(this._data, DictionnaryManagerPanel.this._comparator);
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Messages.getString("DictionnaryManagerPanel.0");
                }
                case 1: {
                    return Messages.getString("DictionnaryManagerPanel.1");
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Dictionnary dico = this._data.get(row);
            switch (col) {
                case 0: {
                    return dico.getName();
                }
                case 1: {
                    return dico.getDescriptionKey();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }
    }
}

