/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaDBTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTablePanel;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableModel;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class FmeaTableDataSelection {
    private ExternalFmeaReference _reference;
    private boolean _forEdition = false;

    public void setForEdition(boolean forEdition) {
        this._forEdition = forEdition;
    }

    public boolean isForEdition() {
        return this._forEdition;
    }

    public FmeaTableDataSelection(ExternalFmeaReference reference) {
        this._reference = reference;
    }

    public FmeaTable open(DBTableFMEA dbFMEA, CeciliaAppl appli) {
        DBTableFMEADataSelectDlg dlg = new DBTableFMEADataSelectDlg(dbFMEA, appli, appli.getTopWindow());
        if (this._reference != null) {
            dlg.prepareReference();
        }
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return null;
        }
        return dlg.getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValidateButtonState(DBTableFMEADataSelectDlg dlg, FmeaTable tbl) {
        boolean enabled = false;
        try {
            int col;
            if (tbl.getSelectedColumnCount() == 0 || tbl.getSelectedRowCount() == 0) {
                return;
            }
            int row = tbl.getSelectedRow();
            if (tbl.getValueAt(row, col = tbl.getSelectedColumn()) == null) {
                return;
            }
            int modelCol = tbl.convertColumnIndexToModel(col);
            FmeaTableModel model = tbl.getFmeaTableModel();
            FmeaColumnDefinition colDef = model.getColumnDefinition(modelCol);
            if (!colDef.isLinkedToAttribute()) {
                return;
            }
            if (!(model.getColumnType(modelCol) instanceof FmeaAttributeDefinition.Number)) {
                return;
            }
            enabled = true;
        }
        finally {
            dlg.getValidateButton().setEnabled(enabled);
        }
    }

    class MoveKeyAction
    extends AbstractAction {
        DBTableFMEADataSelectDlg _dialog;
        FmeaTable _table;

        MoveKeyAction(DBTableFMEADataSelectDlg dialog, FmeaTable table) {
            this._dialog = dialog;
            this._table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FmeaTableDataSelection.this.setValidateButtonState(this._dialog, this._table);
        }
    }

    class DoubleClickOnTableListener
    extends MouseAdapter {
        DBTableFMEADataSelectDlg _dialog;

        public DoubleClickOnTableListener(DBTableFMEADataSelectDlg dialog) {
            this._dialog = dialog;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FmeaTableDataSelection.this.setValidateButtonState(this._dialog, (FmeaTable)e.getSource());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FmeaTableDataSelection.this.setValidateButtonState(this._dialog, (FmeaTable)e.getSource());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                this._dialog.getValidateButton().doClick();
            }
        }
    }

    class DBTableFMEADataSelectDlg
    extends JDialogCecilia {
        DBTableFMEA _dbFMEA;
        CeciliaAppl _appli;
        FmeaTablePanel _ctrlTable;

        DBTableFMEADataSelectDlg(DBTableFMEA dbFMEA, CeciliaAppl appli, Window owner) {
            super(owner, Messages.getString("FmeaTableDataSelection.0") + " : " + dbFMEA.getRefPath(), true);
            this._appli = appli;
            this._dbFMEA = dbFMEA;
            this.make();
            this.setSize(800, 500);
            this._ctrlTable.open(this._dbFMEA);
        }

        private void make() {
            this._ctrlTable = new FmeaTablePanel(this._appli);
            this._ctrlTable.getToolbar().setVisible(false);
            FmeaDBTable table = (FmeaDBTable)this._ctrlTable.getFmeaTable();
            table.setEditable(false);
            table.setRowSelectionAllowed(true);
            if (FmeaTableDataSelection.this._forEdition) {
                table.setSelectionMode(0);
            } else {
                table.setSelectionMode(2);
            }
            table.setShowLinesByGroup(false);
            MouseListener[] listeners = (MouseListener[])table.getListeners(MouseListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof FmeaDBTable.DoubleClickListener)) continue;
                table.removeMouseListener(listeners[i]);
            }
            table.addMouseListener(new DoubleClickOnTableListener(this));
            table.setOnArrowKeysAction(new MoveKeyAction(this, table));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this._ctrlTable, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this.getOwner()));
        }

        protected FmeaTable getTable() {
            if (this._ctrlTable == null) {
                return null;
            }
            return this._ctrlTable.getFmeaTable();
        }

        public JButton getValidateButton() {
            return this._ctrlOK;
        }

        @Override
        protected boolean verifyParameters() {
            return this._ctrlOK.isEnabled();
        }

        public void prepareReference() {
            FmeaDBTable table = (FmeaDBTable)this._ctrlTable.getFmeaTable();
            int mdlCol = table.getFmeaTableModel().getColumnForDefinition(FmeaTableDataSelection.this._reference.getFmeaEntId(), FmeaTableDataSelection.this._reference.getFmeaAttId());
            FmeaColumnDefinition colDef = table.getFmeaTableModel().getColumnDefinition(mdlCol);
            int mdlRow = table.getFmeaTableModel().getRowForEntity(colDef, FmeaTableDataSelection.this._reference.getFmeaEntValue());
            int col = table.convertColumnIndexToView(mdlCol);
            int row = table.convertRowIndexToView(mdlRow);
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(col, col);
        }
    }
}

