/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class SortDlg
extends JDialog {
    private SortData sortData;
    private Set columns = new TreeSet<FmeaColumnDefinition>(new Comparator<FmeaColumnDefinition>(){

        @Override
        public int compare(FmeaColumnDefinition o1, FmeaColumnDefinition o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });
    private Set numericColumns = new TreeSet<FmeaColumnDefinition>(new Comparator<FmeaColumnDefinition>(){

        @Override
        public int compare(FmeaColumnDefinition o1, FmeaColumnDefinition o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });
    private boolean canceled = true;
    private Vector data = new Vector();
    private AbstractTableModel dataModel = new AbstractTableModel(){

        @Override
        public int getColumnCount() {
            return SortDlg.this.sortData == null ? 0 : (SortDlg.this.sortData.getGroupCells() ? 5 : 2);
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 2: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Messages.getString("SortDlg.4");
                }
                case 1: {
                    return Messages.getString("SortDlg.3");
                }
                case 2: {
                    return Messages.getString("SortDlg.2");
                }
                case 3: {
                    return Messages.getString("SortDlg.1");
                }
                case 4: {
                    return Messages.getString("SortDlg.0");
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return SortDlg.this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return ((Object[])SortDlg.this.data.get(row))[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return SortDlg.this.numericColumns.contains(this.getValueAt(row, 0));
                }
                case 3: {
                    return (Boolean)this.getValueAt(row, 2);
                }
                case 4: {
                    return (Boolean)this.getValueAt(row, 2);
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ((Object[])((SortDlg)SortDlg.this).data.get((int)row))[col] = value;
            switch (col) {
                case 1: {
                    String order = value.toString().equals(Messages.getString("SortDlg.16")) ? "ascending" : "descending";
                    SortDlg.this.sortData.setColumnOrder((FmeaColumnDefinition)this.getValueAt(row, 0), order);
                    break;
                }
                case 2: {
                    SortDlg.this.sortData.setColumnFormula((FmeaColumnDefinition)this.getValueAt(row, 0), (Boolean)value);
                    SortDlg.this.updateOkButton();
                    break;
                }
                case 3: {
                    int operation = value == null ? -1 : (value.toString().equals(Messages.getString("SortDlg.22")) ? 0 : 1);
                    SortDlg.this.sortData.setColumnFormulaOperation((FmeaColumnDefinition)this.getValueAt(row, 0), operation);
                    SortDlg.this.updateOkButton();
                    break;
                }
                case 4: {
                    FmeaColumnDefinition sourceCol = (FmeaColumnDefinition)value;
                    SortDlg.this.sortData.setColumnFormulaSourceColumn((FmeaColumnDefinition)this.getValueAt(row, 0), sourceCol);
                    SortDlg.this.updateOkButton();
                }
            }
        }
    };
    private JTable table = new JTable(this.dataModel){

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            DefaultCellEditor editor = null;
            JComboBox<String> comboBox = null;
            switch (column) {
                case 1: {
                    String[] items = new String[]{Messages.getString("SortDlg.16"), Messages.getString("SortDlg.17")};
                    comboBox = new JComboBox<String>(items);
                    editor = new DefaultCellEditor(comboBox);
                    editor.setClickCountToStart(2);
                    SortDlg.this.table.getColumnModel().getColumn(1).setCellEditor(editor);
                    return editor;
                }
                case 3: {
                    String[] items2 = new String[]{Messages.getString("SortDlg.22"), Messages.getString("SortDlg.23")};
                    comboBox = new JComboBox<String>(items2);
                    editor = new DefaultCellEditor(comboBox);
                    editor.setClickCountToStart(2);
                    SortDlg.this.table.getColumnModel().getColumn(3).setCellEditor(editor);
                    return editor;
                }
                case 4: {
                    ArrayList values = new ArrayList(SortDlg.this.numericColumns);
                    values.remove(SortDlg.this.table.getValueAt(row, 0));
                    SortDlg.this.comboSources.setModel(new DefaultComboBoxModel<Object>(values.toArray()));
                    editor = new DefaultCellEditor(SortDlg.this.comboSources);
                    editor.setClickCountToStart(2);
                    return editor;
                }
            }
            return super.getCellEditor(row, column);
        }
    };
    private JCheckBox bGroupCells = new JCheckBox(Messages.getString("SortDlg.9"));
    private JScrollPane scrollpane = new JScrollPane(this.table);
    private JComboBox comboSources = new JComboBox();
    private JButton bAdd = new JButton(Messages.getString("SortDlg.10"));
    private JButton bRemove = new JButton(Messages.getString("SortDlg.11"));
    private JButton bMoveUp = new JButton(Messages.getString("SortDlg.12"));
    private JButton bMoveDown = new JButton(Messages.getString("SortDlg.13"));
    private JButton bOk = new JButton(Messages.getString("SortDlg.14"));
    private JButton bCancel = new JButton(Messages.getString("SortDlg.15"));

    public SortDlg(Frame owner, String title) throws HeadlessException {
        super(owner, title, true);
        this.init();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    public SortDlg(Dialog owner, String title) throws HeadlessException {
        super(owner, title, true);
        this.init();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    private void init() {
        this.setModal(true);
        JPanel tPanel = new JPanel();
        tPanel.setLayout(new GridBagLayout());
        tPanel.add((Component)this.bGroupCells, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        tPanel.add((Component)this.scrollpane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new GridBagLayout());
        bPanel.add((Component)this.bAdd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bMoveUp, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bMoveDown, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bOk, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this.bCancel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)tPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.scrollpane.setBorder(new TitledBorder(Messages.getString("SortDlg.18")));
        this.getContentPane().add(panel);
        this.defineListeners();
        this.updateOkButton();
        this.pack();
        this.setSize(500, 250);
    }

    public void setData(Vector cols, Vector numCols, SortData sort) {
        this.setData(cols, numCols);
        this.sortData = sort;
        if (this.sortData == null) {
            this.sortData = new SortData(false);
        }
        this.bGroupCells.setSelected(this.sortData.getGroupCells());
        this.setRows(this.sortData);
        this.table.tableChanged(null);
    }

    public SortData getData() {
        return this.sortData;
    }

    public Map getSources() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int row = 0; row < this.data.size(); ++row) {
            map.put(((Object[])this.data.get(row))[0], ((Object[])this.data.get(row))[4]);
        }
        return map;
    }

    public Vector getColumns() {
        Vector<Object> values = new Vector<Object>();
        for (int row = 0; row < this.data.size(); ++row) {
            values.add(((Object[])this.data.get(row))[0]);
        }
        return values;
    }

    public boolean isGroupingCells() {
        return this.bGroupCells.isSelected();
    }

    public boolean canceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.bAdd.requestFocus();
        }
        if (!visible && this.data.isEmpty()) {
            this.sortData = null;
        }
        super.setVisible(visible);
    }

    protected void setData(Vector cols, Vector numCols) {
        this.columns.clear();
        this.columns.addAll(cols);
        this.numericColumns.clear();
        this.numericColumns.addAll(numCols);
    }

    protected void swapRows(int row1, int row2) {
        Object[] value1 = (Object[])this.data.get(row1);
        Object[] value2 = (Object[])this.data.get(row2);
        this.data.set(row1, value2);
        this.data.set(row2, value1);
        this.sortData.swapColumns(row1, row2);
    }

    protected boolean moveUp(int row) {
        if (this.table.getSelectedRowCount() == 0) {
            return false;
        }
        if (row == 0) {
            return false;
        }
        this.swapRows(row - 1, row);
        return true;
    }

    protected boolean moveDown(int row) {
        if (this.table.getSelectedRowCount() == 0) {
            return false;
        }
        if (row == this.table.getRowCount() - 1) {
            return false;
        }
        this.swapRows(row, row + 1);
        return true;
    }

    protected void setRows(SortData sort) {
        this.data.clear();
        if (sort == null) {
            return;
        }
        for (int i = 0; i < sort.getColumnCount(); ++i) {
            FmeaColumnDefinition colDef = sort.getColumnDefinition(i);
            if (colDef == null) continue;
            Object[] row = new Object[5];
            row[0] = colDef;
            row[1] = sort.getColumnSortOrder(i).equals("ascending") ? Messages.getString("SortDlg.16") : Messages.getString("SortDlg.17");
            Object object = row[2] = sort.formulaApplied(i) ? Boolean.TRUE : Boolean.FALSE;
            row[3] = sort.formulaApplied(i) ? (sort.getFormulaOperation(i) == 0 ? Messages.getString("SortDlg.22") : Messages.getString("SortDlg.23")) : null;
            row[4] = sort.formulaApplied(i) ? sort.getFormulaSourceColumn(i) : null;
            this.data.add(row);
            this.columns.remove(row[0]);
        }
        this.dataModel.fireTableRowsInserted(0, this.dataModel.getRowCount() - 1);
        this.updateOkButton();
    }

    protected void addRows(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object[] value = new Object[]{values[i], Messages.getString("SortDlg.16"), Boolean.FALSE, null, null};
            this.data.add(value);
            this.columns.remove(value[0]);
            this.sortData.addColumn((FmeaColumnDefinition)value[0], "ascending");
        }
        this.dataModel.fireTableRowsInserted(this.dataModel.getRowCount(), this.dataModel.getRowCount() - values.length - 1);
        this.updateOkButton();
    }

    protected void removeRows(int[] rows) {
        if (rows.length == 0) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            Object[] value = (Object[])this.data.remove(rows[i]);
            this.columns.add(value[0]);
            this.sortData.removeColumn((FmeaColumnDefinition)value[0]);
        }
        this.dataModel.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        this.updateOkButton();
    }

    protected void updateOkButton() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getColumnCount() <= 2 || this.table.getValueAt(i, 2) != Boolean.TRUE || this.table.getValueAt(i, 3) != null && this.table.getValueAt(i, 4) != null) continue;
            this.bOk.setEnabled(false);
            return;
        }
        this.bOk.setEnabled(true);
    }

    protected void defineListeners() {
        this.bGroupCells.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SortDlg.this.sortData.setGroupCells(SortDlg.this.bGroupCells.isSelected());
                SortDlg.this.table.tableChanged(null);
            }
        });
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnListDlg dlg = new ColumnListDlg(SortDlg.this, Messages.getString("SortDlg.28"));
                dlg.setVisible(true);
                dlg.dispose();
                Object[] values = dlg.getSelectedValues();
                SortDlg.this.addRows(values);
            }
        });
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SortDlg.this.table.getSelectedRows();
                SortDlg.this.removeRows(rows);
            }
        });
        this.bMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int[] rows = SortDlg.this.table.getSelectedRows();
                for (i = 0; i < rows.length; ++i) {
                    if (i == 0) {
                        rows[i] = SortDlg.this.moveUp(rows[i]) ? rows[i] - 1 : rows[i];
                        continue;
                    }
                    if (rows[i - 1] == rows[i] - 1) continue;
                    rows[i] = SortDlg.this.moveUp(rows[i]) ? rows[i] - 1 : rows[i];
                }
                SortDlg.this.dataModel.fireTableDataChanged();
                for (i = 0; i < rows.length; ++i) {
                    SortDlg.this.table.addRowSelectionInterval(rows[i], rows[i]);
                }
            }
        });
        this.bMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int[] rows = SortDlg.this.table.getSelectedRows();
                for (i = rows.length - 1; i >= 0; --i) {
                    if (i == rows.length - 1) {
                        rows[i] = SortDlg.this.moveDown(rows[i]) ? rows[i] + 1 : rows[i];
                        continue;
                    }
                    if (rows[i + 1] == rows[i] + 1) continue;
                    rows[i] = SortDlg.this.moveDown(rows[i]) ? rows[i] + 1 : rows[i];
                }
                SortDlg.this.dataModel.fireTableDataChanged();
                for (i = rows.length - 1; i >= 0; --i) {
                    SortDlg.this.table.addRowSelectionInterval(rows[i], rows[i]);
                }
            }
        });
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDlg.this.canceled = false;
                SortDlg.this.setVisible(false);
                SortDlg.this.dispose();
            }
        });
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDlg.this.canceled = true;
                SortDlg.this.setVisible(false);
                SortDlg.this.dispose();
            }
        });
    }

    public static void main(String[] args) throws HeadlessException {
        SortDlg sortDlg1 = new SortDlg((Frame)null, "Sort...");
        Vector<String> columns = new Vector<String>();
        columns.add("Function");
        columns.add("Failure Mode");
        columns.add("Component");
        columns.add("Failure Cause");
        Vector<String> numericColumns = new Vector<String>();
        numericColumns.add("Failure Cause");
        sortDlg1.setData(columns, numericColumns);
        sortDlg1.setVisible(true);
    }

    class ColumnListDlg
    extends JDialog {
        JList list;

        public ColumnListDlg(Dialog owner, String title) throws HeadlessException {
            super(owner, title, true);
            this.list = new JList<Object>(SortDlg.this.columns.toArray());
            JLabel label = new JLabel(Messages.getString("SortDlg.29"));
            JScrollPane scroll = new JScrollPane(this.list);
            JButton butOk = new JButton(Messages.getString("SortDlg.14"));
            JButton butCancel = new JButton(Messages.getString("SortDlg.15"));
            JPanel bPanel = new JPanel(new GridBagLayout());
            bPanel.add((Component)butOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            bPanel.add((Component)butCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)scroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)bPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add(panel);
            this.pack();
            butOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnListDlg.this.setVisible(false);
                }
            });
            butCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnListDlg.this.setVisible(false);
                    ColumnListDlg.this.list.clearSelection();
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(e)) {
                        ColumnListDlg.this.setVisible(false);
                    }
                }
            });
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
        }

        public Object[] getSelectedValues() {
            return this.list.getSelectedValuesList().toArray();
        }
    }
}

