/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.EditDialog;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.EntityDefinitionComboBoxModel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.EntityPathDefinitionPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.FmeaModelDefinitionPanel;
import com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition.Messages;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelationDefinition;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class RelationDefinitionPanel
extends JPanel {
    private final FmeaModelDefinitionPanel _definitionPanel;
    private RelationTableModel _tRelationModel;
    private JTable _table;
    private JScrollPane _scpane;
    private JButton _bAdd = new JButton(Messages.getString("RelationDefinitionPanel.0"));
    private JButton _bRemove = new JButton(Messages.getString("RelationDefinitionPanel.1"));
    private boolean _enabled = true;
    private EntityPathDefinitionPanel entityPathPanel;

    RelationDefinitionPanel(FmeaModelDefinitionPanel panel) {
        super(new GridBagLayout());
        this._definitionPanel = panel;
        this._tRelationModel = new RelationTableModel();
        this._table = new JTable(this._tRelationModel){

            @Override
            public boolean isCellEditable(int row, int col) {
                return RelationDefinitionPanel.this._enabled && super.isCellEditable(row, col);
            }
        };
        this._scpane = new JScrollPane(this._table);
        this._table.setPreferredScrollableViewportSize(new Dimension(300, 150));
        this._table.getTableHeader().setReorderingAllowed(false);
        JPanel bPanel = new JPanel(new GridBagLayout());
        bPanel.add((Component)this._bAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        bPanel.add((Component)this._bRemove, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.entityPathPanel = new EntityPathDefinitionPanel(this._definitionPanel);
        this.entityPathPanel.setBorder(new TitledBorder(Messages.getString("RelationDefinitionPanel.2")));
        this.add((Component)this._scpane, new GridBagConstraints(0, 0, 1, 1, 0.7, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)bPanel, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.entityPathPanel, new GridBagConstraints(1, 0, 1, 2, 0.3, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        DefaultCellEditor cellEditor = new DefaultCellEditor(new JComboBox<FmeaRelationDefinition.Type>(FmeaModelDefinitionPanel.relationTypes));
        cellEditor.setClickCountToStart(2);
        this._table.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        this._bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._entityData.length < 2) {
                    return;
                }
                final EditRelationPanel editPanel = new EditRelationPanel();
                Window window = SwingUtilities.getWindowAncestor(RelationDefinitionPanel.this._definitionPanel);
                EditDialog dlg = null;
                dlg = window instanceof Frame ? new EditDialog((Frame)window, Messages.getString("RelationDefinitionPanel.3"), true, editPanel, 3){

                    @Override
                    protected boolean closeEnabled() {
                        return editPanel.validateFields();
                    }
                } : new EditDialog((Dialog)window, Messages.getString("RelationDefinitionPanel.3"), true, editPanel, 3){

                    @Override
                    protected boolean closeEnabled() {
                        return editPanel.validateFields();
                    }
                };
                dlg.setVisible(true);
                dlg.dispose();
                if (dlg.isCanceled()) {
                    return;
                }
                FmeaRelationDefinition def = new FmeaRelationDefinition(null, editPanel.getSelectedEntity().getKey(), editPanel.getSelectedLinkedEntity().getKey(), editPanel.getSelectedType());
                RelationDefinitionPanel.this._tRelationModel.addRow(def);
            }
        });
        this._bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationDefinitionPanel.this._tRelationModel.removeRows(RelationDefinitionPanel.this._table.getSelectedRows());
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RelationDefinitionPanel.this.updateButtonStates();
            }
        });
    }

    void updateButtonStates() {
        this._bAdd.setEnabled(this._enabled && this._definitionPanel._entityData.length >= 2);
        this._bRemove.setEnabled(this._enabled && this._table.getSelectedRowCount() != 0);
    }

    public void updateContent() {
        this._tRelationModel.fireTableDataChanged();
        this.entityPathPanel.updateContent();
        this.updateButtonStates();
    }

    public void setPanelEnabled(boolean enabled) {
        this._enabled = enabled;
        this.entityPathPanel.setPanelEnabled(enabled);
        this.updateButtonStates();
    }

    public EntityPathDefinitionPanel getEntityPathPanel() {
        return this.entityPathPanel;
    }

    class EditRelationPanel
    extends JPanel {
        JLabel label1;
        JLabel label2;
        JLabel label3;
        JComboBox combo1;
        JComboBox combo2;
        JComboBox combo3;

        public EditRelationPanel() {
            super(new GridBagLayout());
            this.label1 = new JLabel(Messages.getString("RelationDefinitionPanel.5"));
            this.label2 = new JLabel(Messages.getString("RelationDefinitionPanel.6"));
            this.label3 = new JLabel(Messages.getString("RelationDefinitionPanel.7"));
            this.combo1 = new JComboBox(new EntityDefinitionComboBoxModel(RelationDefinitionPanel.this._definitionPanel));
            this.combo2 = new JComboBox(new EntityDefinitionComboBoxModel(RelationDefinitionPanel.this._definitionPanel));
            this.combo3 = new JComboBox<FmeaRelationDefinition.Type>(FmeaModelDefinitionPanel.relationTypes);
            this.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this.add((Component)this.label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this.add((Component)this.label3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
            this.add((Component)this.combo1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.combo2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.combo3, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public FmeaEntityDefinition getSelectedEntity() {
            return (FmeaEntityDefinition)this.combo1.getSelectedItem();
        }

        public FmeaEntityDefinition getSelectedLinkedEntity() {
            return (FmeaEntityDefinition)this.combo2.getSelectedItem();
        }

        public FmeaRelationDefinition.Type getSelectedType() {
            return (FmeaRelationDefinition.Type)this.combo3.getSelectedItem();
        }

        public void setSelectedEntity(String entity) {
            this.combo1.setSelectedItem(entity);
        }

        public void setSelectedLinkedEntity(String linkedEntity) {
            this.combo2.setSelectedItem(linkedEntity);
        }

        public void setSelectedType(FmeaRelationDefinition.Type type) {
            this.combo3.setSelectedItem(type);
        }

        public boolean validateFields() {
            if (this.getSelectedEntity() == this.getSelectedLinkedEntity()) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("RelationDefinitionPanel.8"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            if (((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getRelationDefinition(this.getSelectedEntity(), this.getSelectedLinkedEntity()) != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("RelationDefinitionPanel.9"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            if (((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getRelationDefinition(this.getSelectedLinkedEntity(), this.getSelectedEntity()) != null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("RelationDefinitionPanel.10"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            return true;
        }
    }

    private class RelationTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Messages.getString("RelationDefinitionPanel.5"), Messages.getString("RelationDefinitionPanel.6"), Messages.getString("RelationDefinitionPanel.7")};

        private RelationTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._relationData.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return String.class;
                }
                case 2: {
                    return FmeaRelationDefinition.Type.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FmeaRelationDefinition def = (FmeaRelationDefinition)((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._relationData[row];
            switch (col) {
                case 0: {
                    return ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getEntityDefinition(def.getEntityDef1()).getName();
                }
                case 1: {
                    return ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getEntityDefinition(def.getEntityDef2()).getName();
                }
                case 2: {
                    return def.getRelationType();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            FmeaRelationDefinition def = (FmeaRelationDefinition)((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._relationData[row];
            switch (col) {
                case 0: {
                    def.setEntity1(value.toString());
                    break;
                }
                case 1: {
                    def.setEntity2(value.toString());
                    break;
                }
                case 2: {
                    def.setRelationType((FmeaRelationDefinition.Type)value);
                    break;
                }
            }
        }

        public void addRow(FmeaRelationDefinition def) {
            ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.addRelationDefinition(def);
            ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._relationData = ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getRelationDefinitions();
            FmeaEntityDefinition entityDef1 = ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getEntityDefinition(def.getEntityDef1());
            FmeaEntityDefinition entityDef2 = ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getEntityDefinition(def.getEntityDef2());
            RelationDefinitionPanel.this._definitionPanel.getEntityPathPanel().addRelation(entityDef1, entityDef2);
            super.fireTableDataChanged();
        }

        public void removeRows(int[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                FmeaRelationDefinition def = (FmeaRelationDefinition)((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._relationData[rows[i]];
                ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.removeRelationDefinition(def);
                FmeaEntityDefinition entityDef1 = ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getEntityDefinition(def.getEntityDef1());
                FmeaEntityDefinition entityDef2 = ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getEntityDefinition(def.getEntityDef2());
                RelationDefinitionPanel.this._definitionPanel.getEntityPathPanel().removeRelation(entityDef1, entityDef2);
            }
            ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._relationData = ((RelationDefinitionPanel)RelationDefinitionPanel.this)._definitionPanel._fmea.getModel().getRelationDefinitions();
            super.fireTableDataChanged();
        }
    }
}

