/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.io;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaDBTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.io.FmeaOutputOptions;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReferenceTableModel;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableModel;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;

public class FmeaOutput {
    protected DBKOutput xmlWriter;
    private DBFolder _dbFolder;
    private FmeaDBTable _table;
    private FmeaOutputOptions _options;

    public FmeaOutput(DBFolder dbFolder, FmeaDBTable table, FmeaOutputOptions options) {
        this._dbFolder = dbFolder;
        this._table = table;
        this._options = options;
    }

    public void exportFormatScribe(SrbInputStream scribe) {
        scribe.concat("<GDOC SEC=''>\n");
        scribe.concat("<TITLE>" + ResMsgVoc.getString("VOC_FMEA") + "\n");
        scribe.concat("<DOCNUM>\n");
        scribe.concat("<DATE>" + this._options.formatDate(new Date()) + "\n");
        scribe.concat(".ti @\n");
        scribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        scribe.concat("<BODY>\n");
        scribe.concat("<UL>\n");
        if (this._options.getAnalysisOption()) {
            DBFolder fmea = this._dbFolder.getParent();
            DBFolder system = fmea.getParent();
            DBFolder project = system.getParent();
            scribe.concat("<H1>" + ResMsgArbor.getString("KEY_0377") + "\n");
            scribe.concat("<LI>" + ResMsgVoc.getString("VOC_IDENTIFICATION") + "\n");
            scribe.concat(".br \n");
            scribe.concat(ResMsgVoc.getString("VOC_PROJECT") + "@:@<HP2>" + project.getName());
            scribe.concat("<EHP2>\n");
            scribe.concat(".br \n");
            String description = project.getDescription();
            if (description != null && description.length() > 0) {
                scribe.concat("@@");
                this.writeComment(scribe, description, "\n.br \n@@");
                scribe.concat("\n");
                scribe.concat(".br \n");
            }
            scribe.concat(ResMsgVoc.getString("VOC_SYSTEM") + "@:@<HP2>" + system.getName());
            scribe.concat("<EHP2>\n");
            scribe.concat(".br \n");
            description = system.getDescription();
            if (description != null && description.length() > 0) {
                scribe.concat("@@");
                this.writeComment(scribe, description, "\n.br \n@@");
                scribe.concat("\n");
                scribe.concat(".br \n");
            }
            scribe.concat(ResMsgVoc.getString("VOC_FMEA") + "@:@<HP2>" + fmea.getName());
            scribe.concat(" (" + this._dbFolder.getName() + ")<EHP2>\n");
            scribe.concat(".br \n");
            description = fmea.getDescription();
            if (description != null && description.length() > 0) {
                scribe.concat("@@");
                this.writeComment(scribe, description, "\n.br \n@@");
                scribe.concat("\n");
                scribe.concat(".br \n");
            }
            if ((description = this._dbFolder.getDescription()) != null && description.length() > 0) {
                scribe.concat("@@");
                this.writeComment(scribe, description, "\n.br \n@@");
                scribe.concat("\n");
                scribe.concat(".br \n");
            }
            DBFolder object = this._dbFolder;
            String createDate = this._options.formatDate(object.getDateCreate());
            String createBy = null;
            String modifyDate = this._options.formatDate(object.getDateModify());
            String modifyBy = object.getUserModify().getLogin();
            DBObjProperty dbObjProp = null;
            if (this._dbFolder.isVersion() && this._dbFolder.getObject() != null) {
                dbObjProp = this._dbFolder.getObject().getProperty("object.creator");
            }
            if (dbObjProp != null) {
                createBy = dbObjProp.getValue();
            }
            scribe.concat("<LI>" + ResMsgVoc.getString("VOC_DATES") + "\n");
            scribe.concat(".br \n");
            if (createBy != null) {
                scribe.concat(ResMsgVoc.getString("VOC_CREATION") + "@:@<HP2>" + ResMsgCore.msgFormat("MSG_DATE_BY_USER", createDate, createBy) + "<EHP2>\n");
            } else {
                scribe.concat(ResMsgVoc.getString("VOC_CREATION") + "@:@<HP2>" + createDate + "<EHP2>\n");
            }
            scribe.concat(".br \n");
            scribe.concat(ResMsgVoc.getString("VOC_MODIFICATION") + "@:@<HP2>" + ResMsgCore.msgFormat("MSG_DATE_BY_USER", modifyDate, modifyBy) + "<EHP2>\n");
            scribe.concat(".br \n");
        }
        scribe.concat("<H1>" + Messages.getString("FmeaPanel.39") + "\n");
        StringBuilder b = new StringBuilder();
        b.append("<TABLEAU>\n");
        b.append("<TABTIT>" + ResMsgVoc.getString("VOC_FMEA") + "\n");
        for (int col = 0; col < this._table.getColumnCount(); ++col) {
            b.append("<TABCOL>" + this._table.getColumnName(col) + "\n");
        }
        StringBuilder cwidth = new StringBuilder();
        StringBuilder align = new StringBuilder();
        for (int col = 0; col < this._table.getColumnCount(); ++col) {
            cwidth.append(this._table.getColumnModel().getColumn(col).getPreferredWidth() / 6);
            cwidth.append(" ");
            FmeaAttributeDefinition.Type colType = this._table.getFmeaTableModel().getColumnType(col);
            if (colType instanceof FmeaAttributeDefinition.Number) {
                align.append("C");
            } else if (colType instanceof FmeaAttributeDefinition.String) {
                align.append("L");
            }
            align.append(" ");
        }
        cwidth.deleteCharAt(cwidth.length() - 1);
        align.deleteCharAt(align.length() - 1);
        b.append("<TABDEF CWIDTH = '");
        b.append((CharSequence)cwidth);
        b.append("' ALIGN = '");
        b.append((CharSequence)align);
        b.append("'>\n");
        String str = "";
        for (int row = 0; row < this._table.getRowCount(); ++row) {
            for (int col = 0; col < this._table.getColumnCount(); ++col) {
                FmeaTable.FusionedCell cell;
                Object value = this._table.getValueAt(row, col);
                str = value == null ? "" : ((cell = this._table.getFusionedCell(row, col)) == null ? this.convertValue(value) : (cell._rStart == row ? this.convertValue(value) : ""));
                b.append("<C>" + str + "\n");
            }
        }
        b.append("<ETABLEAU>\n");
        scribe.concat(b.toString());
        this.makeExternalAttributeRefScribeFile(scribe);
        scribe.concat("<EGDOC>0\n");
    }

    private void writeComment(SrbInputStream out, String comment, String format) {
        char[] text = comment.toCharArray();
        for (int i = 0; i < comment.length(); ++i) {
            if (text[i] != '\n') {
                out.concat("" + text[i]);
                continue;
            }
            if (i == comment.length() - 1) continue;
            out.concat(format);
        }
    }

    private void makeExternalAttributeRefScribeFile(SrbInputStream scribe) {
        String title = Messages.getString("FmeaPrintablePage.11");
        scribe.concat("<H1>" + title + "\n");
        ArrayList<Point> externRefAttr = new ArrayList<Point>();
        FmeaTableModel model = this._table.getFmeaTableModel();
        for (int row = 0; row < this._table.getRowCount(); ++row) {
            for (int col = 0; col < this._table.getColumnCount(); ++col) {
                int mdlCol = this._table.convertColumnIndexToModel(col);
                int mdlRow = this._table.convertRowIndexToFmeaModel(row);
                FmeaAttribute attribute = model.getAttributeAt(mdlRow, mdlCol);
                if (!(attribute instanceof FmeaExternalRefAttribute)) continue;
                externRefAttr.add(new Point(mdlRow, mdlCol));
            }
        }
        if (externRefAttr.size() == 0) {
            scribe.concat("" + Messages.getString("FmeaPrintablePage.12") + "\n");
            scribe.concat(".br \n");
        } else {
            for (int i = 0; i < externRefAttr.size(); ++i) {
                Point p = (Point)externRefAttr.get(i);
                int row = p.x;
                int col = p.y;
                this.makeExternalAttributeRefScribeFile(scribe, row, col);
            }
        }
    }

    private void makeExternalAttributeRefScribeFile(SrbInputStream scribe, int row, int col) {
        FmeaTableModel model = this._table.getFmeaTableModel();
        FmeaColumnDefinition colDef = model.getColumnDefinition(col);
        FmeaExternalRefAttribute attribute = (FmeaExternalRefAttribute)model.getAttributeAt(row, col);
        FmeaEntity entity = model.getEntityAt(row, col);
        Object value = attribute.getValue();
        String str = this.convertValue(value);
        scribe.concat("<LI>" + ResMsgVoc.getString("VOC_REFERENCE") + "@: <HP2>" + colDef.getEntityDefinition().getName() + "." + entity.getName() + "<EHP2>\n");
        scribe.concat(".br \n");
        scribe.concat(ResMsgVoc.getString("VOC_VALUE") + "@: <HP2>" + str + "<EHP2>\n");
        scribe.concat(".br \n");
        scribe.concat(" \n");
        scribe.concat(".br \n");
        ExternalFmeaReferenceTableModel mdl = new ExternalFmeaReferenceTableModel();
        mdl.setReferences(new ArrayList<ExternalFmeaReference>(attribute.getExternalReferences()));
        JTable tbl = new JTable(mdl);
        this.makeExternalAttributeRefScribeFile(scribe, tbl);
    }

    private void makeExternalAttributeRefScribeFile(SrbInputStream scribe, JTable table) {
        StringBuilder b = new StringBuilder();
        b.append("<TABLEAU>\n");
        b.append("<TABTIT>" + Messages.getString("FmeaPrintablePage.11") + "\n");
        for (int col = 0; col < table.getColumnCount(); ++col) {
            if (col == table.getColumnCount() - 2 && !this._options.getAttributeOption()) continue;
            b.append("<TABCOL>" + table.getColumnName(col) + "\n");
        }
        StringBuilder cwidth = new StringBuilder();
        StringBuilder align = new StringBuilder();
        int[] widths = new int[]{30, 25, 11, 11};
        for (int col = 0; col < table.getColumnCount(); ++col) {
            if (col == table.getColumnCount() - 2 && !this._options.getAttributeOption()) continue;
            if (col == 0) {
                cwidth.append(widths[col]);
            } else if (col >= table.getColumnCount() - 3) {
                cwidth.append(widths[col - table.getColumnCount() + 4]);
            } else {
                cwidth.append("10");
            }
            cwidth.append(" ");
        }
        if (this._options.getAttributeOption()) {
            align.append("L L L C");
        } else {
            align.append("L L C");
        }
        cwidth.deleteCharAt(cwidth.length() - 1);
        b.append("<TABDEF CWIDTH = '");
        b.append((CharSequence)cwidth);
        b.append("' ALIGN = '");
        b.append((CharSequence)align);
        b.append("'>\n");
        for (int row = 0; row < table.getRowCount(); ++row) {
            for (int col = 0; col < table.getColumnCount(); ++col) {
                if (col == table.getColumnCount() - 2 && !this._options.getAttributeOption()) continue;
                Object value = table.getValueAt(row, col);
                b.append("<C>" + this.convertValue(value) + "\n");
            }
        }
        b.append("<ETABLEAU>\n");
        scribe.concat(b.toString());
    }

    public void exportXMLDocBook(File file) throws IOException {
        this.xmlWriter = new DBKOutput(file);
        if (this.xmlWriter.getXmlOutputFile() != null) {
            this.xmlWriter.printHeadXML();
            this.xmlWriter.write("<title>", false);
            this.xmlWriter.write(ResMsgVoc.getString("VOC_FMEA"), true);
            this.xmlWriter.write("</title>\n", false);
            this.printXmlBegining();
            this.xmlWriter.writeSection(1, Messages.getString("FmeaPanel.39"));
            ArrayList<String> columns = new ArrayList<String>();
            for (int col = 0; col < this._table.getColumnCount(); ++col) {
                columns.add(this._table.getColumnName(col));
            }
            String str = "";
            int iMoreRows = 0;
            ArrayList rows = new ArrayList();
            ArrayList<List> moreRows = new ArrayList<List>();
            for (int row = 0; row < this._table.getRowCount(); ++row) {
                ArrayList<String> irow = new ArrayList<String>();
                ArrayList<Integer> moreRow = new ArrayList<Integer>();
                for (int col = 0; col < this._table.getColumnCount(); ++col) {
                    Object value = this._table.getValueAt(row, col);
                    FmeaTable.FusionedCell cell = this._table.getFusionedCell(row, col);
                    if (cell == null) {
                        str = this.convertValue(value);
                        iMoreRows = 0;
                    } else if (cell._rStart == row) {
                        str = this.convertValue(value);
                        iMoreRows = cell._rStart == cell._rEnd ? 0 : cell._rEnd - cell._rStart;
                    } else {
                        str = "";
                        iMoreRows = -1;
                    }
                    irow.add(str);
                    moreRow.add(iMoreRows);
                }
                rows.add(irow);
                moreRows.add(moreRow);
            }
            DBKTableModel tableModel = new DBKTableModel(rows, columns, moreRows, DBKTableModel.DataType.OBJECTS);
            this.xmlWriter.insertTable(tableModel);
            this.xmlWriter.writeEndSection(1);
            this.printXmlExternalAttributeRefScribeFile();
            this.xmlWriter.printFootXML();
        }
    }

    public void printXmlBegining() {
        try {
            if (this._options.getAnalysisOption()) {
                DBFolder fmea = this._dbFolder.getParent();
                DBFolder system = fmea.getParent();
                DBFolder project = system.getParent();
                this.xmlWriter.writeSection(1, ResMsgArbor.getString("KEY_0377"));
                this.xmlWriter.writeSection(2, ResMsgVoc.getString("VOC_IDENTIFICATION"));
                this.xmlWriter.write("<para>", false);
                this.xmlWriter.write(ResMsgVoc.getString("VOC_PROJECT") + " : " + project.getName(), true);
                String description = project.getDescription();
                if (description != null && description.length() > 0) {
                    this.xmlWriter.write("<para>", false);
                    this.xmlWriter.write(description, true);
                    this.xmlWriter.write("</para>\n", false);
                }
                this.xmlWriter.write("</para>\n", false);
                this.xmlWriter.write("<para>", false);
                this.xmlWriter.write(ResMsgVoc.getString("VOC_SYSTEM") + " : " + system.getName(), true);
                description = system.getDescription();
                if (description != null && description.length() > 0) {
                    this.xmlWriter.write("<para>", false);
                    this.xmlWriter.write(description, true);
                    this.xmlWriter.write("</para>\n", false);
                }
                this.xmlWriter.write("</para>\n", false);
                this.xmlWriter.write("<para>", false);
                this.xmlWriter.write(ResMsgVoc.getString("VOC_FMEA") + " : " + fmea.getName(), true);
                this.xmlWriter.write(" (" + this._dbFolder.getName() + ")\n", false);
                description = fmea.getDescription();
                if (description != null && description.length() > 0) {
                    this.xmlWriter.write("<para>", false);
                    this.xmlWriter.write(description, true);
                    this.xmlWriter.write("</para>\n", false);
                }
                if ((description = this._dbFolder.getDescription()) != null && description.length() > 0) {
                    this.xmlWriter.write("<para>", false);
                    this.xmlWriter.write(description, true);
                    this.xmlWriter.write("</para>\n", false);
                }
                this.xmlWriter.write("</para>\n", false);
                this.xmlWriter.writeEndSection(2);
                String createDate = this._options.formatDate(this._dbFolder.getDateCreate());
                String createBy = null;
                String modifyDate = this._options.formatDate(this._dbFolder.getDateModify());
                String modifyBy = this._dbFolder.getUserModify().getLogin();
                DBObjProperty dbObjProp = null;
                if (this._dbFolder.isVersion() && this._dbFolder.getObject() != null) {
                    dbObjProp = this._dbFolder.getObject().getProperty("object.creator");
                }
                if (dbObjProp != null) {
                    createBy = dbObjProp.getValue();
                }
                this.xmlWriter.writeSection(2, ResMsgVoc.getString("VOC_DATES"));
                this.xmlWriter.write("<para>", false);
                if (createBy != null) {
                    this.xmlWriter.write(ResMsgVoc.getString("VOC_CREATION") + " : " + ResMsgCore.msgFormat("MSG_DATE_BY_USER", createDate, createBy), true);
                } else {
                    this.xmlWriter.write(ResMsgVoc.getString("VOC_CREATION") + " : " + createDate + "<EHP2>\n", true);
                }
                this.xmlWriter.write("</para>\n", false);
                this.xmlWriter.write("<para>", false);
                this.xmlWriter.write(ResMsgVoc.getString("VOC_MODIFICATION") + " : " + ResMsgCore.msgFormat("MSG_DATE_BY_USER", modifyDate, modifyBy), true);
                this.xmlWriter.write("</para>\n", false);
                this.xmlWriter.writeEndSection(2);
                this.xmlWriter.writeEndSection(1);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void printXmlExternalAttributeRefScribeFile() {
        try {
            this.xmlWriter.writeSection(1, Messages.getString("FmeaPrintablePage.11"));
            ArrayList<Point> externRefAttr = new ArrayList<Point>();
            FmeaTableModel model = this._table.getFmeaTableModel();
            for (int row = 0; row < this._table.getRowCount(); ++row) {
                for (int col = 0; col < this._table.getColumnCount(); ++col) {
                    int mdlCol = this._table.convertColumnIndexToModel(col);
                    int mdlRow = this._table.convertRowIndexToFmeaModel(row);
                    FmeaAttribute attribute = model.getAttributeAt(mdlRow, mdlCol);
                    if (!(attribute instanceof FmeaExternalRefAttribute)) continue;
                    externRefAttr.add(new Point(mdlRow, mdlCol));
                }
            }
            if (externRefAttr.size() == 0) {
                this.xmlWriter.write("<para>", false);
                this.xmlWriter.write(Messages.getString("FmeaPrintablePage.12"), true);
                this.xmlWriter.write("</para>\n", false);
            } else {
                for (int i = 0; i < externRefAttr.size(); ++i) {
                    Point p = (Point)externRefAttr.get(i);
                    int row = p.x;
                    int col = p.y;
                    this.printXmlExternalAttributeRefScribeFile(row, col);
                }
            }
            this.xmlWriter.writeEndSection(1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void printXmlExternalAttributeRefScribeFile(int row, int col) {
        try {
            FmeaTableModel model = this._table.getFmeaTableModel();
            FmeaColumnDefinition colDef = model.getColumnDefinition(col);
            FmeaExternalRefAttribute attribute = (FmeaExternalRefAttribute)model.getAttributeAt(row, col);
            FmeaEntity entity = model.getEntityAt(row, col);
            Object value = attribute.getValue();
            String str = this.convertValue(value);
            this.xmlWriter.writeSection(2, ResMsgVoc.getString("VOC_REFERENCE") + " : " + colDef.getEntityDefinition().getName() + "." + entity.getName());
            this.xmlWriter.write("<para>", false);
            this.xmlWriter.write(ResMsgVoc.getString("VOC_VALUE") + " : " + str, true);
            this.xmlWriter.write("</para>\n", false);
            ExternalFmeaReferenceTableModel mdl = new ExternalFmeaReferenceTableModel();
            mdl.setReferences(new ArrayList<ExternalFmeaReference>(attribute.getExternalReferences()));
            JTable tbl = new JTable(mdl);
            this.printXmlExternalAttributeRefScribeFile(tbl);
            this.xmlWriter.writeEndSection(2);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void printXmlExternalAttributeRefScribeFile(JTable table) {
        ArrayList<String> columns = new ArrayList<String>();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            if (col == 2 && !this._options.getAttributeOption()) continue;
            columns.add(table.getColumnName(col));
        }
        String str = "";
        ArrayList rows = new ArrayList();
        for (int row = 0; row < table.getRowCount(); ++row) {
            ArrayList<String> irow = new ArrayList<String>();
            for (int col = 0; col < table.getColumnCount(); ++col) {
                if (col == 2 && !this._options.getAttributeOption()) continue;
                Object value = table.getValueAt(row, col);
                str = this.convertValue(value);
                irow.add(str);
            }
            rows.add(irow);
        }
        DBKTableModel tableModel = new DBKTableModel(rows, columns, DBKTableModel.DataType.OBJECTS);
        this.xmlWriter.insertTable(tableModel);
    }

    private String convertValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Number) {
            return this._options.formatDouble(((Number)value).doubleValue());
        }
        return value.toString().replace('\n', ' ');
    }
}

