/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.Dictionnary;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class DictionnaryStore
extends FmeaObject
implements DictionnaryManager,
FmeaSerializable {
    private static DictionnaryStore __instance = null;
    private Map<String, Dictionnary> _dictionnaries = new TreeMap<String, Dictionnary>();

    public static DictionnaryStore getInstance() {
        return __instance == null ? (__instance = new DictionnaryStore()) : __instance;
    }

    @Override
    public Collection<Dictionnary> getDictionnaries() {
        return this._dictionnaries.values();
    }

    @Override
    public void setDictionnaries(Collection<Dictionnary> dictionnaries) {
        this._dictionnaries.clear();
        for (Dictionnary dico : dictionnaries) {
            this._dictionnaries.put(dico.getName(), dico);
        }
    }

    @Override
    public Dictionnary getDictionnary(String name) {
        return this._dictionnaries.get(name);
    }

    @Override
    public void addDictionnary(Dictionnary dico) {
        this._dictionnaries.put(dico.getName(), dico);
        dico.getChangeNotifier().addChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    @Override
    public void removeDictionnary(String name) {
        this._dictionnaries.remove(name);
        this._changeNotifier.changed(this);
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        for (Dictionnary dico : this.getDictionnaries()) {
            dico.writeXML(w);
        }
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        for (Dictionnary dico : this.getDictionnaries()) {
            dico.toXML(out, indent);
        }
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }
}

