/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaHead;
import com.dassault.cecilia.dbobj.fmea.model.FmeaModel;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelation;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelationDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Element;

public class Fmea
extends FmeaObject
implements FmeaSerializable {
    public static List<Msg> errorMgr = new ArrayList<Msg>();
    private FmeaModel fmeaModel = null;
    private Map<String, Map<Integer, FmeaEntity>> entities = new LinkedHashMap<String, Map<Integer, FmeaEntity>>();
    private List<ExternalFmeaReference> externalLinks;
    private Collection<FmeaRelation> relations = new TreeSet<FmeaRelation>(new Comparator<FmeaRelation>(){

        @Override
        public int compare(FmeaRelation rel1, FmeaRelation rel2) {
            int r = rel1.getDefinition().getKey().compareTo(rel2.getDefinition().getKey());
            if (r != 0) {
                return r;
            }
            r = rel1.getEntity1().getReferenceID().compareTo(rel2.getEntity1().getReferenceID());
            if (r != 0) {
                return r;
            }
            return rel1.getEntity2().getReferenceID().compareTo(rel2.getEntity2().getReferenceID());
        }
    });
    private Map<Integer, String> ReferenceID_to_Name = new HashMap<Integer, String>();
    private Map<String, Integer> Name_to_ReferenceID = new HashMap<String, Integer>();
    public static int READ_WRITE = 0;
    public static int READ_ONLY = 1;
    private int openMode = READ_WRITE;

    public Fmea() {
        this.fmeaModel = new FmeaModel();
        FmeaTableDefinition ftd = new FmeaTableDefinition();
        ftd.setHead(new FmeaHead());
        this.fmeaModel.setTableDefinition(ftd);
        this.externalLinks = new ArrayList<ExternalFmeaReference>();
    }

    public void setModel(FmeaModel fm) {
        if (this.fmeaModel != null) {
            this.fmeaModel.getChangeNotifier().removeChangeListener(this._changeNotifier);
        }
        this.fmeaModel = fm;
        this.fmeaModel.getChangeNotifier().addChangeListener(this._changeNotifier);
        this.externalLinks = new ArrayList<ExternalFmeaReference>();
    }

    public FmeaModel getModel() {
        return this.fmeaModel;
    }

    public void registerEntity(FmeaEntity entity) {
        Integer referenceID = entity.getReferenceID();
        String globalName = entity.getGlobalName();
        this.ReferenceID_to_Name.put(referenceID, globalName);
        this.Name_to_ReferenceID.put(globalName, referenceID);
    }

    public void unregisterEntity(FmeaEntity entity) {
        Integer referenceID = entity.getReferenceID();
        String globalName = entity.getGlobalName();
        this.ReferenceID_to_Name.remove(referenceID);
        this.Name_to_ReferenceID.remove(globalName);
    }

    public Integer getReferenceID(String globalName) {
        return this.Name_to_ReferenceID.get(globalName);
    }

    public String getName(int referenceID) {
        return this.ReferenceID_to_Name.get(referenceID);
    }

    public FmeaEntity getEntity(String definitionKey, String name) {
        Integer referenceID = this.getReferenceID(FmeaEntity.FormatGlobalName(definitionKey, name));
        return referenceID == null ? null : this.entities.get(definitionKey).get(referenceID);
    }

    public Map<Integer, FmeaEntity> getEntities(String definitionKey) {
        return this.entities.get(definitionKey);
    }

    public void changeEntityDefinitionName(String oldName, String newName) {
        this.getModel().changeEntityDefinitionName(oldName, newName);
    }

    public void removeEntity(FmeaEntity entity) {
        boolean origin = entity.getDefinition().equals(this.getModel().getEntityPath().get(0));
        Iterator<FmeaRelation> itr = this.relations.iterator();
        while (itr.hasNext()) {
            FmeaRelation relation = itr.next();
            if (!origin && relation.getEntity2() == entity) {
                relation.getEntity1().removeRelation(entity);
                itr.remove();
                continue;
            }
            if (relation.getEntity1() != entity) continue;
            itr.remove();
        }
        entity.removeRelations();
        entity.setRelationOrigin(null);
        Map<Integer, FmeaEntity> entityMap = this.entities.get(entity.getDefinition().getKey());
        if (entityMap != null) {
            entityMap.remove(entity.getReferenceID());
            entity.release();
            this.unregisterEntity(entity);
        }
        entity.getChangeNotifier().removeChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void addEntityDefinition(FmeaEntityDefinition entityDef) {
        this.getModel().addEntityDefinition(entityDef);
        this.entities.put(entityDef.getKey(), new LinkedHashMap());
        this._changeNotifier.changed(this);
    }

    public void removeEntityDefinition(FmeaEntityDefinition entityDef) {
        this.getModel().removeEntityDefinition(entityDef);
        this.entities.remove(entityDef.getKey());
        this._changeNotifier.changed(this);
    }

    public void addRelation(FmeaRelation relation) {
        this.relations.add(relation);
        String entityDef1 = relation.getDefinition().getEntityDef1();
        Map<Integer, FmeaEntity> entityMap = this.entities.get(entityDef1);
        FmeaEntity entity1 = entityMap.get(relation.getEntity1().getReferenceID());
        String entityDef2 = relation.getDefinition().getEntityDef2();
        entityMap = this.entities.get(entityDef2);
        FmeaEntity entity2 = entityMap.get(relation.getEntity2().getReferenceID());
        entity1.addRelation(entity2);
        entity2.setRelationOrigin(entity1);
        this._changeNotifier.changed(this);
    }

    public void removeRelation(FmeaEntity entity1, FmeaEntity entity2) {
        FmeaRelationDefinition relDef = this.getModel().getRelationDefinition(entity1.getDefinition(), entity2.getDefinition());
        FmeaRelation relation = new FmeaRelation(relDef, entity1, entity2);
        this.relations.remove(relation);
        entity1.removeRelation(entity2);
        entity2.setRelationOrigin(null);
        relation.getChangeNotifier().removeChangeListener(this._changeNotifier);
        this._changeNotifier.changed(this);
    }

    public void addRelationDefinition(FmeaRelationDefinition relationDef) {
        this.getModel().addRelationDefinition(relationDef);
        this._changeNotifier.changed(this);
    }

    public void removeRelationDefinition(FmeaRelationDefinition relationDef) {
        Iterator<FmeaRelation> it = this.relations.iterator();
        while (it.hasNext()) {
            FmeaRelation relation = it.next();
            if (relation.getDefinition() != relationDef) continue;
            it.remove();
        }
        this.getModel().removeRelationDefinition(relationDef);
        this._changeNotifier.changed(this);
    }

    public FmeaEntity createEntity(FmeaEntityDefinition entDef, String name) {
        FmeaEntity entity = new FmeaEntity(entDef, name);
        entity.getChangeNotifier().addChangeListener(this._changeNotifier);
        this.addEntity(entity);
        this._changeNotifier.changed(this);
        return entity;
    }

    public FmeaRelation createRelation(FmeaEntity entity) {
        FmeaEntityDefinition relatedEntityDef = entity.getDefinition().getDefaultRelatedEntityDefinition();
        if (relatedEntityDef == null) {
            return null;
        }
        FmeaEntity newEntity = this.createEntity(relatedEntityDef, null);
        FmeaRelation relation = this.createRelation(entity, newEntity);
        this._changeNotifier.changed(this);
        return relation;
    }

    public FmeaRelation createAllRelations(FmeaEntity entity) {
        FmeaEntityDefinition relatedEntityDef = entity.getDefinition().getDefaultRelatedEntityDefinition();
        if (relatedEntityDef == null) {
            return null;
        }
        FmeaRelation relation = this.createAllRelations(this.createRelation(entity).getEntity2());
        this._changeNotifier.changed(this);
        return relation;
    }

    public boolean checkValue(Object value, int row, int col) {
        return this.getModel().checkValue(value, row, col);
    }

    private Collection<FmeaColumnDefinition[]> findRelationDefinitions(Collection columns) {
        HashSet<FmeaColumnDefinition[]> relationDefs = new HashSet<FmeaColumnDefinition[]>();
        ArrayList cols1 = new ArrayList(columns);
        ArrayList cols2 = new ArrayList(columns);
        for (String col1 : cols1) {
            FmeaEntityDefinition entityDef1;
            FmeaColumnDefinition columnDef1 = this.getModel().getTableDefinition().getColumnDefinitionWithName(col1);
            if (!(columnDef1.getColumnType() instanceof FmeaAttributeDefinition.Reference) || (entityDef1 = columnDef1.getEntityDefinition()) == null) continue;
            for (String col2 : cols2) {
                FmeaRelationDefinition relDef;
                FmeaEntityDefinition entityDef2;
                FmeaColumnDefinition columnDef2 = this.getModel().getTableDefinition().getColumnDefinitionWithName(col2);
                if (!(columnDef2.getColumnType() instanceof FmeaAttributeDefinition.Reference) || (entityDef2 = columnDef2.getEntityDefinition()) == null || (relDef = this.getModel().getRelationDefinition(entityDef1, entityDef2)) == null) continue;
                FmeaColumnDefinition[] rel = new FmeaColumnDefinition[]{columnDef1, columnDef2};
                relationDefs.add(rel);
            }
        }
        return relationDefs;
    }

    public void importData(List lines, Map<String, Integer> columnMatch, List<Msg> errMng, boolean importLineAsSingleEntity) {
        if (!importLineAsSingleEntity) {
            this.importData1(lines, columnMatch, errMng);
        } else {
            this.importData2(lines, columnMatch, errMng);
        }
    }

    public void importData2(List lines, Map<String, Integer> columnMatch, List<Msg> errMng) {
        FmeaEntityDefinition entityDef = (FmeaEntityDefinition)this.getModel().getEntityDefinitions()[0];
        Iterator itr_lines = lines.iterator();
        while (itr_lines.hasNext()) {
            FmeaEntity entity = this.createEntity(entityDef, null);
            String entityName = entity.getName();
            List fields = (List)itr_lines.next();
            for (String column : columnMatch.keySet()) {
                FmeaColumnDefinition columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(column);
                if (columnDef.getAttributeDefinition().getType() instanceof FmeaAttributeDefinition.Reference) continue;
                FmeaAttributeDefinition attDef = columnDef.getAttributeDefinition();
                String attributeName = attDef.getName();
                int f_col = columnMatch.get(column);
                if (f_col >= fields.size()) continue;
                String attributeValue = (String)fields.get(f_col);
                if (entity.importAttributeValue(attDef.getKey(), attributeValue)) continue;
                errMng.add(new Msg(Messages.msgFormat("Fmea.2", entityName, attributeName, attributeValue, entityDef.getName())));
            }
        }
    }

    public void importData1(List lines, Map<String, Integer> columnMatch, List<Msg> msgMng) {
        Collection<FmeaColumnDefinition[]> relationDefs = this.findRelationDefinitions(columnMatch.keySet());
        HashMap<String, Collection<String>> importedEntities = new HashMap<String, Collection<String>>();
        for (List fields : lines) {
            for (String column2 : columnMatch.keySet()) {
                String entityName;
                FmeaColumnDefinition columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(column2);
                if (!(columnDef.getColumnType() instanceof FmeaAttributeDefinition.Reference)) continue;
                FmeaEntityDefinition entityDef = columnDef.getEntityDefinition();
                int f_col = columnMatch.get(column2);
                if (f_col >= fields.size() || (entityName = (String)fields.get(f_col)).length() == 0 || this.isEntityAlreadyImported(entityName, entityDef.getKey(), importedEntities)) continue;
                FmeaEntity entity = this.getEntity(entityDef.getKey(), entityName);
                if (entity != null) {
                    msgMng.add(new Msg(Messages.msgFormat("Fmea.0", entityName, entityDef.getName()), MsgType.INFO));
                } else {
                    try {
                        entity = this.createEntity(entityDef, entityName);
                        this.registerImportedEntity(entityName, entityDef.getKey(), importedEntities);
                    }
                    catch (Exception e) {
                        msgMng.add(new Msg(Messages.msgFormat("Fmea.1", entityName, entityDef.getName())));
                        continue;
                    }
                }
                for (String column2 : columnMatch.keySet()) {
                    columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(column2);
                    if (columnDef.getEntityDefinition() != entityDef || columnDef.getAttributeDefinition().getType() instanceof FmeaAttributeDefinition.Reference) continue;
                    FmeaAttributeDefinition attDef = columnDef.getAttributeDefinition();
                    String attributeName = attDef.getName();
                    f_col = columnMatch.get(column2);
                    if (f_col >= fields.size()) continue;
                    String attributeValue = (String)fields.get(f_col);
                    if (entity.importAttributeValue(attDef.getKey(), attributeValue)) continue;
                    msgMng.add(new Msg(Messages.msgFormat("Fmea.2", entityName, attributeName, attributeValue, entityDef.getName())));
                }
            }
            for (FmeaColumnDefinition[] rel : relationDefs) {
                String entityName;
                FmeaColumnDefinition colDef1 = rel[0];
                FmeaEntityDefinition entityDef = colDef1.getEntityDefinition();
                String column = colDef1.getName();
                int f_col = columnMatch.get(column);
                if (f_col >= fields.size() || (entityName = (String)fields.get(columnMatch.get(column))).length() == 0) continue;
                FmeaEntity entity = this.getEntity(entityDef.getKey(), entityName);
                assert (entity != null);
                if (entity == null) continue;
                FmeaColumnDefinition colDef2 = rel[1];
                FmeaEntityDefinition linked_entityDef = colDef2.getEntityDefinition();
                String linked_entityName = (String)fields.get(columnMatch.get(colDef2.getName()));
                FmeaEntity linked_entity = this.getEntity(linked_entityDef.getKey(), linked_entityName);
                assert (linked_entity != null);
                if (linked_entity == null) continue;
                try {
                    this.createRelation(entity, linked_entity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    msgMng.add(new Msg(Messages.msgFormat("Fmea.3", entity.getName(), linked_entity.getName())));
                }
            }
        }
    }

    public void importData3(List lines, Vector columnMatch, Vector columnRelations, List<Msg> msgMng) {
        HashMap<String, Collection<String>> importedEntities = new HashMap<String, Collection<String>>();
        for (List fields : lines) {
            for (Vector match : columnMatch) {
                String entityName;
                FmeaColumnDefinition columnDef;
                String column = (String)match.get(1);
                if (column == null || !((columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(column)).getColumnType() instanceof FmeaAttributeDefinition.Reference)) continue;
                FmeaEntityDefinition entityDef = columnDef.getEntityDefinition();
                Integer f_col = (Integer)match.get(0);
                if (f_col >= fields.size() || (entityName = (String)fields.get(f_col)).length() == 0 || this.isEntityAlreadyImported(entityName, entityDef.getKey(), importedEntities)) continue;
                FmeaEntity entity = this.getEntity(entityDef.getKey(), entityName);
                if (entity != null) {
                    msgMng.add(new Msg(Messages.msgFormat("Fmea.0", entityName, entityDef.getKey()), MsgType.INFO));
                } else {
                    try {
                        entity = this.createEntity(entityDef, entityName);
                        this.registerImportedEntity(entityName, entityDef.getKey(), importedEntities);
                    }
                    catch (Exception e) {
                        msgMng.add(new Msg(Messages.msgFormat("Fmea.1", entityName, entityDef.getName())));
                        continue;
                    }
                }
                for (int i = 0; i < columnMatch.size(); ++i) {
                    String attributeValue;
                    match = (Vector)columnMatch.get(i);
                    column = (String)match.get(1);
                    if (column == null || (columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(column)).getEntityDefinition() != entityDef || columnDef.getAttributeDefinition().getType() instanceof FmeaAttributeDefinition.Reference) continue;
                    String attributeName = columnDef.getAttributeDefinition().getName();
                    f_col = (Integer)match.get(0);
                    if (f_col >= fields.size() || entity.importAttributeValue(attributeName, attributeValue = (String)fields.get(f_col))) continue;
                    msgMng.add(new Msg(Messages.msgFormat("Fmea.2", entityName, attributeName, attributeValue, entityDef.getName())));
                }
            }
            for (Vector relation : columnRelations) {
                String linked_entityName;
                String entityName;
                Integer f_col = (Integer)relation.get(0);
                Integer f_lnk_col = (Integer)relation.get(1);
                if (f_col >= fields.size() || f_lnk_col >= fields.size() || (entityName = (String)fields.get(f_col)).length() == 0 || (linked_entityName = (String)fields.get(f_lnk_col)).length() == 0) continue;
                String column = null;
                for (int i = 0; i < columnMatch.size(); ++i) {
                    Vector match = (Vector)columnMatch.get(i);
                    if (!match.get(0).equals(f_col)) continue;
                    column = (String)match.get(1);
                    break;
                }
                String linked_column = null;
                for (int i = 0; i < columnMatch.size(); ++i) {
                    Vector match = (Vector)columnMatch.get(i);
                    if (!match.get(0).equals(f_lnk_col)) continue;
                    linked_column = (String)match.get(1);
                    break;
                }
                assert (column != null && linked_column != null);
                FmeaColumnDefinition columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(column);
                FmeaEntityDefinition entityDef = columnDef.getEntityDefinition();
                FmeaEntity entity = this.getEntity(entityDef.getName(), entityName);
                assert (entity != null);
                FmeaColumnDefinition linked_columnDef = this.getModel().getTableDefinition().getColumnDefinitionWithName(linked_column);
                FmeaEntityDefinition linked_entityDef = linked_columnDef.getEntityDefinition();
                FmeaEntity linked_entity = this.getEntity(linked_entityDef.getName(), linked_entityName);
                assert (linked_entity != null);
                try {
                    this.createRelation(entity, linked_entity);
                }
                catch (Exception e) {
                    msgMng.add(new Msg(Messages.msgFormat("Fmea.3", entity.getName(), linked_entity.getName())));
                }
            }
        }
    }

    public void printEntityMap() {
        System.out.println(this.entities);
        System.out.println();
        System.out.println();
        for (String entityDefKey : this.entities.keySet()) {
            System.out.println("--------------" + entityDefKey + "--------------");
            Map<Integer, FmeaEntity> entityMap = this.entities.get(entityDefKey);
            for (FmeaEntity entity : entityMap.values()) {
                entity.print();
            }
        }
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.incTabCount();
        w.writeln("<FMEA>");
        this.fmeaModel.writeXML(w);
        this.writeXMLData(w);
        w.writeln("</FMEA>");
        w.decTabCount();
        this.getChangeNotifier().setChanged(false);
    }

    public void writeXMLData(FmeaBufferedWriter w) throws IOException {
        w.incTabCount();
        this.writeXMLEntities(w);
        this.writeXMLRelations(w);
        w.decTabCount();
        this.getChangeNotifier().setChanged(false);
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        Iterator<Object> it = this.entities.values().iterator();
        while (it.hasNext()) {
            for (FmeaEntity entity : it.next().values()) {
                entity.toXML(out, indent);
            }
        }
        for (FmeaRelation relation : this.relations) {
            relation.toXML(out, indent);
        }
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    private void addEntity(FmeaEntity entity) {
        Map<Integer, FmeaEntity> entityMap = this.entities.get(entity.getDefinition().getKey());
        entityMap.put(entity.getReferenceID(), entity);
        this.registerEntity(entity);
    }

    private FmeaRelation createRelation(FmeaEntity entity1, FmeaEntity entity2) {
        FmeaRelationDefinition relationDef = this.getModel().getRelationDefinition(entity1.getDefinition(), entity2.getDefinition());
        FmeaRelation relation = new FmeaRelation(relationDef, entity1, entity2);
        relation.getChangeNotifier().addChangeListener(this._changeNotifier);
        this.addRelation(relation);
        return relation;
    }

    private void registerImportedEntity(String entity, String entityDefKey, Map<String, Collection<String>> importedEntities) {
        Collection<String> col = importedEntities.get(entityDefKey);
        if (col == null) {
            col = new HashSet<String>();
            importedEntities.put(entityDefKey, col);
        }
        col.add(entity);
    }

    private boolean isEntityAlreadyImported(String entity, String entityDefKey, Map<String, Collection<String>> importedEntities) {
        Collection<String> col = importedEntities.get(entityDefKey);
        if (col == null) {
            return false;
        }
        return col.contains(entity);
    }

    private void writeXMLEntities(FmeaBufferedWriter w) throws IOException {
        Iterator<Map<Integer, FmeaEntity>> it = this.entities.values().iterator();
        while (it.hasNext()) {
            for (FmeaEntity entity : it.next().values()) {
                entity.writeXML(w);
            }
        }
    }

    private void writeXMLRelations(FmeaBufferedWriter w) throws IOException {
        for (FmeaRelation relation : this.relations) {
            relation.writeXML(w);
        }
    }

    public void setOpenMode(int mode) {
        this.openMode = mode;
    }

    public int getOpenMode() {
        return this.openMode;
    }

    public List<ExternalFmeaReference> getExternalLinks() {
        return this.externalLinks;
    }

    public Double getValueOf(String fmeaEntId, String fmeaEntName, String fmeaEntValue, String fmeaAttId, String fmeaAttName) {
        FmeaEntity entity = this.getEntity(fmeaEntId, fmeaEntValue);
        if (entity == null) {
            return null;
        }
        FmeaAttribute attribute = entity.getAttribute(fmeaAttId);
        if (attribute == null) {
            return null;
        }
        Object value = attribute.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        Iterator<Map<Integer, FmeaEntity>> it = this.entities.values().iterator();
        while (it.hasNext()) {
            for (FmeaEntity entity : it.next().values()) {
                result |= entity.update(daoFactory, logMng);
            }
        }
        return result;
    }
}

