/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.event.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.gui.DBAttribValuesTablePanel;
import com.dassault.cecilia.dbobj.general.event.Event;
import com.dassault.cecilia.dbobj.general.event.gui.EventLawPanel;
import com.dassault.cecilia.dbobj.general.event.gui.EventModifierLawPanel;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class EventsDlgEdit
extends JDialogCecilia {
    protected CeciliaAppl _appl;
    protected JSplitPane _splitPane;
    private static EventsDlgEdit __dlg;
    JTextArea _ctrlLabel;
    DBAttribValuesTablePanel _ctrlAttribs;
    EventLawPanel _ctrlLawPanel;
    EventModifierLawPanel _ctrlModifierPanel;
    Collection<? extends Event> _events;
    String _valueLabel;
    boolean _validLabel;
    ArrayList<DBAttrib.Value> _currentAttribs;
    ArrayList<DBAttrib.Value> _previousAttribs;
    int _typeDistrib;
    Law _valueLaw;
    DBModelLaw _dbModelLaw;
    int _typeModifier;
    Param _valueParam;

    public static EventsDlgEdit getInstance(JPanel parent, CeciliaAppl appl, String title) {
        if (__dlg == null) {
            __dlg = new EventsDlgEdit(JOptionCecilia.getWindowOf(parent), appl);
            __dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(parent));
        }
        __dlg.setTitle(title);
        return __dlg;
    }

    protected EventsDlgEdit(Window owner, CeciliaAppl appl) throws HeadlessException {
        super(owner);
        this._appl = appl;
        this.make();
        this.setModal(true);
        this.fixSize(owner);
    }

    protected void fixSize(Window owner) {
        this.pack();
        this.setSize(720, 450);
        this.setLocationRelativeTo(owner);
        this._splitPane.setDividerLocation(320);
    }

    protected boolean isEditable() {
        return !this._appl.isReader();
    }

    private void make() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createContentPanel(), "Center");
        if (this.isEditable()) {
            this.getContentPane().add((Component)this.createButPanel(), "South");
        } else {
            this.getContentPane().add((Component)this.createButPanelClose(), "South");
        }
        this.init();
    }

    protected Component createContentPanel() {
        JPanel content = new JPanel(new GridBagLayout());
        content.add(this.createLabelPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.6, 11, 1, new Insets(0, 0, 2, 0), 0, 0));
        content.add(this.createAttribPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 1, new Insets(2, 0, 0, 0), 0, 0));
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._splitPane = new JSplitPane(1, content, this.createDistribPanel());
        return this._splitPane;
    }

    protected Component createLabelPanel() {
        this._ctrlLabel = new JTextArea(3, 20);
        this._ctrlLabel.setEditable(this.isEditable());
        this._ctrlLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String txt;
                if (!EventsDlgEdit.this._validLabel && !(txt = EventsDlgEdit.this._ctrlLabel.getText()).equals(EventsDlgEdit.this._valueLabel)) {
                    EventsDlgEdit.this._validLabel = true;
                }
                super.focusLost(e);
            }
        });
        JScrollPane scroll = new JScrollPane(this._ctrlLabel);
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_COMMENTS")));
        return scroll;
    }

    protected Component createAttribPanel() {
        this._ctrlAttribs = new DBAttribValuesTablePanel(this, this._appl);
        this._ctrlAttribs.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_ATTRIBUTES")));
        return this._ctrlAttribs;
    }

    protected Component createDistribPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlLawPanel = new EventLawPanel(this._appl);
        result.add((Component)this._ctrlLawPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._ctrlModifierPanel = new EventModifierLawPanel(this._appl);
        result.add((Component)this._ctrlModifierPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        result.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_DISTRIBUTION"))));
        this._ctrlLawPanel.setEditable(this.isEditable());
        this._ctrlModifierPanel.setEditable(this.isEditable());
        return result;
    }

    public void setEvents(Collection<? extends Event> events) {
        this._ctrlLawPanel.setLaw(0, null, null);
        this._events = events;
        Iterator<? extends Event> iterEvt = events.iterator();
        this.setFirstEvent(iterEvt.next());
        while (iterEvt.hasNext()) {
            this.setNextEvent(iterEvt.next());
        }
        this._previousAttribs = new ArrayList();
        for (DBAttrib.Value attrib : this._currentAttribs) {
            this._previousAttribs.add(attrib.getCopy());
        }
        this._ctrlLabel.setText(this._validLabel ? this._valueLabel : "");
        if (this._validLabel) {
            this._ctrlLabel.setCaretPosition(0);
        }
        this._ctrlAttribs.setItems(this._currentAttribs);
        this._ctrlLawPanel.setLaw(this._typeDistrib, this._valueLaw, this._dbModelLaw);
        this._ctrlModifierPanel.setModifier(this._typeModifier, this._valueParam);
    }

    protected void setFirstEvent(Event evt) {
        this._validLabel = true;
        this._valueLabel = evt.getLabel();
        this._dbModelLaw = evt.getModelLaw();
        if (this._dbModelLaw != null) {
            this._typeDistrib = 2;
        } else {
            this._valueLaw = evt.getOccurrence();
            if (this._valueLaw != null) {
                this._typeDistrib = 1;
                this._valueLaw = this._valueLaw.getCopy();
            } else {
                this._typeDistrib = 3;
            }
        }
        this._valueParam = evt.getInspected();
        if (this._valueParam != null) {
            this._typeModifier = 1;
            this._valueParam = this._valueParam.getCopy();
        } else {
            this._valueParam = evt.getInflightTested();
            if (this._valueParam != null) {
                this._typeModifier = 2;
                this._valueParam = this._valueParam.getCopy();
            } else {
                this._typeModifier = 0;
            }
        }
        this._currentAttribs = new ArrayList();
        for (DBAttrib.Value attrib : evt.getAttributes()) {
            this._currentAttribs.add(attrib.getCopy());
        }
    }

    protected void setNextEvent(Event evt) {
        Object current;
        if (this._validLabel && !this._valueLabel.equals(evt.getLabel())) {
            this._valueLabel = "";
            this._validLabel = false;
        }
        switch (this._typeDistrib) {
            case 0: {
                break;
            }
            case 1: {
                current = evt.getOccurrence();
                if (current == null) {
                    this._typeDistrib = 0;
                    break;
                }
                if (((Law)current).equals(this._valueLaw)) break;
                this._valueLaw = null;
                break;
            }
            case 2: {
                current = evt.getModelLaw();
                if (current == null) {
                    this._typeDistrib = 0;
                    break;
                }
                if (((DBModelLaw)current).equals(this._dbModelLaw)) break;
                this._dbModelLaw = null;
                break;
            }
            case 3: {
                if (evt.getOccurrence() == null && evt.getModelLaw() == null) break;
                this._typeDistrib = 0;
            }
        }
        switch (this._typeModifier) {
            case -1: {
                break;
            }
            case 0: {
                if (evt.getInspected() == null && evt.getInflightTested() == null) break;
                this._typeModifier = -1;
                break;
            }
            case 1: {
                current = evt.getInspected();
                if (current == null) {
                    this._typeModifier = -1;
                    break;
                }
                if (((Param)current).equals(this._valueParam)) break;
                this._valueParam = null;
                break;
            }
            case 2: {
                current = evt.getInflightTested();
                if (current == null) {
                    this._typeModifier = -1;
                    break;
                }
                if (((Param)current).equals(this._valueParam)) break;
                this._valueParam = null;
            }
        }
        if (!this._currentAttribs.isEmpty()) {
            ArrayList<DBAttrib.Value> union = new ArrayList<DBAttrib.Value>(this._currentAttribs.size());
            if (!evt.getAttributes().isEmpty()) {
                block12: for (DBAttrib.Value attrib : evt.getAttributes()) {
                    for (int i = this._currentAttribs.size() - 1; i >= 0; --i) {
                        if (!this._currentAttribs.get(i).equals(attrib)) continue;
                        union.add(this._currentAttribs.get(i));
                        continue block12;
                    }
                }
            }
            this._currentAttribs = union;
        }
    }

    public void affectEvents(Collection<? extends Event> selectEvents) {
        if (!this._previousAttribs.isEmpty()) {
            ArrayList<DBAttrib.Value> diff = new ArrayList<DBAttrib.Value>(this._previousAttribs.size());
            for (DBAttrib.Value attrib : this._previousAttribs) {
                boolean find = false;
                for (int i = this._currentAttribs.size() - 1; !find && i >= 0; --i) {
                    if (!this._currentAttribs.get(i).getKey().equals(attrib.getKey())) continue;
                    find = true;
                }
                if (find) continue;
                diff.add(attrib);
            }
            this._previousAttribs = diff;
        }
        Iterator<? extends Event> iterEvt = selectEvents.iterator();
        while (iterEvt.hasNext()) {
            this.affectEvent(iterEvt.next());
        }
    }

    protected void affectEvent(Event next) {
        if (this._validLabel) {
            next.setLabel(this._ctrlLabel.getText());
        }
        this._ctrlLawPanel.affectEvent(next);
        this._ctrlModifierPanel.affectEvent(next);
        if (!this._currentAttribs.isEmpty()) {
            for (DBAttrib.Value attrib : this._currentAttribs) {
                next.addAttribute(attrib);
            }
        }
        if (!this._previousAttribs.isEmpty()) {
            for (DBAttrib.Value attrib : this._previousAttribs) {
                next.delAttribute(attrib);
            }
        }
    }

    @Override
    protected boolean verifyParameters() {
        if (!this._ctrlLawPanel.verifyParameters(this._typeDistrib, this.getTitle())) {
            return false;
        }
        boolean simpleExp = true;
        Law law = this._ctrlLawPanel.getLaw();
        if (law != null) {
            boolean bl = simpleExp = law.getID() == 0 && law.getModifierLaw() == null;
        }
        return this._ctrlModifierPanel.verifyParameters(this._typeModifier, simpleExp, this.getTitle());
    }
}

