/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.icon;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class DBIcon
extends DBWrap {
    private static Logger _LOG = Logger.getLogger(DBIcon.class.getPackage().getName());
    ImageIcon _imag = null;
    boolean _mustBeSave = false;
    public static final String PROP_MIGRATION_HIDE_OCAS = "cecilia.migration.db51to60.HideLogImagOcasFormat";

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBIcon(DBFolder folder) {
        super(folder);
    }

    @Override
    public DBWrap getCopy() {
        return null;
    }

    public ImageIcon getImage() {
        return this._imag;
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.IMAG;
    }

    @Override
    protected String getNature() {
        return "image";
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        throw new IOException("Pas de XML pour les icones !!!");
    }

    @Override
    public boolean readFromDAO(DAOFactory cecFactory) {
        ImageIcon image;
        if (!this.verifyFolder()) {
            return false;
        }
        String oldFormat = null;
        DBObjModel model = this._dbFolder.getObject().getModel("image");
        if (model != null) {
            oldFormat = model.getFormat();
        }
        if ((image = DBIcon.readImage(this._dbFolder, cecFactory)) == null) {
            return false;
        }
        if (oldFormat != null) {
            String newFormat = null;
            DBObjModel model2 = this._dbFolder.getObject().getModel("image");
            if (model2 != null) {
                newFormat = model2.getFormat();
            }
            if (newFormat != null && !newFormat.equals(oldFormat)) {
                this._mustBeSave = true;
            }
        }
        this._imag = image;
        return true;
    }

    public static ImageIcon readImage(DBFolder dbFolder, DAOFactory daoFactory) {
        if (dbFolder == null) {
            throw new NullPointerException();
        }
        ImageIcon imag = null;
        DBObjModel model = dbFolder.getObject().getModel("image");
        if (model == null) {
            _LOG.info("Le DBIcon n'a pas de definition");
        } else {
            String format = model.getFormat();
            if (!(format.equals(DBObjModel.FORMAT_IMAGE_GIF) || format.equals(DBObjModel.FORMAT_IMAGE_JPG) || format.equals(DBObjModel.FORMAT_IMAGE_PNG))) {
                if (!(format == null || format.isEmpty() || format.equals("OCAS") && Boolean.getBoolean(PROP_MIGRATION_HIDE_OCAS))) {
                    _LOG.fine("Le format de l'image n'est pas reconnu : " + format);
                }
                byte[] ibytes = null;
                InputStream istream = daoFactory.createObjModelDAO().getBinaryStream(model);
                if (istream == null) {
                    _LOG.info("Le modele de donnee n'est pas lisible");
                } else {
                    ibytes = DAOObjModel.convertFromCompressedByte(istream);
                    if (ibytes == null) {
                        _LOG.info("Le modele de donnee n'est pas decompressable");
                    } else {
                        Image tkImag = Toolkit.getDefaultToolkit().createImage(ibytes);
                        if (tkImag == null) {
                            _LOG.info("L'image n'est pas compatible avec le Toolkit par defaut");
                        } else {
                            imag = new ImageIcon(tkImag);
                        }
                    }
                }
                if (imag != null) {
                    String extention;
                    String name;
                    int pos;
                    DBFolder dbParent = dbFolder.getParent();
                    if (dbParent.isModel() && (pos = (name = dbParent.getName()).lastIndexOf(".")) != -1 && !(extention = name.substring(pos + 1)).isEmpty() && ((extention = extention.toUpperCase()).equals(DBObjModel.FORMAT_IMAGE_GIF) || extention.equals(DBObjModel.FORMAT_IMAGE_JPG) || extention.equals(DBObjModel.FORMAT_IMAGE_PNG))) {
                        model.setFormat(extention);
                        model.setSize(ibytes.length).setStreamToSave(new ByteArrayInputStream(ibytes));
                        dbFolder.getObject().addModel(model);
                    }
                } else {
                    int height = 40;
                    int width = 40;
                    BufferedImage buffer = new BufferedImage(width, height, 1);
                    Graphics2D graph = buffer.createGraphics();
                    graph.setColor(Color.green);
                    graph.fillRect(0, 0, width, height);
                    graph.setColor(Color.gray);
                    graph.drawRect(0, 0, width - 1, height - 1);
                    imag = new ImageIcon(buffer);
                }
            }
            if (imag == null) {
                InputStream istream = daoFactory.createObjModelDAO().getBinaryStream(model);
                if (istream == null) {
                    _LOG.info("Le modele de donnee n'est pas lisible");
                } else {
                    byte[] ibytes = DAOObjModel.convertAsByte(istream);
                    if (ibytes == null) {
                        _LOG.info("Le modele de donnee n'est pas convertible");
                    } else {
                        Image tkImag = Toolkit.getDefaultToolkit().createImage(ibytes);
                        if (tkImag == null) {
                            _LOG.info("L'image n'est pas compatible avec le Toolkit par defaut");
                        } else {
                            imag = new ImageIcon(tkImag);
                        }
                    }
                }
            }
        }
        return imag;
    }

    public static byte[] readImageBytes(DBFolder dbFolder, DAOFactory daoFactory) {
        if (dbFolder == null) {
            throw new NullPointerException();
        }
        DBObjModel model = dbFolder.getObject().getModel("image");
        if (model == null) {
            _LOG.info("Le DBIcon n'a pas de definition");
        } else {
            InputStream istream;
            String format = model.getFormat();
            if (!(format.equals(DBObjModel.FORMAT_IMAGE_GIF) || format.equals(DBObjModel.FORMAT_IMAGE_JPG) || format.equals(DBObjModel.FORMAT_IMAGE_PNG))) {
                if (!(format == null || format.isEmpty() || format.equals("OCAS") && Boolean.getBoolean(PROP_MIGRATION_HIDE_OCAS))) {
                    _LOG.fine("Le format de l'image n'est pas reconnu : " + format);
                }
                if ((istream = daoFactory.createObjModelDAO().getBinaryStream(model)) == null) {
                    _LOG.info("Le modele de donnee n'est pas lisible");
                } else {
                    return DAOObjModel.convertFromCompressedByte(istream);
                }
            }
            if ((istream = daoFactory.createObjModelDAO().getBinaryStream(model)) == null) {
                _LOG.info("Le modele de donnee n'est pas lisible");
            } else {
                return DAOObjModel.convertAsByte(istream);
            }
        }
        return null;
    }

    @Override
    public boolean writeToDAO(DAOFactory cecFactory, DBUser dbModifyUser) {
        if (!this.verifyFolder()) {
            return false;
        }
        if (this._mustBeSave) {
            this._dbFolder.setRelations(null);
            return cecFactory.createFolderDAO().update(this._dbFolder);
        }
        return true;
    }

    public File savePNG(File path, double scale) {
        StringBuilder name = new StringBuilder(128);
        name.append("Icon_").append(this.getDBFolder().getParent().getName()).append("_");
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(name.toString(), ".png", path);
            Graphics2D graph = null;
            int width = (int)((double)(this._imag.getIconWidth() + 1) * scale);
            int height = (int)((double)(this._imag.getIconHeight() + 1) * scale);
            BufferedImage image = new BufferedImage(width, height, 1);
            graph = image.createGraphics();
            graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graph.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graph.setClip(0, 0, width, height);
            graph.scale(scale, scale);
            graph.setColor(Color.white);
            graph.fillRect(0, 0, width, height);
            graph.drawImage(this._imag.getImage(), 0, 0, null);
            ImageIO.write((RenderedImage)image, "png", tmpFile);
        }
        catch (Throwable th) {
            _LOG.log(Level.INFO, "Probleme lors de la sauvegarde de l'image : " + this.getDBFolder().getRefPath(), th);
            tmpFile = null;
        }
        return tmpFile;
    }
}

