/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.law.LawException;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;

public class ParamFMEA
extends Param {
    protected DBFolder _dbFolder;
    protected String _strDefineEntity;
    protected String _strDefineAttribute;
    protected String _strNameEntity;
    protected String _strNameAttribute;
    protected String _strValueEntity;
    protected double _dblValueAttribute;
    public static final String FLAG_FMEA = " /*" + ResMsgVoc.getString("VOC_FMEA") + "*/";

    public ParamFMEA(TypeParam type, DBFolder value) {
        super(type);
        this._dbFolder = value;
    }

    public ParamFMEA(TypeParam type, ExternalFmeaReference ref) {
        super(type);
        this._dbFolder = ref.getDBFolder();
        this._strDefineEntity = ref.getFmeaEntId();
        this._strDefineAttribute = ref.getFmeaAttId();
        this._strNameEntity = ref.getFmeaEntName();
        this._strNameAttribute = ref.getFmeaAttName();
        this._strValueEntity = ref.getFmeaEntValue();
        this._dblValueAttribute = (Double)ref.getFmeaAttValue();
    }

    public String getDefineEntity() {
        return this._strDefineEntity;
    }

    public String getDefineAttribute() {
        return this._strDefineAttribute;
    }

    public String getNameEntity() {
        return this._strNameEntity;
    }

    public String getNameAttribute() {
        return this._strNameAttribute;
    }

    public String getValueEntity() {
        return this._strValueEntity;
    }

    public double getValueAttribute() {
        return this._dblValueAttribute;
    }

    public ParamFMEA setDefineEntity(String value) {
        this._strDefineEntity = value;
        return this;
    }

    public ParamFMEA setDefineAttribute(String value) {
        this._strDefineAttribute = value;
        return this;
    }

    public ParamFMEA setNameEntity(String value) {
        this._strNameEntity = value;
        return this;
    }

    public ParamFMEA setNameAttribute(String value) {
        this._strNameAttribute = value;
        return this;
    }

    public ParamFMEA setValueEntity(String value) {
        this._strValueEntity = value;
        return this;
    }

    public ParamFMEA setValueAttribute(double value) {
        this._dblValueAttribute = value;
        return this;
    }

    @Override
    public ParamFMEA getCopy() {
        ParamFMEA result = new ParamFMEA(this._type, this._dbFolder);
        result.setDefineEntity(this.getDefineEntity());
        result.setDefineAttribute(this.getDefineAttribute());
        result.setNameEntity(this.getNameEntity());
        result.setNameAttribute(this.getNameAttribute());
        result.setValueEntity(this.getValueEntity());
        result.setValueAttribute(this.getValueAttribute());
        return result;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (!super.equals(otherObject)) {
            return false;
        }
        if (!(otherObject instanceof ParamFMEA)) {
            return false;
        }
        ParamFMEA other = (ParamFMEA)otherObject;
        if (!this._dbFolder.equals(other._dbFolder)) {
            return false;
        }
        if (!this._strDefineEntity.equals(other._strDefineEntity)) {
            return false;
        }
        if (!this._strDefineAttribute.equals(other._strDefineAttribute)) {
            return false;
        }
        if (!this._strNameEntity.equals(other._strNameEntity)) {
            return false;
        }
        if (!this._strNameAttribute.equals(other._strNameAttribute)) {
            return false;
        }
        if (!this._strValueEntity.equals(other._strValueEntity)) {
            return false;
        }
        return this._dblValueAttribute == other._dblValueAttribute;
    }

    @Override
    public void verify(DAOFactory daoFactory) throws LawException {
        if (!daoFactory.createFolderDAO().exist(this._dbFolder.getID())) {
            throw new LawException(ResMsgCore.msgFormat("MSG_ERR_ACCESS_UNKNOWN", this._dbFolder.getRefPath()));
        }
    }

    @Override
    public void toXML(Appendable out, String indent, boolean withID) throws IOException {
        out.append(indent).append("<").append("parameter.fmea");
        DBObjectXmlUtility.writeDBFolder(out, this._dbFolder, null, withID);
        DBObjectXmlUtility.appendXML(out.append(" ").append("def.elt").append("='"), this.getDefineEntity()).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("def.att").append("='"), this.getDefineAttribute()).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name.elt").append("='"), this.getNameEntity()).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name.att").append("='"), this.getNameAttribute()).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("val.elt").append("='"), this.getValueEntity()).append("'");
        out.append(" ").append("val.att").append("='").append(Double.toString(this.getValueAttribute())).append("'");
        out.append("/>\n");
    }

    public DBFolder getDBFolder() {
        return this._dbFolder;
    }

    @Override
    public Double getValue() {
        return this.getValueAttribute();
    }

    @Override
    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        DBRelation dbRelation = new DBRelation(dbSrcFolder, typeSrcRelation, this._dbFolder, "FMEA_V");
        relations.add(dbRelation);
    }

    public static String transcodeCollections(Collection<Param> params) {
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Param param : params) {
            ParamFMEA pFmea = (ParamFMEA)param;
            sb.append(pFmea.getDBFolder().getRefPath()).append("@(");
            sb.append(pFmea.getNameAttribute()).append(",");
            sb.append(pFmea.getValueEntity()).append(")");
            sb.append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public boolean withDepends() {
        return true;
    }

    @Override
    public Param update(CECFactory cecFactory, DBLogs.DBLogsManager logMng, String name) {
        DBTableFMEA fmeaTable;
        Double updateValue;
        DBWrap dbWrap = cecFactory.findOrCreateWrap(this._dbFolder);
        if (dbWrap != null && (updateValue = (fmeaTable = (DBTableFMEA)dbWrap).getFMEA().getValueOf(this._strDefineEntity, this._strNameEntity, this._strValueEntity, this._strDefineAttribute, this._strNameAttribute)) != null) {
            this._dblValueAttribute = updateValue;
            return this;
        }
        logMng.addLog(DBLogs.DBLevel.WARNING, "Le lien FMEA n'est plus valide.");
        return new ParamValue(this.getType(), this._dblValueAttribute);
    }

    @Override
    public String getFieldsCompare() {
        StringBuilder sb = new StringBuilder();
        BiFunction<String, String, String> func = (x, y) -> {
            StringBuilder tmp = new StringBuilder();
            sb.append(Messages.getString(x)).append(" : ").append((String)y).append('\n');
            return tmp.toString();
        };
        sb.append(func.apply("FmeaDataReferencePanel.5", this.getDBFolder().getRefPath()));
        sb.append(func.apply("FmeaDataReferencePanel.7", this.getValueEntity()));
        sb.append(func.apply("FmeaDataReferencePanel.8", this.getNameAttribute()));
        sb.append(func.apply("FmeaDataReferencePanel.9", String.valueOf(this.getValueAttribute())));
        return sb.toString();
    }
}

