/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law;

import com.dassault.cecilia.dbobj.general.law.ResLaw;

public enum TypeParam {
    PROBABILITY(ResLaw.getString("PAR_TYPE_PROBABILITY"), 1, 0.01, value -> {
        if (value < 0.0 || value > 1.0) {
            return ResLaw.msgFormat("MSG_ERR_TYPE_PROBABILITY", value);
        }
        return null;
    }),
    RATE(ResLaw.getString("PAR_TYPE_RATE"), 2, 1.0E-5, value -> {
        if (value < 0.0) {
            return ResLaw.msgFormat("MSG_ERR_TYPE_RATE", value);
        }
        return null;
    }, ResLaw.getString("PAR_TYPE_RATE_HOUR"), ResLaw.getString("PAR_TYPE_RATE_HOUR_TOOLTIP")),
    DELAY(ResLaw.getString("PAR_TYPE_DELAY"), 3, 730.0, value -> {
        if (value < 0.0) {
            return ResLaw.msgFormat("MSG_ERR_TYPE_DELAY", value);
        }
        return null;
    }, ResLaw.getString("PAR_TYPE_DELAY_HOUR"), ResLaw.getString("PAR_TYPE_DELAY_HOUR_TOOLTIP")),
    FACTOR(ResLaw.getString("PAR_TYPE_FACTOR"), 4, 3.0, value -> {
        if (value <= 0.0) {
            return ResLaw.msgFormat("MSG_ERR_TYPE_FACTOR", value);
        }
        return null;
    }),
    BOOLEAN(ResLaw.getString("PAR_TYPE_BOOLEAN"), 5, 1.0, value -> {
        if (value != 0.0 && value != 1.0) {
            return ResLaw.msgFormat("MSG_ERR_TYPE_BOOLEAN", value);
        }
        return null;
    });

    String _label;
    String _symbol;
    String _symbolToolTip;
    int _index;
    double _defaultValue;
    Verifier _verifier;

    public String getLabel() {
        return this._label;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public String getSymbolToolTip() {
        return this._symbolToolTip;
    }

    public int getIndex() {
        return this._index;
    }

    public double getDefaultValue() {
        return this._defaultValue;
    }

    public String verify(double value) {
        return this._verifier.verify(value);
    }

    private TypeParam(String lbl, int idx, double defaultValue, Verifier verif) {
        this(lbl, idx, defaultValue, verif, null, null);
    }

    private TypeParam(String lbl, int idx, double defaultValue, Verifier verif, String symbol, String symbolToolTip) {
        this._label = lbl;
        this._index = idx;
        this._defaultValue = defaultValue;
        this._verifier = verif;
        this._symbol = symbol;
        this._symbolToolTip = symbolToolTip;
    }

    public static TypeParam getType(int idx) {
        for (TypeParam type : TypeParam.values()) {
            if (type.getIndex() != idx) continue;
            return type;
        }
        return null;
    }

    public boolean withSymbol() {
        return this == DELAY || this == RATE;
    }

    static interface Verifier {
        public String verify(double var1);
    }
}

