/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawException;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ResLaw;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.gui.LawDialog;
import com.dassault.cecilia.dbobj.general.law.gui.ParamValueDlgEdit;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;

public class LawPanel
extends JPanel {
    protected LawManager _lawManager;
    protected CeciliaAppl _application;
    protected Law _law;
    protected JComboBox _ctrlTypes;
    protected JLabel _ctrlLblModifier;
    protected JButton _ctrlActModifier;
    protected ParamsPanel _ctrlParams;
    protected HashMap<Integer, Law> _hashLaws;
    protected int[] _idLaws;
    protected ArrayList<Component> _allCtrls;
    private boolean _bModified = false;
    boolean _bEditable = true;
    ArrayList<ComboBoxModel> _params = new ArrayList();
    private static ParamValueDlgEdit _instanceParamDlg = null;
    private static Object _instanceParamDlgLocker = new Object();
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public LawPanel(LawManager mng, CeciliaAppl appl) {
        this._lawManager = mng;
        this._application = appl;
        this._hashLaws = new HashMap();
        this._allCtrls = new ArrayList();
        this._idLaws = null;
        this.create();
    }

    public Law getLaw() {
        if (this._law == null) {
            return null;
        }
        return this._law.getCopy();
    }

    public void setLaw(Law law) {
        this._bModified = false;
        if (this._law == law) {
            this._ctrlTypes.setSelectedIndex(-1);
            return;
        }
        if (this._law != null) {
            this._hashLaws.put(this._law.getID(), this._law);
        }
        this._law = law;
        if (this._law == null) {
            this._ctrlParams.defineNbrRow(null);
        } else {
            int idLaw = this._law.getID();
            LawManager.LawData lawInfo = this._lawManager.getLaw(idLaw);
            if (lawInfo != null) {
                this._ctrlTypes.setSelectedItem(lawInfo);
                this._ctrlParams.defineNbrRow(lawInfo);
                int nbrParam = lawInfo.size();
                for (int i = 0; i < nbrParam; ++i) {
                    this._ctrlParams.defineLabel(i, (LawManager.ParamData)lawInfo.get(i));
                    this._ctrlParams.setCurrentData(i, this._law.getParamAt(i).toString());
                    this._ctrlParams.defineLabelUnit(i, (LawManager.ParamData)lawInfo.get(i));
                }
            } else {
                this._ctrlTypes.setSelectedIndex(-1);
                this._ctrlParams.defineNbrRow(null);
            }
            if (this._law.getModifierLaw() != null) {
                this._ctrlLblModifier.setText(this._law.getModifierLaw().toString());
            } else {
                this._ctrlLblModifier.setText("                       ");
            }
        }
        this.validate();
        this.repaint();
    }

    public void setModified(boolean value) {
        this._bModified = value;
    }

    public boolean isModified() {
        return this._bModified;
    }

    protected int[] getLaws() {
        return this._idLaws != null ? this._idLaws : this._lawManager.getLaws();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        for (int i = 0; i < this._allCtrls.size(); ++i) {
            Component cpo = this._allCtrls.get(i);
            cpo.setEnabled(enable);
        }
    }

    public void setEditable(boolean editable) {
        this._bEditable = editable;
        this._ctrlTypes.setEnabled(this._bEditable);
        this._ctrlParams.setEditable(this._bEditable);
    }

    private boolean validateParam(int idx, LawManager.ParamData parInfo, LawParser lawParser, TypeParam type) {
        String str = this._ctrlParams.getCurrentData(idx).toString();
        if (!str.isEmpty() && str.equals(this._law.getParamAt(idx).toString())) {
            Param par = this._law.getParamAt(idx);
            try {
                par.verify(this._application.getDAOFactory());
                return true;
            }
            catch (LawException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), e.getMessage(), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._ctrlParams.setFocus(idx);
                return false;
            }
        }
        lawParser.clearErrors();
        Param par = lawParser.parseParam(str);
        if (par != null && !lawParser.withError()) {
            TypeParam paramType = parInfo.getType();
            if (paramType == null) {
                paramType = type;
            }
            if (par.getType() == null) {
                par.setType(paramType);
            } else if (par.getType() != paramType) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.msgFormat("PAR_ERR_TYPE_FRM", paramType.getLabel()), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._ctrlParams.setCurrentData(idx, this._law.getParamAt(idx).toString());
                this._ctrlParams.setFocus(idx);
                return false;
            }
            par.setType(paramType);
            try {
                par.verify(this._application.getDAOFactory());
                this._law.setParamAt(idx, par);
                this._ctrlParams.setCurrentData(idx, par.toString());
                return true;
            }
            catch (LawException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), e.getMessage(), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._ctrlParams.setCurrentData(idx, this._law.getParamAt(idx).toString());
                this._ctrlParams.setFocus(idx);
                return false;
            }
        }
        StringBuilder errorMsg = new StringBuilder();
        if (lawParser.withError()) {
            for (String msg : lawParser.getErrors()) {
                errorMsg.append(msg).append("\n");
            }
        } else {
            errorMsg.append(ResMsgCore.msgFormat("MSG_INTERNAL_ERROR", "Erreur lors du d\u00e9chiffrage du param\u00e8tre."));
        }
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), errorMsg.toString(), ResMsgVoc.getString("VOC_ERROR"), 0);
        this._ctrlParams.setCurrentData(idx, this._law.getParamAt(idx).toString());
        this._ctrlParams.setFocus(idx);
        return false;
    }

    public boolean validateParams(TypeParam type) {
        if (this._law == null) {
            return true;
        }
        LawManager.LawData lawInfo = this._lawManager.getLaw(this._law.getID());
        LawParser lawParser = new LawParser(this._lawManager, this._application.getDAOFactory());
        for (int i = 0; i < this._law.getNbrParam(); ++i) {
            if (this.validateParam(i, (LawManager.ParamData)lawInfo.get(i), lawParser, type)) continue;
            return false;
        }
        return true;
    }

    protected ComboBoxModel getModelFromParam(LawManager.ParamData parInfo) {
        int idParam = parInfo.getID();
        if (this._params.size() <= idParam || this._params.get(idParam) == null) {
            while (this._params.size() <= idParam) {
                this._params.add(null);
            }
            ParamsCboModel res = new ParamsCboModel();
            this._params.set(idParam, res);
            return res;
        }
        return this._params.get(idParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParamValueDlgEdit getParamDlg(Window owner, CeciliaAppl appl) {
        if (_instanceParamDlg == null) {
            Object object = _instanceParamDlgLocker;
            synchronized (object) {
                ParamValueDlgEdit dlg = new ParamValueDlgEdit(owner, appl, true, true, true);
                if (_instanceParamDlg == null) {
                    _instanceParamDlg = dlg;
                }
            }
        }
        return _instanceParamDlg;
    }

    protected void doClicParameter(int idx) {
        LawParser lawParser;
        Param par;
        if (this._lawManager.getParameterManager() == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        LawManager.ParamData paramInfo = (LawManager.ParamData)this._lawManager.getLaw(this._law.getID()).get(idx);
        ParamValueDlgEdit dlg = LawPanel.getParamDlg(SwingUtilities.getWindowAncestor(this), this._application);
        dlg.setTitle(ResMsgCore.msgFormat("TITLE_PARAM_VALUE_EDIT_FRM", paramInfo.getLabel()));
        dlg.setParamType(paramInfo.getType());
        Param select = this._law.getParamAt(idx);
        String strParam = this._ctrlParams.getCurrentData(idx).toString();
        if (!strParam.equals(select.toString()) && (par = (lawParser = new LawParser(this._lawManager, this._application.getDAOFactory())).parseParam(strParam)) != null && !lawParser.withError()) {
            select = par;
        }
        dlg.setParam(select);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            Param param = dlg.getParam();
            if (param == null) {
                return;
            }
            if (select != null && select.equals(param)) {
                return;
            }
            this._law.setParamAt(idx, param);
            this._ctrlParams.setCurrentData(idx, param.toString());
            this.setModified(true);
            if (select != null && select.withDepends() || param != null && param.withDepends()) {
                this.fireChangeDepends();
            }
        }
    }

    protected void doClicModifier() {
        if (this._lawManager.getModifierManager() == null || this._law == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        LawPanel panel = new LawPanel(this._lawManager.getModifierManager(), this._application){

            @Override
            protected String getLawLabel() {
                return ResLaw.getString("VOC_MODIFIER");
            }

            @Override
            protected JComboBox createCtrlTypes() {
                if (this._ctrlTypes == null) {
                    this._ctrlTypes = new JComboBox();
                    this._ctrlTypes.setEnabled(this._bEditable);
                }
                this._ctrlTypes.addItem(new LawManager.LawData(-1, ResMsgVoc.getString("VOC_AUCUN"), null, "", "", 10));
                return super.createCtrlTypes();
            }
        };
        panel.setPreferredSize(new Dimension(200, 120));
        Law select = this._law.getModifierLaw();
        panel.setLaw(select);
        panel.setEditable(this._bEditable);
        LawDialog dlg = new LawDialog((Window)owner, panel);
        dlg.setTitle(ResLaw.getString("TITLE_LAW_MODIFIER"));
        dlg.setVisible(true);
        if (dlg.getResult()) {
            Law law = panel.getLaw();
            if (select == law) {
                return;
            }
            this._law.setModifierLaw(law);
            this._ctrlLblModifier.setText(law == null ? "                       " : law.toString());
            this.setModified(true);
            if (select != null && select.withDepends() || law != null && law.withDepends()) {
                this.fireChangeDepends();
            }
        }
    }

    protected String getLawLabel() {
        return ResLaw.getString("VOC_LAW");
    }

    protected JComboBox createCtrlTypes() {
        if (this._ctrlTypes == null) {
            this._ctrlTypes = new JComboBox();
            this._ctrlTypes.setEnabled(this._bEditable);
        }
        this._ctrlTypes.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof LawManager.LawData) {
                    LawManager.LawData lawInfo = (LawManager.LawData)value;
                    this.setText(lawInfo.getLabel());
                    this.setToolTipText(lawInfo.getTooltip());
                }
                return this;
            }
        });
        int[] laws = this.getLaws();
        for (int i = 0; i < laws.length; ++i) {
            this._ctrlTypes.addItem(this._lawManager.getLaw(laws[i]));
        }
        this._ctrlTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LawManager.LawData lawInfo;
                int id;
                if (e.getStateChange() != 1) {
                    return;
                }
                Law select = null;
                Object value = LawPanel.this._ctrlTypes.getSelectedItem();
                if (value != null && value instanceof LawManager.LawData && (id = (lawInfo = (LawManager.LawData)value).getID()) >= 0) {
                    if (LawPanel.this._law != null && id == LawPanel.this._law.getID()) {
                        return;
                    }
                    select = LawPanel.this._hashLaws.get(id);
                    if (select == null) {
                        select = LawPanel.this._lawManager.createLaw(id);
                    }
                }
                Law previous = LawPanel.this._law;
                LawPanel.this.setLaw(select);
                LawPanel.this.setModified(true);
                if (select != null && select.withDepends() || previous != null && previous.withDepends()) {
                    LawPanel.this.fireChangeDepends();
                }
            }
        });
        return this._ctrlTypes;
    }

    protected void create() {
        this.setLayout(new BorderLayout());
        JLabel lbl = new JLabel(this.getLawLabel());
        this._allCtrls.add(lbl);
        this._ctrlTypes = this.createCtrlTypes();
        this._allCtrls.add(this._ctrlTypes);
        this._ctrlLblModifier = new JLabel("                       ");
        this._ctrlLblModifier.setHorizontalAlignment(4);
        this._allCtrls.add(this._ctrlLblModifier);
        this._ctrlActModifier = new JButton("...");
        this._ctrlActModifier.setMargin(new Insets(1, 1, 1, 1));
        this._allCtrls.add(this._ctrlActModifier);
        if (this._lawManager.getModifierManager() != null) {
            this._ctrlActModifier.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LawPanel.this.doClicModifier();
                }
            });
        }
        JPanel lawPanel = new JPanel(new GridBagLayout());
        lawPanel.add((Component)lbl, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this._lawManager.getModifierManager() != null) {
            lawPanel.add((Component)this._ctrlTypes, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            lawPanel.add((Component)new JLabel(" "), new GridBagConstraints(2, 1, 1, 1, 0.25, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            lawPanel.add((Component)this._ctrlActModifier, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            lawPanel.add((Component)this._ctrlLblModifier, new GridBagConstraints(1, 2, 3, 1, 1.25, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else {
            lawPanel.add((Component)this._ctrlTypes, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)lawPanel, "North");
        this._ctrlParams = new ParamsPanel();
        this._ctrlParams.defineAction(this._lawManager.getParameterManager() != null);
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.setMinimumSize(new Dimension(300, 60));
        scrollpane.setVerticalScrollBarPolicy(22);
        scrollpane.setHorizontalScrollBarPolicy(31);
        scrollpane.getViewport().add(this._ctrlParams);
        scrollpane.setBorder(BorderFactory.createTitledBorder(ResLaw.getString("VOC_PARAMETERS")));
        this.add((Component)scrollpane, "Center");
    }

    public JComponent getCtrlAt(int i) {
        return this._ctrlParams.getComboBox(i);
    }

    public void refresh() {
        this._ctrlParams.refresh();
    }

    public JComponent getFocusableComponent() {
        return this._ctrlTypes;
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }

    class ParamsCboModel
    extends AbstractListModel
    implements ComboBoxModel {
        Object _selectedObject;
        Vector<DBParam> _namedParameters = new Vector();

        ParamsCboModel() {
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this._selectedObject = anItem;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this._selectedObject;
        }

        @Override
        public int getSize() {
            return this._namedParameters.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._namedParameters.get(index);
        }
    }

    public class ParamsPanel
    extends JPanel {
        protected int _currentRows;
        protected ArrayList<JLabel> _labelsArray;
        protected List<JLabel> _labelsUnitArray;
        protected ArrayList<Component> _buttonsArray;
        protected ArrayList<JComboBox> _combosArray;
        private JPanel _emptyPanel;
        protected int _currentIdLaw;
        protected boolean _withAction;
        private ComboBoxModel _nullModel;

        public ParamsPanel() {
            super(new GridBagLayout());
            this._nullModel = new ComboBoxModel(){

                @Override
                public void setSelectedItem(Object anItem) {
                }

                @Override
                public Object getSelectedItem() {
                    return null;
                }

                @Override
                public int getSize() {
                    return 0;
                }

                @Override
                public Object getElementAt(int index) {
                    return null;
                }

                @Override
                public void addListDataListener(ListDataListener l) {
                }

                @Override
                public void removeListDataListener(ListDataListener l) {
                }
            };
            this._labelsArray = new ArrayList();
            this._buttonsArray = new ArrayList();
            this._combosArray = new ArrayList();
            this._labelsUnitArray = new ArrayList<JLabel>();
            this._currentRows = 0;
            this._currentIdLaw = -1;
            this._withAction = true;
            this.setLayout(new GridBagLayout());
        }

        public void setEditable(boolean editable) {
            for (int i = this._combosArray.size() - 1; i >= 0; ++i) {
                JComboBox cbo = this._combosArray.get(i);
                if (cbo == null) continue;
                cbo.setEnabled(editable);
            }
        }

        public void defineAction(boolean withAction) {
            if (this._withAction == withAction) {
                return;
            }
            GridBagConstraints cnt = new GridBagConstraints();
            cnt.weighty = 100.0;
            cnt.weightx = 100.0;
            cnt.gridwidth = 1;
            cnt.gridheight = 1;
            for (int i = 0; i < this._currentRows; ++i) {
                if (!this._withAction) {
                    cnt.gridy = i;
                    cnt.gridx = 1;
                    cnt.weightx = 50.0;
                    cnt.fill = 0;
                    cnt.anchor = 13;
                    this.add(this._buttonsArray.get(i), cnt);
                    continue;
                }
                this.remove(this._buttonsArray.get(i));
            }
            this._withAction = withAction;
            this.doLayout();
        }

        public void defineNbrRow(LawManager.LawData lawInfo) {
            int y;
            int nbr = 0;
            int lawID = -1;
            if (lawInfo != null) {
                lawID = lawInfo.getID();
                nbr = lawInfo.size();
            }
            if (this._currentIdLaw == lawID) {
                return;
            }
            if (this._labelsArray.isEmpty()) {
                this._emptyPanel = new JPanel();
            }
            while (this._labelsArray.size() < nbr) {
                JButton but = new JButton("...");
                but.setMargin(new Insets(1, 1, 1, 1));
                but.addActionListener(new ClicAdapter(this._labelsArray.size()));
                but.setEnabled(LawPanel.this.isEnabled());
                this._buttonsArray.add(but);
                LawPanel.this._allCtrls.add(but);
                JComboBox cbo = new JComboBox();
                cbo.setEditable(true);
                cbo.setEnabled(LawPanel.this.isEnabled());
                cbo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() != 1) {
                            return;
                        }
                        LawPanel.this.setModified(true);
                    }
                });
                cbo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LawPanel.this.setModified(true);
                    }
                });
                cbo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        LawPanel.this.setModified(true);
                    }
                });
                ComboFocusAdapter adapter = new ComboFocusAdapter(cbo, this._labelsArray.size());
                cbo.getEditor().getEditorComponent().addFocusListener(adapter);
                this._combosArray.add(cbo);
                LawPanel.this._allCtrls.add(cbo);
                JLabel lbl = new JLabel("        ");
                this._labelsArray.add(lbl);
                LawPanel.this._allCtrls.add(lbl);
                JLabel lblUnit = new JLabel("");
                this._labelsUnitArray.add(lblUnit);
                LawPanel.this._allCtrls.add(lblUnit);
            }
            this.removeAll();
            for (y = 0; y < nbr; ++y) {
                int x = 0;
                this.add((Component)this._labelsArray.get(y), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
                JComboBox cbo = this._combosArray.get(y);
                cbo.setModel(LawPanel.this.getModelFromParam((LawManager.ParamData)lawInfo.get(y)));
                this.add((Component)cbo, new GridBagConstraints(x++, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
                this.add((Component)this._labelsUnitArray.get(y), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
                if (!this._withAction) continue;
                this.add(this._buttonsArray.get(y), new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0));
            }
            this.add((Component)this._emptyPanel, new GridBagConstraints(0, y, this._withAction ? 4 : 3, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this._currentRows = nbr;
            this._currentIdLaw = lawID;
            this.doLayout();
        }

        public void refresh() {
            LawManager.LawData lawInfo = LawPanel.this._lawManager.getLaw(this._currentIdLaw);
            if (lawInfo == null) {
                return;
            }
            int nbr = lawInfo.size();
            for (int i = 0; i < nbr; ++i) {
                JComboBox cbo = this._combosArray.get(i);
                cbo.setModel(this._nullModel);
                cbo.setModel(LawPanel.this.getModelFromParam((LawManager.ParamData)lawInfo.get(i)));
            }
        }

        public void defineLabel(int idx, LawManager.ParamData defParam) {
            JLabel lbl = this._labelsArray.get(idx);
            lbl.setText(defParam.getLabel());
            lbl.setToolTipText(defParam.getTooltip());
        }

        public void setCurrentData(int idx, Object data) {
            JComboBox cbo = this.getComboBox(idx);
            cbo.getModel().setSelectedItem(data);
            cbo.getEditor().setItem(data);
        }

        public void defineLabelUnit(int idx, LawManager.ParamData defParam) {
            TypeParam type = defParam.getType();
            JLabel lbl = this._labelsUnitArray.get(idx);
            if (type != null && type.withSymbol()) {
                lbl.setText(defParam.getType().getSymbol());
                lbl.setToolTipText(defParam.getType().getSymbolToolTip());
            } else {
                lbl.setText("");
                lbl.setToolTipText("");
            }
        }

        public Object getCurrentData(int idx) {
            JTextField textField;
            JComboBox cbo = this.getComboBox(idx);
            Object result = cbo.getSelectedItem();
            Component editor = cbo.getEditor().getEditorComponent();
            if (editor != null && editor instanceof JTextField && !(textField = (JTextField)editor).getText().equals(result.toString())) {
                return textField.getText();
            }
            return result;
        }

        public void setFocus(int idx) {
            this.getComboBox(idx).requestFocus();
        }

        public JComboBox getComboBox(int idx) {
            return this._combosArray.get(idx);
        }

        class ClicAdapter
        implements ActionListener {
            int _idx;

            ClicAdapter(int idx) {
                this._idx = idx;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LawPanel.this.doClicParameter(this._idx);
            }
        }

        class ComboFocusAdapter
        extends FocusAdapter {
            JComponent _cmp;
            int _idx;

            ComboFocusAdapter(JComponent cmp, int idx) {
                this._cmp = cmp;
                this._idx = idx;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    Rectangle r = this._cmp.getBounds();
                    ParamsPanel.this.scrollRectToVisible(r);
                }
            }
        }
    }
}

