/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.LawHandlerXml;
import com.dassault.cecilia.dbobj.general.law.io.LawXmlConstant;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ParamHandlerXml
extends SAXWrapHandler
implements LawXmlConstant {
    protected CECFactory _cecFactory;
    protected LawManager _lawManager;
    boolean _bWithParamRef = true;
    boolean _bWithParamFMEA = true;
    protected LawHandlerXml _childHandler = null;

    protected ParamHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, CECFactory cecFactory, LawManager lawManager) {
        super(logMng, locator);
        this._cecFactory = cecFactory;
        this._lawManager = lawManager;
    }

    public void setWithParamRef(boolean value) {
        this._bWithParamRef = value;
    }

    public void setWithParamFMEA(boolean value) {
        this._bWithParamFMEA = value;
    }

    protected abstract TypeParam getCurrentType();

    protected abstract void manageCreateParam(Param var1);

    protected abstract Param createDefaultParam();

    protected abstract String getOwnerObject();

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._childHandler != null) {
            this._childHandler.startAction(key, attrs, startAction);
        } else if ("parameter.value".equals(key)) {
            String strValue = attrs.get("value");
            if (strValue == null || strValue.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", "parameter.value", "value"), this.getLocator()));
            }
            double value = Double.NaN;
            try {
                value = Double.parseDouble(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            TypeParam type = this.getCurrentType();
            if (Double.isNaN(value)) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", "parameter.value", "value", strValue), this.getLocator()));
                value = type.getDefaultValue();
            } else {
                String msgType = type.verify(value);
                if (msgType != null) {
                    this.warning(new SAXParseException(this.getOwnerObject() + ": " + msgType, this.getLocator()));
                    value = type.getDefaultValue();
                }
            }
            ParamValue param = new ParamValue(type, value);
            this.manageCreateParam(param);
        } else if ("parameter.law".equals(key)) {
            if (this._lawManager.getParameterManager() == null) {
                this.error(new SAXParseException(ResMsgObj.getString("MSG_ERR_DBMOD_LAW_NO_MANAGER"), this.getLocator()));
            }
            this._childHandler = new LawHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this._lawManager.getParameterManager()){

                @Override
                protected String getOwnerObject() {
                    return ParamHandlerXml.this.getOwnerObject();
                }
            };
            TypeParam type = this.getCurrentType();
            this._childHandler.setDefaultType(type);
            this._childHandler.startAction(key, attrs, true);
        } else if (this._bWithParamRef && "parameter.ref".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "LAW_PARAMETERS", false);
            TypeParam type = this.getCurrentType();
            Param param = null;
            param = dbFolder == null ? this.createDefaultParam() : new ParamRef(type, dbFolder);
            this.manageCreateParam(param);
        } else if (this._bWithParamFMEA && "parameter.fmea".equals(key)) {
            String valueAttrib;
            String valueEntite;
            String nameAttrib;
            String nameEntite;
            String defAttrib;
            String defEntite;
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "PROJECTS", false);
            TypeParam type = this.getCurrentType();
            Param param = null;
            if (!(dbFolder == null || dbFolder.getFamily() != DBFolder.Family.PROJECT || !dbFolder.isVersion() || dbFolder.getFamilyFlag() != 4 || (defEntite = attrs.get("def.elt")) == null || defEntite.isEmpty() || (defAttrib = attrs.get("def.att")) == null || defAttrib.isEmpty() || (nameEntite = attrs.get("name.elt")) == null || nameEntite.isEmpty() || (nameAttrib = attrs.get("name.att")) == null || nameAttrib.isEmpty() || (valueEntite = attrs.get("val.elt")) == null || valueEntite.isEmpty() || (valueAttrib = attrs.get("val.att")) == null || valueAttrib.isEmpty() || !DBFactory.verifyDouble(valueAttrib))) {
                DBTableFMEA fmeaTable;
                Double updateValue;
                ParamFMEA paramFMEA = new ParamFMEA(type, dbFolder);
                paramFMEA.setDefineEntity(defEntite);
                paramFMEA.setDefineAttribute(defAttrib);
                paramFMEA.setNameEntity(nameEntite);
                paramFMEA.setNameAttribute(nameAttrib);
                paramFMEA.setValueEntity(valueEntite);
                paramFMEA.setValueAttribute(Double.parseDouble(valueAttrib));
                boolean error = true;
                DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                if (dbWrap != null && (updateValue = (fmeaTable = (DBTableFMEA)dbWrap).getFMEA().getValueOf(defEntite, nameEntite, valueEntite, defAttrib, nameAttrib)) != null) {
                    paramFMEA.setValueAttribute(updateValue);
                    param = paramFMEA;
                    error = false;
                }
                if (error) {
                    param = new ParamValue(type, Double.parseDouble(valueAttrib));
                }
            }
            if (param == null) {
                param = this.createDefaultParam();
            }
            this.manageCreateParam(param);
        } else {
            this.errorElementUnknown(key);
        }
    }

    protected void manageChildEndAction(String name) {
        if ("parameter.law".equals(name)) {
            Law law = this._childHandler.getLaw();
            TypeParam type = this.getCurrentType();
            Param param = null;
            param = law == null ? this.createDefaultParam() : new ParamLaw(type, law);
            this.manageCreateParam(param);
        }
    }
}

