/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa;

import com.dassault.cecilia.core.plugin.AbstractInfoDatum;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;

public class AltaInfoStepper
extends AbstractInfoDatum
implements IModel {
    private static Logger _LOG = Logger.getLogger(AltaInfoStepper.class.getPackage().getName());
    public static final String KEY_INFO_COMPUTE = "Stepper";
    public static final String KEY_INFO_CONFIG = "Config";
    public static final String KEY_INFO_MAIN = "Main";
    public static final String KEY_FILE_COMPIL = "compil.zip";
    boolean _bMustBeSaveToDB = false;

    public void fixSaveToDB() {
        this._bMustBeSaveToDB = true;
    }

    public AltaInfoStepper(InfoDatum isource) {
        super(isource);
    }

    public AltaInfoStepper(String key, String stepper, long uid) {
        super(key);
        this._parameters.put(KEY_INFO_COMPUTE, stepper);
        this._parameters.put("ID", Long.toString(uid));
    }

    public AltaInfoStepper(InputStream stream) throws IOException {
        super(stream);
    }

    @Override
    public InfoDatum createCopy() {
        return new AltaInfoStepper(this);
    }

    @Override
    protected boolean fileException(String keyFile) {
        return keyFile.equals("altarica.file");
    }

    @Override
    protected boolean verifyInformations(Map<String, String> params) {
        if (!super.verifyInformations(params)) {
            return false;
        }
        if (params.get(KEY_INFO_COMPUTE) == null) {
            return false;
        }
        return params.get(KEY_INFO_CONFIG) != null;
    }

    @Override
    public void setKey(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IModel getModel() {
        return this;
    }

    @Override
    public String getFormat() {
        return "altarica.file";
    }

    @Override
    public File getFile() {
        return this.getInputFiles().get("altarica.file");
    }

    @Override
    public String getName() {
        return this.getParameters().get(KEY_INFO_MAIN);
    }

    @Override
    public String getConfig() {
        return this.getParameters().get(KEY_INFO_CONFIG);
    }

    @Override
    public long getUID() {
        String uid = this.getParameters().get("ID");
        if (uid == null) {
            _LOG.warning("No UID parameter for compute tree: " + this._parameters);
            return -1L;
        }
        return Long.parseLong(uid);
    }
}

