/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBComponentHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBComponentReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareObjWithNameResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AltaComponent
extends AltaNode {
    private static Logger _LOG = Logger.getLogger(AltaComponent.class.getPackage().getName());
    public static final String PROP_ALTARICA_ICON_PUBLIC = "cecilia.mbsa.IconIsPublicFlow";
    public static boolean __IconIsPublicFlow = Boolean.getBoolean("cecilia.mbsa.IconIsPublicFlow");
    public static final int SIZE_WIDTH = 80;
    public static final int SIZE_HEIGHT = 80;
    List<AltaState> _lstState;
    protected List<AltaEvent> _lstEvent;
    ArrayList<DBIcon> _lstIconSimul;
    DBIcon _dbIconEdit = null;
    int _width = 80;
    int _height = 80;
    NamePosition _textPosition = NamePosition.TOP;
    boolean _drawBorder = true;
    boolean _autoMovePort = true;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public AltaComponent(DBFolder dbFolder) {
        super(dbFolder);
        this._lstState = new ArrayList<AltaState>();
        this._lstEvent = new ArrayList<AltaEvent>();
        this._lstIconSimul = new ArrayList();
    }

    @Override
    public AltaComponent getCopy() {
        AltaComponent dest = new AltaComponent(this._dbFolder);
        dest.copy(this, (CopyUtility)new CopyUtility.Default());
        return dest;
    }

    protected void copy(AltaComponent src, CopyUtility util) {
        ObjectWithName cpy;
        int i;
        this._width = src._width;
        this._height = src._height;
        this._drawBorder = src._drawBorder;
        this._autoMovePort = src._autoMovePort;
        this._textPosition = src._textPosition;
        super.copy(src, util);
        List<ObjectWithName> lstSrc = src.getStates();
        ArrayList<AltaState> lstCopy = new ArrayList<AltaState>(lstSrc.size());
        for (i = 0; i < lstSrc.size(); ++i) {
            cpy = lstSrc.get(i).getCopy();
            util.setRef((Object)lstSrc.get(i), (Object)cpy);
            lstCopy.add((AltaState)cpy);
        }
        this.setStates(lstCopy);
        lstSrc = src.getEvents();
        lstCopy = new ArrayList(lstSrc.size());
        for (i = 0; i < lstSrc.size(); ++i) {
            cpy = ((AltaEvent)lstSrc.get(i)).getCopy();
            util.setRef((Object)lstSrc.get(i), (Object)cpy);
            lstCopy.add((AltaState)cpy);
        }
        this.setEvents(lstCopy);
        this._dbIconEdit = src._dbIconEdit;
        this.setSimuls(new ArrayList<DBIcon>(src.getSimuls()));
    }

    public String toString() {
        return this.getAltaRicaName();
    }

    public List<AltaState> getStates() {
        return this._lstState;
    }

    public void setStates(List<AltaState> states) {
        this._lstState = states;
    }

    public List<AltaEvent> getEvents() {
        return this._lstEvent;
    }

    public void setEvents(List<AltaEvent> events) {
        this._lstEvent = events;
    }

    public List<DBIcon> getSimuls() {
        return this._lstIconSimul;
    }

    public void setSimuls(List<DBIcon> simuls) {
        this._lstIconSimul = new ArrayList<DBIcon>(simuls);
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public NamePosition getTextPosition() {
        return this._textPosition;
    }

    public void setTextPosition(NamePosition position) {
        this._textPosition = position;
    }

    public boolean isBorderDrawing() {
        return this._drawBorder;
    }

    public boolean isAutoMovePort() {
        return this._autoMovePort;
    }

    public void setBorderDrawing(boolean value) {
        this._drawBorder = value;
    }

    public void setAutoMovePort(boolean value) {
        this._autoMovePort = value;
    }

    public DBIcon getIconEdit() {
        return this._dbIconEdit;
    }

    public void setIconEdit(DBIcon iconEdit) {
        this._dbIconEdit = iconEdit;
    }

    @Override
    public ObjectWithName getFieldWithName(String name) {
        int i;
        ObjectWithName obj = super.getFieldWithName(name);
        if (obj != null) {
            return obj;
        }
        for (i = this._lstState.size() - 1; i >= 0; --i) {
            obj = this._lstState.get(i);
            if (!obj.getName().equals(name)) continue;
            return obj;
        }
        for (i = this._lstEvent.size() - 1; i >= 0; --i) {
            obj = this._lstEvent.get(i);
            if (!obj.getName().equals(name)) continue;
            return obj;
        }
        return null;
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.COMPONENT;
    }

    @Override
    protected String getNature() {
        return "component";
    }

    @Override
    protected String getRelation() {
        return "OA_COMP";
    }

    @Override
    protected Set<DBRelation> createRelations(String typeSrc) {
        int i;
        Set<DBRelation> relations = super.createRelations(typeSrc);
        for (i = 0; i < this._lstState.size(); ++i) {
            DBFolder dbType;
            AltaType altaType = this._lstState.get(i).getType();
            if (!(altaType instanceof DBType) || (dbType = ((DBType)altaType).getDBFolder()) == null) continue;
            relations.add(new DBRelation(this._dbFolder, typeSrc, dbType, "OA_TYPE"));
        }
        for (i = 0; i < this._lstEvent.size(); ++i) {
            AltaEvent altaEvent = this._lstEvent.get(i);
            altaEvent.addRelation(this._dbFolder, typeSrc, relations);
        }
        if (this._dbIconEdit != null) {
            relations.add(new DBRelation(this._dbFolder, typeSrc, this._dbIconEdit.getDBFolder(), "OA_IMAG"));
        }
        for (i = 0; i < this._lstIconSimul.size(); ++i) {
            DBIcon dbIcon = this._lstIconSimul.get(i);
            if (dbIcon == null || dbIcon.getDBFolder() == null) continue;
            relations.add(new DBRelation(this._dbFolder, typeSrc, dbIcon.getDBFolder(), "OA_IMAG"));
        }
        return relations;
    }

    public void reshape(int w, int h) {
        if (this._width == w && this._height == h) {
            return;
        }
        if (this._autoMovePort) {
            double ratioW = (double)w / (double)this._width;
            double ratioH = (double)h / (double)this._height;
            for (int i = this._lstFlow.size() - 1; i >= 0; --i) {
                AltaFlow flow = (AltaFlow)this._lstFlow.get(i);
                if (flow.getOrientation() == AltaFlow.Orientation.LOCAL) continue;
                double x = ratioW * (double)flow.getX();
                x = x > (double)w ? (double)w : Math.ceil(x);
                flow.setX((int)x);
                double y = ratioH * (double)flow.getY();
                y = y > (double)h ? (double)h : Math.ceil(y);
                flow.setY((int)y);
            }
        } else {
            for (int i = this._lstFlow.size() - 1; i >= 0; --i) {
                AltaFlow flow = (AltaFlow)this._lstFlow.get(i);
                if (flow.getOrientation() == AltaFlow.Orientation.LOCAL) continue;
                double x = flow.getX();
                double y = flow.getY();
                if (x == (double)this._width && w > this._width || (double)w < x) {
                    flow.setX(w);
                }
                if ((y != (double)this._height || h <= this._height) && !((double)h < y)) continue;
                flow.setY(h);
            }
        }
        this._width = w;
        this._height = h;
    }

    @Override
    public String getAltaRicaName() {
        StringBuilder dbPath = new StringBuilder(64);
        this._dbFolder.getParent().getPathUntilSystem(dbPath);
        return dbPath.substring(1).replace('/', '_');
    }

    protected void writeAltaRicaFlows(Appendable out, boolean expandLink) throws IOException {
        int nbrIcon = this._lstIconSimul.size();
        if (!this._lstFlow.isEmpty() || nbrIcon > 0) {
            out.append(" flow\n");
            if (nbrIcon > 0) {
                out.append("  icone : [1,").append(Integer.toString(nbrIcon)).append("] : ");
                out.append(__IconIsPublicFlow ? "out" : "local");
                out.append(" ;\n");
            }
            for (AltaFlow flow : this._lstFlow) {
                flow.getType().writeAltaRicaFlow(out, flow.getName(), flow.getOrientation(), expandLink);
            }
        }
    }

    protected void writeAltaRicaDeclaration(Appendable out, boolean expandLink) throws IOException {
        out.append("node ").append(this.getAltaRicaName()).append("\n");
        this.writeAltaRicaFlows(out, expandLink);
        if (!this._lstState.isEmpty()) {
            out.append(" state\n");
            for (AltaState state : this._lstState) {
                state.getType().writeAltaRicaFlow(out, state.getName(), null, false);
            }
        }
        if (!this._lstEvent.isEmpty()) {
            out.append(" event\n");
            for (AltaEvent event : this._lstEvent) {
                out.append("  ").append(event.getName()).append(";\n");
            }
        }
    }

    protected void writeAltaRicaDefinition(Appendable out) throws IOException {
        if (!this._lstState.isEmpty()) {
            out.append(" init\n");
            for (AltaState state : this._lstState) {
                out.append("  ").append(state.getName()).append(" := ").append(state.getDefaultValue()).append(";\n");
            }
        }
    }

    protected void writeAltaRicaExtern(Appendable out) throws IOException {
        if (!this._lstEvent.isEmpty()) {
            StringBuilder outEvents = new StringBuilder();
            for (AltaEvent event : this._lstEvent) {
                event.writeAltaRicaExtern(outEvents);
            }
            if (outEvents.length() > 0) {
                out.append(" extern\n").append(outEvents.toString());
            }
        }
    }

    public String getHeader(boolean expandLink) throws IOException {
        StringBuilder header = new StringBuilder(512);
        try {
            this.writeAltaRicaDeclaration(header, expandLink);
            this.writeAltaRicaDefinition(header);
        }
        catch (IOException e) {
            _LOG.log(Level.FINEST, "Il y a eu un soucis lors de l'ecriture du header AltaRica", e);
            throw e;
        }
        return header.toString();
    }

    public String getFooter() throws IOException {
        StringBuilder footer = new StringBuilder(512);
        try {
            this.writeAltaRicaExtern(footer);
        }
        catch (IOException e) {
            _LOG.log(Level.FINEST, "Il y a eu un soucis lors de l'ecriture du footer AltaRica", e);
            throw e;
        }
        footer.append("edon\n");
        return footer.toString();
    }

    @Override
    protected void doGenerateCode(File file, GenerateAltaricaCode generator) {
        generator.generateComponent(this, file);
    }

    protected void toXML_Header(Appendable out, String eltName, String indent) throws IOException {
        out.append(indent).append("<").append(eltName);
        out.append(" ").append("width").append("='").append(Integer.toString(this._width)).append("'");
        out.append(" ").append("height").append("='").append(Integer.toString(this._height)).append("'");
        out.append(" ").append("text.position").append("='").append(this._textPosition.toXML()).append("'");
        out.append(" ").append("auto-move").append("='").append(Boolean.toString(this._autoMovePort)).append("'");
        out.append(" ").append("border").append("='").append(Boolean.toString(this._drawBorder)).append("'");
        out.append(">\n");
        if (this._dbIconEdit != null) {
            out.append(indent).append("  <").append("alta.icon");
            DBObjectXmlUtility.writeDBFolder(out, this._dbIconEdit.getDBFolder(), null);
            out.append("/>\n");
        }
        if (!this._lstIconSimul.isEmpty()) {
            for (int i = 0; i < this._lstIconSimul.size(); ++i) {
                out.append(indent).append("  <").append("alta.simul");
                DBObjectXmlUtility.writeDBFolder(out, this._lstIconSimul.get(i).getDBFolder(), null);
                out.append("/>\n");
            }
        }
        if (!this._lstFlow.isEmpty()) {
            String indent1 = indent + "  ";
            for (int i = 0; i < this._lstFlow.size(); ++i) {
                AltaFlow flow = (AltaFlow)this._lstFlow.get(i);
                if (flow.getID() < 0L) {
                    flow.setID(this.getNextFlowID());
                }
                flow.toXML(out, true, indent1);
            }
        }
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        this.toXML_Header(out, "cec.component", indent);
        if (!this._lstState.isEmpty() || !this._lstEvent.isEmpty()) {
            int i;
            String indent1 = indent + "  ";
            for (i = 0; i < this._lstState.size(); ++i) {
                this._lstState.get(i).toXML(out, indent1);
            }
            for (i = 0; i < this._lstEvent.size(); ++i) {
                this._lstEvent.get(i).toXML(out, indent1);
            }
        }
        this.toXML_Footer(out, "cec.component", indent);
    }

    protected void toXML_Footer(Appendable out, String eltName, String indent) throws IOException {
        out.append(indent).append("  <").append("alta.code").append(">");
        DBObjectXmlUtility.appendXML(out, this._code);
        out.append("</").append("alta.code").append(">\n");
        if (!this._lstUsedOperator.isEmpty()) {
            String indent1 = indent + "  ";
            for (int i = 0; i < this._lstUsedOperator.size(); ++i) {
                ((AltaOperatorRef)this._lstUsedOperator.get(i)).toXML(out, indent1);
            }
        }
        out.append(indent).append("</").append(eltName).append(">\n");
    }

    @Override
    protected DBNodeHandlerXml createHandlerXml(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        return new DBComponentHandlerXml(logMng, null, cecFactory);
    }

    @Override
    protected void copyFromHandlerXml(DBNodeHandlerXml saxHandler, DBLogs.DBLogsManager logMng) {
        DBComponentHandlerXml xmlHandler = (DBComponentHandlerXml)saxHandler;
        this._dbIconEdit = xmlHandler.getIcon();
        this._autoMovePort = xmlHandler.getAutoMovePort();
        this._drawBorder = xmlHandler.getDrawBorder();
        this._width = xmlHandler.getWidth();
        this._height = xmlHandler.getHeight();
        this._textPosition = xmlHandler.getNamePosition();
        this._lstIconSimul.clear();
        this._lstIconSimul.addAll(xmlHandler.getSimuls());
        this._lstState.clear();
        this._lstState.addAll(xmlHandler.getStates());
        this._lstEvent.clear();
        this._lstEvent.addAll(xmlHandler.getEvents());
        super.copyFromHandlerXml(saxHandler, logMng);
    }

    @Override
    protected DBNodeReaderRaw createReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        return new DBComponentReaderRaw(this._dbFolder, logMng);
    }

    @Override
    protected void copyFromReaderRaw(DBNodeReaderRaw nodeReaderRaw, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        DBComponentReaderRaw readerRaw = (DBComponentReaderRaw)nodeReaderRaw;
        this._dbIconEdit = readerRaw.getIcon();
        this._autoMovePort = readerRaw.getAutoMovePort();
        this._drawBorder = readerRaw.getDrawBorder();
        this._width = readerRaw.getWidth() - 6;
        if (this._width < 1) {
            this._width = 1;
        }
        this._height = readerRaw.getHeight() - 6;
        if (this._height < 1) {
            this._height = 1;
        }
        this._lstIconSimul.clear();
        this._lstIconSimul.addAll(readerRaw.getSimuls());
        this._lstState.clear();
        this._lstState.addAll(readerRaw.getStates());
        this._lstEvent.clear();
        this._lstEvent.addAll(readerRaw.getEvents());
        super.copyFromReaderRaw(readerRaw, cecFactory, logMng);
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = super.update(daoFactory, logMng);
        for (AltaState altaState : this._lstState) {
            if (altaState.update(daoFactory, logMng)) continue;
            result = false;
        }
        for (AltaEvent altaEvent : this._lstEvent) {
            altaEvent.update(daoFactory, logMng, altaEvent.getName());
        }
        if (this._dbIconEdit != null) {
            this._dbIconEdit = (DBIcon)DBWrap.createOrFind(daoFactory, this._dbIconEdit.getDBFolder(), logMng, DBIcon.class);
            if (this._dbIconEdit == null) {
                result = false;
            }
        }
        for (int i = this._lstIconSimul.size() - 1; i >= 0; --i) {
            DBIcon dBIcon = this._lstIconSimul.get(i);
            DBWrap dbWrap = DBWrap.createOrFind(daoFactory, dBIcon.getDBFolder(), logMng, DBIcon.class);
            if (dbWrap == null) {
                this._lstIconSimul.remove(i);
                result = false;
                continue;
            }
            this._lstIconSimul.set(i, (DBIcon)dbWrap);
        }
        return result;
    }

    protected final Comparator<ObjectWithName> getComparatorForCompare() {
        return new Comparator<ObjectWithName>(){

            @Override
            public int compare(ObjectWithName o1, ObjectWithName o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
    }

    public String getGlobalInfos() {
        StringBuilder sb = new StringBuilder();
        BiFunction<String, String, String> func = (x, y) -> {
            StringBuilder tmp = new StringBuilder();
            tmp.append((String)x).append(" : ").append((String)y).append('\n');
            return tmp.toString();
        };
        sb.append(func.apply(ResMsgVoc.getString("VOC_WIDTH"), String.valueOf(this._width)));
        sb.append(func.apply(ResMsgVoc.getString("VOC_HEIGHT"), String.valueOf(this._height)));
        return sb.toString();
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                return new CompareResultString(ResMsgVoc.getString("VOC_INFORMATIONS"), AltaComponent.this.getGlobalInfos(), ((AltaComponent)wrap).getGlobalInfos());
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                Function<AltaComponent, String> getIcons = comp -> {
                    StringBuilder sb = new StringBuilder();
                    ArrayList<DBIcon> icons = new ArrayList<DBIcon>(comp.getSimuls());
                    if (icons != null) {
                        icons.sort(new Comparator<DBIcon>(){

                            @Override
                            public int compare(DBIcon icon1, DBIcon icon2) {
                                if (icon1 == null && icon2 == null) {
                                    return 0;
                                }
                                if (icon1 == null) {
                                    return 1;
                                }
                                if (icon2 == null) {
                                    return -1;
                                }
                                return icon1.getRefPath().compareToIgnoreCase(icon2.getRefPath());
                            }
                        });
                        for (DBIcon icon : icons) {
                            sb.append(icon.getRefPath()).append('\n');
                        }
                        if (sb.length() > 0) {
                            sb.setLength(sb.length() - 1);
                        }
                    }
                    return sb.toString();
                };
                return new CompareResultString(ResMsgVoc.getString("VOC_ICONS"), getIcons.apply(AltaComponent.this), getIcons.apply((AltaComponent)wrap));
            }
        });
        return list;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons compare = super.getCompareConflict(factoryWrap, wrap, forImport);
        CompareUtils.addConflictInDBWrap(compare, this, wrap, ResMsgVoc.getString("VOC_EVENTS"), obj -> ((ObjectWithName)obj).getName(), comp -> ((AltaComponent)comp).getEvents(), CompareObjWithNameResult.class);
        CompareUtils.addConflictInDBWrap(compare, this, wrap, ResMsgVoc.getString("VOC_STATES"), obj -> ((ObjectWithName)obj).getName(), comp -> ((AltaComponent)comp).getStates(), CompareObjWithNameResult.class);
        return compare;
    }
}

