/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.CTextFieldWithCallback;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconAndSizeDlg;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaPropertiesPanel;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AltaGeneralPanel
extends AltaEditPanel {
    private JLabel _nameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME") + " : ");
    private JTextField _name = new JTextField("");
    private JLabel _sizeLabel = new JLabel(ResMsgVoc.getString("VOC_SIZE") + " : ");
    private JTextField _sizeCtrl = new JTextField(20);
    private JLabel _iconLabel = new JLabel(ResMsgOcas.getString("MODEL_EDIT_FILE_ICON") + " : ");
    private JTextField _iconFile = new JTextField("");
    private AltaPropertiesPanel _propertiesPanel = new AltaPropertiesPanel();
    private JButton _resizeButton = new JButton(ResMsgVoc.getString("VOC_CHANGE"));
    private JTextField _lastInfoFocusField = this._name;
    private CeciliaAppl _application;
    List<ChangeListener> _changeListeners = new ArrayList<ChangeListener>();

    public AltaGeneralPanel(CeciliaAppl application) {
        this._application = application;
        this.make();
        this.defineActions();
    }

    private void make() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this._name, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this._sizeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this._sizeCtrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this._iconLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this._iconFile, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        if (!this._application.isReader()) {
            this.add((Component)this._resizeButton, new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 5, 2, 5), 0, 0));
        }
        this._propertiesPanel.setEditable(!this._application.isReader());
        this.add((Component)this._propertiesPanel, new GridBagConstraints(0, 7, 3, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 10, 5), 0, 0));
        this._propertiesPanel.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_PROPERTIES")));
        ((TitledBorder)this._propertiesPanel.getBorder()).setTitleColor(Color.black);
        this._nameLabel.setForeground(Color.black);
        this._sizeLabel.setForeground(Color.black);
        this._iconLabel.setForeground(Color.black);
    }

    private void defineActions() {
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AltaGeneralPanel.this._lastInfoFocusField = (JTextField)e.getSource();
            }
        };
        this._name.addFocusListener(focusListener);
        this._sizeCtrl.addFocusListener(focusListener);
        this._sizeCtrl.setEnabled(false);
        this._sizeCtrl.setEnabled(false);
        this._iconFile.addFocusListener(focusListener);
        this._iconFile.setEnabled(false);
        this._iconFile.setEnabled(false);
        this._resizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaIconAndSizeDlg dlg = new AltaIconAndSizeDlg(JOptionCecilia.getWindowOf(AltaGeneralPanel.this._resizeButton), AltaGeneralPanel.this._application);
                dlg.copyToCtrl(AltaGeneralPanel.this._currentComponent);
                dlg.setVisible(true);
                if (dlg.getResult()) {
                    AltaGeneralPanel.this._currentComponent.setBorderDrawing(dlg.isBorderDrawing());
                    AltaGeneralPanel.this._currentComponent.setAutoMovePort(dlg.isAutoMovePort());
                    AltaGeneralPanel.this._currentComponent.setIconEdit(dlg.getIcon());
                    int width = dlg.getIconWidth();
                    int height = dlg.getIconHeight();
                    if (width > 0 && height > 0 && (width != AltaGeneralPanel.this._currentComponent.getWidth() || height != AltaGeneralPanel.this._currentComponent.getHeight())) {
                        AltaGeneralPanel.this._currentComponent.reshape(width, height);
                    }
                    AltaGeneralPanel.this._sizeCtrl.setText(Integer.toString(AltaGeneralPanel.this._currentComponent.getWidth()) + " x " + Integer.toString(AltaGeneralPanel.this._currentComponent.getHeight()));
                    DBIcon dbIcon = AltaGeneralPanel.this._currentComponent.getIconEdit();
                    AltaGeneralPanel.this._iconFile.setText(dbIcon == null ? "" : dbIcon.getRefPath());
                    AltaGeneralPanel.this.setModified(true);
                }
            }
        });
    }

    DBIcon verifyDBIcon(String dbPath) {
        DBWrap dbWrap;
        DBFolder dbFolder;
        if (!dbPath.isEmpty() && (dbFolder = this._application.getDAOFactory().createFolderDAO().findFolder(DBFolder.Family.IMAG.getRootName(), dbPath)) != null && (dbWrap = this._application.getDAOFactory().findOrCreateWrap(dbFolder)) != null) {
            return (DBIcon)dbWrap;
        }
        return null;
    }

    public JTextField getCtrlName() {
        return this._name;
    }

    public AltaPropertiesPanel getPropertiesPanel() {
        return this._propertiesPanel;
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this._name.setText(currentComponent.getDBFolder().getParent().getName());
        this._name.setEditable(false);
        this._sizeCtrl.setText(Integer.toString(this._currentComponent.getWidth()) + " x " + Integer.toString(this._currentComponent.getHeight()));
        DBIcon dbIcon = currentComponent.getIconEdit();
        this._iconFile.setText(dbIcon == null ? "" : dbIcon.getRefPath());
        this._propertiesPanel.setDBFolder(this._currentComponent.getDBFolder());
    }

    public boolean isModified() {
        return this._propertiesPanel.isModified();
    }

    public void setModified(boolean modified) {
        this._propertiesPanel.setModified(modified);
    }

    public void updateLangage() {
        this._nameLabel.setText(ResMsgVoc.getString("VOC_NAME") + " : ");
        this._sizeLabel.setText(ResMsgVoc.getString("VOC_SIZE") + " : ");
        this._iconLabel.setText(ResMsgOcas.getString("MODEL_EDIT_FILE_ICON") + " : ");
        this._resizeButton.setText(ResMsgVoc.getString("VOC_CHANGE"));
    }

    @Override
    public void focusTreatment() {
        this._lastInfoFocusField.requestFocus();
    }

    public void addChangeListener(ChangeListener l) {
        if (!this._changeListeners.contains(l)) {
            this._changeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this._changeListeners.remove(l);
    }

    public void fireRefresh(boolean resize) {
        for (int l = this._changeListeners.size() - 1; l >= 0; --l) {
            this._changeListeners.get(l).refresh(resize);
        }
    }

    public void changePreferencies(Preferencies prefs) {
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            this._propertiesPanel.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
    }

    public static interface ChangeListener {
        public void refresh(boolean var1);
    }

    class AltaGeneralTextField
    extends CTextFieldWithCallback {
        public AltaGeneralTextField(String defText) {
            super(defText);
        }

        @Override
        protected void notifyChange() {
            AltaGeneralPanel.this.getAltaComponent().setModified(true);
        }
    }
}

