/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.icon.gui.IconPanelTree;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaDefaultTableCellRenderer;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AltaIconPanel
extends AltaEditPanel {
    CeciliaAppl _appl;
    IconTable _iconTable;
    JPopupMenu _popupMenu = new JPopupMenu();
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    JSplitPane _splitPane;
    IconPanelTree _iconChooserPanel;

    public AltaIconPanel(CeciliaAppl appl) {
        this._appl = appl;
        this.createActions();
        this._iconChooserPanel = new IconPanelTree(appl, false);
        this._iconChooserPanel.setSelectionMode(4);
        this._iconChooserPanel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AltaIconPanel.this._ctrlAdd.setEnabled(AltaIconPanel.this._iconChooserPanel.atMostOneSelectedFolder());
            }
        });
        this._iconChooserPanel.addDBTreeActionListener(new DBFolderTree.DBTreeActionListener(){

            @Override
            public void actionPerformed(DBFolderTreeNode selectNode, MouseEvent e) {
                if (e.getClickCount() <= 1) {
                    return;
                }
                if (AltaIconPanel.this._appl.isReader()) {
                    return;
                }
                DBFolder dbFolder = selectNode.getDBFolder();
                if (dbFolder == null) {
                    return;
                }
                if (dbFolder.isVersion() && !e.isControlDown()) {
                    AltaIconPanel.this.doInsert();
                }
            }
        });
        IconTableModel model = new IconTableModel();
        this._iconTable = new IconTable(model);
        model.setTable(this._iconTable);
        this._iconTable.doLayout();
        this._iconTable.setSelectionMode(2);
        this._iconTable.getTableHeader().setReorderingAllowed(false);
        this._iconTable.getTableHeader().getColumnModel().getColumn(0).setCellRenderer(new AltaDefaultTableCellRenderer());
        ((AltaDefaultTableCellRenderer)this._iconTable.getTableHeader().getColumnModel().getColumn(0).getCellRenderer()).setHorizontalAlignment(0);
        this._popupMenu.add(this._ctrlDel);
        this._popupMenu.add(this._ctrlUp);
        this._popupMenu.add(this._ctrlDown);
        this._popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AltaIconPanel.this.updateButtons();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        JToolBar panelButtonIcon = new JToolBar();
        panelButtonIcon.add(Box.createGlue());
        panelButtonIcon.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelButtonIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelButtonIcon.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelButtonIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelButtonIcon.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelButtonIcon.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelButtonIcon.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelButtonIcon.add(Box.createGlue());
        panelButtonIcon.setFloatable(false);
        panelButtonIcon.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._ctrlAdd.setEnabled(false);
        JPanel leftPanel = new JPanel(new BorderLayout());
        JScrollPane scrollTable = new JScrollPane(this._iconTable);
        leftPanel.add((Component)scrollTable, "Center");
        if (!this._appl.isReader()) {
            leftPanel.add((Component)panelButtonIcon, "South");
            scrollTable.setComponentPopupMenu(this._popupMenu);
        }
        leftPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this._splitPane = new JSplitPane(1, leftPanel, this._iconChooserPanel);
        this.add((Component)this._splitPane, "Center");
        this.updateButtons();
        this.defineActions();
    }

    public void refreshTable() {
        ((IconTableModel)this._iconTable.getModel()).refresh();
    }

    @Override
    public void focusTreatment() {
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaIconPanel.this._currentComponent == null) {
                    return;
                }
                AltaIconPanel.this.doInsert();
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_ICON_ADD_ICONS"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes;
                if (AltaIconPanel.this._currentComponent != null && (indexes = AltaIconPanel.this._iconTable.getSelectedRows()).length != 0) {
                    ArrayList<Integer> listDeletion = new ArrayList<Integer>();
                    for (int i = indexes.length - 1; i >= 0; --i) {
                        listDeletion.add(indexes[i]);
                    }
                    Iterator iterator = listDeletion.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        AltaIconPanel.this._currentComponent.getSimuls().remove(index);
                    }
                    ((IconTableModel)AltaIconPanel.this._iconTable.getModel()).refresh();
                    AltaIconPanel.this._iconChooserPanel.setSelectFolder(null);
                    AltaIconPanel.this.getAltaComponent().setModified(true);
                    AltaIconPanel.this.getAltaComponent().updateDependTimeUpdt(AltaIconPanel.this._appl.getDAOFactory(), AltaIconPanel.this.getAltaComponent().getWorkingRelations());
                }
            }
        }.setDesc(ResMsgOcas.getString("MODEL_EDIT_ICON_DEL"));
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("CMD_MOVE_UP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes;
                if (AltaIconPanel.this._currentComponent != null && (indexes = AltaIconPanel.this._iconTable.getSelectedRows()).length > 0) {
                    AltaIconPanel.this._iconTable.clearSelection();
                    for (int index : indexes) {
                        DBIcon dbIcon = AltaIconPanel.this._currentComponent.getSimuls().remove(index);
                        AltaIconPanel.this._currentComponent.getSimuls().add(index - 1, dbIcon);
                        AltaIconPanel.this._iconTable.addRowSelectionInterval(index - 1, index - 1);
                    }
                    if (indexes.length > 1) {
                        AltaIconPanel.this._iconChooserPanel.setSelectFolder(null);
                    }
                    AltaIconPanel.this.updateButtons();
                    AltaIconPanel.this.getAltaComponent().setModified(true);
                }
            }
        }.setDesc(ResMsgVoc.getString("CMD_MOVE_UP"));
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("CMD_MOVE_DOWN")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes;
                if (AltaIconPanel.this._currentComponent != null && (indexes = AltaIconPanel.this._iconTable.getSelectedRows()).length > 0) {
                    AltaIconPanel.this._iconTable.clearSelection();
                    ArrayList<Integer> listDownElements = new ArrayList<Integer>();
                    for (int index = indexes.length - 1; index >= 0; --index) {
                        listDownElements.add(indexes[index]);
                    }
                    Iterator iterator = listDownElements.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        DBIcon dbIcon = AltaIconPanel.this._currentComponent.getSimuls().remove(index);
                        AltaIconPanel.this._currentComponent.getSimuls().add(index + 1, dbIcon);
                        AltaIconPanel.this._iconTable.addRowSelectionInterval(index + 1, index + 1);
                    }
                    if (indexes.length > 1) {
                        AltaIconPanel.this._iconChooserPanel.setSelectFolder(null);
                    }
                    AltaIconPanel.this.updateButtons();
                    AltaIconPanel.this.getAltaComponent().setModified(true);
                }
            }
        }.setDesc(ResMsgVoc.getString("CMD_MOVE_DOWN"));
    }

    private void defineActions() {
        this._iconTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AltaIconPanel.this._iconTable.getSelectedRowCount() > 1) {
                    AltaIconPanel.this._iconChooserPanel.setSelectFolder(null);
                    AltaIconPanel.this._iconChooserPanel.getSelectFolder();
                    return;
                }
                int row = AltaIconPanel.this._iconTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                if (AltaIconPanel.this._currentComponent == null) {
                    return;
                }
                DBIcon dbIcon = AltaIconPanel.this._currentComponent.getSimuls().get(row);
                AltaIconPanel.this._iconChooserPanel.setSelectFolder(dbIcon.getDBFolder());
            }
        });
        if (!this._appl.isReader()) {
            this._iconTable.getActionMap().put("DELETE", this._ctrlDel);
            this._iconTable.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        }
    }

    protected void doInsert() {
        Collection<DBFolder> dbFolders = this._iconChooserPanel.getSelectFolders();
        if (dbFolders.isEmpty()) {
            return;
        }
        boolean bInsert = false;
        StringBuilder iconAlreadyExist = new StringBuilder();
        List<DBIcon> listIcons = this._currentComponent.getSimuls();
        int index = this._iconTable.getSelectedRow();
        for (DBFolder dbFolder : dbFolders) {
            DBWrap dbWrap = this._appl.getDAOFactory().findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                if (iconAlreadyExist.length() > 0) {
                    iconAlreadyExist.append(", ");
                }
                iconAlreadyExist.append(dbFolder.getRefPath());
                iconAlreadyExist.append("*");
                continue;
            }
            boolean find = false;
            for (int i = 0; !find && i < listIcons.size(); ++i) {
                if (!listIcons.get(i).getDBFolder().equals(dbFolder)) continue;
                find = true;
            }
            if (find) {
                if (iconAlreadyExist.length() > 0) {
                    iconAlreadyExist.append(", ");
                }
                iconAlreadyExist.append(dbFolder.getRefPath());
                continue;
            }
            if (index != -1) {
                listIcons.add(index, (DBIcon)dbWrap);
            } else {
                listIcons.add((DBIcon)dbWrap);
            }
            bInsert = true;
        }
        if (bInsert) {
            ((IconTableModel)this._iconTable.getModel()).refresh();
            this.getAltaComponent().setModified(true);
            this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
        }
        if (iconAlreadyExist.length() > 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("KEY_ALREADY_EXIST", ResMsgOcas.getString("GLOBAL_THE_ICON"), iconAlreadyExist.toString()), ResMsgVoc.getString("VOC_ERROR"), 0);
        }
    }

    public void updateButtons() {
        int[] indexes = this._iconTable.getSelectedRows();
        if (indexes.length > 0) {
            this._ctrlUp.setEnabled(indexes[0] != 0);
            this._ctrlDown.setEnabled(indexes[indexes.length - 1] != this._iconTable.getRowCount() - 1);
            this._ctrlDel.setEnabled(true);
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlUp.setEnabled(false);
            this._ctrlDown.setEnabled(false);
        }
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this._splitPane.setDividerLocation(200);
        ((IconTableModel)this._iconTable.getModel()).refresh();
    }

    public void updateLangage() {
        ((IconTableModel)this._iconTable.getModel()).refresh();
        this._ctrlAdd.setDesc(ResMsgOcas.getString("MODEL_EDIT_ICON_ADD_ICONS"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("MODEL_EDIT_ICON_DEL"));
        this._ctrlUp.setDesc(ResMsgVoc.getString("CMD_MOVE_UP"));
        this._ctrlDown.setDesc(ResMsgVoc.getString("CMD_MOVE_DOWN"));
    }

    public class IconTableModel
    extends AbstractTableModel {
        private JTable _table;

        IconTableModel() {
        }

        protected IconTableModel setTable(JTable table) {
            this._table = table;
            return this;
        }

        public void refresh() {
            int selectedRow = this._table.getSelectedRow();
            int height = 0;
            for (int r = 0; r < this.getRowCount(); ++r) {
                ImageIcon icon = (ImageIcon)this.getValueAt(r, 1);
                if (icon.getIconHeight() <= height) continue;
                height = icon.getIconHeight();
            }
            this.fireTableChanged(null);
            int tableWidth = this._table.getSize().width;
            this._table.getTableHeader().getColumnModel().getColumn(0).setWidth(20);
            this._table.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(20);
            this._table.getTableHeader().getColumnModel().getColumn(0).setMinWidth(20);
            this._table.getTableHeader().getColumnModel().getColumn(0).setPreferredWidth(20);
            this._table.getTableHeader().getColumnModel().getColumn(0).setResizable(false);
            this._table.getTableHeader().getColumnModel().getColumn(1).setWidth(tableWidth - 20);
            this._table.setRowHeight(height + 10);
            this._table.getTableHeader().getColumnModel().getColumn(0).setCellRenderer(new AltaDefaultTableCellRenderer(0));
            if (selectedRow != -1 && selectedRow < this._table.getRowCount() && this._table.getSelectedRowCount() > 1) {
                this._table.setRowSelectionInterval(selectedRow, selectedRow);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (AltaIconPanel.this._currentComponent == null) {
                return 0;
            }
            return AltaIconPanel.this._currentComponent.getSimuls().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaIconPanel.this._currentComponent == null) {
                return "<null>";
            }
            switch (col) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return AltaIconPanel.this._currentComponent.getSimuls().get(row).getImage();
                }
            }
            return "???";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "N\u00b0";
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_ICONS");
                }
            }
            return "";
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return ImageIcon.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    public class IconTable
    extends CeciliaTable
    implements JTableTransfertHandler.HelperConvert {
        public IconTable(TableModel model) {
            super(model);
            this.setTransferHandler(new JTableTransfertHandler());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DBIcon dbIcon;
            super.valueChanged(e);
            try {
                AltaIconPanel.this.updateButtons();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int row = this.getSelectedRow();
            if (row != -1 && AltaIconPanel.this._currentComponent != null && (dbIcon = AltaIconPanel.this._currentComponent.getSimuls().get(row)) != null && this.getSelectedRowCount() == 1) {
                AltaIconPanel.this._iconChooserPanel.setSelectFolder(dbIcon.getDBFolder());
            }
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            switch (col) {
                case 0: {
                    return obj.toString();
                }
                case 1: {
                    return AltaIconPanel.this._currentComponent.getSimuls().get(row).getRefPath();
                }
            }
            return null;
        }
    }
}

