/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.DelegateMouseFormMovePoint;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class AlgaForm
extends AlgaDraw {
    Type _type;
    transient Shape _shape = new Rectangle();

    public AlgaForm(Type type) {
        this._type = type;
        this._opaque = true;
        this._background = Color.white;
        this._foreground = Color.black;
    }

    @Override
    public AlgaForm getCopy(boolean withDepth, CopyUtility util) {
        AlgaForm result = new AlgaForm(this._type);
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaForm) {
            AlgaForm src = (AlgaForm)grfsrc;
            this._type = src._type;
            this._shape = this.createShape();
        }
    }

    @Override
    public boolean isVisio() {
        return true;
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        switch (this._type) {
            case RECTANGLE: {
                return "[Rectangle]";
            }
            case OVALE: {
                return "[Ellipse]";
            }
            case ROUND_RECTANGLE: {
                return "[Rectangle-Round]";
            }
            case ARROW_SIMPLE: {
                return "[Arrow]";
            }
            case ARROW_DOUBLE: {
                return "[Arrow-Double]";
            }
            case ARROW_R_SIMPLE: {
                return "[Arrow-Turn]";
            }
            case ARROW_R_DOUBLE: {
                return "[Arrow-Turn-Double]";
            }
            case ARROW_TRIPLE: {
                return "[Arrow-Triple]";
            }
        }
        return "";
    }

    @Override
    public boolean contains(int x, int y) {
        Rectangle possible = new Rectangle(this.getSelectBounds());
        possible.grow(4, 4);
        return possible.contains(x, y);
    }

    @Override
    public AltaContentView.DelegateMouse getCtrlMouse(int x, int y, AltaContentView view) {
        int result;
        if (!this.isLocked() && this.isSelected() && view instanceof AltaContentEditView && (result = this.getHitPoint(x, y)) != -10 && result != -1) {
            return new DelegateMouseFormMovePoint(this, result);
        }
        return super.getCtrlMouse(x, y, view);
    }

    @Override
    public void paintSelectionCorner(Graphics2D g, AlgaContext context, int rectx, int recty, int rectwidth, int rectheight) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setStroke(context.getStroke(1, -1, -1, false));
        if (this.isLocked()) {
            g.setColor(context.getColorSelect(true));
            int x = rectx;
            int y = recty;
            g.drawRect(x - 3, y - 3, 6, 6);
            g.drawRect((x += rectwidth) - 3, y - 3, 6, 6);
            g.drawRect(x - 3, (y += rectheight) - 3, 6, 6);
            g.drawRect((x -= rectwidth) - 3, y - 3, 6, 6);
        } else {
            g.setColor(context.getColorSelect(false));
            int x = rectx;
            int y = recty;
            g.fillRect(x - 3, y - 3, 6, 6);
            g.fillRect((x += rectwidth) - 3, y - 3, 6, 6);
            g.fillRect(x - 3, (y += rectheight) - 3, 6, 6);
            g.fillRect((x -= rectwidth) - 3, y - 3, 6, 6);
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(this.getCX() - this.getW() / 2, this.getCY() - this.getH() / 2);
            this._transform.prepareGraphics(g, this.getW() / 2, this.getH() / 2);
            this.paintForm(g, context);
            if (this.isSelected() && context.isDisplay()) {
                this.paintSelectionCorner(g, context, 0, 0, this.getW(), this.getH());
            }
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    private void paintForm(Graphics2D g, AlgaContext context) {
        if (this._shape == null) {
            return;
        }
        Color oldColor = g.getColor();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fill(this._shape);
        }
        g.setColor(this.getForeground());
        g.draw(this._shape);
        g.setColor(oldColor);
    }

    public Type getType() {
        return this._type;
    }

    public AlgaForm setType(Type type) {
        this._type = type;
        return this;
    }

    @Override
    public void computeControlPoints() {
        super.computeControlPoints();
        this._shape = this.createShape();
    }

    private Shape createShape() {
        switch (this._type) {
            case RECTANGLE: {
                return new Rectangle2D.Float(0.0f, 0.0f, this.getW(), this.getH());
            }
            case OVALE: {
                return new Ellipse2D.Float(0.0f, 0.0f, this.getW(), this.getH());
            }
            case ROUND_RECTANGLE: {
                return new RoundRectangle2D.Float(0.0f, 0.0f, this.getW(), this.getH(), (float)this.getW() * 0.1f, (float)this.getW() * 0.1f);
            }
            case ARROW_SIMPLE: {
                int w = this.getW();
                int h = this.getH();
                double dw = (double)w / 4.0;
                double dh = (double)h / 4.0;
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0, 1.0 * dh);
                path.lineTo(3.0 * dw, 1.0 * dh);
                path.lineTo(3.0 * dw, 0.0);
                path.lineTo(4.0 * dw, 2.0 * dh);
                path.lineTo(3.0 * dw, 4.0 * dh);
                path.lineTo(3.0 * dw, 3.0 * dh);
                path.lineTo(0.0, 3.0 * dh);
                path.closePath();
                return path;
            }
            case ARROW_DOUBLE: {
                int w = this.getW();
                int h = this.getH();
                double dw = (double)w / 4.0;
                double dh = (double)h / 4.0;
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0, 2.0 * dh);
                path.lineTo(1.0 * dw, 0.0);
                path.lineTo(1.0 * dw, 1.0 * dh);
                path.lineTo(3.0 * dw, 1.0 * dh);
                path.lineTo(3.0 * dw, 0.0);
                path.lineTo(4.0 * dw, 2.0 * dh);
                path.lineTo(3.0 * dw, 4.0 * dh);
                path.lineTo(3.0 * dw, 3.0 * dh);
                path.lineTo(1.0 * dw, 3.0 * dh);
                path.lineTo(1.0 * dw, 4.0 * dh);
                path.closePath();
                return path;
            }
            case ARROW_R_SIMPLE: {
                int w = this.getW();
                int h = this.getH();
                double dw = (double)w / 10.0;
                double dh = (double)h / 3.0;
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0, 2.0 * dh);
                path.lineTo(5.0 * dw, 2.0 * dh);
                path.lineTo(5.0 * dw, 1.0 * dh);
                path.lineTo(4.0 * dw, 1.0 * dh);
                path.lineTo(7.0 * dw, 0.0);
                path.lineTo(10.0 * dw, 1.0 * dh);
                path.lineTo(9.0 * dw, 1.0 * dh);
                path.lineTo(9.0 * dw, 3.0 * dh);
                path.lineTo(0.0, 3.0 * dh);
                path.closePath();
                return path;
            }
            case ARROW_R_DOUBLE: {
                int w = this.getW();
                int h = this.getH();
                double dw = w / 7;
                double dh = h / 7;
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0, 5.0 * dh);
                path.lineTo(2.0 * dw, 3.0 * dh);
                path.lineTo(2.0 * dw, 4.0 * dh);
                path.lineTo(4.0 * dw, 4.0 * dh);
                path.lineTo(4.0 * dw, 2.0 * dh);
                path.lineTo(3.0 * dw, 2.0 * dh);
                path.lineTo(5.0 * dw, 0.0);
                path.lineTo(7.0 * dw, 2.0 * dh);
                path.lineTo(6.0 * dw, 2.0 * dh);
                path.lineTo(6.0 * dw, 6.0 * dh);
                path.lineTo(2.0 * dw, 6.0 * dh);
                path.lineTo(2.0 * dw, 7.0 * dh);
                path.closePath();
                return path;
            }
            case ARROW_TRIPLE: {
                int w = this.getW();
                int h = this.getH();
                double dw = (double)w / 16.0;
                double dh = (double)h / 11.0;
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0, 8.0 * dh);
                path.lineTo(4.0 * dw, 5.0 * dh);
                path.lineTo(4.0 * dw, 6.0 * dh);
                path.lineTo(6.0 * dw, 6.0 * dh);
                path.lineTo(6.0 * dw, 4.0 * dh);
                path.lineTo(5.0 * dw, 4.0 * dh);
                path.lineTo(8.0 * dw, 0.0);
                path.lineTo(11.0 * dw, 4.0 * dh);
                path.lineTo(10.0 * dw, 4.0 * dh);
                path.lineTo(10.0 * dw, 6.0 * dh);
                path.lineTo(12.0 * dw, 6.0 * dh);
                path.lineTo(12.0 * dw, 5.0 * dh);
                path.lineTo(16.0 * dw, 8.0 * dh);
                path.lineTo(12.0 * dw, 11.0 * dh);
                path.lineTo(12.0 * dw, 10.0 * dh);
                path.lineTo(4.0 * dw, 10.0 * dh);
                path.lineTo(4.0 * dw, 11.0 * dh);
                path.closePath();
                return path;
            }
        }
        return null;
    }

    public static enum Type {
        TEXT,
        IMAGE,
        LINE,
        POLYGONE,
        OVALE,
        RECTANGLE,
        ROUND_RECTANGLE,
        ARROW_SIMPLE,
        ARROW_DOUBLE,
        ARROW_R_SIMPLE,
        ARROW_R_DOUBLE,
        ARROW_TRIPLE;

        String _xml = this.toString().toLowerCase();

        public String toXML() {
            return this._xml;
        }

        public static Type fromXML(String code) {
            for (Type value : Type.values()) {
                if (!value._xml.equals(code)) continue;
                return value;
            }
            return null;
        }
    }
}

