/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;

public class AlgaNode
extends AlgaWithPorts {
    AltaSub _logSub = null;

    public AltaSub getLogical() {
        return this._logSub;
    }

    public AlgaNode setLogical(AltaSub logSub) {
        if (logSub == null) {
            throw new NullPointerException();
        }
        this._logSub = logSub;
        this._logSub.setGraphic(this);
        return this;
    }

    @Override
    public AlgaNode getCopy(boolean withDepth, CopyUtility util) {
        AlgaNode result = new AlgaNode();
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaNode) {
            AlgaNode src = (AlgaNode)grfsrc;
            this.setLogical((AltaSub)util.getRef((Object)src.getLogical()));
        }
    }

    @Override
    public int getW() {
        return this._logSub.getNode().getWidth();
    }

    @Override
    public int getH() {
        return this._logSub.getNode().getHeight();
    }

    @Override
    public Pt getPoint(AltaFlow flow) {
        Pt pt = this._transform.convertPoint(flow.getX(), flow.getY(), this.getW(), this.getH());
        pt.setX(pt.getX() + this.getX());
        pt.setY(pt.getY() + this.getY());
        return pt;
    }

    @Override
    public AltaFlow getFlowAt(int x, int y) {
        Pt pt = this._transform.convertPointInverse(x - this.getX(), y - this.getY(), this.getW(), this.getH());
        List<AltaFlow> flows = this.getLogical().getNode().getFlows();
        for (int i = flows.size() - 1; i >= 0; --i) {
            AltaFlow flow = flows.get(i);
            if (flow.getOrientation() == AltaFlow.Orientation.LOCAL || !this.isAround(flow.getX(), flow.getY(), pt.getX(), pt.getY())) continue;
            return flow;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(this.getCX() - this.getW() / 2, this.getCY() - this.getH() / 2);
            this._transform.prepareGraphics(g, this.getW() / 2, this.getH() / 2);
            this.paintNode(g, context);
            if (context.isPaintingPort()) {
                this.paintPorts(g, context);
            }
            if (this.isSelected() && context.isDisplay()) {
                this.paintSelectionCorner(g, context, 0, 0, this.getW(), this.getH());
            }
        }
        finally {
            g.setTransform(oldTransform);
        }
        if (context.itsCompatiblePolicyLabel(AlgaContext.PolicyLabel.NODE)) {
            this.paintLabel(g, context);
        }
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel());
        AltaFlow flow = this.getFlowAt(x, y);
        if (flow != null) {
            sb.append(".").append(flow.getName());
            sb.append(" (").append(flow.getType().toLabel()).append(")");
            if (flow.isRecord()) {
                sb.append(" -");
                DBRecord dbRecord = (DBRecord)flow.getType();
                for (int i = 0; i < dbRecord.getValueCount(); ++i) {
                    DBRecordField field = dbRecord.getFieldAt(i);
                    sb.append(" \"").append(field.getName()).append("\" : ");
                    int nbr = 0;
                    for (AltaLink link : owner.getLinks()) {
                        if ((link.getToFlow() != flow || link.getToSub() != this.getLogical() || link.getToField() != null && !link.getToField().equals(field)) && (link.getFromFlow() != flow || link.getFromSub() != this.getLogical() || link.getFromField() != null && !link.getFromField().equals(field))) continue;
                        ++nbr;
                    }
                    sb.append(nbr);
                    sb.append(" ,");
                }
                sb.deleteCharAt(sb.length() - 1);
            } else {
                sb.append(" : ");
                int nbr = 0;
                for (AltaLink link : owner.getLinks()) {
                    if (flow.getOrientation() == AltaFlow.Orientation.IN) {
                        if (link.getToFlow() != flow || link.getToSub() != this.getLogical()) continue;
                        ++nbr;
                        continue;
                    }
                    if (flow.getOrientation() != AltaFlow.Orientation.OUT || link.getFromFlow() != flow || link.getFromSub() != this.getLogical()) continue;
                    ++nbr;
                }
                sb.append(nbr);
            }
        } else {
            sb.append(" (").append(this._logSub.getNode().getRefPath()).append(")");
        }
        return sb.toString();
    }

    @Override
    protected String getLabel() {
        return this._logSub.getName();
    }

    @Override
    public Font getFont(AlgaContext context) {
        if (this._logSub.getNode() instanceof AltaEquipment) {
            return context.getFont(null, 1, -1);
        }
        return super.getFont(context);
    }

    @Override
    protected Color getColor(AlgaContext context) {
        if (this.isSelected()) {
            return context.getColorSelect(this.isLocked());
        }
        return context.getDefaultColor();
    }

    private DBIcon getIcon(AlgaContext context) {
        return context.getIconSub(this._logSub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintNode(Graphics2D g, AlgaContext context) {
        int w = this.getW();
        int h = this.getH();
        DBIcon dbIcon = this.getIcon(context);
        if (dbIcon != null) {
            ImageIcon icon = dbIcon.getImage();
            Graphics g2D = null;
            try {
                BufferedImage image = new BufferedImage(w, h, 2);
                g2D = image.createGraphics();
                g2D.drawImage(icon.getImage(), 0, 0, w, h, null);
                g.drawImage((Image)image, 0, 0, null);
            }
            finally {
                if (g2D != null) {
                    g2D.dispose();
                }
            }
        }
        if (this._logSub.getNode().isBorderDrawing()) {
            Color oldColor = g.getColor();
            try {
                g.setColor(Color.black);
                g.drawRect(0, 0, w, h);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }

    private void paintPorts(Graphics2D g, AlgaContext context) {
        List<AltaFlow> flows = this._logSub.getNode().getFlows();
        if (!flows.isEmpty()) {
            Color oldColor = g.getColor();
            for (int i = 0; i < flows.size(); ++i) {
                AltaFlow flow = flows.get(i);
                if (flow.getOrientation() == AltaFlow.Orientation.LOCAL) continue;
                if (flow.isSelected()) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                if (flow.getOrientation() == AltaFlow.Orientation.OUT) {
                    g.fillRect(flow.getX() - 3, flow.getY() - 3, 6, 6);
                    continue;
                }
                g.drawRect(flow.getX() - 3, flow.getY() - 3, 6, 6);
            }
            g.setColor(oldColor);
        }
    }

    @Override
    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        return this._logSub.getNode() != null;
    }
}

