/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class AlgaPort
extends AlgaWithPorts {
    private static final int WIDTH = 34;
    private static final int HEIGHT = 14;
    AltaFlow _flow;
    boolean _automaticLocation = false;

    public AltaFlow getFlow() {
        return this._flow;
    }

    public AlgaPort setFlow(AltaFlow flow) {
        if (flow == null) {
            throw new NullPointerException();
        }
        this._flow = flow;
        return this;
    }

    public boolean isAutomaticPosition() {
        return this._automaticLocation;
    }

    public AlgaPort setAutomaticPosition(boolean auto) {
        this._automaticLocation = auto;
        return this;
    }

    @Override
    public AlgaPort getCopy(boolean withDepth, CopyUtility util) {
        AlgaPort result = new AlgaPort();
        result.copy(this, withDepth, util);
        util.setRef((Object)this, (Object)result);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaPort) {
            AlgaPort src = (AlgaPort)grfsrc;
            this.setFlow((AltaFlow)util.getRef((Object)src.getFlow()));
            this.setAutomaticPosition(src.isAutomaticPosition());
        }
    }

    @Override
    public int getW() {
        return 34;
    }

    @Override
    public int getH() {
        return 14;
    }

    @Override
    public Pt getPoint(AltaFlow flow) {
        Pt pt = this._transform.convertPoint(34, 7, this.getW(), this.getH());
        pt.setX(pt.getX() + this.getX());
        pt.setY(pt.getY() + this.getY());
        return pt;
    }

    @Override
    public AltaFlow getFlowAt(int x, int y) {
        Pt pt = this._transform.convertPointInverse(x - this.getX(), y - this.getY(), this.getW(), this.getH());
        if (this.isAround(34, 7, pt.getX(), pt.getY())) {
            return this._flow;
        }
        return null;
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel()).append(" (").append(this._flow.getType().toLabel()).append(")");
        if (this._flow.isRecord()) {
            sb.append(" -");
            DBRecord dbRecord = (DBRecord)this._flow.getType();
            for (int i = 0; i < dbRecord.getValueCount(); ++i) {
                DBRecordField field = dbRecord.getFieldAt(i);
                sb.append(" \"").append(field.getName()).append("\" : ");
                int nbr = 0;
                for (AltaLink link : owner.getLinks()) {
                    if (this._flow.getOrientation() == AltaFlow.Orientation.OUT) {
                        if (link.getToFlow() != this._flow || link.getToSub() != null || link.getToField() != null && !link.getToField().equals(field)) continue;
                        ++nbr;
                        continue;
                    }
                    if (this._flow.getOrientation() != AltaFlow.Orientation.IN || link.getFromFlow() != this._flow || link.getFromSub() != null || link.getFromField() != null && !link.getFromField().equals(field)) continue;
                    ++nbr;
                }
                sb.append(nbr);
                sb.append(" ,");
            }
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append(" : ");
            int nbr = 0;
            for (AltaLink link : owner.getLinks()) {
                if (this._flow.getOrientation() == AltaFlow.Orientation.OUT) {
                    if (link.getToFlow() != this._flow || link.getToSub() != null) continue;
                    ++nbr;
                    continue;
                }
                if (this._flow.getOrientation() != AltaFlow.Orientation.IN || link.getFromFlow() != this._flow || link.getFromSub() != null) continue;
                ++nbr;
            }
            sb.append(nbr);
        }
        return sb.toString();
    }

    @Override
    protected String getLabel() {
        return this._flow.getName();
    }

    @Override
    protected Color getColor(AlgaContext context) {
        return context.getColorFlow(this._flow, this.isSelected(), this.isLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(this.getCX() - this.getW() / 2, this.getCY() - this.getH() / 2);
            this._transform.prepareGraphics(g, this.getW() / 2, this.getH() / 2);
            this.paintNode(g, context);
            if (context.isPaintingPort()) {
                this.paintPorts(g, context);
            }
            if (this.isSelected() && context.isDisplay()) {
                this.paintSelectionCorner(g, context, 0, 0, this.getW(), this.getH());
            }
        }
        finally {
            g.setTransform(oldTransform);
        }
        if (context.itsCompatiblePolicyLabel(AlgaContext.PolicyLabel.NODE)) {
            this.paintLabel(g, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintNode(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        try {
            g.setColor(this.getColor(context));
            g.drawRect(0, 0, this.getW(), this.getH());
        }
        finally {
            g.setColor(oldColor);
        }
    }

    private void paintPorts(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        AltaFlow flow = this._flow;
        if (flow.isSelected()) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        if (flow.getOrientation() == AltaFlow.Orientation.IN) {
            g.fillRect(31, 4, 6, 6);
        } else {
            g.drawRect(31, 4, 6, 6);
        }
        g.setColor(oldColor);
    }
}

