/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AlgaSheet
extends AlgaContainer {
    public static final int MAX_NBR_SHEET = 30;
    private static final int MARGE = 50;
    int _number;
    String _name;
    int _order;
    boolean _visible;
    Rectangle _bound;

    public AlgaSheet(int number, String name, int order, boolean selected, boolean visible) {
        this._number = number;
        this._name = name;
        this._order = order;
        this._selected = selected;
        this._visible = visible;
        this._bound = new Rectangle(0, 0, 0, 0);
    }

    @Override
    public AlgaSheet getCopy(boolean withDepth, CopyUtility util) {
        AlgaSheet result = new AlgaSheet(this._number, this._name, this._order, this._selected, this._visible);
        result.copy(this, withDepth, util);
        return result;
    }

    public int getOrder() {
        return this._order;
    }

    public int getNumber() {
        return this._number;
    }

    public String getName() {
        return this._name;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public AlgaSheet setNumber(int number) {
        this._number = number;
        return this;
    }

    public AlgaSheet setName(String name) {
        this._name = name;
        return this;
    }

    public AlgaSheet setVisible(boolean visible) {
        this._visible = visible;
        return this;
    }

    @Override
    public int getX() {
        return 0;
    }

    @Override
    public int getY() {
        return 0;
    }

    @Override
    public int getW() {
        return this._bound.width;
    }

    @Override
    public int getH() {
        return this._bound.height;
    }

    @Override
    public Rectangle getSelectBounds() {
        return this._bound;
    }

    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        if (!this._visible) {
            return;
        }
        super.paint(g, context);
    }

    @Override
    public void computeControlPoints() {
    }

    public void computeSize(Graphics g) {
        this._bound.height = 0;
        this._bound.width = 0;
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaGraph graph = (AlgaGraph)this._graphs.get(i);
            Rectangle bounds = graph.getBounds(g);
            this._bound.width = Math.max(this._bound.width, bounds.x + bounds.width);
            this._bound.height = Math.max(this._bound.height, bounds.y + bounds.height);
        }
        this._bound.width += 50;
        this._bound.height += 50;
    }

    public AlgaGraph getGraphAtPoint(int x, int y, AltaContentDisplayPreferencies.LinkDisplay linkDisplay) {
        if (!this._visible) {
            return null;
        }
        switch (linkDisplay) {
            case BG: {
                AlgaGraph graph;
                int i;
                for (i = this._graphs.size() - 1; i >= 0; --i) {
                    graph = (AlgaGraph)this._graphs.get(i);
                    if (graph.isLink() || !graph.contains(x, y)) continue;
                    return graph;
                }
                for (i = this._graphs.size() - 1; i >= 0; --i) {
                    graph = (AlgaGraph)this._graphs.get(i);
                    if (!graph.isLink() || !graph.contains(x, y)) continue;
                    return graph;
                }
                break;
            }
            case FG: {
                AlgaGraph graph;
                int i;
                for (i = this._graphs.size() - 1; i >= 0; --i) {
                    graph = (AlgaGraph)this._graphs.get(i);
                    if (!graph.isLink() || !graph.contains(x, y)) continue;
                    return graph;
                }
                for (i = this._graphs.size() - 1; i >= 0; --i) {
                    graph = (AlgaGraph)this._graphs.get(i);
                    if (graph.isLink() || !graph.contains(x, y)) continue;
                    return graph;
                }
                break;
            }
            case RELATIVE: {
                for (int i = this._graphs.size() - 1; i >= 0; --i) {
                    AlgaGraph graph = (AlgaGraph)this._graphs.get(i);
                    if (!graph.contains(x, y)) continue;
                    return graph;
                }
                break;
            }
        }
        return null;
    }
}

