/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;

public class AlgaText
extends AlgaForm {
    VAlignement _verticalAlignement = VAlignement.TOP;
    HAlignement _horizontalAlignement = HAlignement.LEFT;
    int _fontSize = 12;
    boolean _fontBold = false;
    boolean _fontItalic = false;
    String _text;

    public AlgaText() {
        super(AlgaForm.Type.TEXT);
    }

    public String getText() {
        return this._text;
    }

    public AlgaText setText(String text) {
        this._text = text;
        return this;
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return "[Text]:" + this._text;
    }

    public VAlignement getVerticalAlignement() {
        return this._verticalAlignement;
    }

    public AlgaText setVerticalAlignement(VAlignement align) {
        this._verticalAlignement = align;
        return this;
    }

    public HAlignement getHorizontalAlignement() {
        return this._horizontalAlignement;
    }

    public AlgaText setHorizontalAlignement(HAlignement align) {
        this._horizontalAlignement = align;
        return this;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public boolean isFontBold() {
        return this._fontBold;
    }

    public boolean isFontItalic() {
        return this._fontItalic;
    }

    public AlgaText setFont(int size, boolean bold, boolean italic) {
        this._fontSize = size;
        this._fontBold = bold;
        this._fontItalic = italic;
        return this;
    }

    @Override
    public AlgaText getCopy(boolean withDepth, CopyUtility util) {
        AlgaText result = new AlgaText();
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaText) {
            AlgaText src = (AlgaText)grfsrc;
            this._verticalAlignement = src._verticalAlignement;
            this._horizontalAlignement = src._horizontalAlignement;
            this._fontSize = src._fontSize;
            this._fontBold = src._fontBold;
            this._fontItalic = src._fontItalic;
            this._text = src._text;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(this.getCX() - this.getW() / 2, this.getCY() - this.getH() / 2);
            this._transform.prepareGraphics(g, this.getW() / 2, this.getH() / 2);
            this.paintText(g, context);
            if (this.isSelected() && context.isDisplay()) {
                this.paintSelectionCorner(g, context, 0, 0, this.getW(), this.getH());
            }
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintText(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        try {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getW(), this.getH());
            }
            g.setColor(this.getForeground());
            int style = 0;
            if (this.isFontBold()) {
                style = 1;
            }
            if (this.isFontItalic()) {
                style += 2;
            }
            Font font = context.getFont(null, style, this.getFontSize());
            g.setFont(font);
            FontMetrics fmetrics = g.getFontMetrics(font);
            int y = fmetrics.getHeight();
            int h = this.getH();
            int w = this.getW();
            StringTokenizer stoken = new StringTokenizer(this._text, "\n");
            switch (this.getVerticalAlignement()) {
                default: {
                    break;
                }
                case BOTTOM: {
                    y = h;
                    break;
                }
                case MIDDLE: {
                    y = (h - (stoken.countTokens() - 1) * fmetrics.getHeight()) / 2;
                }
            }
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextToken();
                switch (this.getHorizontalAlignement()) {
                    case LEFT: {
                        g.drawString(token, 0, y);
                        break;
                    }
                    case CENTER: {
                        g.drawString(token, (w - fmetrics.stringWidth(token)) / 2, y);
                        break;
                    }
                    case RIGHT: {
                        g.drawString(token, w - fmetrics.stringWidth(token), y);
                    }
                }
                y += fmetrics.getHeight();
            }
        }
        finally {
            g.setFont(oldFont);
            g.setColor(oldColor);
        }
    }

    public static enum HAlignement {
        LEFT,
        CENTER,
        RIGHT;

        String _xml = this.toString().toLowerCase();

        public String toXML() {
            return this._xml;
        }

        public static HAlignement fromXML(String code) {
            for (HAlignement value : HAlignement.values()) {
                if (!value._xml.equals(code)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum VAlignement {
        TOP,
        MIDDLE,
        BOTTOM;

        String _xml = this.toString().toLowerCase();

        public String toXML() {
            return this._xml;
        }

        public static VAlignement fromXML(String code) {
            for (VAlignement value : VAlignement.values()) {
                if (!value._xml.equals(code)) continue;
                return value;
            }
            return null;
        }
    }
}

