/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;

public class OCmdFormMovePoint
extends OCCmd {
    AlgaForm _graphic;
    int _index;
    int _oldCX;
    int _oldCY;
    int _oldWUser;
    int _oldHUser;
    int _newCX;
    int _newCY;
    int _newWUser;
    int _newHUser;

    public OCmdFormMovePoint(AltaContentEditPanel c, AlgaForm graphic, int moveX, int moveY, int hitpoint) {
        super(c.getAppl(), c);
        this._graphic = graphic;
        this._oldWUser = this._graphic.getWUser();
        this._oldHUser = this._graphic.getHUser();
        this._oldCX = this._graphic.getCX();
        this._oldCY = this._graphic.getCY();
        int originX = this._graphic.getX();
        int originY = this._graphic.getY();
        switch (hitpoint) {
            case 0: {
                originX += this._graphic.getWUser();
                originY += this._graphic.getHUser();
                break;
            }
            case 1: {
                originY += this._graphic.getHUser();
                break;
            }
            case 3: {
                originX += this._graphic.getWUser();
                break;
            }
        }
        this._newWUser = Math.abs(originX - moveX);
        this._newHUser = Math.abs(originY - moveY);
        switch (hitpoint) {
            case 0: {
                this._newCX = this._oldCX + (this._oldWUser - this._newWUser) / 2;
                this._newCY = this._oldCY + (this._oldHUser - this._newHUser) / 2;
                break;
            }
            case 1: {
                this._newCX = this._oldCX + (this._newWUser - this._oldWUser) / 2;
                this._newCY = this._oldCY + (this._oldHUser - this._newHUser) / 2;
                break;
            }
            case 3: {
                this._newCX = this._oldCX + (this._oldWUser - this._newWUser) / 2;
                this._newCY = this._oldCY + (this._newHUser - this._oldHUser) / 2;
                break;
            }
            case 2: {
                this._newCX = this._oldCX + (this._newWUser - this._oldWUser) / 2;
                this._newCY = this._oldCY + (this._newHUser - this._oldHUser) / 2;
            }
        }
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        this._graphic.setWUser(this._newWUser).setHUser(this._newHUser).setCX(this._newCX).setCY(this._newCY);
        this._graphic.computeControlPoints();
        this.refreshAll();
    }

    @Override
    public void undo() {
        this._graphic.setWUser(this._oldWUser).setHUser(this._oldHUser).setCX(this._oldCX).setCY(this._oldCY);
        this._graphic.computeControlPoints();
        this.refreshAll();
    }
}

