/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OCmdOrder
extends OCCmd {
    List<AlgaSheetTransform> _sheetsTransfom;
    Type _type;

    public OCmdOrder(CeciliaAppl appl, AltaContentEditPanel c, Type type) {
        super(appl, c);
        this._type = type;
        this._sheetsTransfom = new ArrayList<AlgaSheetTransform>(8);
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            AlgaSheetTransform transform = null;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked()) continue;
                if (transform == null) {
                    transform = this.createTransform(sheet);
                }
                transform.addGraph(graph);
            }
        }
        return this._sheetsTransfom.size() > 0;
    }

    private AlgaSheetTransform createTransform(AlgaSheet sheet) {
        AlgaSheetTransform result = new AlgaSheetTransform(sheet);
        this._sheetsTransfom.add(result);
        return result;
    }

    @Override
    protected void firstDo() {
        if (this._sheetsTransfom.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        for (int i = this._sheetsTransfom.size() - 1; i >= 0; --i) {
            this._sheetsTransfom.get(i).redo();
        }
        this.refreshAll();
    }

    @Override
    public void undo() {
        for (int i = 0; i < this._sheetsTransfom.size(); ++i) {
            this._sheetsTransfom.get(i).undo();
        }
        this.refreshAll();
    }

    class AlgaSheetTransform {
        AlgaSheet _sheet;
        List<AlgaGraph> _graphs;
        List<Integer> _graphsIndexes;

        public AlgaSheetTransform(AlgaSheet sheet) {
            this._sheet = sheet;
            int nbrGraph = this._sheet.getGraphs().size();
            if (nbrGraph < 16) {
                nbrGraph = 16;
            }
            this._graphs = new ArrayList<AlgaGraph>(nbrGraph);
        }

        public void addGraph(AlgaGraph graph) {
            this._graphs.add(graph);
        }

        public void redo() {
            if (this._graphs.isEmpty()) {
                return;
            }
            this._graphsIndexes = new ArrayList<Integer>(this._graphs.size() + 1);
            for (int i = 0; i < this._graphs.size(); ++i) {
                int index = this._sheet.remove(this._graphs.get(i));
                this._graphsIndexes.add(index);
            }
            Collection<AlgaGraph> others = this._sheet.getGraphs();
            ArrayList<AlgaGraph> result = new ArrayList<AlgaGraph>(this._graphs.size() + others.size());
            if (OCmdOrder.this._type == Type.LAST) {
                result.addAll(this._graphs);
                result.addAll(others);
            } else {
                result.addAll(others);
                result.addAll(this._graphs);
            }
            this._sheet.setGraphs(result);
        }

        public void undo() {
            int i;
            if (this._graphs.isEmpty()) {
                return;
            }
            for (i = this._graphs.size() - 1; i >= 0; --i) {
                this._sheet.remove(this._graphs.get(i));
            }
            for (i = this._graphs.size() - 1; i >= 0; --i) {
                this._sheet.add(this._graphs.get(i), this._graphsIndexes.get(i));
            }
        }
    }

    public static enum Type {
        FIRST,
        LAST;

    }
}

