/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareObjWithNameResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public abstract class AltaNode
extends DBWrap {
    private static Logger _LOG = Logger.getLogger(AltaNode.class.getPackage().getName());
    protected String _code;
    protected List<AltaOperatorRef> _lstUsedOperator;
    protected List<AltaFlow> _lstFlow;
    long _nextFlowID = -1L;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public AltaNode(DBFolder dbFolder) {
        super(dbFolder);
        if (dbFolder != null && !dbFolder.isVersion()) {
            _LOG.severe("Creation d'un node a partir d'un DBFolder qui n'est pas une version : " + dbFolder.getRefPath());
        }
        this._code = "";
        this._lstFlow = new ArrayList<AltaFlow>();
        this._lstUsedOperator = new ArrayList<AltaOperatorRef>();
    }

    protected abstract String getRelation();

    protected Set<DBRelation> createRelations(String typeSrc) {
        int i;
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        for (i = 0; i < this._lstFlow.size(); ++i) {
            DBFolder dbType;
            AltaType altaType = this._lstFlow.get(i).getType();
            if (!(altaType instanceof DBType) || (dbType = ((DBType)altaType).getDBFolder()) == null) continue;
            relations.add(new DBRelation(this._dbFolder, typeSrc, dbType, "OA_TYPE"));
        }
        for (i = 0; i < this._lstUsedOperator.size(); ++i) {
            DBFolder dbOper = this._lstUsedOperator.get(i).getDBFolder();
            if (dbOper == null) continue;
            relations.add(new DBRelation(this._dbFolder, typeSrc, dbOper, "OA_OPER"));
        }
        return relations;
    }

    public final Set<DBRelation> getUseRelations() {
        return this.createRelations(this.getRelation());
    }

    public final Set<DBRelation> getWorkingRelations() {
        return this.createRelations("WORKING");
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        int i;
        String indent1 = indent + "  ";
        for (i = 0; i < this._lstFlow.size(); ++i) {
            this._lstFlow.get(i).toXML(out, false, indent1);
        }
        out.append(indent).append("  <").append("alta.code").append(">");
        DBObjectXmlUtility.appendXML(out, this._code);
        out.append("</").append("alta.code").append(">\n");
        for (i = 0; i < this._lstUsedOperator.size(); ++i) {
            this._lstUsedOperator.get(i).toXML(out, indent1);
        }
    }

    protected void copy(AltaNode src, CopyUtility util) {
        ObjectWithName cpy;
        int i;
        this.copy(src);
        this.setCode(src.getCode());
        List<ObjectWithName> lstSrc = src.getFlows();
        ArrayList<AltaFlow> lstCopy = new ArrayList<AltaFlow>(lstSrc.size());
        for (i = 0; i < lstSrc.size(); ++i) {
            cpy = lstSrc.get(i).getCopy();
            util.setRef((Object)lstSrc.get(i), (Object)cpy);
            lstCopy.add((AltaFlow)cpy);
        }
        this.setFlows(lstCopy);
        lstSrc = src.getUsedOperator();
        lstCopy = new ArrayList(lstSrc.size());
        for (i = 0; i < lstSrc.size(); ++i) {
            cpy = ((AltaOperatorRef)lstSrc.get(i)).getCopy();
            util.setRef((Object)lstSrc.get(i), (Object)cpy);
            lstCopy.add((AltaFlow)cpy);
        }
        this.setUsedOperator(lstCopy);
    }

    public abstract String getAltaRicaName();

    public void setCode(String code) {
        this._code = new String(code);
    }

    public String getCode() {
        return this._code;
    }

    public List<AltaFlow> getFlows() {
        return this._lstFlow;
    }

    public void setFlows(List<AltaFlow> opers) {
        this._lstFlow = opers;
    }

    public List<AltaOperatorRef> getUsedOperator() {
        return this._lstUsedOperator;
    }

    public void setUsedOperator(List<AltaOperatorRef> opers) {
        this._lstUsedOperator = opers;
    }

    public AltaFlow getFlow(String operName) {
        for (AltaFlow operande : this._lstFlow) {
            if (!operande.getName().equals(operName)) continue;
            return operande;
        }
        return null;
    }

    public AltaFlow getFlowWithID(long id) {
        for (AltaFlow operande : this._lstFlow) {
            if (operande.getID() != id) continue;
            return operande;
        }
        return null;
    }

    public AltaFlow getFlowAtLocation(int x, int y) {
        for (int i = this._lstFlow.size() - 1; i >= 0; --i) {
            AltaFlow flow = this._lstFlow.get(i);
            if (x < flow.getX() - 6 || x > flow.getX() + 6 || y < flow.getY() - 6 || y > flow.getY() + 6) continue;
            return flow;
        }
        return null;
    }

    public long getNextFlowID() {
        if (this._nextFlowID == -1L) {
            for (int i = this._lstFlow.size() - 1; i >= 0; --i) {
                AltaFlow flow = this._lstFlow.get(i);
                this._nextFlowID = Math.max(this._nextFlowID, flow.getID());
            }
        }
        return ++this._nextFlowID;
    }

    public ObjectWithName getFieldWithName(String name) {
        ObjectWithName obj = null;
        for (int i = this._lstFlow.size() - 1; i >= 0; --i) {
            obj = this._lstFlow.get(i);
            if (!obj.getName().equals(name)) continue;
            return obj;
        }
        return null;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("OCAS".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            byte[] ibyte = DAOObjModel.convertFromCompressedByte(istream);
            if (ibyte == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            String buffer = null;
            String encoding = model.getEncoding();
            if (encoding != null && !encoding.isEmpty()) {
                if (encoding.equals("ISO-8859-1")) {
                    buffer = new String(ibyte, DBObjModel.getOcasCharset());
                } else if (encoding.equals("UTF-8")) {
                    buffer = new String(ibyte, StandardCharsets.UTF_8);
                }
            }
            if (buffer == null) {
                buffer = new String(ibyte);
            }
            return this.readOcas(buffer, cecFactory, logMng);
        }
        if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
            if (istream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(istream, cecFactory, logMng);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    protected abstract DBNodeReaderRaw createReaderRaw(DBFolder var1, DBLogs.DBLogsManager var2);

    protected void copyFromReaderRaw(DBNodeReaderRaw readerRaw, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        this._lstFlow.clear();
        this._lstFlow.addAll(readerRaw.getFlows());
        this._lstUsedOperator.clear();
        this._lstUsedOperator.addAll(readerRaw.getOperators());
        this._code = readerRaw.getCode();
        AltaFileHeader properties = readerRaw.getProperties();
        if (properties != null) {
            properties.convertToDBFolder(this._dbFolder, cecFactory, logMng);
        }
    }

    public boolean readOcas(String input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        DBNodeReaderRaw readerRaw = this.createReaderRaw(this._dbFolder, logMng);
        try {
            if (readerRaw.readRaw(input, cecFactory)) {
                this.copyFromReaderRaw(readerRaw, cecFactory, logMng);
                result = true;
            }
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, this._dbFolder.getPathUntilSystem(new StringBuilder("Format de donnees incompatible").append(" : ")).toString(), e);
        }
        return result;
    }

    protected abstract DBNodeHandlerXml createHandlerXml(CECFactory var1, DBLogs.DBLogsManager var2);

    protected void copyFromHandlerXml(DBNodeHandlerXml saxHanlder, DBLogs.DBLogsManager logMng) {
        this._lstFlow.clear();
        this._lstFlow.addAll(saxHanlder.getFlows());
        this._lstUsedOperator.clear();
        this._lstUsedOperator.addAll(saxHanlder.getOperators());
        this._code = saxHanlder.getCode();
    }

    protected boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        DBNodeHandlerXml nodeHandlerXML = this.createHandlerXml(cecFactory, logMng);
        try {
            this.readXml(input, nodeHandlerXML.getSAXHandler());
            this.copyFromHandlerXml(nodeHandlerXML, logMng);
            this.verifyRefOperators(logMng);
            result = true;
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    protected void verifyRefOperators(DBLogs.DBLogsManager logMng) {
        for (AltaOperatorRef operRef : this.getUsedOperator()) {
            if (operRef.getName().equals(operRef.getDBFolder().getParent().getName())) continue;
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgObj.msgFormat("ERR_OPERATOR_NAME_UNCONSISTENCY_FRM", operRef.getName(), operRef.getDBFolder().getParent().getName()), true);
        }
    }

    public GenerateAltaricaCode generateCode(File file, CECFactory daoFactory, GenerateAltaricaCode.GenerateAltaRicaCodeUtility utility) {
        GenerateAltaricaCode generator = new GenerateAltaricaCode(daoFactory);
        generator.setUtility(utility);
        if (generator.prepare(this.getDBFolder(), this, this.getUseRelations())) {
            this.doGenerateCode(file, generator);
        }
        return generator;
    }

    protected abstract void doGenerateCode(File var1, GenerateAltaricaCode var2);

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = true;
        for (AltaFlow flow : this._lstFlow) {
            if (flow.update(daoFactory, logMng)) continue;
            result = false;
        }
        return result;
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String code1 = AltaNode.this.getCode();
                String code2 = ((AltaNode)wrap).getCode();
                return new CompareResultString(ResMsgVoc.getString("VOC_CODE"), code1, code2);
            }
        });
        return list;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons comparaisons = super.getCompareConflict(factoryWrap, wrap, forImport);
        CompareUtils.addConflictInDBWrap(comparaisons, this, wrap, ResMsgVoc.getString("VOC_FLOWS"), flow -> ((AltaFlow)flow).getName(), node -> ((AltaNode)node).getFlows(), CompareObjWithNameResult.class);
        CompareUtils.addConflictInDBWrap(comparaisons, this, wrap, ResMsgVoc.getString("VOC_OPERATORS"), operator -> ((AltaOperatorRef)operator).getName(), node -> ((AltaNode)node).getUsedOperator(), CompareObjWithNameResult.class);
        return comparaisons;
    }
}

