/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator.gui;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelectFilter;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class OperatorDlgChooser
extends JDialogCecilia {
    CAppl _application;
    String _filterName;
    DBFolderPanelSelect _ctrlSelect;

    public OperatorDlgChooser(Window owner, CAppl appl) {
        super(owner, ResMsgOcas.getString("TITLE_ALTA_OPERATOR_CHOICE"));
        this._application = appl;
        this.make(owner);
    }

    public void setFilterName(String name) {
        if (this._filterName != null && this._filterName.equals(name)) {
            return;
        }
        this._filterName = name;
        this._ctrlSelect.resetCache();
    }

    private void make(Window owner) {
        this._ctrlSelect = new DBFolderPanelSelectFilterOperator();
        this._ctrlSelect.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = OperatorDlgChooser.this._ctrlSelect.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (!dbFolder.isVersion()) {
                    return;
                }
                OperatorDlgChooser.this.validDialog();
            }
        });
        this._ctrlSelect.getCtrlTree().setVisibleRowCount(15);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._ctrlSelect, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width, 250);
        this.setSize(size);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
        this.setModal(true);
    }

    @Override
    public void dispose() {
        this._ctrlSelect.dispose();
        super.dispose();
    }

    @Override
    protected boolean verifyParameters() {
        return this.getSelectFolder() != null;
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._ctrlSelect.setSelectFolder(dbFolder);
    }

    public DBFolder getSelectFolder() {
        return this._ctrlSelect.getSelectFolder(true);
    }

    class DBFolderPanelSelectFilterOperator
    extends DBFolderPanelSelectFilter {
        public DBFolderPanelSelectFilterOperator() {
            super(OperatorDlgChooser.this._application, DBFolder.Family.OPERATOR);
        }

        @Override
        protected boolean selectThisFolder(DBFolder dbFolder) {
            if (dbFolder.isModel()) {
                return OperatorDlgChooser.this._filterName.equals(dbFolder.getName());
            }
            return dbFolder.isVersion();
        }

        @Override
        public boolean selectFolder(DBFolder dbFolder) {
            if (OperatorDlgChooser.this._filterName != null && !OperatorDlgChooser.this._filterName.isEmpty()) {
                return super.selectFolder(dbFolder);
            }
            return true;
        }
    }
}

