/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.stepper.ViewListener;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulPanel;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;

public class AltaSimulFrame
extends DBInternalFrame {
    CeciliaAppl _application;
    AltaSystem _dbSystem;
    AltaSimStepper _simStepper;
    AltaSimulPanel _simulPanel;
    private JLabel _ctrlPath;
    private JLabel _ctrlSimul;

    @Override
    public AltaSystem getDBWrap() {
        return this._dbSystem;
    }

    @Override
    protected CeciliaAppl getApplication() {
        return this._application;
    }

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_MODEL");
    }

    @Override
    protected String getDescription() {
        return this.getDBFolder().getDescription();
    }

    public AltaSimulFrame(CeciliaAppl appl, AltaSystem dbSystem, AltaSimStepper stepper) {
        super(ResIcoSimul.getImageIcon("SIMULATION"), dbSystem.getDBFolder().getParent().getName() + ";" + dbSystem.getDBFolder().getName(), dbSystem.getRefPath());
        this._application = appl;
        this._dbSystem = dbSystem;
        this._simStepper = stepper;
        this.setFrameIcon(ResIcoSimul.getImageIcon("SIMULATION"));
        this.makePanel();
        this._simulPanel.setComponent(this._dbSystem);
    }

    private void makePanel() {
        this._ctrlPath = new JLabel(".");
        this._ctrlSimul = new JLabel("");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add(this._ctrlPath);
        box.add(Box.createHorizontalGlue());
        box.add(this._ctrlSimul);
        box.add(Box.createHorizontalStrut(10));
        this._simStepper.addAltaListener(new ViewListener(){

            @Override
            public void altaTransitionUpdate(ViewTransition tr) {
            }

            @Override
            public void altaStateUpdate(ViewVariable state) {
            }

            @Override
            public void altaModelChanged(ViewStepper acastep) {
            }

            @Override
            public void altaFlowUpdate(ViewVariable flow) {
            }

            @Override
            public void altaOtherUpdate(int type, Object data) {
                if (type == 2 || type == 1) {
                    AltaSimulFrame.this.refreshTimeLoop();
                }
            }
        });
        this._simulPanel = new AltaSimulPanel(this.getApplication(), this._dbSystem, this._simStepper);
        this._simulPanel.make();
        this._simulPanel.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add((Component)box, "North");
        this.getContentPane().add((Component)this._simulPanel, "Center");
        this.refreshTimeLoop();
        this.refreshPath();
        this.setSize(800, 600);
    }

    public AltaSimulPanel getSimulPanel() {
        return this._simulPanel;
    }

    String defineTitle(AltaSystem dbSystem, String add) {
        StringBuilder sb = new StringBuilder();
        sb.append(dbSystem.getDBFolder().getParent().getName());
        sb.append(";");
        sb.append(dbSystem.getDBFolder().getName());
        if (!add.isEmpty()) {
            sb.append(add);
        }
        return sb.toString();
    }

    void refreshPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResMsgVoc.getString("VOC_PATH")).append(" : ");
        String instance = this._simulPanel.constructCurrentInstance();
        if (instance.length() <= 1) {
            sb.append(".");
            this.setIconText(this.defineTitle(this._dbSystem, "    "));
            this.setIconToolTip(this._dbSystem.getRefPath());
        } else {
            String path = instance.subSequence(0, instance.length() - 1).toString();
            sb.append(path);
            this.setIconText(this.defineTitle(this._dbSystem, " *"));
            StringBuilder tt = new StringBuilder(128);
            tt.append(this._dbSystem.getRefPath()).append(" [").append(path).append("]");
            this.setIconToolTip(tt.toString());
        }
        this._ctrlPath.setText(sb.toString());
    }

    private void refreshTimeLoop() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._simStepper.getCurrentTime()).append(" / ").append(this._simStepper.getCurrentLoop());
        this._ctrlSimul.setText(sb.toString());
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        this._simulPanel.toDoWhenActivated();
        this._application.getTopWindow().setEnabledAction("SEARCH", true);
    }

    @Override
    public void toDoWhenDeActivated() {
        this._simulPanel.toDoWhenDeActivated();
        this._application.getTopWindow().setEnabledAction("SEARCH", false);
        super.toDoWhenDeActivated();
    }

    @Override
    public boolean toDoWhenClosing() {
        OpenFolder openfolder = this.getApplication().getOpenFolders().getOpenFolder(this.getDBFolder());
        if (openfolder.getMasterFrame() == this && !this._simStepper.isSimulationStoping() && this.isSelected()) {
            this._simStepper.stopSimulation();
        }
        return super.toDoWhenClosing();
    }

    public String getSelectedComponentPath() {
        return this._simulPanel.getView().getSelectedComponentPath();
    }

    @Override
    public boolean withMemorizedLocation() {
        return false;
    }
}

