/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.seq;

import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqNode;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.TableRendererSeqString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;

public class TableRendererSeqNode
extends TableRendererSeqString {
    private Font plainFont = null;
    private Font boldFont = null;
    private Font italicFont = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.plainFont == null) {
            this.plainFont = this.getFont();
            if (this.plainFont != null) {
                this.boldFont = this.plainFont.deriveFont(1);
                this.italicFont = this.plainFont.deriveFont(2);
            }
        }
        if (value == null || !(value instanceof SeqNode)) {
            this.setText("");
            this.setFont(this.plainFont);
        } else {
            SeqNode node = (SeqNode)value;
            this.setText(node.getName());
            switch (node.getNbrFireable()) {
                case 0: {
                    this.setFont(this.italicFont);
                    this.setForeground(Color.red);
                    break;
                }
                case -1: 
                case 1: {
                    this.setFont(this.plainFont);
                    break;
                }
                default: {
                    this.setFont(this.boldFont);
                    this.setForeground(Color.red);
                }
            }
        }
        return this;
    }
}

