/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.LimitedTableCellRenderer;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.core.swing.table.WithErrorTableCellRenderer;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaConfigEditDlg;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaConfigTableCellRenderer;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AltaConfigPanel
extends AltaEditPanel {
    private static final int IDX_NAME = 0;
    private static final int IDX_LBL = 1;
    private static final int IDX_INITS = 2;
    private CeciliaAppl _appl;
    JTable _ctrlTable;
    ConfigTableModel _ctrlTableModel;
    JLabel _ctrlNameLabel;
    JTextField _ctrlName;
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected CeciliaAction _ctrlEdit;
    JPopupMenu _popupMenu = new JPopupMenu();
    AltaConfigEditDlg _dlgEdit;

    public AltaConfigPanel(CeciliaAppl appl) {
        this._appl = appl;
        this.createActions();
        this.createTable();
        this.make();
    }

    @Override
    public AltaSystem getAltaComponent() {
        return (AltaSystem)this._currentComponent;
    }

    private void createTable() {
        this._ctrlTableModel = new ConfigTableModel();
        this._ctrlTable = new ConfigTable(this._ctrlTableModel);
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AltaConfigPanel.this.selectConfig();
            }
        });
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaConfigPanel.this.addConfig();
                AltaConfigPanel.this._ctrlName.setText("");
                AltaConfigPanel.this._ctrlName.requestFocus();
            }
        }.setDesc(ResMsgOcas.getString("CMD_CONFIG_ADD"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] viewIndices;
                if (AltaConfigPanel.this.getAltaComponent() != null && (viewIndices = AltaConfigPanel.this._ctrlTable.getSelectedRows()).length != 0) {
                    int[] modelIndices = new int[viewIndices.length];
                    for (int i = viewIndices.length - 1; i >= 0; --i) {
                        modelIndices[i] = AltaConfigPanel.this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
                    }
                    Arrays.sort(modelIndices);
                    List<AltaConfig> events = AltaConfigPanel.this.getAltaComponent().getConfigs();
                    for (int i = modelIndices.length - 1; i >= 0; --i) {
                        events.remove(modelIndices[i]);
                    }
                    AltaConfigPanel.this._ctrlTable.clearSelection();
                    AltaConfigPanel.this.refresh();
                    AltaConfigPanel.this.getAltaComponent().setModified(true);
                    AltaConfigPanel.this._ctrlName.setText("");
                }
            }
        }.setDesc(ResMsgOcas.getString("CMD_CONFIG_DEL"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaConfigPanel.this.getAltaComponent() == null) {
                    return;
                }
                AltaConfigPanel.this.doEditConfig();
            }
        }.setDesc(ResMsgOcas.getString("CMD_CONFIG_EDIT"));
        this._popupMenu.add(this._ctrlEdit.createMenuItem());
        this._popupMenu.add(this._ctrlDel.createMenuItem());
    }

    private void make() {
        JToolBar panelEventButton = new JToolBar();
        JPanel panelEventValue = new JPanel();
        this.setLayout(new GridBagLayout());
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        this.add((Component)scrollTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (!this._appl.isReader()) {
            this.add((Component)panelEventButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)panelEventValue, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            scrollTable.setComponentPopupMenu(this._popupMenu);
        }
        panelEventButton.add(Box.createGlue());
        panelEventButton.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createGlue());
        panelEventButton.setFloatable(false);
        this._ctrlNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlNameLabel.setForeground(Color.black);
        this._ctrlName = new JTextField("");
        this._ctrlName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AltaConfigPanel.this.addConfig();
                    AltaConfigPanel.this._ctrlName.setText("");
                    AltaConfigPanel.this._ctrlName.requestFocus();
                }
            }
        });
        panelEventValue.setLayout(new GridBagLayout());
        panelEventValue.setBorder(BorderFactory.createEtchedBorder());
        panelEventValue.add((Component)this._ctrlNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelEventValue.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectConfig();
    }

    public void refresh() {
        this._ctrlTableModel.fireTableDataChanged();
    }

    @Override
    public void focusTreatment() {
        this.requestFocus();
        this._ctrlName.requestFocus();
    }

    @Override
    protected String validateName(String name) {
        return AltaConfig.verifyName(name, this);
    }

    protected void doEditConfig() {
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices.length != 1) {
            return;
        }
        if (this._dlgEdit == null) {
            AltaConfigEditDlg dlg = new AltaConfigEditDlg(SwingUtilities.getWindowAncestor(this), this._appl.getPlugable());
            if (this._dlgEdit == null) {
                this._dlgEdit = dlg;
            }
        }
        this._dlgEdit.setEditable(!this._appl.isReader());
        int index = this._ctrlTable.convertRowIndexToModel(viewIndices[0]);
        List<AltaConfig> allConfigs = this.getAltaComponent().getConfigs();
        this._dlgEdit.setConfig(allConfigs.get(index), allConfigs, this.getAltaComponent());
        this._dlgEdit.setVisible(true);
        if (this._dlgEdit.getResult()) {
            AltaConfig select = allConfigs.get(index);
            select.setName(this._dlgEdit.getName());
            select.setLabel(this._dlgEdit.getLabel());
            select.setStates(this._dlgEdit.getStates());
            select.verify(null, this.getAltaComponent());
            this.refresh();
            index = this._ctrlTable.convertRowIndexToView(index);
            this._ctrlTable.setRowSelectionInterval(index, index);
            this.getAltaComponent().setModified(true);
        }
    }

    public void addConfig() {
        if (this.getAltaComponent() == null) {
            return;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this.getAltaComponent().getConfigs().size() >= DemoLimits.Limit.SYSTEM_CONFIGS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgOcas.getString("DEMO_SYSTEM_CONFIGS"), JOptionCecilia.getTopTitleOf(this._ctrlTable), 0);
            return;
        }
        String name = this._ctrlName.getText();
        if (name.isEmpty()) {
            return;
        }
        if ((name = this.validateName(name)) == null || name.isEmpty()) {
            return;
        }
        AltaConfig config = this.getAltaComponent().getConfig(name);
        if (config != null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgOcas.getString("MSG_ERR_CONFIG_ALREADY"), ResMsgOcas.getString("VOC_INITIAL_CONFIGS"), 0);
            return;
        }
        config = new AltaConfig().setName(name);
        this.getAltaComponent().getConfigs().add(config);
        int idx = this.getAltaComponent().getConfigs().size() - 1;
        this.refresh();
        idx = this._ctrlTable.convertRowIndexToView(idx);
        this._ctrlTable.setRowSelectionInterval(idx, idx);
        this.getAltaComponent().setModified(true);
    }

    public void selectConfig() {
        int selectedRow = this._ctrlTable.getSelectedRowCount();
        if (selectedRow >= 1) {
            this._ctrlDel.setEnabled(true);
            this._ctrlEdit.setEnabled(selectedRow == 1);
            if (this.getAltaComponent() != null && selectedRow == 1) {
                int idx = this._ctrlTable.getSelectedRow();
                if (idx != -1) {
                    idx = this._ctrlTable.convertRowIndexToModel(idx);
                    AltaConfig cfg = this.getAltaComponent().getConfigs().get(idx);
                    this._ctrlName.setText(cfg.getName());
                } else {
                    this._ctrlName.setText("");
                }
            } else {
                this._ctrlName.setText("");
            }
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlEdit.setEnabled(false);
        }
    }

    public void updateLangage() {
        this._ctrlNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this.refresh();
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("CMD_CONFIG_DEL"));
        this._ctrlEdit.setName(ResMsgVoc.getString("VOC_EDIT"));
        this._ctrlEdit.setDesc(ResMsgOcas.getString("CMD_CONFIG_EDIT"));
        this._ctrlAdd.setDesc(ResMsgOcas.getString("CMD_CONFIG_ADD"));
    }

    private class ConfigTable
    extends CeciliaTable
    implements JTableTransfertHandler.HelperConvert {
        public ConfigTable(TableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.doLayout();
            this.setSelectionMode(2);
            this.setTransferHandler(new JTableTransfertHandler());
            this.setDefaultRenderer(AltaConfig.class, new AltaConfigTableCellRenderer());
            this.getColumnModel().getColumn(1).setCellRenderer(new LimitedTableCellRenderer());
            this.getColumnModel().getColumn(0).setCellRenderer(new WithErrorTableCellRenderer(){

                @Override
                public boolean withError(JTable table, Object value, int row, int column) {
                    AltaConfig cfg = (AltaConfig)AltaConfigPanel.this._ctrlTableModel.getValueAt(row, 2);
                    return cfg.withError();
                }
            });
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (AltaConfigPanel.this.getAltaComponent() == null) {
                        return;
                    }
                }
            });
            this.getActionMap().put("DELETE", AltaConfigPanel.this._ctrlDel);
            this.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        }

        @Override
        protected boolean withSorter() {
            return true;
        }

        @Override
        protected List<Integer> getUnsortableCols() {
            return Arrays.asList(2);
        }

        @Override
        public void createDefaultColumnsFromModel() {
            super.createDefaultColumnsFromModel();
            TableColumnModel colModel = this.getColumnModel();
            block5: for (int c = 0; c < this.getColumnCount(); ++c) {
                switch (c) {
                    case 0: {
                        colModel.getColumn(c).setPreferredWidth(75);
                        continue block5;
                    }
                    case 1: {
                        colModel.getColumn(c).setPreferredWidth(150);
                        continue block5;
                    }
                    case 2: {
                        colModel.getColumn(c).setPreferredWidth(200);
                    }
                }
            }
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            if (AltaConfigPanel.this.getAltaComponent() == null) {
                return;
            }
            int columnView = AltaConfigPanel.this._ctrlTable.columnAtPoint(e.getPoint());
            int columnDoc = AltaConfigPanel.this._ctrlTable.convertColumnIndexToModel(columnView);
            if (columnDoc == 0) {
                return;
            }
            AltaConfigPanel.this.doEditConfig();
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            switch (col) {
                case 0: 
                case 1: {
                    return obj.toString();
                }
                case 2: {
                    AltaConfig config = (AltaConfig)obj;
                    StringBuilder sb = new StringBuilder();
                    Map<String, String> inits = config.getStates();
                    if (inits.isEmpty()) {
                        return "";
                    }
                    for (Map.Entry<String, String> init : inits.entrySet()) {
                        sb.append(init.getKey()).append(" := ").append(init.getValue());
                        sb.append('\n');
                    }
                    return sb.toString();
                }
            }
            return null;
        }
    }

    public class ConfigTableModel
    extends AbstractTableModel {
        ConfigTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (AltaConfigPanel.this.getAltaComponent() == null) {
                return 0;
            }
            return AltaConfigPanel.this.getAltaComponent().getConfigs().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaConfigPanel.this.getAltaComponent() == null) {
                return "null";
            }
            switch (col) {
                case 0: {
                    return AltaConfigPanel.this.getAltaComponent().getConfigs().get(row).getName();
                }
                case 1: {
                    return AltaConfigPanel.this.getAltaComponent().getConfigs().get(row).getLabel();
                }
                case 2: {
                    return AltaConfigPanel.this.getAltaComponent().getConfigs().get(row);
                }
            }
            return " ";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_COMMENT");
                }
                case 2: {
                    return ResMsgOcas.getString("OCAS_INIT_STATES");
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return AltaConfig.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (AltaConfigPanel.this._appl.isReader()) {
                return false;
            }
            return col == 0 && AltaConfigPanel.this._ctrlTable.getSelectedRows().length == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            switch (column) {
                case 0: {
                    AltaConfig config;
                    String oldName;
                    String name = AltaConfigPanel.this.validateName((String)aValue);
                    if (name == null || name.length() <= 0 || (oldName = (config = AltaConfigPanel.this.getAltaComponent().getConfigs().get(row)).getName()).equals(name)) break;
                    if (AltaConfigPanel.this.getAltaComponent().getConfig(name) == null) {
                        config.setName(name);
                        AltaConfigPanel.this.refresh();
                        row = AltaConfigPanel.this._ctrlTable.convertRowIndexToView(row);
                        AltaConfigPanel.this._ctrlTable.setRowSelectionInterval(row, row);
                        AltaConfigPanel.this.getAltaComponent().setModified(true);
                        break;
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(AltaConfigPanel.this._ctrlTable), ResMsgOcas.getString("MSG_ERR_CONFIG_ALREADY"), ResMsgOcas.getString("VOC_INITIAL_CONFIGS"), 0);
                    break;
                }
            }
        }
    }
}

