/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaDefaultHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBAltaConfigHandlerXml
extends DBAltaDefaultHandlerXml
implements DBObjectXmlConstant {
    private static Logger _LOG = Logger.getLogger(DBAltaConfigHandlerXml.class.getPackage().getName());
    public static final String ELT_ALTA_INIT = "alta.init";
    public static final String ELT_ALTA_CONFIG = "alta.config";
    AltaConfig _altaConfig = null;
    String _label = "";
    String _name = null;
    Map<String, String> _inits = null;

    protected DBAltaConfigHandlerXml(DBLogs.DBLogsManager manager, Locator locator) {
        super(manager, locator);
    }

    public AltaConfig getConfig() {
        return this._altaConfig;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!ELT_ALTA_CONFIG.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_ALTA_CONFIG), this.getLocator()));
            }
            this._name = this.readName(key, "name", attrs);
            this._inits = new LinkedHashMap<String, String>();
        } else if (ELT_ALTA_INIT.equals(key)) {
            String oldValue;
            String path = this.readAltaPath(key, attrs);
            String value = attrs.get("value");
            if (value == null || value.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "value"), this.getLocator()));
            }
            if ((oldValue = this._inits.put(path, value)) != null && !oldValue.equals(value)) {
                _LOG.warning("La configuration initiale '" + this._name + "' avait deja la valeur '" + oldValue + "' pour la variable '" + path + "'");
            }
        } else if (!"label".equals(key)) {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
        if ("label".equals(key)) {
            this._label = txt;
            return false;
        }
        boolean result = ELT_ALTA_CONFIG.equals(key);
        if (result) {
            this._altaConfig = this.createConfig();
        }
        return result;
    }

    protected AltaConfig createConfig() {
        return new AltaConfig().setName(this._name).setLabel(this._label).setStates(this._inits);
    }
}

