/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.io.DBLinkHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.io.DBLinkReaderRaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareDBRecordFieldResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.function.BiPredicate;
import org.xml.sax.SAXException;

public class DBRecord
extends DBType {
    protected LinkType _typeLink = LinkType.UNDEFINE;
    ArrayList<DBRecordField> _fields = new ArrayList();
    long _nextFieldID = -1L;

    public LinkType getTypeLink() {
        return this._typeLink;
    }

    public void setTypeLink(LinkType typeLink) {
        this._typeLink = typeLink;
    }

    public DBRecord(DBFolder dbFolder) {
        super(dbFolder);
    }

    @Override
    protected String getNature() {
        return "type.structured";
    }

    @Override
    public short getFamilyFlag() {
        return 2;
    }

    @Override
    protected void toXML(Appendable outData, String indent) throws IOException {
        outData.append("<").append("cec.type.link");
        outData.append(" ").append("type").append("='").append(this._typeLink.name().toLowerCase()).append("'");
        outData.append(">\n");
        for (DBRecordField field : this._fields) {
            outData.append("  <").append("link.field");
            DBObjectXmlUtility.appendXML(outData.append(" ").append("name").append("='"), field.getName()).append("'");
            DBAltaTypeHandlerXml.writeType(field.getType(), outData);
            DBObjectXmlUtility.appendXML(outData.append(" ").append("direction").append("='"), field.getDirection().toString().toLowerCase()).append("'");
            if (!field.getCrossField().isEmpty()) {
                DBObjectXmlUtility.appendXML(outData.append(" ").append("cross").append("='"), field.getCrossField()).append("'");
            }
            if (field.isLinkToDisplay()) {
                DBObjectXmlUtility.appendXML(outData.append(" ").append("LinkDisplay").append("='"), String.valueOf(field.isLinkToDisplay())).append("'");
            }
            if (field.getID() < 0L) {
                field.setID(this.getNextFieldID());
            }
            DBObjectXmlUtility.appendXML(outData.append(" ").append("id").append("='"), Long.toString(field.getID())).append("'");
            outData.append("/>\n");
        }
        outData.append("</").append("cec.type.link").append(">\n");
    }

    public long getNextFieldID() {
        if (this._nextFieldID == -1L) {
            for (int i = this._fields.size() - 1; i >= 0; --i) {
                DBRecordField field = this._fields.get(i);
                this._nextFieldID = Math.max(this._nextFieldID, field.getID());
            }
        }
        return ++this._nextFieldID;
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        for (DBRecordField field : this._fields) {
            DBFolder dbSubtypeFolder;
            AltaType type = field.getType();
            if (!(type instanceof DBEnum) || (dbSubtypeFolder = ((DBEnum)type).getDBFolder()) == null) continue;
            relations.add(new DBRelation(this._dbFolder, "OA_TYPE", dbSubtypeFolder, "OA_TYPE"));
        }
        return relations;
    }

    @Override
    protected SAXExtendedHandler createXMLHandler(CECFactory daoFactory, final DBLogs.DBLogsManager logMng) {
        return new DBLinkHandlerXml(logMng, null, daoFactory){

            public void endDocument() throws SAXException {
                super.endDocument();
                DBRecord.this._typeLink = this.getType();
                DBRecord.this._fields.clear();
                DBRecord.this._fields.addAll(this.getFields());
                boolean findID = false;
                for (DBRecordField field : DBRecord.this._fields) {
                    if (field.getID() < 0L) continue;
                    findID = true;
                    break;
                }
                if (!findID) {
                    long id = 0L;
                    for (DBRecordField field : DBRecord.this._fields) {
                        if (field.getID() >= 0L) continue;
                        field.setID(id++);
                    }
                }
                DBRecord.this.updateCrossFields(logMng);
            }
        };
    }

    @Override
    public void readFromFile(String input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) throws IOException {
        DBLinkReaderRaw readerRaw = new DBLinkReaderRaw(this._dbFolder, logMng);
        if (readerRaw.readRaw(input, cecFactory)) {
            this._typeLink = readerRaw.getType();
            this._fields.clear();
            this._fields.addAll(readerRaw.getFields());
            AltaFileHeader properties = readerRaw.getProperties();
            if (properties != null) {
                properties.convertToDBFolder(this._dbFolder, cecFactory, logMng);
            }
            this.updateCrossFields(logMng);
        }
    }

    protected boolean updateCrossFields(DBLogs.DBLogsManager logMng) {
        boolean result = true;
        HashSet<String> treatCrossFields = new HashSet<String>();
        for (DBRecordField field : this._fields) {
            String crossName = field.getCrossField();
            if (crossName.isEmpty()) continue;
            DBRecordField cross = null;
            for (DBRecordField current : this._fields) {
                if (!current.getName().equals(crossName)) continue;
                cross = current;
                break;
            }
            if (cross == null) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("TYPE_EDIT_FIELD_UNKNOW", crossName));
                field.setCrossField("");
                result = false;
                continue;
            }
            if (cross == field) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("TYPE_EDIT_FIELDS_CROSS_ERROR", crossName, crossName));
                field.setCrossField("");
                result = false;
                continue;
            }
            if (!cross.getType().equivalents(field.getType())) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("TYPE_EDIT_FIELDS_CROSS_ERROR", crossName, field.getName()));
                field.setCrossField("");
                result = false;
                continue;
            }
            if (treatCrossFields.contains(crossName)) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("TYPE_EDIT_FIELD_ALREADY_CROSS", crossName));
                field.setCrossField("");
                result = false;
                continue;
            }
            treatCrossFields.add(crossName);
        }
        return result;
    }

    public boolean update(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = true;
        for (DBRecordField field : this._fields) {
            AltaType type = field.getType();
            if (!(type instanceof DBEnum)) continue;
            DBEnum dbEnum = (DBEnum)type;
            DBWrap dbWrap = DBWrap.createOrFind(cecFactory, dbEnum.getDBFolder(), logMng, DBEnum.class);
            if (dbWrap == null) {
                field.setType(AltaTypeBool.getInstance());
                result = false;
                continue;
            }
            field.setType((AltaType)((Object)dbWrap));
        }
        if (!this.updateCrossFields(logMng)) {
            result = false;
        }
        this.prepareDependTimeUpdt(cecFactory, this.getUseRelations());
        return result;
    }

    @Override
    public void writeAltaRicaFlow(Appendable out, String name, AltaFlow.Orientation orientation, boolean expandLink) throws IOException {
        super.writeAltaRicaFlow(out, name, orientation, expandLink);
        if (!expandLink) {
            return;
        }
        for (DBRecordField field : this._fields) {
            String newName = name + "^" + field.getName();
            AltaFlow.Orientation newOrientation = orientation;
            if (field.getDirection().equals((Object)DBRecordField.Direction.INVERSE)) {
                switch (newOrientation) {
                    case IN: {
                        newOrientation = AltaFlow.Orientation.OUT;
                        break;
                    }
                    case OUT: {
                        newOrientation = AltaFlow.Orientation.IN;
                        break;
                    }
                    case LOCAL: {
                        _LOG.info("Il y a un flux local avec un type structure avec inversion !!!");
                    }
                }
            }
            field.getType().writeAltaRicaFlow(out, newName, newOrientation, false);
        }
    }

    @Override
    public void writeAltaRicaDefine(Appendable out) throws IOException {
        String inName;
        super.writeAltaRicaDefine(out);
        boolean hasInverseField = false;
        out.append(" link\n");
        out.append(" flow\n");
        for (DBRecordField field : this._fields) {
            if (field.getDirection().equals((Object)DBRecordField.Direction.INVERSE)) {
                hasInverseField = true;
            }
            out.append("  ");
            field.getType().writeAltaRicaFlow(out, field.getName(), null, false);
        }
        if (hasInverseField) {
            out.append(" inverse\n");
            for (DBRecordField field : this._fields) {
                if (!field.getDirection().equals((Object)DBRecordField.Direction.INVERSE)) continue;
                out.append("  out^").append(field.getName()).append(";\n");
                inName = field.getName();
                if (!field.getCrossField().isEmpty()) {
                    inName = field.getCrossField();
                }
                out.append("  in^").append(inName).append(";\n");
            }
        }
        out.append(" assert\n");
        for (DBRecordField field : this._fields) {
            inName = field.getName();
            if (!field.getCrossField().isEmpty()) {
                inName = field.getCrossField();
            }
            if (field.getDirection().equals((Object)DBRecordField.Direction.NORMAL)) {
                out.append("  in^").append(inName).append(" := out^").append(field.getName()).append(" ;\n");
                continue;
            }
            out.append("  out^").append(field.getName()).append(" := in^").append(inName).append(" ;\n");
        }
        out.append("knil ;\n");
    }

    public boolean computeTypeLink() {
        LinkType typeLink = LinkType.UNDEFINE;
        for (DBRecordField field : this._fields) {
            if (field.getCrossField().equals("")) {
                if (typeLink == LinkType.BIDIRECT) {
                    this._typeLink = LinkType.UNDEFINE;
                    return false;
                }
                typeLink = LinkType.UNIDIRECT;
                continue;
            }
            DBRecordField crossField = this.fieldExist(field.getCrossField());
            if (crossField.getDirection().equals((Object)field.getDirection())) {
                if (typeLink == LinkType.BIDIRECT) {
                    this._typeLink = LinkType.UNDEFINE;
                    return false;
                }
                typeLink = LinkType.UNIDIRECT;
                continue;
            }
            if (typeLink == LinkType.UNIDIRECT) {
                this._typeLink = LinkType.UNDEFINE;
                return false;
            }
            typeLink = LinkType.BIDIRECT;
        }
        this._typeLink = typeLink;
        return true;
    }

    public boolean hasMissingCross() {
        for (DBRecordField field : this._fields) {
            if (field.getCrossField().isEmpty() || this.isFieldCrossed(field.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasInverseField() {
        for (DBRecordField field : this._fields) {
            if (!field.getDirection().equals((Object)DBRecordField.Direction.INVERSE)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInverseCrossedField() {
        for (DBRecordField field : this._fields) {
            if (field.getCrossField().equals("")) continue;
            DBRecordField crossField = this.getValue(field.getCrossField());
            if (field.getDirection().equals((Object)crossField.getDirection())) continue;
            return true;
        }
        return false;
    }

    public Vector getAltaricaOcasInverseField() {
        Vector<String> data = new Vector<String>();
        for (DBRecordField field : this._fields) {
            if (!field.getDirection().equals((Object)DBRecordField.Direction.INVERSE)) continue;
            if (!data.contains("out^" + field.getName())) {
                data.addElement("out^" + field.getName());
            }
            if (field.getCrossField().equals("")) {
                if (data.contains("in^" + field.getName())) continue;
                data.addElement("in^" + field.getName());
                continue;
            }
            if (data.contains("in^" + field.getCrossField())) continue;
            data.addElement("in^" + field.getCrossField());
        }
        return data;
    }

    public boolean isFieldCrossed(String name) {
        for (DBRecordField field : this._fields) {
            if (!field.getCrossField().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void removeCross(String searchName) {
        for (DBRecordField field : this._fields) {
            if (!field.getCrossField().equals(searchName)) continue;
            field.setCrossField("");
            break;
        }
    }

    public void renameCross(String oldName, String newName) {
        for (DBRecordField field : this._fields) {
            if (!field.getCrossField().equals(oldName)) continue;
            field.setCrossField(newName);
            break;
        }
    }

    public Vector getFieldsOfType(AltaType searchType) {
        Vector<String> tab = new Vector<String>();
        for (DBRecordField field : this._fields) {
            if (!field.getType().equivalents(searchType)) continue;
            tab.addElement(field.getName());
        }
        return tab;
    }

    @Deprecated
    public DBRecordField getValue(String fieldName) {
        for (DBRecordField field : this._fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public DBRecordField fieldExist(String value) {
        for (DBRecordField field : this._fields) {
            if (!field.getName().equals(value)) continue;
            return field;
        }
        return null;
    }

    public DBRecordField getFieldWithID(long id) {
        if (id < 0L) {
            return null;
        }
        for (DBRecordField field : this._fields) {
            if (field.getID() != id) continue;
            return field;
        }
        return null;
    }

    public DBRecordField getFieldAt(int idx) {
        return this._fields.get(idx);
    }

    public List<DBRecordField> getFields() {
        return this._fields;
    }

    public void update(DBRecord type) {
        this.copy(type);
    }

    public void removeType(AltaType type) {
        for (DBRecordField field : this._fields) {
            if (field.getType() != type) continue;
            field.setType(AltaTypeBool.getInstance());
        }
    }

    @Override
    public DBRecord getCopy() {
        DBRecord res = new DBRecord(this._dbFolder);
        res.copy(this);
        return res;
    }

    @Override
    protected void copy(DBLogsWrap src) {
        super.copy(src);
        if (src instanceof DBRecord) {
            DBRecord typeSrc = (DBRecord)src;
            this.setTypeLink(typeSrc.getTypeLink());
            this._fields.clear();
            for (DBRecordField field : typeSrc._fields) {
                this._fields.add(field.getCopy());
            }
        }
    }

    @Override
    public String getValue() {
        return this.getRefPath();
    }

    @Override
    public String getDefaultValue() {
        if (this._fields.size() > 0) {
            return this._fields.get(0).getName();
        }
        return null;
    }

    @Override
    public int getValueCount() {
        return this._fields.size();
    }

    @Override
    public String getValueAt(int index) {
        return this._fields.get(index).getName();
    }

    @Override
    public int getValueIndex(Object value) {
        for (int i = this._fields.size() - 1; i >= 0; --i) {
            if (!this._fields.get(i).getName().equals(value)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean valueExist(String value) {
        for (DBRecordField field : this._fields) {
            if (!field.getName().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void setFieldAt(DBRecordField value, int idx) {
        this._fields.set(idx, value);
    }

    public void addField(DBRecordField value, int idx) {
        this._fields.add(idx, value);
    }

    public DBRecordField removeField(int idx) {
        return this._fields.remove(idx);
    }

    @Override
    public boolean equivalents(AltaType type) {
        if (type == null) {
            return false;
        }
        if (type == this) {
            return true;
        }
        if (!(type instanceof DBRecord)) {
            return false;
        }
        return this.getDBFolder().equals(((DBRecord)type).getDBFolder());
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons comparaisons = super.getCompareConflict(factoryWrap, wrap, forImport);
        DBRecord ref = this;
        DBRecord toBeCompared = (DBRecord)wrap;
        HashSet set = new HashSet();
        BiPredicate<DBRecord, Integer> pred = (dbenum, idx) -> {
            if (idx >= dbenum.getValueCount()) {
                return false;
            }
            DBRecordField val = dbenum.getFieldAt((int)idx);
            if (!set.contains(val.getName())) {
                comparaisons.addConflict(new CompareDBRecordFieldResult(ref, toBeCompared, val.getName()));
            }
            return set.add(val.getName());
        };
        for (int i = 0; i < ref.getValueCount() || i < toBeCompared.getValueCount(); ++i) {
            pred.test(ref, i);
            pred.test(toBeCompared, i);
        }
        return comparaisons;
    }

    @Override
    public String getAbstract() {
        throw new IllegalAccessError();
    }

    public static enum LinkType {
        UNDEFINE(0),
        UNIDIRECT(1),
        BIDIRECT(2);

        int _id;

        public int getID() {
            return this._id;
        }

        private LinkType(int id) {
            this._id = id;
        }

        public static LinkType get(int ID) {
            LinkType[] links = LinkType.values();
            for (int i = links.length - 1; i >= 0; --i) {
                if (links[i].getID() != ID) continue;
                return links[i];
            }
            return null;
        }
    }
}

