/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.gui;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaColorPanel;
import com.dassault.cecilia.dbobj.mbsa.system.gui.ColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AltaColorComboBox
extends JComboBox {
    public static ColorChooserDlg __dlg;
    private final Window _window;
    private final List<Color> _colorList = new ArrayList<Color>(Arrays.asList(Color.RED, Color.BLUE, Color.GREEN, Color.BLACK));
    private AltaColorPanel.DlgColor _colorDlg = null;

    public AltaColorComboBox(Window owner) {
        for (Color color : this._colorList) {
            this.addItem(color);
        }
        this.addItem(ResMsgOcas.getString("TITLE_COLOR_OTHERS"));
        this._window = owner;
        this.setRenderer(new AltaColorRenderer());
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            return;
        }
        if (anObject.equals(ResMsgOcas.getString("TITLE_COLOR_OTHERS"))) {
            if (__dlg == null) {
                __dlg = new ColorChooserDlg(this._window);
                __dlg.pack();
            }
            __dlg.setVisible(true);
            Color color = __dlg.getColor();
            if (color == null || !__dlg.getResult()) {
                this.fireActionEvent();
                return;
            }
            anObject = color;
            this.addColorUsed(color);
        }
        super.setSelectedItem(anObject);
    }

    public void addColorUsed(Color color) {
        this.removeItem(ResMsgOcas.getString("TITLE_COLOR_OTHERS"));
        this.addItem(color);
        this.addItem(ResMsgOcas.getString("TITLE_COLOR_OTHERS"));
    }

    private AltaColorPanel.DlgColor createAdvancedColorDlg() {
        if (this._colorDlg == null) {
            final JColorChooser chooser = new JColorChooser();
            final AltaColorPanel.PreviewColorPanel previewChooser = new AltaColorPanel.PreviewColorPanel(false);
            AbstractColorChooserPanel[] tabColorPanel = chooser.getChooserPanels();
            chooser.removeChooserPanel(tabColorPanel[2]);
            chooser.removeChooserPanel(tabColorPanel[1]);
            chooser.setPreviewPanel(previewChooser);
            chooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    previewChooser.setColor(chooser.getColor());
                }
            });
            this._colorDlg = new AltaColorPanel.DlgColor(this._window, chooser);
            this._colorDlg.setLocationRelativeTo(this._window);
        }
        return this._colorDlg;
    }

    public class ColorChooserDlg
    extends JDialogCecilia {
        ColorChooser _colorChooser;

        public ColorChooserDlg(Window owner) {
            super(owner, ResMsgOcas.getString("TITLE_COLOR_TYPE"), true);
            this.setLocationRelativeTo(owner);
            this.build();
        }

        private void build() {
            this.setLayout(new GridBagLayout());
            this._colorChooser = new ColorChooser();
            this.add((Component)this._colorChooser, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.createButPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 100.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        @Override
        protected JComponent createButPanel() {
            JPanel panel = (JPanel)super.createButPanel();
            JButton button = new JButton(ResMsgOcas.getString("TITLE_COLOR_ADVANCED"));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AltaColorPanel.DlgColor dlgColor = AltaColorComboBox.this.createAdvancedColorDlg();
                    Color currentColor = ColorChooserDlg.this.getColor();
                    dlgColor.setVisible(true);
                    if (!dlgColor.getResult()) {
                        return;
                    }
                    Color color = dlgColor.getChooser().getColor();
                    if (color != null && color != currentColor) {
                        ColorChooserDlg.this.setColor(color);
                    }
                }
            });
            panel.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, -10, 0, 0), 0, 0));
            return panel;
        }

        @Override
        protected boolean verifyParameters() {
            return this.getColor() != null;
        }

        public void setColor(Color c) {
            this._colorChooser.setColor(c);
        }

        public Color getColor() {
            return this._colorChooser.getColor();
        }
    }

    public class AltaColorRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            if (value instanceof Color) {
                Color color = (Color)value;
                label.setBackground(color);
                label.setText(" ");
            } else {
                label.setText(String.valueOf(value));
            }
            return label;
        }
    }
}

