/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.mbsa.type.gui.DBTypeCmdEdit;
import com.dassault.cecilia.dbobj.mbsa.type.gui.DBTypeCmdInsert;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.event.ActionEvent;
import javax.swing.JPopupMenu;

public class TypeFolderTree
extends DBFolderTreeActivable {
    protected CeciliaAction _ctrlAddEnum;
    protected CeciliaAction _ctrlAddLink;
    protected JPopupMenu _popupTypes;

    public TypeFolderTree(CeciliaAppl application, DBFolderTreeModel model) {
        super(application, model, false);
    }

    @Override
    protected CeciliaAppl getAppl() {
        return super.getAppl();
    }

    @Override
    protected void createActions() {
        super.createActions();
        this._ctrlAddEnum = new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_ENUM_"), ResMsgObj.getString("ACTION_ADD_ENUM_MENU"), ResMsgObj.getString("ACTION_ADD_ENUM_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder subfamily = TypeFolderTree.this.getCurrentSubFamily();
                if (subfamily != null) {
                    TypeFolderTree.this.doInsert(subfamily, (short)1);
                }
            }
        };
        this._ctrlAddEnum.setEnabled(true);
        this._ctrlAddLink = new CeciliaAction(ResIcoCore.getImageIcon("FOLDER_LINK_"), ResMsgObj.getString("ACTION_ADD_LINK_MENU"), ResMsgObj.getString("ACTION_ADD_LINK_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolder subfamily = TypeFolderTree.this.getCurrentSubFamily();
                if (subfamily != null) {
                    TypeFolderTree.this.doInsert(subfamily, (short)2);
                }
            }
        };
        this._ctrlAddLink.setEnabled(true);
    }

    private DBFolder getCurrentSubFamily() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        DBFolderTreeNode selectNode = (DBFolderTreeNode)this.getSelectionPath().getLastPathComponent();
        if (selectNode == null || selectNode.isReadOnly()) {
            return null;
        }
        DBFolder folder = selectNode.getSource();
        if (folder.getDepthUntilSystem() == folder.getFamily().getDepthFolder()) {
            return folder;
        }
        return null;
    }

    @Override
    protected void createPopupMenu() {
        boolean isEditable;
        super.createPopupMenu();
        this._popupTypes = new JPopupMenu();
        boolean bl = isEditable = !this.getAppl().isReader();
        if (isEditable) {
            this._popupTypes.add(this._ctrlAddFolder);
            this._popupTypes.addSeparator();
            this._popupTypes.add(this._ctrlAddEnum);
            this._popupTypes.add(this._ctrlAddLink);
            this._popupTypes.addSeparator();
        }
        this._popupTypes.add(this._ctrlProp);
        if (isEditable) {
            this._popupTypes.add(this._ctrlRename);
        }
        this._popupTypes.add(this._ctrlCompareObjects);
        if (isEditable) {
            this._popupTypes.add(this._ctrlDel);
            this._popupTypes.addSeparator();
            this._popupTypes.add(this._ctrlCopy);
            this._popupTypes.add(this._ctrlCut);
            this._popupTypes.add(this._ctrlPaste);
        }
        this._popupTypes.addSeparator();
        this._popupTypes.add(this._ctrlExpand);
        this._popupTypes.add(this._ctrlCollapse);
        this._popupTypes.add(this._ctrlRefresh);
        if (isEditable) {
            this._popupTypes.addSeparator();
            this._popupTypes.add(this._ctrlExport);
            this._popupTypes.add(this._ctrlAnonymize);
        }
        if (this.getAppl().isDebugMode()) {
            this._popupTypes.addSeparator();
            this._popupTypes.add(this._ctrlDebug);
            this._popupTypes.add(this._ctrlDependDown);
            this._popupTypes.add(this._ctrlDependUp);
        }
        if (isEditable) {
            this._popupTypes.addSeparator();
            this._popupTypes.add(this._ctrlFreeze);
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        if (this.getCurrentSubFamily() != null) {
            return this._popupTypes;
        }
        return super.getComponentPopupMenu();
    }

    @Override
    protected void doInsert(DBFolderTreeNode selectNode) {
        DBFolder folder = selectNode.getSource();
        if (folder.isVersion()) {
            this.doInsertFile(folder);
        } else if (folder.getDepthUntilSystem() == folder.getFamily().getDepthFolder()) {
            this.doInsert(folder, (short)1);
        } else {
            this.doInsert(folder);
        }
    }

    protected void doInsert(DBFolder dbParent, short subfamily) {
        if (!dbParent.isFolder()) {
            return;
        }
        DBFolder.Family familyFolder = dbParent.getFamily();
        if (familyFolder != DBFolder.Family.TYPE) {
            return;
        }
        DBTypeCmdInsert cmd = new DBTypeCmdInsert((CAppl)this.getAppl(), (DBFolderTreeEditable)this, subfamily);
        cmd.setDBFolder(dbParent).setDBUser(this._model.getDBUser());
        cmd.realiseDo();
    }

    @Override
    protected void doEdit(DBFolder folder, boolean readOnly) {
        if (folder.getFamily() != DBFolder.Family.TYPE) {
            return;
        }
        if (!folder.isVersion()) {
            return;
        }
        DBTypeCmdEdit cmd = new DBTypeCmdEdit(this.getAppl(), this, folder, readOnly);
        cmd.realiseDo();
    }
}

