/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict;

import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareDiffText;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;

public class CompareLinkColorResult
implements CompareResult {
    private List<CompareDiffText.Diff> _diffs;
    private AltaSystem _system1;
    private AltaSystem _system2;
    private AltaType _type;

    public CompareLinkColorResult(AltaSystem system1, AltaSystem system2, AltaType type) {
        this._system1 = system1;
        this._system2 = system2;
        this._type = type;
        this._diffs = this.initListDiff();
    }

    @Override
    public String getName() {
        return this._type.getValue();
    }

    @Override
    public String getCategory() {
        return ResMsgOcas.getString("MENU_LINK_COLORS");
    }

    @Override
    public boolean withDiff() {
        AltaColor.ColorMap colorMap2;
        AltaColor.ColorMap colorMap1 = this._system1.getColors().getColorMap(this._type);
        if (colorMap1 == null ^ (colorMap2 = this._system2.getColors().getColorMap(this._type)) == null) {
            return true;
        }
        if (colorMap1 == null && colorMap2 == null) {
            return false;
        }
        return colorMap1.equals(colorMap2);
    }

    @Override
    public String getData(int idx) {
        AltaColor.ColorMap colorMap;
        AltaSystem system = idx == 0 ? this._system1 : this._system2;
        AltaColor color = system.getColors();
        AltaColor.ColorMap colorMap2 = colorMap = color != null ? color.getColorMap(this._type) : null;
        if (colorMap == null) {
            return "";
        }
        List types = colorMap.getItems().stream().map(item -> item.getValue()).sorted().collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (String str : types) {
            sb.append(str).append('\n');
        }
        return sb.toString();
    }

    @Override
    public String getResultInfo() {
        return null;
    }

    @Override
    public List<CompareDiffText.Diff> getListDiff() {
        return this._diffs;
    }

    @Override
    public String getResultDetailledForText(int idx) {
        String result = CompareResult.super.getResultDetailledForText(idx);
        AltaSystem system = idx == 0 ? this._system1 : this._system2;
        AltaColor c = system.getColors();
        if (c == null || c.getColorMap(this._type) == null) {
            return result;
        }
        AltaColor.ColorMap map = c.getColorMap(this._type);
        List<AltaColor.ColorMap.Item> items = map.getItems();
        List strs = items.stream().map(e -> e.getValue()).collect(Collectors.toList());
        for (String str : strs) {
            Color color = map.getColor(str);
            StringBuilder sb = new StringBuilder();
            sb.append("<font color=\"rgb(");
            sb.append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue());
            sb.append(")\">");
            sb.append(str);
            sb.append("</font>");
            result = result.replace(str + "<br>", sb.toString() + "<br>");
        }
        return result;
    }

    @Override
    public boolean isObjectPresent(int idx) {
        if (idx != 0 && idx != 1) {
            throw new IllegalArgumentException();
        }
        return this.getData(idx) != null && !this.getData(idx).isEmpty();
    }
}

