/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareDiffText;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import java.awt.Color;
import java.util.List;

public class CompareResultType
implements CompareResult {
    private static final char SEPARATOR = '#';
    private List<CompareDiffText.Diff> _diffs;
    private DBEnum _wrap1;
    private DBEnum _wrap2;
    private String _name;

    public CompareResultType(DBEnum wrap1, DBEnum wrap2, String nameType) {
        this._wrap1 = wrap1;
        this._wrap2 = wrap2;
        this._name = nameType;
        this._diffs = this.initListDiff();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getCategory() {
        return ResMsgVoc.getString("VOC_TYPE");
    }

    @Override
    public boolean withDiff() {
        String data2;
        String data1 = this.getData(0);
        if (data1 == null ^ (data2 = this.getData(1)) == null) {
            return false;
        }
        if (data1 == null && data2 == null) {
            return true;
        }
        return !data1.equals(data2);
    }

    @Override
    public String getData(int idx) {
        DBEnum dbEnum;
        DBEnum dBEnum = dbEnum = idx == 0 ? this._wrap1 : this._wrap2;
        if (!dbEnum.valueExist(this._name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._name);
        sb.append('#');
        sb.append(dbEnum.getColorEnumerate(this._name));
        return sb.toString();
    }

    @Override
    public String getResultInfo() {
        return null;
    }

    @Override
    public List<CompareDiffText.Diff> initListDiff() {
        String data1 = this.getData(0);
        String data2 = this.getData(1);
        if (data1.contains(String.valueOf('#'))) {
            data1 = data1.substring(0, data1.indexOf(35));
        }
        if (data2.contains(String.valueOf('#'))) {
            data2 = data2.substring(0, data2.indexOf(35));
        }
        return CompareDiffText.startDiff(data1, data2);
    }

    @Override
    public List<CompareDiffText.Diff> getListDiff() {
        return this._diffs;
    }

    @Override
    public String getResultDetailledForText(int idx) {
        String result = CompareResult.super.getResultDetailledForText(idx);
        DBEnum dbEnum = idx == 0 ? this._wrap1 : this._wrap2;
        Color c = dbEnum.getColorEnumerate(this._name);
        if (!dbEnum.valueExist(this._name) || c == null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<font color=\"rgb(");
        sb.append(c.getRed()).append(',').append(c.getGreen()).append(',').append(c.getBlue());
        sb.append(")\">");
        sb.append(result.replace("<html>", "").replace("</html>", ""));
        sb.append("</p>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public boolean isObjectPresent(int idx) {
        return (idx == 0 ? this._wrap1 : this._wrap2).getColorEnumerate(this._name) != null;
    }
}

