/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.compareConflict;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareFTEventResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public abstract class CompareUtils {
    private CompareUtils() {
    }

    public static final CompareResultString getRefPathCompare(String name, DBFolder folder1, DBFolder folder2) {
        return new CompareResultString(name, folder1 == null ? "" : folder1.getRefPath(), folder2 == null ? "" : folder2.getRefPath());
    }

    public static String convertToHtmlText(String txt) {
        String result = txt.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\n", "<br>");
        return result;
    }

    public static final String getTextForCompare(String ress, String name) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(ress).append(" : ").append(name).append('\n');
        return tmp.toString();
    }

    public static final void addConflictInDBWrap(DBComparaisons comparaison, DBWrap wrap1, DBWrap wrap2, Function<Object, String> getNameFromObj, Function<DBWrap, List> func, Class compareResultClass) {
        CompareUtils.addConflictInDBWrap(comparaison, wrap1, wrap2, null, getNameFromObj, func, compareResultClass);
    }

    public static final void addConflictInDBWrap(DBComparaisons comparaison, DBWrap wrap1, DBWrap wrap2, String category, Function<Object, String> getNameFromObj, Function<DBWrap, List> func, Class compareResultClass) {
        HashSet<String> allVarsIntersect = new HashSet<String>();
        ArrayList objs = new ArrayList();
        objs.addAll(func.apply(wrap1));
        objs.addAll(func.apply(wrap2));
        for (Object obj : objs) {
            String name = getNameFromObj.apply(obj);
            if (allVarsIntersect.contains(name)) continue;
            allVarsIntersect.add(name);
            try {
                Constructor<?> cons = compareResultClass.getConstructors()[0];
                CompareResult result = compareResultClass == CompareFTEventResult.class ? (CompareResult)cons.newInstance(wrap1, wrap2, name) : (CompareResult)cons.newInstance(wrap1, wrap2, name, category, func);
                comparaison.addConflict(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

