/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.wrap.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class DBWrapFrameEdit
extends DBInternalFrame {
    protected JTextField _ctrlPath;
    protected JTextField _ctrlName;
    protected JTextField _ctrlVersion;
    protected JTextArea _ctrlDescription;
    DBWrap _dbWrap;
    CeciliaAppl _application;

    @Override
    public DBWrap getDBWrap() {
        return this._dbWrap;
    }

    @Override
    protected CeciliaAppl getApplication() {
        return this._application;
    }

    @Override
    public boolean isEditable() {
        return !this._application.isReader();
    }

    public DBWrapFrameEdit(DBWrap dbWrap, CeciliaAppl appl) {
        super(dbWrap.getDBFolder());
        this._dbWrap = dbWrap;
        this._application = appl;
        this.setFrameIcon(DBFolderResources.getFrameIcon(dbWrap.getDBFolder()));
    }

    public DBWrapFrameEdit(DBWrap dbWrap, CeciliaAppl appl, ImageIcon icon, String iconLabel, String iconTooltip) {
        super(icon, iconLabel, iconTooltip);
        this._dbWrap = dbWrap;
        this._application = appl;
        this.setFrameIcon(icon);
    }

    protected void refreshControl() {
        this._ctrlPath.setEnabled(false);
        this._ctrlName.setEnabled(false);
        this._ctrlVersion.setEnabled(false);
        this._ctrlDescription.setEnabled(true);
        this._ctrlPath.setText(this.getDBFolder().getRefPath());
        this._ctrlName.setText(this.getDBFolder().getParent().getName());
        this._ctrlVersion.setText(this.getDBFolder().getName());
        this._ctrlDescription.setText(this.getDBFolder().getDescription());
    }

    protected Component createPathCtrl() {
        return this.createPathCtrl(false);
    }

    protected Component createPathCtrl(boolean bPath) {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlPath = new JTextField();
        this._ctrlName = new JTextField();
        this._ctrlVersion = new JTextField();
        this._ctrlPath.setEditable(this.isEditable());
        this._ctrlName.setEditable(this.isEditable());
        this._ctrlVersion.setEditable(this.isEditable());
        int posY = 0;
        if (bPath) {
            panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_PATH")), new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this._ctrlPath, new GridBagConstraints(1, posY, 3, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            ++posY;
        }
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_NAME")), new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlName, new GridBagConstraints(1, posY, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_VERSION")), new GridBagConstraints(2, posY, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlVersion, new GridBagConstraints(3, posY, 1, 1, 0.33, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    protected Component createDescriptionCtrl() {
        if (this._ctrlDescription == null) {
            this._ctrlDescription = new JTextArea(6, 30);
        }
        this._ctrlDescription.setEditable(this.isEditable());
        this._ctrlDescription.setLineWrap(true);
        this._ctrlDescription.setWrapStyleWord(true);
        this._ctrlDescription.getDocument().addDocumentListener(new ModifyListener());
        JScrollPane scroll = new JScrollPane(this._ctrlDescription);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(31);
        return scroll;
    }

    protected boolean verifyDescription() {
        String description;
        if (this._ctrlDescription != null && !DBFactory.verifyDescription(description = this.getDescription())) {
            JInternalFrame iFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this._ctrlDescription);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlDescription), ResMsgObj.msgFormat("MSG_ERR_DESCRIPTION_FRM", (short)1023), iFrame.getTitle(), 0);
            this._ctrlDescription.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected String getDescription() {
        if (this._ctrlDescription == null) {
            return null;
        }
        return this._ctrlDescription.getText();
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this.getApplication(), this._ctrlClose).realiseDo();
        return true;
    }

    @Override
    protected Component createSaveAndClosePanel() {
        Component result = super.createSaveAndClosePanel();
        if (this.isEditable()) {
            return result;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)this._ctrlClose, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected class ModifyListener
    implements ActionListener,
    DocumentListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            DBWrapFrameEdit.this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DBWrapFrameEdit.this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DBWrapFrameEdit.this.setModified(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DBWrapFrameEdit.this.setModified(true);
        }
    }
}

