/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.db.dao.xml.DBObjModelBytes;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.ResMsgSA51;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SA51FMEAHandler
extends AbstractSA51Handler {
    StringBuilder _sb = new StringBuilder();
    String _name;
    DBFolder _fmeaFolder;
    DBFolder _systemFolder;
    String _dateCreation;
    String _dateUpdate;
    SA51Utils.Pair _fmeaWithVersion;
    String _modelID;
    Map<Integer, String> _idToFolder = new LinkedHashMap<Integer, String>();

    public String getString() {
        return this._sb.toString();
    }

    public Map<Integer, String> getIDToFolder() {
        return this._idToFolder;
    }

    public SA51FMEAHandler(SA51Handler handler) {
        super(handler);
        this._fmeaFolder = this.getCeciFactory().createFolderDAO().getRootID("FMEA_MODELS");
        this._modelID = null;
    }

    public SA51FMEAHandler(SA51Handler handler, DBFolder systemFolder) {
        super(handler);
        this._systemFolder = systemFolder;
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if ("FMEA".equals(name)) {
            this._sb.append('<' + name + '>' + '\n');
            this._modelID = this.getAttribute(attrs, "MODEL_ID");
        } else if ("IDENTIFICATION".equals(name)) {
            this._fmeaWithVersion = new SA51Utils.Pair(this.getAttribute(attrs, "VERSION"), this.getAttribute(attrs, "NAME"), this.getAttribute(attrs, "RELEASE"));
            this._dateCreation = this.getAttribute(attrs, "CREATION_DATE");
            this._dateUpdate = this.getAttribute(attrs, "UPDATE_DATE");
        } else {
            if ("FMEA_MODEL".equals(name)) {
                this._name = this.getAttribute(attrs, "ID");
            } else if ("EXTERNAL_REF".equals(name)) {
                int idFMEAExtRef = Integer.parseInt(this.getAttribute(attrs, "FMEA_ID"));
                String pathFMEAExtRef = this.getAttribute(attrs, "FMEA_PATH");
                this._idToFolder.put(idFMEAExtRef, pathFMEAExtRef);
            }
            this._sb.append("<" + name);
            for (String key : attrs.keySet()) {
                this._sb.append(" " + key + "=\"" + this.getAttribute(attrs, key) + "\"");
            }
            this._sb.append(">\n");
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (!name.equals("IDENTIFICATION")) {
            this._sb.append("</" + name + ">\n");
        } else {
            this._sb.append("<" + name + "/>\n");
        }
        if ("FMEA_MODEL".equals(name)) {
            DBFolder dbFolder = this.createNewFolder(this._name, DBFolder.createFlagsModel(DBFolder.Family.FMEA_MODEL, (short)4, (short)0), true, this._fmeaFolder);
            DBFolder dbFoldVers = this.createNewFolder("1", DBFolder.createFlagsVersion(DBFolder.Family.FMEA_MODEL, (short)4, (short)0), true, dbFolder);
            DBObject obj = new DBObject(dbFoldVers.getID());
            dbFoldVers.setObject(obj);
            byte[] bytes = this._sb.toString().getBytes(StandardCharsets.UTF_8);
            this._sb.setLength(0);
            DBObjModelBytes dbObjModel = new DBObjModelBytes(bytes);
            dbObjModel.setNature("fmea.model");
            dbObjModel.setFormat("XML");
            dbObjModel.setEncoding("UTF-8");
            obj.addModel(dbObjModel);
            DBLogs logs = new DBLogs();
            logs.addLog(this.getHandler().getCurrentDate(), this.getLogin(), DBLogs.DBLevel.FINEST, ResMsgSA51.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getHandler().getFilePathForLog()));
            SA51Utils.addLogsToObj(obj, logs);
            return true;
        }
        if ("FMEA".equals(name)) {
            String versionName;
            DBFolder versFmeaFolder;
            DBFolder fmeaFolder = this._systemFolder.findChild(this._fmeaWithVersion.getName());
            if (fmeaFolder == null) {
                fmeaFolder = this.createNewFolder(this._fmeaWithVersion.getName(), DBFolder.createFlagsModel(DBFolder.Family.PROJECT, (short)4, (short)0), false, this._systemFolder);
                fmeaFolder.setDateCreate(SA51Utils.convertDate(this._dateCreation));
                fmeaFolder.setDateModify(SA51Utils.convertDate(this._dateUpdate));
            }
            if ((versFmeaFolder = fmeaFolder.findChild(versionName = this._fmeaWithVersion.getVersion() + "." + this._fmeaWithVersion.getRelease())) == null) {
                versFmeaFolder = this.createNewFolder(versionName, DBFolder.createFlagsVersion(DBFolder.Family.PROJECT, (short)4, (short)0), false, fmeaFolder);
                versFmeaFolder.setDateCreate(fmeaFolder.getDateCreate());
                versFmeaFolder.setDateModify(fmeaFolder.getDateModify());
            } else {
                versFmeaFolder.setID(this.incrementCounter());
            }
            DBObject obj = new DBObject(versFmeaFolder.getID());
            versFmeaFolder.setObject(obj);
            byte[] bytes = this._sb.toString().getBytes(StandardCharsets.UTF_8);
            this._sb.setLength(0);
            Object logs = this._idToFolder.keySet().iterator();
            while (logs.hasNext()) {
                int id = logs.next();
                SA51FMEAHandler.createProperty(obj, id, this._idToFolder.get(id), "external.field");
            }
            logs = new DBLogs();
            ((DBLogs)logs).addLog(this.getHandler().getCurrentDate(), this.getLogin(), DBLogs.DBLevel.FINEST, ResMsgSA51.msgFormat("MSG_LOG_IMPORT_FROM_FILE", this.getHandler().getFilePathForLog()));
            DBObjModelBytes dbObjModel = new DBObjModelBytes(bytes);
            dbObjModel.setNature("fmea");
            dbObjModel.setFormat("XML");
            dbObjModel.setEncoding("UTF-8");
            obj.addModel(dbObjModel);
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version='1.0'?>\n");
                ((DBLogs)logs).toXML(sb, "");
                byte[] bytesLogs = DAOObjModel.convertToCompressedByte(new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
                DBObjModelBytes dbObjLogs = new DBObjModelBytes(bytesLogs);
                dbObjLogs.setNature("logs");
                dbObjModel.setFormat("XML");
                dbObjModel.setEncoding("UTF-8");
                obj.addModel(dbObjModel);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DBFolder versionFolder = SA51Utils.goToChild(this.getCeciFactory().createFolderDAO().getRootID("FMEA_MODELS"), this._modelID, "1");
            if (versionFolder == null) {
                this.warning(new SAXParseException(ResMsgSA51.getString("MSG_ERR_FMEA_MODEL"), this.getLocator()));
            } else {
                SA51Utils.createProperty(obj, Long.toString(versionFolder.getID()), "fmea.model.id");
            }
            return true;
        }
        return false;
    }

    public static void createProperty(DBObject obj, int id, String data, String key) {
        SA51Utils.createProperty(obj, data, key);
        DBObjProperty property = obj.getProperty(key);
        property.setID(id);
    }
}

