/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.arbor51;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.io.arbor51.AbstractSA51Handler;
import com.dassault.cecilia.io.arbor51.SA51Constant;
import com.dassault.cecilia.io.arbor51.SA51DSFHandler;
import com.dassault.cecilia.io.arbor51.SA51FMEAHandler;
import com.dassault.cecilia.io.arbor51.SA51Handler;
import com.dassault.cecilia.io.arbor51.SA51TreeHandler;
import com.dassault.cecilia.io.arbor51.SA51Utils;
import com.dassault.cecilia.lib.util.xmlparser.SAXActionHandler;
import java.util.Date;
import java.util.Map;
import org.xml.sax.SAXException;

public class SA51SystemHandler
extends AbstractSA51Handler
implements SAXActionHandler,
SA51Constant {
    private String _systemName;
    private DBFolder _systemFolder;
    private DBFolder _projectFolder;
    private SA51TreeHandler _treeHandler;
    private SA51DSFHandler _dsfHandler;
    private SA51FMEAHandler _fmeaHandler;
    boolean _autoGenerateProject = false;

    public SA51SystemHandler(DBFolder root, SA51Handler handler) {
        super(handler);
        this._projectFolder = root;
        assert (this._projectFolder != null && this._projectFolder.getParent() != null && this._projectFolder.getParent().getName().equals("PROJECTS"));
    }

    public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._treeHandler != null) {
            this._treeHandler.startAction(name, attrs, false);
        } else if (this._dsfHandler != null) {
            this._dsfHandler.startAction(name, attrs, false);
        } else if (this._fmeaHandler != null) {
            this._fmeaHandler.startAction(name, attrs, false);
        } else if ("IDENTIFICATION".equals(name)) {
            this._systemName = this.getValidName(this.getAttribute(attrs, "NAME"), DBFolder.Family.PROJECT, name, "NAME");
            Date dateCreation = SA51Utils.convertDate(this.getAttribute(attrs, "CREATION_DATE"));
            Date dateUpdate = SA51Utils.convertDate(this.getAttribute(attrs, "UPDATE_DATE"));
            this._systemFolder = this._projectFolder.findChild(this._systemName);
            if (this._autoGenerateProject) {
                this._projectFolder.setDateCreate(dateCreation);
                this._projectFolder.setDateModify(dateUpdate);
            }
            String commentSys = this.getValidDesc(this.getAttribute(attrs, "COMMENT"));
            if (this._systemFolder == null) {
                this._systemFolder = this.createNewFolder(this._systemName, DBFolder.createFlagsFolder(DBFolder.Family.PROJECT, (short)0, (short)0), dateCreation, dateUpdate, commentSys, this._projectFolder);
            } else if (this._systemFolder.getUserFlag() == 1) {
                this._systemFolder.setUserFlag((short)0);
                this._systemFolder.setDateCreate(dateCreation);
                this._systemFolder.setDateModify(dateUpdate);
                if (commentSys != null && !commentSys.isEmpty()) {
                    this._systemFolder.setDescription(commentSys);
                }
            } else {
                this._systemFolder.setDateCreate(dateCreation);
                this._systemFolder.setDateModify(dateUpdate);
            }
        } else if ("DSF".equals(name)) {
            this._dsfHandler = new SA51DSFHandler(this._systemFolder, this.getHandler());
            this._dsfHandler.startAction(name, attrs, true);
        } else if ("FMEA".equals(name)) {
            this._fmeaHandler = new SA51FMEAHandler(this.getHandler(), this._systemFolder);
            this._fmeaHandler.startAction(name, attrs, true);
        } else if ("TREE".equals(name)) {
            this._treeHandler = new SA51TreeHandler(this._systemFolder, this.getHandler());
            this._treeHandler.startAction(name, attrs, true);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._treeHandler != null && this._treeHandler.endAction(name, attrs, txt)) {
            this._treeHandler = null;
        } else if (this._dsfHandler != null && this._dsfHandler.endAction(name, attrs, txt)) {
            this._dsfHandler = null;
        } else if (this._fmeaHandler != null && this._fmeaHandler.endAction(name, attrs, txt)) {
            this._fmeaHandler = null;
        } else if ("SYSTEM".equals(name)) {
            return true;
        }
        return false;
    }
}

