/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBSession;
import java.util.logging.Logger;

public class ChoiceImport {
    private static Logger _LOG = Logger.getLogger(ChoiceImport.class.getPackage().getName());
    public static long MASK_ERROR = 1L;
    public static long MASK_CONFLICT = 2L;
    public static long MASK_CONFLICT_TRUE = 4L;
    DBFolder _dbImport;
    DBFolder _dbLocal;
    boolean _bConflict;
    boolean _bFalseConflict;
    DBAccess.Right _accessRight;
    boolean _bSelectImport;
    String _strMsg;

    public DBFolder getFolderImport() {
        return this._dbImport;
    }

    public DBFolder getFolderLocal() {
        return this._dbLocal;
    }

    public void setFolderLocal(DBFolder dbFolder) {
        if (this._bConflict) {
            throw new UnsupportedOperationException();
        }
        if (this._dbLocal != null) {
            throw new UnsupportedOperationException();
        }
        this._dbLocal = dbFolder;
    }

    public boolean isConflict() {
        return this._bConflict;
    }

    public boolean isFalseConflict() {
        return this._bFalseConflict;
    }

    public DBAccess.Right getAccessRight() {
        return this._accessRight;
    }

    public boolean isFreeze() {
        return this._dbLocal != null && this._dbLocal.isFreeze();
    }

    public boolean isSelectImport() {
        return this._bSelectImport;
    }

    public void setSelectImport(boolean value) {
        if (value && this.isCheckError()) {
            _LOG.warning("Tentative pour imposer l'import d'une donn\u00e9e en erreur.");
            return;
        }
        this._bSelectImport = value;
    }

    public String getMsg() {
        return this._strMsg;
    }

    protected void updateMsg() {
        if (this.isNoAccess()) {
            this._strMsg = ResMsgCore.getString("MSG_IMPORT_NOACCESS");
        } else if (this._dbLocal != null) {
            if (this._dbLocal.isLocked()) {
                DBSession dbSession = this._dbLocal.getObject().getLockedSession();
                this._strMsg = ResMsgCore.msgFormat("MSG_IMPORT_LOCK", dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~");
            } else {
                this._strMsg = this.isFreeze() ? ResMsgCore.getString("MSG_IMPORT_FREEZE") : (this.isReadOnly() ? ResMsgCore.getString("MSG_IMPORT_READONLY") : (this._bFalseConflict ? ResMsgCore.getString("MSG_IMPORT_NOCONFLICT") : (this._dbLocal.getDateModify().compareTo(this._dbImport.getDateModify()) < 0 ? ResMsgCore.getString("MSG_IMPORT_ISIMPORT") : ResMsgCore.getString("MSG_IMPORT_ISBASE"))));
            }
        }
    }

    public boolean isNoAccess() {
        return this._accessRight == DBAccess.Right.NONE;
    }

    public boolean isReadOnly() {
        if (this._dbLocal == null) {
            return false;
        }
        return this._accessRight != DBAccess.Right.WRITE;
    }

    public boolean isCheckError() {
        if (this._accessRight == DBAccess.Right.NONE) {
            return true;
        }
        return this._dbLocal != null && this._dbLocal.isLocked();
    }

    public boolean isCheckBase() {
        if (this.isCheckError()) {
            return false;
        }
        if (this.isFreeze()) {
            return true;
        }
        if (this.isReadOnly()) {
            return true;
        }
        return !this.isSelectImport();
    }

    public boolean isCheckImport() {
        if (this.isCheckError()) {
            return false;
        }
        if (this.isFreeze()) {
            return false;
        }
        if (this.isReadOnly()) {
            return false;
        }
        return this.isSelectImport();
    }

    public ChoiceImport(DBFolder dbImport) {
        if (dbImport == null) {
            throw new NullPointerException();
        }
        this._dbImport = dbImport;
        this._dbLocal = null;
        this._bSelectImport = true;
        this._bConflict = false;
        this._bFalseConflict = false;
        this._accessRight = DBAccess.Right.WRITE;
        this._dbImport.setExternalFlag(0L);
        this.updateMsg();
    }

    public ChoiceImport(DBFolder dbImport, DBFolder dbLocal, ChoiceImport oldChoice, DBAccess.Right accessRight) {
        if (dbImport == null) {
            throw new NullPointerException();
        }
        if (dbLocal == null) {
            throw new NullPointerException();
        }
        this._dbImport = dbImport;
        this._dbLocal = dbLocal;
        if (dbImport.getUserFlag() == 1) {
            this._accessRight = DBAccess.Right.READ;
            this._bConflict = true;
            this._bFalseConflict = true;
            this._bSelectImport = false;
        } else {
            this._accessRight = accessRight;
            this._bConflict = true;
            boolean _bSameCreateDate = dbLocal.getDateCreate().equals(dbImport.getDateCreate());
            boolean _bSameModifyDate = dbLocal.getDateModify().equals(dbImport.getDateModify());
            boolean _bSameCRC = true;
            boolean bl = this._bFalseConflict = _bSameCreateDate && _bSameModifyDate && _bSameCRC;
            if (dbImport.getFamily() == DBFolder.Family.BTP_APPLICATION && dbImport.getName().equals("ALL")) {
                this._bFalseConflict = true;
            }
            if (dbImport.getFamily() == DBFolder.Family.BTP_AUTHOR && dbImport.getName().equals("admin")) {
                this._bFalseConflict = true;
            }
            this._bSelectImport = false;
            if (!this._bFalseConflict && dbLocal.getDateModify().compareTo(dbImport.getDateModify()) < 0) {
                this._bSelectImport = true;
            }
        }
        long mask = MASK_CONFLICT | (this._accessRight == DBAccess.Right.NONE || this._dbLocal.isLocked() ? MASK_ERROR : 0L) | (this._bFalseConflict ? 0L : MASK_CONFLICT_TRUE);
        this.setExternalFlag(mask);
        this.updateMsg();
    }

    public ChoiceImport(DBFolder dbImport, DBFolder dbLocal) {
        if (dbImport == null) {
            throw new NullPointerException();
        }
        if (dbLocal == null) {
            throw new NullPointerException();
        }
        this._dbImport = dbImport;
        this._dbLocal = dbLocal;
        this._bConflict = true;
        this._bFalseConflict = true;
    }

    private void setExternalFlag(long mask) {
        this._dbImport.setExternalFlag(mask);
        if (mask == 0L) {
            return;
        }
        for (DBFolder dbParent = this._dbImport.getParent(); dbParent != null && !dbParent.isSystem(); dbParent = dbParent.getParent()) {
            if (dbParent.getExternalFlag() == mask) {
                return;
            }
            dbParent.setExternalFlag(dbParent.getExternalFlag() | mask);
        }
    }
}

