/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.faulttree.egli.EGLICmdGenerate;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.io.imports.ChoiceImport;
import com.dassault.cecilia.io.imports.UtilityConvertID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapImport {
    public static final short DBFOLDER_FORCE_DB_FLAG = 1;
    private static Logger _LOG = Logger.getLogger(MapImport.class.getPackage().getName());
    DAOFactory _daoImport;
    CECFactory _daoTmpImport;
    DAOFactory _daoLocal;
    DBSession _dbSession;
    DBUser _dbUser;
    Map<DBFolder, ChoiceImport> _mapChoice;
    Map<DBFolder, DBComparaisons> _mapConflict;
    int _nbrError;
    int _nbrConflict;
    int _nbrTrueConflict;
    int _nbrImport;
    ArrayList<GeneralError<DBFolder>> _errors = new ArrayList();
    boolean _withError = false;
    boolean _choiceImportPrefs = false;
    private List<DBFolder> _lockerFolders = new ArrayList<DBFolder>();
    private List<DBFolder> _lockerCreatedFolders = new ArrayList<DBFolder>();
    DAOFolder _daoFolderLocal;
    private Set<DBFolder> _objectFolders = new LinkedHashSet<DBFolder>();

    public MapImport(DAOFactory daoImport, DAOFactory daoLocal, DBSession dbSession) {
        this._daoImport = daoImport;
        this._daoLocal = daoLocal;
        this._dbSession = dbSession;
        this._dbUser = this._dbSession.getUser() instanceof DBUser ? (DBUser)this._dbSession.getUser() : (DBUser)this._daoLocal.createUserDAO().find(this._dbSession.getUser().getID());
        this.constructChoice();
    }

    public int getNbrError() {
        return this._nbrError;
    }

    public int getNbrConflict() {
        return this._nbrConflict;
    }

    public int getNbrTrueConflict() {
        return this._nbrTrueConflict;
    }

    public int getNbrImport() {
        return this._nbrImport;
    }

    public Map<DBFolder, DBComparaisons> getMapConflicts() {
        return this._mapConflict;
    }

    public boolean withError() {
        return this._withError;
    }

    public boolean withWarnning() {
        return !this._errors.isEmpty();
    }

    protected void addError(DBFolder folder, String msg) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg));
        this._withError = true;
    }

    protected void addError(DBFolder folder, MsgType type, String msg) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg, type));
        switch (type) {
            case ERROR: 
            case FATAL: {
                this._withError = true;
            }
        }
    }

    public List<GeneralError<DBFolder>> getErrors() {
        return this._errors;
    }

    public boolean withImportPrefs() {
        DBUser dbUserImport = this._daoImport.createUserDAO().getMasterUser();
        return this._daoImport.createPreferenceDAO().find(dbUserImport, "Default") != null;
    }

    public boolean isChoiceImportPrefs() {
        return this._choiceImportPrefs;
    }

    public void setChoiceImportPrefs(boolean choice) {
        this._choiceImportPrefs = choice;
    }

    public void constructChoice() {
        Map<DBFolder, ChoiceImport> oldChoice = this._mapChoice;
        this._mapChoice = new HashMap<DBFolder, ChoiceImport>();
        this._mapConflict = new HashMap<DBFolder, DBComparaisons>();
        DAOFolder daoFolderI = this._daoImport.createFolderDAO();
        DBFolder dbFolderI = daoFolderI.getRootID("ROOT");
        this.resetConflict_rec(daoFolderI, dbFolderI);
        this._nbrImport = 0;
        this._nbrTrueConflict = 0;
        this._nbrConflict = 0;
        this._nbrError = 0;
        DAOFolder daoFolderA = this._daoLocal.createFolderDAO();
        DBFolder dbFolderA = daoFolderA.getRootID("ROOT");
        this.constructChoice_rec(dbFolderI, dbFolderA, daoFolderA, oldChoice);
    }

    private void resetConflict_rec(DAOFolder daoFolderI, DBFolder dbFolderI) {
        List<DBFolder> childrenI = dbFolderI.getChildren();
        if (childrenI == null) {
            childrenI = daoFolderI.findChildren(dbFolderI);
        }
        if (childrenI == null) {
            return;
        }
        for (int i = 0; i < childrenI.size(); ++i) {
            DBFolder dbChild = childrenI.get(i);
            dbChild.setExternalFlag(0L);
            this.resetConflict_rec(daoFolderI, dbChild);
        }
    }

    private void constructChoice_rec(DBFolder dbFolderI, DBFolder dbFolderA, DAOFolder daoFolderA, Map<DBFolder, ChoiceImport> oldChoice) {
        DBFolder dbChildI;
        if (dbFolderA == null) {
            throw new NullPointerException();
        }
        if (this._mapChoice.containsKey(dbFolderI)) {
            ChoiceImport current = this._mapChoice.get(dbFolderI);
            _LOG.warning("Folder d\u00e9j\u00e0 trait\u00e9 [" + dbFolderI.getRefPath() + ",  ID=" + dbFolderI.getID() + "] : " + current.getFolderImport().getRefPath() + " (ID=" + current.getFolderImport() + ")");
            return;
        }
        if (!dbFolderI.isSystem()) {
            DBAccess.Right accessRight;
            ChoiceImport current;
            if (!dbFolderA.getRefPath().equalsIgnoreCase(dbFolderI.getRefPath())) {
                _LOG.warning("Probleme dans le parcours : " + dbFolderI.getRefPath());
                return;
            }
            ChoiceImport old = null;
            if (oldChoice != null) {
                old = oldChoice.get(dbFolderI);
            }
            if ((current = new ChoiceImport(dbFolderI, dbFolderA, old, accessRight = daoFolderA.getAccessRight(dbFolderA, this._dbUser))).isCheckError()) {
                ++this._nbrError;
            }
            if (current.isConflict()) {
                ++this._nbrConflict;
                if (!current.isFalseConflict()) {
                    ++this._nbrTrueConflict;
                }
            }
            if (current.isCheckImport()) {
                ++this._nbrImport;
            }
            this._mapChoice.put(dbFolderI, current);
            if (dbFolderI != null && dbFolderA != null && dbFolderI.isVersion() && dbFolderA.isVersion() && dbFolderI.getFamily() != DBFolder.Family.BTP_APPLICATION && dbFolderI.getFamily() != DBFolder.Family.BTP_AUTHOR && dbFolderI.getFamily() != DBFolder.Family.BTP_SUBSTANTIATION) {
                DBComparaisons compare;
                DBWrap wrapI = (DBWrap)this._daoImport.createObjectDAO().getWrap(dbFolderI.getObject());
                DBWrap wrapA = ((CECFactory)this._daoLocal).findOrCreateWrap(dbFolderA);
                if (wrapI == null) {
                    if (this._daoTmpImport == null) {
                        this._daoTmpImport = new CeciliaFactory((CAppl)CAppl.getInstance(), this._daoImport);
                    }
                    wrapI = this._daoTmpImport.findOrCreateWrap(dbFolderI);
                }
                if (wrapI != null && wrapA != null && wrapI.getClass().equals(wrapA.getClass()) && (compare = wrapA.getCompareConflict(this._daoImport, wrapI, true)) != null && compare.withConflicts()) {
                    this._mapConflict.put(dbFolderI, compare);
                }
            }
        } else {
            ChoiceImport current = new ChoiceImport(dbFolderI, dbFolderA);
            this._mapChoice.put(dbFolderI, current);
        }
        List<DBFolder> childrenI = dbFolderI.getChildren();
        List<DBFolder> childrenA = dbFolderA.getChildren();
        if (childrenA == null) {
            childrenA = daoFolderA.findChildren(dbFolderA);
        }
        if (childrenI == null) {
            return;
        }
        if (childrenA == null) {
            for (int i = 0; i < childrenI.size(); ++i) {
                dbChildI = childrenI.get(i);
                this.constructChoice_rec(dbChildI);
            }
        } else {
            for (int i = 0; i < childrenI.size(); ++i) {
                dbChildI = childrenI.get(i);
                DBFolder dbChildA = null;
                for (int a = 0; a < childrenA.size(); ++a) {
                    if (!childrenA.get(a).getName().equalsIgnoreCase(dbChildI.getName())) continue;
                    dbChildA = childrenA.get(a);
                    break;
                }
                if (dbChildA == null) {
                    this.constructChoice_rec(dbChildI);
                    continue;
                }
                this.constructChoice_rec(dbChildI, dbChildA, daoFolderA, oldChoice);
            }
        }
    }

    private void constructChoice_rec(DBFolder dbFolderI) {
        ChoiceImport current = new ChoiceImport(dbFolderI);
        if (current.isCheckImport()) {
            ++this._nbrImport;
        }
        this._mapChoice.put(dbFolderI, current);
        if (dbFolderI.isVersion()) {
            return;
        }
        List<DBFolder> childrenI = dbFolderI.getChildren();
        if (childrenI == null) {
            return;
        }
        for (int i = 0; i < childrenI.size(); ++i) {
            DBFolder dbChildI = childrenI.get(i);
            this.constructChoice_rec(dbChildI);
        }
    }

    public DBFolder getRootImport() {
        DAOFolder daoFolder = this._daoImport.createFolderDAO();
        return daoFolder.getRootID("ROOT");
    }

    public DAOFactory getDAOImport() {
        return this._daoImport;
    }

    public ChoiceImport getChoice(DBFolder dbFolder) {
        return this._mapChoice.get(dbFolder);
    }

    public void selectChoice(Collection<DBFolder> selectFolders, boolean choiceImport) {
        if (selectFolders == null) {
            selectFolders = this._mapChoice.keySet();
        }
        for (DBFolder dbFolder : selectFolders) {
            boolean previousImport;
            if (dbFolder.isSystem()) continue;
            ChoiceImport choice = this._mapChoice.get(dbFolder);
            if (choice == null) {
                _LOG.info("Pas de choix d'import pour le dossier: " + dbFolder);
                continue;
            }
            if (choice.isCheckError() || choice.isFreeze() || choice.isReadOnly() || choice.isNoAccess() || !choice.isConflict() || (previousImport = choice.isSelectImport()) == choiceImport) continue;
            choice.setSelectImport(choiceImport);
            if (previousImport) {
                --this._nbrImport;
                continue;
            }
            ++this._nbrImport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean lockLocalFolders() {
        DAOObject daoObject = this._daoLocal.createObjectDAO();
        boolean result = false;
        try {
            DBFolder dbFolderErrorLock = null;
            for (ChoiceImport choice : this._mapChoice.values()) {
                DBObject dbObject;
                if (!choice.isConflict() || choice.isFreeze() || choice.isReadOnly() || !choice.isSelectImport() || (dbObject = choice._dbLocal.getObject()) == null) continue;
                if (!daoObject.lock(dbObject, this._dbSession)) {
                    dbFolderErrorLock = choice._dbLocal;
                    break;
                }
                this._lockerFolders.add(choice._dbLocal);
            }
            if (dbFolderErrorLock != null) {
                this.addError(dbFolderErrorLock, ResMsgCore.getString("MSG_FOL_DONT_LOCK"));
                _LOG.info("Impossible de locker le dossier : " + dbFolderErrorLock);
            } else {
                result = true;
            }
        }
        finally {
            if (!result) {
                this.unlockLocalFolder(false);
            }
        }
        return result;
    }

    public synchronized boolean unlockLocalFolder(boolean withCreateObject) {
        DAOObject daoObject = this._daoLocal.createObjectDAO();
        ArrayList<DBFolder> lockerFolders = new ArrayList<DBFolder>();
        for (DBFolder dbFolder : this._lockerFolders) {
            if (dbFolder.getObject() == null || daoObject.unlock(dbFolder.getObject(), this._dbSession)) continue;
            lockerFolders.add(dbFolder);
        }
        if (withCreateObject) {
            for (DBFolder dbFolder : this._lockerCreatedFolders) {
                if (dbFolder.getObject() == null || daoObject.unlock(dbFolder.getObject(), this._dbSession)) continue;
                lockerFolders.add(dbFolder);
            }
        }
        this._lockerFolders = lockerFolders;
        return this._lockerFolders.size() == 0;
    }

    public boolean realiseImport() {
        boolean result = false;
        try {
            this._daoLocal.beginTransaction(true);
            this._daoFolderLocal = this._daoLocal.createFolderDAO();
            try {
                _LOG.finest("Realise-Import (phase1)");
                this.createOrUpdateFolders();
                if (!this._withError) {
                    _LOG.finest("Realise-Import (phase2)");
                    try {
                        this._daoLocal.setIgnoreFreezeState(true);
                        this.createOrUpdateXMLStream();
                    }
                    finally {
                        this._daoLocal.setIgnoreFreezeState(false);
                    }
                }
                if (!this._withError && this.isChoiceImportPrefs()) {
                    DBUser dbUserImport = this._daoImport.createUserDAO().getMasterUser();
                    DBPreference dbPrefsImport = this._daoImport.createPreferenceDAO().find(dbUserImport, "Default");
                    DBPreference dbPrefsLocal = this._daoLocal.createPreferenceDAO().find(this._dbUser, "Default");
                    if (dbPrefsLocal != null) {
                        dbPrefsLocal.setValue(dbPrefsImport.getValue());
                        if (!this._daoLocal.createPreferenceDAO().update(dbPrefsLocal)) {
                            this.addError(this.getRootImport(), "Probl\u00e8me lors de la mise \u00e0 jour des pr\u00e9f\u00e9rences de l'utilisateur '" + this._dbUser.getName() + "'");
                        }
                    } else {
                        dbPrefsLocal = new DBPreference(dbPrefsImport).setUser(this._dbUser);
                        dbPrefsLocal.setID(-1L);
                        if (this._daoLocal.createPreferenceDAO().create(dbPrefsLocal) == null) {
                            this.addError(this.getRootImport(), "Probl\u00e8me lors de la cr\u00e9ation des pr\u00e9f\u00e9rences de l'utilisateur '" + this._dbUser.getName() + "'");
                        }
                    }
                }
            }
            catch (Throwable th) {
                _LOG.log(Level.INFO, "Realise-Import (Throwable)", th);
                this._daoLocal.abortTransaction();
                this.addError(this.getRootImport(), ResMsgObj.getString("MSG_ERR_DB_FOL_IMPORT_EXCEPTION"));
                return false;
            }
            if (this._withError) {
                this._daoLocal.abortTransaction();
            } else {
                this._daoLocal.endTransaction();
                result = true;
            }
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Realise-Import | Processus de transition", e);
            this.addError(this.getRootImport(), ResMsgObj.getString("MSG_ERR_DB_WARNING"));
        }
        if (result && !Boolean.getBoolean("cecilia.ft.import.NoUpdateEGL")) {
            this.updateEGL();
        }
        return result;
    }

    private void createOrUpdateFolders() {
        DBFolder dbRoot = this._daoImport.createFolderDAO().getRootID("ROOT");
        this.createOrUpdateFolders_rec(dbRoot, null);
    }

    private void createOrUpdateFolders_rec(DBFolder dbFolderI, DBFolder dbParentLocal) {
        List<DBFolder> childrenI;
        if (this._daoLocal.withExceptionDuringTransaction()) {
            return;
        }
        ChoiceImport choice = this._mapChoice.get(dbFolderI);
        if (choice == null) {
            throw new NullPointerException();
        }
        if (!dbFolderI.isSystem()) {
            if (!choice.isConflict()) {
                _LOG.finest("Realise-Import | createFolder:" + dbFolderI);
                if (!this.createFolder(dbFolderI, choice, dbParentLocal)) {
                    _LOG.info("Realise-Import | error during createFolder:" + dbFolderI);
                    this.addError(dbFolderI, ResMsgObj.getString("MSG_ERR_DB_FOL_IMPORT_CONVERT"));
                    return;
                }
            } else if (!choice.isFreeze() && !choice.isReadOnly() && choice.isSelectImport()) {
                _LOG.finest("Realise-Import | updateFolder:" + dbFolderI);
                if (!this.updateFolder(dbFolderI, choice)) {
                    _LOG.info("Realise-Import | error during updateFolder:" + dbFolderI);
                    this.addError(dbFolderI, ResMsgObj.getString("MSG_ERR_DB_FOL_UPDATE"));
                }
            }
        }
        if (!dbFolderI.isVersion() && (childrenI = dbFolderI.getChildren()) != null) {
            for (int i = 0; i < childrenI.size(); ++i) {
                this.createOrUpdateFolders_rec(childrenI.get(i), choice.getFolderLocal());
            }
        }
    }

    private boolean createFolder(DBFolder importFol, ChoiceImport choice, DBFolder localParentFol) {
        try {
            DBFolder dbCreate;
            DBFolder localFol = new DBFolder(localParentFol, this._dbUser);
            localFol.setName(importFol.getName());
            localFol.setDescription(importFol.getDescription());
            if (importFol.getDateCreate() != null) {
                localFol.setDateCreate(importFol.getDateCreate());
            } else {
                _LOG.fine("Pas de date de creation pour le dossier: " + importFol.getPathUntilSystem(new StringBuilder()).toString());
            }
            if (importFol.getDateModify() != null) {
                localFol.setDateModify(importFol.getDateModify());
            } else {
                _LOG.fine("Pas de date de modification pour le dossier: " + importFol.getPathUntilSystem(new StringBuilder()).toString());
            }
            localFol.setFlags(importFol.getFlags());
            DBObject importObj = importFol.getObject();
            if (importObj != null) {
                this.createObject(importFol, localFol, importObj);
            }
            if ((dbCreate = this._daoFolderLocal.create(localFol)) != null) {
                dbCreate.setMustBeUpdated(true);
                choice.setFolderLocal(dbCreate);
                if (dbCreate.getObject() != null) {
                    this._lockerCreatedFolders.add(dbCreate);
                }
                return true;
            }
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Realise-Import | Exception during createFolder:" + importFol, th);
        }
        return false;
    }

    private void createObject(DBFolder importFol, DBFolder localFol, DBObject importObj) {
        DBObject localObj = new DBObject();
        localObj.setFlags(importObj.getFlags());
        for (DBObjProperty importObjProp : importObj.getProperties()) {
            if (importObjProp.getName().equals("fmea.model.id")) {
                this._objectFolders.add(importFol);
                continue;
            }
            DBObjProperty localObjProp = new DBObjProperty(importObjProp);
            localObjProp.setID(-1L);
            localObj.addProperty(localObjProp);
        }
        for (DBObjModel importObjMod : importObj.getModels()) {
            String dbFormat = importObjMod.getFormat();
            if (dbFormat.equals("XML") || dbFormat.equals("ZML")) {
                this._objectFolders.add(importFol);
                continue;
            }
            DBObjModel localObjMod = new DBObjModel(importObjMod);
            localObjMod.setID(-1L);
            localObjMod.setStreamToSave(this._daoImport.createObjModelDAO().getBinaryStream(importObjMod));
            localObj.addModel(localObjMod);
        }
        localObj.setLocked(this._dbSession);
        localFol.setObject(localObj);
    }

    private boolean updateFolder(DBFolder importFol, ChoiceImport choice) {
        try {
            DBFolder localFol = choice.getFolderLocal();
            if (localFol == null) {
                throw new NullPointerException();
            }
            localFol.setName(importFol.getName());
            localFol.setDescription(importFol.getDescription());
            localFol.setDateCreate(importFol.getDateCreate());
            localFol.setDateModify(importFol.getDateModify());
            DBObject importObj = importFol.getObject();
            if (importObj != null) {
                DBObject localObj = localFol.getObject();
                if (localObj == null) {
                    this.createObject(importFol, localFol, importObj);
                } else {
                    if (!localObj.isFreeze()) {
                        localObj.setFlags(importObj.getFlags());
                    }
                    for (DBObjProperty importObjProp : importObj.getProperties()) {
                        if (importObjProp.getName().equals("fmea.model.id")) {
                            this._objectFolders.add(importFol);
                            continue;
                        }
                        DBObjProperty localObjProp = localObj.getProperty(importObjProp.getName());
                        if (localObjProp == null) {
                            localObjProp = new DBObjProperty(importObjProp);
                            localObjProp.setID(-1L);
                            localObj.addProperty(localObjProp);
                            continue;
                        }
                        if (importObjProp.getType().isEmpty() || importObjProp.getValue().equals(localObjProp.getValue()) && importObjProp.getType().equals(localObjProp.getType())) continue;
                        localObjProp.setValue(importObjProp.getValue());
                        localObjProp.setType(importObjProp.getType());
                    }
                    for (DBObjModel importObjMod : importObj.getModels()) {
                        String dbFormat = importObjMod.getFormat();
                        if (dbFormat.equals("XML") || dbFormat.equals("ZML")) {
                            this._objectFolders.add(importFol);
                            continue;
                        }
                        DBObjModel localObjMod = localObj.getModel(importObjMod.getNature());
                        if (localObjMod == null) {
                            localObjMod = new DBObjModel(importObjMod);
                            localObjMod.setID(-1L);
                            localObjMod.setStreamToSave(this._daoImport.createObjModelDAO().getBinaryStream(importObjMod));
                            localObj.addModel(localObjMod);
                            continue;
                        }
                        if (importObjMod.getSize() == 0L || importObjMod.getFormat().isEmpty() || !importObjMod.getCRC().isEmpty() && importObjMod.getSize() == localObjMod.getSize() && importObjMod.getFormat().equals(localObjMod.getFormat()) && importObjMod.getCRC().equals(localObjMod.getCRC())) continue;
                        localObjMod.setFormat(importObjMod.getFormat());
                        localObjMod.setCRC(importObjMod.getCRC());
                        localObjMod.setSize(importObjMod.getSize());
                        localObjMod.setStreamToSave(this._daoImport.createObjModelDAO().getBinaryStream(importObjMod));
                    }
                }
            } else if (localFol.getObject() != null) {
                localFol.setObject(null);
            }
            if (this._daoFolderLocal.update(localFol)) {
                localFol.setMustBeUpdated(true);
                return true;
            }
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Realise-Import | Exception during updateFolder:" + importFol, th);
        }
        return false;
    }

    private void createOrUpdateXMLStream() {
        HashMap<Long, Long> mapID = new HashMap<Long, Long>();
        this.constructMapID(mapID);
        for (DBFolder importFol : this._objectFolders) {
            if (this._daoLocal.withExceptionDuringTransaction()) {
                return;
            }
            if (this.createOrUpdateXMLStream(importFol, mapID)) continue;
            _LOG.info("Realise-Import | error during change XML stream:" + importFol);
            this.addError(importFol, ResMsgObj.getString("MSG_ERR_DB_FOL_IMPORT_UPDATE_XML"));
        }
    }

    private void constructMapID(Map<Long, Long> mapID) {
        DBFolder dbRoot = this._daoImport.createFolderDAO().getRootID("ROOT");
        this.constructMapID_rec(dbRoot, mapID);
    }

    private void constructMapID_rec(DBFolder importFol, Map<Long, Long> mapID) {
        List<DBFolder> childrenI;
        ChoiceImport choice = this._mapChoice.get(importFol);
        if (choice == null) {
            throw new NullPointerException("No choice for DBFolder:" + importFol);
        }
        if (choice.getFolderLocal() == null) {
            throw new NullPointerException("No local folder for DBFolder:" + importFol);
        }
        mapID.put(importFol.getID(), choice.getFolderLocal().getID());
        if (!importFol.isVersion() && (childrenI = importFol.getChildren()) != null) {
            for (int i = 0; i < childrenI.size(); ++i) {
                this.constructMapID_rec(childrenI.get(i), mapID);
            }
        }
    }

    private boolean createOrUpdateXMLStream(DBFolder importFol, Map<Long, Long> mapID) {
        _LOG.finest("Realise-Import | updateStream:" + importFol);
        try {
            ChoiceImport choice = this._mapChoice.get(importFol);
            DBFolder localFol = choice.getFolderLocal();
            DBObject importObj = importFol.getObject();
            DBObject localObj = localFol.getObject();
            LinkedHashSet<Long> relationSources = new LinkedHashSet<Long>();
            for (DBObjProperty importObjProp : importObj.getProperties()) {
                long importID;
                boolean create;
                if (!importObjProp.getName().equals("fmea.model.id")) continue;
                DBObjProperty localObjProp = localObj.getProperty(importObjProp.getName());
                boolean bl = create = localObjProp == null;
                if (create) {
                    localObjProp = new DBObjProperty(importObjProp);
                    localObjProp.setID(-1L);
                    localObj.addProperty(localObjProp);
                }
                if ((importID = DBObjProperty.getObjectRelease(importObjProp)) == -1L) continue;
                Long localID = mapID.get(importID);
                if (localID == null) {
                    _LOG.warning("convertXMLLine with bad refID : " + importID);
                    localObjProp.setValue("-1");
                    continue;
                }
                localObjProp.setValue(localID.toString());
                relationSources.add(localID);
            }
            for (DBObjModel importObjMod : importObj.getModels()) {
                String dbFormat = importObjMod.getFormat();
                if (!dbFormat.equals("XML") && !dbFormat.equals("ZML")) continue;
                DBObjModel localObjMod = localObj.getModel(importObjMod.getNature());
                if (localObjMod == null) {
                    localObjMod = new DBObjModel(importObjMod);
                    localObjMod.setID(-1L);
                    localObj.addModel(localObjMod);
                }
                UtilityConvertID.convertXMLStream(this._daoImport.createObjModelDAO(), importObjMod, localObjMod, relationSources, mapID, false);
            }
            localFol.setRelations(this.convertRelation(localFol, relationSources));
            return this._daoFolderLocal.update(localFol);
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Realise-Import | Exception during updateStream:" + importFol, th);
            return false;
        }
    }

    private Collection<DBRelation> convertRelation(DBFolder localFol, Set<Long> relationSources) {
        if (relationSources.size() == 0) {
            return null;
        }
        ArrayList<DBRelation> result = new ArrayList<DBRelation>(relationSources.size());
        for (Long refID : relationSources) {
            result.add(new DBRelation(localFol, (DBFolder)this._daoFolderLocal.find(refID)));
        }
        return result;
    }

    private void updateEGL() {
        if (this._daoLocal instanceof CECFactory) {
            DBFolder dbRoot = this._daoImport.createFolderDAO().getRootID("ROOT");
            this.updateEGL_rec(dbRoot, null);
        }
    }

    private void updateEGL_rec(DBFolder dbFolderI, DBFolder dbParentLocal) {
        List<DBFolder> childrenI;
        if (this._daoLocal.withExceptionDuringTransaction()) {
            return;
        }
        if (dbFolderI.getFamily() != DBFolder.Family.APPLICATION && dbFolderI.getFamily() != DBFolder.Family.PROJECT) {
            return;
        }
        ChoiceImport choice = this._mapChoice.get(dbFolderI);
        if (choice == null) {
            return;
        }
        if (!(!dbFolderI.isVersion() || choice.isConflict() && !choice.isCheckImport() || dbFolderI.getFamilyFlag() != 5 && dbFolderI.getFamilyFlag() != 3 && dbFolderI.getFamilyFlag() != 2)) {
            _LOG.finest("Realise-Import | updateEGL:" + dbFolderI);
            DBFolder dbFolderL = choice.getFolderLocal();
            if (!EGLICmdGenerate.GenerateEGLI((CECFactory)this._daoLocal, dbFolderL)) {
                _LOG.info("Realise-Import | error during updateEGL:" + dbFolderI);
                this.addError(dbFolderI, MsgType.WARNING, ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"));
            }
        }
        if (!dbFolderI.isVersion() && (childrenI = dbFolderI.getChildren()) != null) {
            for (int i = 0; i < childrenI.size(); ++i) {
                this.updateEGL_rec(childrenI.get(i), choice.getFolderLocal());
            }
        }
    }

    public boolean isWithConflict(DBFolder folder) {
        return this._mapConflict.get(folder) != null;
    }

    public void countCreateModel(DemoLimits importLimits) throws DemoLimitedException {
        DBFolder dbRoot = this._daoImport.createFolderDAO().getRootID("ROOT");
        this.countCreateModel_rec(importLimits, dbRoot);
    }

    private void countCreateModel_rec(DemoLimits importLimits, DBFolder dbFolder) throws DemoLimitedException {
        List<DBFolder> dbChildren;
        ChoiceImport choice = this._mapChoice.get(dbFolder);
        if (choice == null) {
            throw new NullPointerException();
        }
        if (!dbFolder.isSystem() && !choice.isConflict()) {
            importLimits.incModelCounterFromFolder(dbFolder);
        }
        if (!dbFolder.isVersion() && (dbChildren = dbFolder.getChildren()) != null) {
            for (int i = 0; i < dbChildren.size(); ++i) {
                this.countCreateModel_rec(importLimits, dbChildren.get(i));
            }
        }
    }
}

