/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.imports.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.FolderRenderer;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.io.imports.ChoiceImport;
import com.dassault.cecilia.io.imports.MapImport;
import com.dassault.cecilia.io.imports.gui.DlgImportAbstract;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DlgImportTable
extends DlgImportAbstract {
    private static Logger _LOG = Logger.getLogger(DlgImportTable.class.getPackage().getName());
    ImportTableModel _modelTree;
    JTable _ctrlTree;

    public DlgImportTable(Window owner, MapImport mapImport) {
        super(owner, mapImport);
    }

    @Override
    protected JComponent createTreeTable() {
        DAOFolder daoFolder = this._mapImport.getDAOImport().createFolderDAO();
        this._modelTree = new ImportTableModel(daoFolder);
        this._ctrlTree = new JTable(this._modelTree);
        TableColumnModel colModel = this._ctrlTree.getColumnModel();
        block5: for (int col = 0; col < colModel.getColumnCount(); ++col) {
            TableColumn tcol = colModel.getColumn(col);
            switch (col) {
                case 1: 
                case 2: 
                case 3: {
                    tcol.setCellRenderer(new DlgImportAbstract.CheckImportRenderer(col));
                    tcol.setCellEditor(new DlgImportAbstract.CheckImportEditor(this._ctrlTree, col));
                    tcol.setPreferredWidth(250);
                    continue block5;
                }
                case 0: {
                    tcol.setPreferredWidth(250);
                    tcol.setCellRenderer(new FolderRenderer(){

                        @Override
                        protected String convertFolderToText(DBFolder folder) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = folder.getDepthUntilRoot() - 2; i >= 0; --i) {
                                sb.append("   ");
                            }
                            sb.append(super.convertFolderToText(folder));
                            return sb.toString();
                        }
                    });
                    continue block5;
                }
                case 4: {
                    tcol.setPreferredWidth(250);
                }
            }
        }
        this._ctrlTree.setPreferredScrollableViewportSize(new Dimension(500, 400));
        return this._ctrlTree;
    }

    @Override
    protected void changeFilter() {
    }

    @Override
    protected void goNext() {
    }

    @Override
    protected void goPrev() {
    }

    @Override
    protected List<DBFolder> getSelectedFolders() {
        return null;
    }

    class ImportTableModel
    extends AbstractTableModel {
        DAOFolder _daoFolder;
        List<DBFolder> _allFolders;

        public ImportTableModel(DAOFolder daoFolder) {
            this._daoFolder = daoFolder;
            this.refresh();
        }

        private void recup_rec(DBFolder dbFolder, boolean add) {
            if (add) {
                this._allFolders.add(dbFolder);
            }
            if (dbFolder.isVersion()) {
                return;
            }
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                _LOG.fine("No children for folder: " + dbFolder);
                return;
            }
            for (int i = 0; i < children.size(); ++i) {
                this.recup_rec(children.get(i), true);
            }
        }

        protected void refresh() {
            DBFolder dbRoot = this._daoFolder.getRootID("ROOT");
            this._allFolders = new ArrayList<DBFolder>(512);
            this.recup_rec(dbRoot, false);
        }

        @Override
        public int getRowCount() {
            return this._allFolders.size();
        }

        protected DBFolder getFolder(int row) {
            return this._allFolders.get(row);
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_PATH");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_IMPORT");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_DATABASE");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_ERROR");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_INFORMATIONS");
                }
            }
            return super.getColumnName(col);
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return DBFolder.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBFolder dbFolder = this.getFolder(row);
            switch (col) {
                case 0: {
                    return dbFolder;
                }
                case 2: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    return DlgImportTable.this._mapImport.getChoice(dbFolder).isCheckImport();
                }
                case 3: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    return DlgImportTable.this._mapImport.getChoice(dbFolder).isCheckBase();
                }
                case 4: {
                    if (dbFolder.isSystem()) {
                        return "";
                    }
                    return DlgImportTable.this._mapImport.getChoice(dbFolder).getMsg();
                }
                case 1: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    return DlgImportTable.this._mapImport.getChoice(dbFolder).isCheckError();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            DBFolder dbFolder = this.getFolder(row);
            switch (col) {
                case 2: 
                case 3: {
                    if (dbFolder.isSystem()) {
                        return false;
                    }
                    ChoiceImport choice = DlgImportTable.this._mapImport.getChoice(dbFolder);
                    if (choice.isCheckError()) {
                        return false;
                    }
                    if (choice.isFreeze()) {
                        return false;
                    }
                    if (choice.isReadOnly()) {
                        return false;
                    }
                    return choice.isConflict();
                }
                case 1: 
                case 4: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            DBFolder dbFolder;
            if (!(col != 2 && col != 3 || (dbFolder = this.getFolder(row)).isSystem())) {
                boolean value = (Boolean)aValue;
                if (col == 3) {
                    value = !value;
                }
                DlgImportTable.this._mapImport.selectChoice(Collections.singleton(dbFolder), value);
                DlgImportTable.this._modelTree.fireTableRowsUpdated(row, row);
            }
        }
    }
}

