/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.trees;

import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.io.trees.CmdImportTreeAbstract;
import com.dassault.cecilia.io.trees.UtilityImportTreeArb;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.io.File;
import java.util.ArrayList;

public class CmdImportTreeArb
extends CmdImportTreeAbstract {
    public CmdImportTreeArb(CeciliaAppl appl, DBFolderTreeEditable owner, DBFolder dbFolder) {
        super(appl, owner, dbFolder);
    }

    @Override
    protected String getTitle() {
        return ResMsgCecilia.getString("MENU_IMPORT_ARB");
    }

    @Override
    protected FileFilterExtention createFileFilter() {
        return new FileFilterExtention(ResMsgObj.getString("FILE_TYPE_ARB"), ".arb");
    }

    @Override
    protected String getImportName(File importFile) {
        String name = importFile.getName();
        int defLen = name.length();
        if (defLen > 4 && name.substring(defLen - 4).equalsIgnoreCase(".ARB")) {
            name = name.substring(0, defLen - 4);
        }
        return DBFactory.convertName(name);
    }

    @Override
    protected void firstDo() {
        UtilityImportTreeArb utility = new UtilityImportTreeArb(this.getAppl()){

            @Override
            protected void addError(File folder, MsgType type, String msg) {
                CmdImportTreeArb.this.addError(folder, type, msg);
            }
        };
        ArrayList<DBFolder> dbVersions = new ArrayList<DBFolder>(this._importFiles.length);
        for (CmdImportTreeAbstract.FileInfos fInfos : this._filesAll) {
            DBFolder dbVersion = utility.doImportFile((File)fInfos.getItem(), this._dstFolder, fInfos.getName(), fInfos.getConfict());
            if (dbVersion == null) continue;
            dbVersions.add(dbVersion);
        }
        this.finishDo(dbVersions);
    }
}

