/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolTranslateParser;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.io.xml6.PerformExportXML6;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasTranslate;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class AnonymizeExportXML6
extends PerformExportXML6 {
    private static Logger _LOG = Logger.getLogger(PerformExportXML6.class.getName());
    OcasAnonymize _parser = new OcasAnonymize();
    ConvertHelper _helperFolder = new ConvertHelper("path", "General.Folder");
    ConvertHelper _helperAttr = new ConvertHelper("attr", "General.Attribute");
    ConvertHelper _helperFTCrit = new ConvertHelper("C", "General.Criticity");
    ConvertHelper _helperVar = new ConvertHelper("var", "MBSA.Var");
    ConvertHelper _helperEvent = new ConvertHelper("evt", "MBSA.Event");
    ConvertHelper _helperEnum = new ConvertHelper("enum", "MBSA.Domain.Enum");
    ConvertHelper _helperField = new ConvertHelper("field", "MBSA.Domain.Field");
    ConvertHelper _helperFct = new ConvertHelper("fct", "MBSA.Operator");
    ConvertHelper _helperSub = new ConvertHelper("sub", "MBSA.Sub");
    ConvertHelper _helperSheet = new ConvertHelper("sheet", "MBSA.Sheet");
    ConvertHelper _helperConfig = new ConvertHelper("config", "MBSA.Config");
    ConvertHelper _helperFTEvent = new ConvertHelper("E", "FaultTree.Event");
    ConvertHelper _helperFTGate = new ConvertHelper("G", "FaultTree.Gate");
    ConvertHelper _helperFTRoot = new ConvertHelper("R", "FaultTree.Root");
    ConvertHelper _helperFTGeneric = new ConvertHelper("_", "FaultTree.Generic");
    ConvertHelper[] _itemExports = new ConvertHelper[]{this._helperFolder, this._helperAttr, this._helperFTCrit, this._helperVar, this._helperEvent, this._helperEnum, this._helperField, this._helperFct, this._helperSub, this._helperSheet, this._helperConfig, this._helperFTEvent, this._helperFTGate, this._helperFTRoot, this._helperFTGeneric};
    Set<Long> _attributesEnumID = new HashSet<Long>();
    int _countIcon = 0;
    boolean _withLawParameters = false;
    DBObjModel _txtDBModel = null;
    String _txtElement = null;
    StringBuilder _txtBuffer = null;
    boolean _bReadSync = false;
    Map<String, String> _mapBigTree = null;
    Set<String> _currentVariables = new HashSet<String>();
    String _currentFct = null;
    boolean _previousAverageComputeAttributeIsEnum = false;
    List<String> _previousLawTypes = new ArrayList<String>();
    List<Integer> _previousParamIdxs = new ArrayList<Integer>();
    DAOFactory _daoFactory;
    Date _beginDate = new Date();
    private static Map<String, double[]> _lawDefaultValues = new HashMap<String, double[]>();
    private Map<String, Pattern> _mapPattern = new HashMap<String, Pattern>();

    public AnonymizeExportXML6(DAOFactory daoFactory, Set<DBFolder> foldersToExport) {
        super(daoFactory, foldersToExport);
        this._daoFactory = daoFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(File reportFile) throws IOException {
        try (Writer output = null;){
            output = new BufferedWriter(new FileWriter(reportFile));
            for (ConvertHelper convertHelper : this._itemExports) {
                convertHelper.generateReport(output);
            }
            output.flush();
        }
    }

    public void setWithLawParameters(boolean value) {
        this._withLawParameters = value;
    }

    @Override
    protected Appendable exportFolder(Writer out, DBFolder dbFolder) throws IOException {
        if (dbFolder.isVersion()) {
            switch (dbFolder.getFamily()) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    return DBObjectXmlUtility.appendXML(out, this._helperFolder.findOrCreate(dbFolder.getName()));
                }
            }
            return super.exportFolder(out, dbFolder);
        }
        if (dbFolder.isModel() && dbFolder.getFamily() == DBFolder.Family.OPERATOR) {
            return DBObjectXmlUtility.appendXML(out, this._helperFct.findOrCreate(dbFolder.getName()));
        }
        return DBObjectXmlUtility.appendXML(out, this._helperFolder.findOrCreate(dbFolder.getName()));
    }

    @Override
    protected void exportLabel(Writer out, DBFolder dbCurr) throws IOException {
    }

    @Override
    protected void exportDate(Writer out, Date date, String attrDate) throws IOException {
        if (date != null) {
            out.append(" ").append(attrDate).append("='").append(Long.toString(this._beginDate.getTime())).append("'");
        }
    }

    @Override
    protected void exportProperty(Writer out, DBObjProperty dbProp, String indent) throws IOException {
        switch (dbProp.getName()) {
            case "object.creator": {
                break;
            }
            case "btp.substantiation.date": {
                out.append(indent).append("<").append("cec.property");
                out.append(" ").append("name").append("='").append("btp.substantiation.date").append("'");
                out.append(" ").append("type").append("='").append("Date").append("'");
                out.append(" ").append("value").append("='01/01/1970'");
                out.append("/>\n");
                break;
            }
            default: {
                super.exportProperty(out, dbProp, indent);
            }
        }
    }

    @Override
    protected List<DBObjModel> sortModels(Collection<DBObjModel> dbModels) {
        List<DBObjModel> listModels = super.sortModels(dbModels);
        DBObjModel dagModel = null;
        Iterator<DBObjModel> iter = listModels.iterator();
        while (iter.hasNext()) {
            DBObjModel dbModel = iter.next();
            if (!dbModel.getNature().equals("tree.dag")) continue;
            dagModel = dbModel;
            iter.remove();
            break;
        }
        if (dagModel != null) {
            listModels.add(dagModel);
        }
        return listModels;
    }

    @Override
    protected boolean canExportInBase64(DBObjModel dbModel) {
        return dbModel.getNature().equals("image");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportModel_ZIP(Writer out, DBObjModel dbModel, String indent) throws IOException {
        if (!dbModel.getNature().equals("image")) {
            super.exportModel_ZIP(out, dbModel, indent);
            return;
        }
        File tmpFile = null;
        try {
            ImageIcon icon = DBIcon.readImage(dbModel.getObject().getFolder(), this._daoFactory);
            Graphics2D graph = null;
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage image = new BufferedImage(width, height, 1);
            graph = image.createGraphics();
            graph.setClip(0, 0, width, height);
            graph.setColor(Color.white);
            graph.fillRect(0, 0, width, height);
            graph.setColor(Color.black);
            graph.drawRect(0, 0, width - 1, height - 1);
            if (this._countIcon < 676) {
                int strWidth = Integer.MAX_VALUE;
                int strHeight = Integer.MAX_VALUE;
                int strAscent = 10;
                int size = 17;
                while ((strWidth > width - 4 || strHeight > height - 4) && --size != 0) {
                    graph.setFont(new Font("Monospaced", 0, size));
                    FontMetrics fm = graph.getFontMetrics();
                    strWidth = fm.stringWidth("AA");
                    strHeight = fm.getHeight();
                    strAscent = fm.getAscent();
                }
                if (size > 0) {
                    String txt;
                    if (this._countIcon < 26) {
                        txt = "" + (char)(65 + this._countIcon);
                        graph.drawString(txt, (width - strWidth / 2) / 2, (height + strAscent) / 2);
                    } else {
                        txt = "" + (char)(65 + this._countIcon / 26 - 1) + (char)(65 + this._countIcon % 26);
                        graph.drawString(txt, (width - strWidth) / 2, (height + strAscent) / 2);
                    }
                    ++this._countIcon;
                }
            }
            String ext = dbModel.getFormat().toLowerCase();
            tmpFile = File.createTempFile("Anonymise", "." + ext);
            ImageIO.write((RenderedImage)image, ext, tmpFile);
            long length = tmpFile.length();
            byte[] bytes = new byte[(int)length];
            try (InputStream in = null;){
                in = new BufferedInputStream(new FileInputStream(tmpFile));
                in.read(bytes);
            }
            this.exportModel_ZIP(out, new ByteArrayInputStream(bytes));
        }
        catch (Throwable th) {
            _LOG.log(Level.INFO, "Probleme lors de la sauvegarde de l'image : " + dbModel.getObject().getFolder().getRefPath(), th);
        }
        finally {
            if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    @Override
    protected void exportCRCModel(Writer out, DBObjModel dbModel) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportModel_ZML(Writer out, DBObjModel dbModel, String indent, boolean inflater) throws IOException {
        InputStream istream = this._daoObjModel.getBinaryStream(dbModel);
        BufferedReader input = null;
        try {
            String line;
            if (inflater) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            input = new BufferedReader(new InputStreamReader(istream, StandardCharsets.UTF_8));
            this._bReadSync = false;
            indent = indent + "  ";
            while ((line = input.readLine()) != null) {
                this.exportLine_ZML(out, line, dbModel, indent);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    _LOG.log(Level.FINE, "Exception during close binary stream : " + dbModel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportModel_DAG(Writer out, DBObjModel dbModel, String indent) throws IOException {
        InputStream istream = this._daoFactory.createObjModelDAO().getBinaryStream(dbModel);
        if (istream == null) {
            throw new IOException("Probleme au niveau de la base de donnee pour recuperer le flux d'equation");
        }
        InflaterInputStream iInflaterStream = new InflaterInputStream(istream, new Inflater());
        BufferedReader iReader = new BufferedReader(new InputStreamReader(iInflaterStream));
        File tmpFile = File.createTempFile("Anonynize", ".dag");
        try {
            try (Writer tmpWriter = null;){
                tmpWriter = new FileWriter(tmpFile);
                tmpWriter = new BufferedWriter(tmpWriter);
                EquBoolTranslateParser translateParser = new EquBoolTranslateParser(iReader, tmpWriter){
                    ConvertHelper helperGate;
                    {
                        this.helperGate = new ConvertHelper("g", "BEDagGate");
                    }

                    @Override
                    protected String translateIdentifier(String id) {
                        String tr = AnonymizeExportXML6.this._mapBigTree.get(id);
                        if (tr == null) {
                            tr = this.helperGate.findOrCreate(id);
                        }
                        return tr;
                    }
                };
                translateParser.run();
                tmpWriter.flush();
            }
            istream = new FileInputStream(tmpFile);
            this.exportModel_ZIP(out, new DeflaterInputStream(istream));
        }
        finally {
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    private boolean txtStart(String line, String code, int startTxt, Writer out) throws IOException {
        this._txtElement = code;
        this._txtBuffer = new StringBuilder();
        int pos = line.indexOf("</" + this._txtElement + ">");
        if (pos == -1) {
            this._txtBuffer.append(line.substring(startTxt)).append("\n");
        } else {
            this._txtBuffer.append(line.substring(startTxt, pos));
            this.exportTxt_ZML(out, this._txtElement, this._txtBuffer.toString());
            out.append("</").append(this._txtElement).append(">\n");
            this._txtElement = null;
            this._txtBuffer = null;
            this._txtDBModel = null;
        }
        return true;
    }

    private boolean txtTreatLine(String line, Writer out, String indent) throws IOException {
        int pos = line.indexOf("</" + this._txtElement + ">");
        if (pos == -1) {
            this._txtBuffer.append(line).append("\n");
        } else {
            this._txtBuffer.append(line.substring(0, pos));
            this.exportTxt_ZML(out, this._txtElement, this._txtBuffer.toString());
            out.append("</").append(this._txtElement).append(">\n");
            this._txtElement = null;
            this._txtBuffer = null;
            this._txtDBModel = null;
        }
        return true;
    }

    private void exportTxt_ZML(Writer out, String code, String txt) throws IOException {
        DBFolder dbFolder;
        if (code.equals("label") || code.equals("alga.text")) {
            out.append("...");
            return;
        }
        if (code.equals("alta.code") && this._txtDBModel != null && this._txtDBModel.getObject() != null && (dbFolder = this._txtDBModel.getObject().getFolder()) != null) {
            switch (dbFolder.getFamily()) {
                case OPERATOR: {
                    txt = StringUtilities.convertFromXML((String)txt);
                    this._parser.restart(new StringReader(txt), 258);
                    this._parser.run();
                    out.append(StringUtilities.convertToXML((String)this._parser.getCode()));
                    return;
                }
                case PROJECT: {
                    if (dbFolder.getFamilyFlag() == 1) {
                        txt = "assert\n" + StringUtilities.convertFromXML((String)txt);
                        this._parser.restart(new StringReader(txt), 257);
                        this._parser.run();
                        txt = this._parser.getCode();
                        if (txt.startsWith("assert\n")) {
                            txt = txt.substring(7);
                        }
                        out.append(StringUtilities.convertToXML((String)txt));
                    }
                    return;
                }
                case COMPONENT: 
                case EQUIPMENT: {
                    txt = StringUtilities.convertFromXML((String)txt);
                    this._parser.restart(new StringReader(txt), 257);
                    this._parser.run();
                    out.append(StringUtilities.convertToXML((String)this._parser.getCode()));
                    return;
                }
            }
        }
    }

    private boolean exportLine_ZML(Writer out, String line, DBObjModel dbModel, String indent) throws IOException {
        if (this._txtElement != null) {
            return this.txtTreatLine(line, out, indent);
        }
        String trim = line.trim();
        if (trim.startsWith("<?")) {
            return true;
        }
        if (trim.startsWith("<alta.code>")) {
            this._txtDBModel = dbModel;
            int startPos = line.indexOf("<alta.code>");
            int endPos = startPos + "<alta.code>".length();
            out.append(indent).append(line.substring(0, endPos));
            return this.txtStart(line, "alta.code", endPos, out);
        }
        if (trim.startsWith("<label>")) {
            int startPos = line.indexOf("<label>");
            int endPos = startPos + "<label>".length();
            out.append(indent).append(line.substring(0, endPos));
            return this.txtStart(line, "label", endPos, out);
        }
        if (trim.startsWith("<alga.text ")) {
            int startPos = line.indexOf("<alga.text ");
            int endPos = line.indexOf(">", startPos + 1) + 1;
            out.append(indent).append(line.substring(0, endPos));
            return this.txtStart(line, "alga.text", endPos, out);
        }
        if (trim.startsWith("<cec.attribute ") && trim.contains("type='enum'")) {
            this._attributesEnumID.add(dbModel.getObject().getFolder().getID());
        } else if (trim.startsWith("<attribute.enum ")) {
            line = this.extractAndReplace(line, "name", this._helperAttr);
        } else if (trim.startsWith("<attribute ")) {
            if (this.isAttrEnum(line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder), "refID")) {
                line = this.extractAndReplace(line, "value", this._helperAttr);
            }
        } else if (trim.startsWith("<enum.field ")) {
            line = this.extractAndReplace(line, "value", this._helperEnum);
        } else if (trim.startsWith("<link.field ")) {
            line = this.extractAndReplace(line, "name", this._helperField);
            line = this.extractAndReplace(line, "cross", this._helperField);
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<cec.operator ")) {
            this._currentVariables.clear();
            this._currentFct = dbModel.getObject().getFolder().getParent().getName();
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("</cec.operator>")) {
            this._currentFct = null;
        } else if (trim.startsWith("<cec.component ")) {
            this._currentVariables.clear();
        } else if (trim.startsWith("<cec.equipment ")) {
            this._currentVariables.clear();
            this._bReadSync = true;
        } else if (trim.startsWith("</cec.equipment>")) {
            this._bReadSync = false;
        } else if (trim.startsWith("<cec.mbsa")) {
            this._currentVariables.clear();
            this._bReadSync = true;
        } else if (trim.startsWith("</cec.mbsa>")) {
            this._bReadSync = false;
        } else if (trim.startsWith("<alta.icon ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.simul ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.flow ")) {
            this._currentVariables.add(this.extract(line, "name"));
            line = this.extractAndReplace(line, "name", this._helperVar);
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.state ")) {
            this._currentVariables.add(this.extract(line, "name"));
            line = this.extractAndReplace(line, "name", this._helperVar);
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
            line = this.extractAndReplaceEnumValue(line, "value", this._helperEnum);
        } else if (trim.startsWith("<alta.event ")) {
            line = this._bReadSync ? this.extractAndReplaceSubPath(line, "name", this._helperEvent) : this.extractAndReplace(line, "name", this._helperEvent);
        } else if (trim.startsWith("<parameter.ref ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
            if (this._withLawParameters) {
                int idx = this._previousParamIdxs.get(this._previousParamIdxs.size() - 1);
                this._previousParamIdxs.set(this._previousParamIdxs.size() - 1, idx + 1);
            }
        } else if (trim.startsWith("<application ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<author ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<subtantiation ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<frb ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<attribute ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.operator.ref ")) {
            line = this.extractAndReplace(line, "name", this._helperFct);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder, this._helperFct);
        } else if (trim.startsWith("<alta.sub ")) {
            line = this.extractAndReplace(line, "name", this._helperSub);
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.link ")) {
            line = this.extractAndReplaceLink(line, "from");
            line = this.extractAndReplaceLink(line, "to");
        } else if (trim.startsWith("<alta.sync ")) {
            line = this.extractAndReplace(line, "name", this._helperEvent);
        } else if (trim.startsWith("<alta.config ")) {
            line = this.extractAndReplace(line, "name", this._helperConfig);
        } else if (trim.startsWith("<alta.init ")) {
            line = this.extractAndReplaceSubPath(line, "name", this._helperVar);
            line = this.extractAndReplaceEnumValue(line, "value", this._helperEnum);
        } else if (trim.startsWith("<alga.sheet ")) {
            line = this.extractAndReplace(line, "name", this._helperSheet);
        } else if (trim.startsWith("<alga.node ")) {
            line = this.extractAndReplace(line, "name", this._helperSub);
        } else if (trim.startsWith("<alga.port ")) {
            line = this.extractAndReplace(line, "name", this._helperVar);
        } else if (trim.startsWith("<alga.icon ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<alta.colors.type ")) {
            line = this.extractAndReplaceTypeEnum(line, "type", this._helperEnum);
        } else if (trim.startsWith("<alta.colors.case ")) {
            line = this.extractAndReplaceEnumValue(line, "value", this._helperEnum);
        } else if (trim.startsWith("<ft.var ")) {
            line = this._mapBigTree != null ? this.extractAndTransformVarBigTree(line) : (trim.contains("isRoot='true'") ? this.extractAndReplace(line, "name", this._helperFTRoot) : (trim.contains("isLeaf='true'") ? this.extractAndReplace(line, "name", this._helperFTEvent) : this.extractAndReplace(line, "name", this._helperFTGate)));
        } else if (trim.startsWith("<ft.link ")) {
            if ((line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder)).contains("addIfGeneric='")) {
                line = this.extractAndReplace(line, "addIfGeneric", this._helperFTGeneric);
            }
        } else if (trim.startsWith("<dsf.link ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<ft.criticity ")) {
            line = this.extractAndReplace(line, "value", this._helperFTCrit);
        } else if (trim.startsWith("<ft.ccf ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<ft.cfg.dsf ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<ft.cfg.ccf ")) {
            line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder);
        } else if (trim.startsWith("<ft.cfg")) {
            line = this.extractAndReplace(line, "name", this._helperConfig);
        } else if (trim.startsWith("<cec.params.average.compute ")) {
            if (this.isAttrEnum(line = this.extractAndReplaceRefPath(line, "refPath", this._helperFolder), "refID")) {
                this._previousAverageComputeAttributeIsEnum = true;
            }
        } else if (trim.startsWith("</cec.params.average.compute>")) {
            this._previousAverageComputeAttributeIsEnum = false;
        } else if (trim.startsWith("<cec.params.average.compute.item ")) {
            if (this._previousAverageComputeAttributeIsEnum) {
                line = this.extractAndReplace(line, "data", this._helperAttr);
            }
        } else if (trim.startsWith("<cec.params.criticities.compute.item ")) {
            line = this.extractAndReplace(line, "name", this._helperFTCrit);
        } else if (trim.startsWith("<cec.faulttree isBigTree='true'")) {
            this._mapBigTree = new HashMap<String, String>();
        } else if (this._withLawParameters) {
            if (trim.startsWith("<law ") || trim.startsWith("<law.modifier ") || trim.startsWith("<parameter.law ") || trim.startsWith("<cec.parameter ")) {
                Pattern pattern = this.createPattern("type");
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) {
                    _LOG.info("Don't find 'type' attribute for law: " + line);
                    this._previousLawTypes.add("unknown");
                } else {
                    this._previousLawTypes.add(matcher.group(1));
                }
                this._previousParamIdxs.add(0);
            } else if (trim.startsWith("<inspected>") || trim.startsWith("<inflight>")) {
                this._previousLawTypes.add("delay");
                this._previousParamIdxs.add(0);
            } else if (trim.startsWith("<parameter.value ")) {
                line = this.anonymiseValue(line, "value");
                int idx = this._previousParamIdxs.get(this._previousParamIdxs.size() - 1);
                this._previousParamIdxs.set(this._previousParamIdxs.size() - 1, idx + 1);
            } else if (trim.startsWith("</law>") || trim.startsWith("</law.modifier>") || trim.startsWith("</cec.parameter>") || trim.startsWith("</inspected>") || trim.startsWith("</inflight>")) {
                this._previousLawTypes.remove(this._previousLawTypes.size() - 1);
                this._previousParamIdxs.remove(this._previousParamIdxs.size() - 1);
            } else if (trim.startsWith("</parameter.law>")) {
                this._previousLawTypes.remove(this._previousLawTypes.size() - 1);
                this._previousParamIdxs.remove(this._previousParamIdxs.size() - 1);
                int idx = this._previousParamIdxs.get(this._previousParamIdxs.size() - 1);
                this._previousParamIdxs.set(this._previousParamIdxs.size() - 1, idx + 1);
            }
        }
        if (trim.startsWith("<")) {
            out.append(indent);
        }
        out.append(line).append("\n");
        return true;
    }

    private String extractAndTransformVarBigTree(String line) {
        String translate = null;
        String export = null;
        String name = null;
        Pattern pattern = this.createPattern("name");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            _LOG.warning("Don't find 'name' attribute: " + line);
            return line;
        }
        name = matcher.group(1);
        if (name.isEmpty() || name.trim().isEmpty()) {
            _LOG.warning("Empty 'name' attribute: " + line);
            return line;
        }
        translate = line.contains("isRoot='true'") ? this._helperFTRoot.findOrCreate(name) : this._helperFTEvent.findOrCreate(name);
        line = matcher.replaceFirst(" name='" + translate + "'");
        pattern = this.createPattern("export");
        matcher = pattern.matcher(line);
        if (matcher.find()) {
            export = matcher.group(1);
            if (name.isEmpty() || name.trim().isEmpty()) {
                export = null;
            }
            line = matcher.replaceFirst(" export='" + translate + "'");
        }
        if (export == null) {
            export = name;
        }
        export = StringUtilities.convertFromXML((String)export);
        this._mapBigTree.put(export, translate);
        return line;
    }

    private double anonymiseValue(String lawType, int paramIdx) {
        double[] defValues = _lawDefaultValues.get(lawType);
        if (defValues != null) {
            double defValue = defValues[0];
            if (paramIdx >= 0 && paramIdx < defValues.length) {
                defValue = defValues[paramIdx];
            }
            return defValue;
        }
        return Double.NaN;
    }

    private String anonymiseValue(String line, String name) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        if (this._previousLawTypes.isEmpty()) {
            _LOG.info("Anonymise parameter value without law type");
            return line;
        }
        String lawType = this._previousLawTypes.get(this._previousLawTypes.size() - 1);
        int paramIdx = this._previousParamIdxs.get(this._previousParamIdxs.size() - 1);
        switch (lawType) {
            case "Dirac": {
                if (Double.parseDouble(value) == 0.0) break;
                line = matcher.replaceFirst(" " + name + "='10'");
                break;
            }
            default: {
                double defValue = this.anonymiseValue(lawType, paramIdx);
                if (defValue < 0.0) {
                    String lawType2 = this._previousLawTypes.get(this._previousLawTypes.size() - 2);
                    int paramIdx2 = this._previousParamIdxs.get(this._previousParamIdxs.size() - 2);
                    defValue *= -this.anonymiseValue(lawType2, paramIdx2);
                }
                if (Double.isNaN(defValue)) break;
                line = matcher.replaceFirst(" " + name + "='" + defValue + "'");
            }
        }
        return line;
    }

    private Pattern createPattern(String name) {
        Pattern result = this._mapPattern.get(name);
        if (result == null) {
            result = Pattern.compile(" " + name + "='([^']*)'");
            this._mapPattern.put(name, result);
        }
        return result;
    }

    private String extract(String line, String name) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    private String extractAndReplace(String line, String name, ConvertHelper helper) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        line = matcher.replaceFirst(" " + name + "='" + helper.findOrCreate(value) + "'");
        return line;
    }

    private String extractAndReplaceTypeEnum(String line, String name, ConvertHelper helper) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        if (value.startsWith("{") && value.endsWith("}")) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("{");
            StringTokenizer token = new StringTokenizer(value, "{,}");
            while (token.hasMoreTokens()) {
                buffer.append(helper.findOrCreate(token.nextToken()));
                if (!token.hasMoreTokens()) continue;
                buffer.append(",");
            }
            buffer.append("}");
            line = matcher.replaceFirst(" " + name + "='" + buffer.toString() + "'");
        }
        return line;
    }

    private String extractAndReplaceEnumValue(String line, String name, ConvertHelper helper) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        if ((value = value.trim()).equals("true")) {
            return line;
        }
        if (value.equals("false")) {
            return line;
        }
        char first = value.charAt(0);
        if (Character.isDigit(first)) {
            return line;
        }
        if (first == '.') {
            return line;
        }
        return matcher.replaceFirst(" " + name + "='" + helper.findOrCreate(value) + "'");
    }

    private boolean isAttrEnum(String line, String refID) {
        Pattern pattern = this.createPattern(refID);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return false;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return false;
        }
        try {
            long refId = Long.parseLong(value);
            if (!this._attributesEnumID.contains(refId)) {
                return false;
            }
        }
        catch (Exception e) {
            _LOG.fine("Exception lors de la lecture d'un refID: " + e.getMessage());
            return false;
        }
        return true;
    }

    private String extractAndReplaceRefPath(String line, String name, ConvertHelper helper) {
        return this.extractAndReplaceRefPath(line, name, helper, helper);
    }

    private String extractAndReplaceRefPath(String line, String name, ConvertHelper helper, ConvertHelper helperLast) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        int pos = value.lastIndexOf(";");
        if (pos == -1) {
            return matcher.replaceFirst(" " + name + "='" + helper.findOrCreate(value) + "'");
        }
        String version = value.substring(pos);
        value = value.substring(0, pos);
        StringBuilder buffer = new StringBuilder();
        StringTokenizer token = new StringTokenizer(value, "/;");
        while (token.hasMoreTokens()) {
            String path = token.nextToken();
            if (token.hasMoreTokens()) {
                buffer.append(helper.findOrCreate(path));
                buffer.append("/");
                continue;
            }
            buffer.append(helperLast.findOrCreate(path));
        }
        return matcher.replaceFirst(" " + name + "='" + buffer.append(version).toString() + "'");
    }

    private String extractAndReplaceSubPath(String line, String name, ConvertHelper helperEnd) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(value, ".");
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                buffer.append(this._helperSub.findOrCreate(element)).append(".");
                continue;
            }
            buffer.append(helperEnd.findOrCreate(element));
        }
        return matcher.replaceFirst(" " + name + "='" + buffer.toString() + "'");
    }

    private String extractAndReplaceLink(String line, String name) {
        Pattern pattern = this.createPattern(name);
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        String value = matcher.group(1);
        if (value.isEmpty() || value.trim().isEmpty()) {
            return line;
        }
        boolean bField = false;
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(value, ".^", true);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            String separator = null;
            if (tokenizer.hasMoreTokens()) {
                separator = tokenizer.nextToken();
            }
            int pos = element.lastIndexOf("[");
            String index = "";
            if (pos != -1) {
                index = element.substring(pos);
                element = element.substring(0, pos);
            }
            if (separator != null && separator.startsWith(".")) {
                buffer.append(this._helperSub.findOrCreate(element)).append(".");
                continue;
            }
            if (bField) {
                buffer.append(this._helperField.findOrCreate(element)).append(index);
            } else {
                buffer.append(this._helperVar.findOrCreate(element)).append(index);
            }
            if (separator == null || !separator.startsWith("^")) continue;
            buffer.append("^");
            bField = true;
        }
        return matcher.replaceFirst(" " + name + "='" + buffer.toString() + "'");
    }

    static {
        _lawDefaultValues.put("bound-time", new double[]{0.0, 48.0});
        _lawDefaultValues.put("exponential", new double[]{0.001});
        _lawDefaultValues.put("constant", new double[]{0.01});
        _lawDefaultValues.put("GLM", new double[]{0.0, 0.001, 0.01});
        _lawDefaultValues.put("GLMa", new double[]{0.001, 0.01});
        _lawDefaultValues.put("Weibull", new double[]{1000.0, 1.0, 0.0});
        _lawDefaultValues.put("SPT", new double[]{0.001, 730.0, 0.0});
        _lawDefaultValues.put("FPT", new double[]{0.001, 0.001, 0.01, 730.0, 730.0, 0.0, 10.0, 1.0, 1.0, 0.0});
        _lawDefaultValues.put("NRD", new double[]{0.01, 24.0});
        _lawDefaultValues.put("dormant", new double[]{0.001, 48.0, 730.0});
        _lawDefaultValues.put("CMT", new double[]{0.001, 730.0, 0.0});
        _lawDefaultValues.put("Dirac", new double[]{10.0});
        _lawDefaultValues.put("uniform", new double[]{-0.95, -1.05});
        _lawDefaultValues.put("lognormal", new double[]{-1.0, 3.0});
        _lawDefaultValues.put("normal", new double[]{-1.0, 0.01});
        _lawDefaultValues.put("delay", new double[]{10.0});
        _lawDefaultValues.put("rate", new double[]{0.001});
        _lawDefaultValues.put("probability", new double[]{0.01});
        _lawDefaultValues.put("boolean", new double[]{1.0});
        _lawDefaultValues.put("factor", new double[]{1.0});
    }

    class ConvertHelper {
        int _idx = 1;
        Map<String, String> _map = new LinkedHashMap<String, String>();
        String _base;
        String _csvType;

        ConvertHelper(String base, String csvType) {
            this._base = base;
            this._csvType = csvType;
        }

        String findOrCreate(String input) {
            String output = this._map.get(input);
            if (output == null) {
                output = this._base + this._idx++;
                this._map.put(input, output);
            }
            return output;
        }

        public void generateReport(Writer output) throws IOException {
            for (Map.Entry<String, String> entry : this._map.entrySet()) {
                output.append(this._csvType).append(";").append(entry.getValue()).append(";").append(entry.getKey()).append("\n");
            }
        }
    }

    class OcasAnonymize
    extends OcasTranslate {
        protected void appendComment(String str) {
            if (str.startsWith("//")) {
                this.appendTxt("// ...");
            } else if (str.startsWith("/*")) {
                this.appendTxt("/* ...");
            } else if (str.endsWith("*/")) {
                this.appendTxt("*/");
            }
        }

        protected void appendOperator(String name) {
            this.replaceID(name, AnonymizeExportXML6.this._helperFct.findOrCreate(name));
        }

        protected void appendVariable(String name) {
            String code;
            int pos = name.lastIndexOf(94);
            if (pos != -1) {
                code = name.substring(pos + 1);
                name = name.substring(0, pos);
                this.replaceID(code, AnonymizeExportXML6.this._helperField.findOrCreate(code));
            }
            if ((pos = name.lastIndexOf(46)) != -1) {
                code = name.substring(pos + 1);
                name = name.substring(0, pos);
                if (code.equals("icone")) {
                    this.replaceID(code, code);
                } else {
                    this.replaceID(code, AnonymizeExportXML6.this._helperVar.findOrCreate(code));
                }
                pos = name.lastIndexOf(46);
                while (pos != -1) {
                    code = name.substring(pos + 1);
                    name = name.substring(0, pos);
                    this.replaceID(code, AnonymizeExportXML6.this._helperSub.findOrCreate(code));
                }
                if (name.length() > 0) {
                    this.replaceID(name, AnonymizeExportXML6.this._helperSub.findOrCreate(name));
                }
            } else if (name.equals("icone")) {
                this.replaceID(name, name);
            } else if (AnonymizeExportXML6.this._currentFct != null && AnonymizeExportXML6.this._currentFct.equals(name)) {
                this.replaceID(name, AnonymizeExportXML6.this._helperFct.findOrCreate(name));
            } else if (AnonymizeExportXML6.this._currentVariables.contains(name)) {
                this.replaceID(name, AnonymizeExportXML6.this._helperVar.findOrCreate(name));
            } else {
                this.replaceID(name, AnonymizeExportXML6.this._helperEnum.findOrCreate(name));
            }
        }

        protected void appendEvent(String name) {
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                String code = name.substring(pos + 1);
                name = name.substring(0, pos);
                this.replaceID(code, AnonymizeExportXML6.this._helperEvent.findOrCreate(code));
                pos = name.lastIndexOf(46);
                while (pos != -1) {
                    code = name.substring(pos + 1);
                    name = name.substring(0, pos);
                    this.replaceID(code, AnonymizeExportXML6.this._helperSub.findOrCreate(code));
                }
                if (name.length() > 0) {
                    this.replaceID(name, AnonymizeExportXML6.this._helperSub.findOrCreate(name));
                }
            } else {
                this.replaceID(name, AnonymizeExportXML6.this._helperEvent.findOrCreate(name));
            }
        }

        protected void appendVariables(List<String> vars) {
            while (!vars.isEmpty()) {
                String var = vars.remove(vars.size() - 1);
                this.appendVariable(var);
            }
        }

        protected void appendEnums(List<String> IDs) {
            while (!IDs.isEmpty()) {
                String id = IDs.remove(IDs.size() - 1);
                this.replaceID(id, AnonymizeExportXML6.this._helperEnum.findOrCreate(id));
            }
        }
    }
}

