/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.io.AbstractCmdExport;
import com.dassault.cecilia.io.GenerateExport;
import com.dassault.cecilia.io.xml6.AnonymizeExportDlg;
import com.dassault.cecilia.io.xml6.AnonymizeExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CmdAnonymizeXML
extends AbstractCmdExport {
    boolean _bAnonymiseParameters = false;
    String _generateReport = null;

    public CmdAnonymizeXML(CeciliaAppl appl, Component owner, Collection<DBFolder> selFolders, DBUser user) {
        super(appl, owner, selFolders, user);
    }

    protected boolean doRecupForExport(DBFolder dbFolder, List<GeneralError<DBFolder>> errors) {
        if (!dbFolder.isVersion()) {
            return true;
        }
        switch (dbFolder.getFamily()) {
            case FMEA_MODEL: {
                errors.add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.getString("MSG_ANONYMISE_ERR_TYPE_DATA"), MsgType.ERROR));
                return false;
            }
            case PROJECT: {
                switch (dbFolder.getFamilyFlag()) {
                    case 4: {
                        errors.add(new GeneralError<DBFolder>(dbFolder, ResMsgObj.getString("MSG_ANONYMISE_ERR_TYPE_DATA"), MsgType.ERROR));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected boolean recupForExport(DBFolder dbFolder) {
        return this.doRecupForExport(dbFolder, this.getErrors());
    }

    @Override
    protected GenerateExport createGenerateExport() {
        return new GenerateExport(this.getAppl().getDAOFactory(), this._dbUser){

            @Override
            protected void folderIsValid(DBFolder dbFolder) {
                CmdAnonymizeXML.this.doRecupForExport(dbFolder, this.getErrors());
            }
        };
    }

    @Override
    protected void doExport(Set<DBFolder> foldersToExport, File file) {
        AnonymizeExportXML6 doExport = new AnonymizeExportXML6(this.getAppl().getDAOFactory(), foldersToExport);
        doExport.setExportLogs(false);
        doExport.setExportAccess(false);
        doExport.setExportPreferences(null);
        doExport.setZipLimit(0L);
        doExport.setWithLawParameters(this._bAnonymiseParameters);
        try {
            doExport.exportTo(file);
            if (this._generateReport != null) {
                doExport.generateReport(new File(this._generateReport));
            }
        }
        catch (IOException ioe) {
            this.addError(this._srcFolder, ResMsgCore.msgFormat("MSG_EXC_IOE", file.getAbsolutePath(), ioe.getMessage()));
        }
    }

    @Override
    protected File askExportFile() {
        AnonymizeExportDlg dlg = new AnonymizeExportDlg((Window)this.getAppl().getTopWindow(), new File(PlugableUtility.getStrOpt(this.getAppl().getPlugable(), "plugable.option.path", ".")));
        if (!dlg.DoModal()) {
            return null;
        }
        String exportPath = dlg.getExportPath();
        if (exportPath == null) {
            return null;
        }
        this._bAnonymiseParameters = dlg.isAnonymizeLawParameters();
        this._generateReport = dlg.getTracePath();
        return new File(exportPath);
    }
}

