/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.io.xml6;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.io.AbstractCmdExport;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.io.xml6.PerformExportXML6;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CmdExportXML6
extends AbstractCmdExport {
    private static Logger _LOG = null;

    private static synchronized Logger getLogger() {
        return _LOG != null ? _LOG : (_LOG = Logger.getLogger(CmdExportXML6.class.getName()));
    }

    public CmdExportXML6(CeciliaAppl appl, Component owner, Collection<DBFolder> selFolders, DBUser user) {
        super(appl, owner, selFolders, user);
    }

    @Override
    protected void doExport(Set<DBFolder> foldersToExport, File file) {
        PerformExportXML6 doExport = new PerformExportXML6(this.getAppl().getDAOFactory(), foldersToExport);
        PluginWithOptions opts = this.getAppl().getPreferencies().getOptions(GeneralIOPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralIOPreferencies) {
            GeneralIOPreferencies gpref = (GeneralIOPreferencies)opts;
            doExport.setExportLogs(gpref.getExportLogs());
            doExport.setExportAccess(gpref.getExportAccess());
            if (gpref.getExportPreferences()) {
                StringBuilder save = new StringBuilder();
                try {
                    this.getAppl().getPlugable().savePreferencies(save, "  ");
                    doExport.setExportPreferences(save.toString());
                }
                catch (IOException e) {
                    CmdExportXML6.getLogger().log(Level.INFO, "Probleme lors de l'export des preferences", e);
                }
            }
            doExport.setZipLimit(gpref.getExportZipLimit());
        }
        try {
            doExport.exportTo(file);
        }
        catch (IOException ioe) {
            this.addError(this._srcFolder, ResMsgCore.msgFormat("MSG_EXC_IOE", file.getAbsolutePath(), ioe.getMessage()));
        }
    }
}

