/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ConfigReconnectDlg;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.dao.DAOPreference;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanLicenseManager;
import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.CryptData;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.CeciliaPlugable;
import com.dassault.cecilia.main.cecilia.OpenFolderList;
import com.dassault.cecilia.main.cecilia.ResIcoCecilia;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import java.awt.Image;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CeciliaAppl
extends CAppl {
    private static Logger _LOG = Logger.getLogger(CeciliaAppl.class.getPackage().getName());
    private boolean _bReader;
    OpenFolderList _openFolders;
    Preferencies _preferencies;
    public static final String PROP_TITLE_ADDCONNECT = "cecilia.gui.TitleWithConnect";

    public CeciliaAppl(boolean reader) {
        this._bReader = reader;
        this._openFolders = new OpenFolderList();
        class BanCeciliaLicenseManager
        extends BanLicenseManager {
            BanCeciliaLicenseManager() {
            }

            protected void validLicense(BanProcess process) throws BanLicenseException {
            }

            protected byte[] getData(int value) {
                String name = "Cecilia6";
                switch (value) {
                    case 1: {
                        return name.getBytes();
                    }
                    case 2: {
                        return CryptData.cryptData((String)name, (String)"zertyghjklmpqwxc").getBytes();
                    }
                    case 3: {
                        return "zertyghjklmpqwxc".getBytes();
                    }
                }
                return null;
            }
        }
        BanLicenseManager.defineManager((BanLicenseManager)new BanCeciliaLicenseManager());
    }

    @Override
    public boolean isReader() {
        return this._bReader;
    }

    @Override
    public CeciliaGUI getTopWindow() {
        return (CeciliaGUI)super.getTopWindow();
    }

    @Override
    public CECFactory getDAOFactory() {
        return (CECFactory)this._daoFactory;
    }

    @Override
    public String getTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResMsgCecilia.getString("TITLE_CECILIA"));
        if (this._sqlConnect != null) {
            sb.append("  [").append(this._sqlConnect.getName());
            if (Boolean.getBoolean(PROP_TITLE_ADDCONNECT)) {
                sb.append(" : ").append(this._sqlConnect.getConnectionUrl());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public ImageIcon getSplashIcon() {
        return new ImageIcon(ResIcoCecilia.getInstance().getImage("SPLASH_CECILIA", 500, 500));
    }

    @Override
    public List<? extends Image> getIcons() {
        int size = 16;
        return Arrays.asList(ResIcoCecilia.getInstance().getImage("FRAME_CECILIA", 1 * size, 1 * size), ResIcoCecilia.getInstance().getImage("FRAME_CECILIA", 2 * size, 2 * size), ResIcoCecilia.getInstance().getImage("FRAME_CECILIA", 3 * size, 3 * size), ResIcoCecilia.getInstance().getImage("FRAME_CECILIA", 4 * size, 4 * size), ResIcoCecilia.getInstance().getImage("FRAME_CECILIA", 8 * size, 8 * size));
    }

    protected boolean verifyDemoVersion(StringBuffer msgLicense) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date compilDate = df.parse("2024-10-16");
            long time1 = compilDate.getTime();
            long time2 = new Date().getTime();
            if ((time1 += 8035200000L) < time2) {
                msgLicense.append("Version expired");
                return false;
            }
        }
        catch (ParseException e) {
            _LOG.log(Level.INFO, "Parse compil date: 2024-10-16", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean verifyLicense(StringBuffer msgLicense) {
        return super.verifyLicense(msgLicense);
    }

    @Override
    public String getModuleName() {
        return "CECILIA";
    }

    @Override
    public boolean standardDatabaseConnection() {
        if (!super.standardDatabaseConnection()) {
            return false;
        }
        this._daoFactory = ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO ? new DemoLimitedFactory(this, this._daoFactory) : new CeciliaFactory(this, this._daoFactory);
        if (!this.verifyMigration60()) {
            return false;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            try {
                ((DemoLimitedFactory)this._daoFactory).verifyBaseLimitsCounter(true);
            }
            catch (DemoLimitedException exc) {
                _LOG.info("DemoLimit: " + exc.getMessage());
                JOptionPane.showMessageDialog(this.getTopWindow(), ResMsgCore.getString("DEMO_ERROR_BASE"), this.getTitle(), 0);
                return false;
            }
        }
        return true;
    }

    public CeciliaPlugable getPlugable() {
        return this.getTopWindow().getPlugable();
    }

    public OpenFolderList getOpenFolders() {
        return this._openFolders;
    }

    @Override
    public void refreshFolders(boolean bOnlyProject) {
        if (bOnlyProject) {
            this.getTopWindow().getFolders().getTree(DBFolder.Family.PROJECT).doRefresh();
        } else {
            super.refreshFolders(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Preferencies getPreferencies() {
        if (this._preferencies == null) {
            CeciliaAppl ceciliaAppl = this;
            synchronized (ceciliaAppl) {
                if (this._preferencies == null) {
                    this._preferencies = new Preferencies(){

                        @Override
                        public void incRefresh() {
                            super.incRefresh();
                            if (CECILIAClient.withOneOrMoreDistribClient() && !CECILIAClient.isActive() && CECILIAClient.getCECILIAClient() != null) {
                                CeciliaAppl.this.addCloseableAction(new CApplInit.CloseableAction(){

                                    @Override
                                    public void callClose() {
                                        CECILIAClient.getCECILIAClient().cancelAllRequest(true);
                                    }
                                });
                            }
                        }
                    };
                }
            }
        }
        return this._preferencies;
    }

    public boolean savePreferencies() {
        block5: {
            StringBuilder save = new StringBuilder();
            try {
                save.append("<?xml version='1.0'?>\n");
                this.getPlugable().savePreferencies(save, "");
                DAOPreference daoPref = this.getDAOFactory().createPreferenceDAO();
                DBPreference pref = daoPref.find(this.getDBUser(), "Default");
                if (pref == null) {
                    pref = new DBPreference().setName("Default").setUser(this.getDBUser());
                    pref.setValue(save.toString());
                    pref = daoPref.create(pref);
                    if (pref == null) {
                        _LOG.warning("Probleme lors de la creation des preferences de '" + this.getDBUser().getName() + "'");
                        break block5;
                    }
                    return true;
                }
                pref.setValue(save.toString());
                if (!daoPref.update(pref)) {
                    _LOG.warning("Probleme lors de la sauvegarde des preferences de '" + this.getDBUser().getName() + "'");
                    break block5;
                }
                return true;
            }
            catch (IOException e) {
                _LOG.log(Level.SEVERE, "Probleme lors de la sauvegarde des preferences de '" + this.getDBUser().getName() + "'", e);
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (!this._dbUser.isAdmin()) {
            this.savePreferencies();
        }
        super.close();
    }

    @Override
    public void stopApplication() {
        super.stopApplication();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConfigReconnectDlg dlg;
                ConfigReconnectDlg configReconnectDlg = dlg = ConfigReconnectDlg.getInstance(CeciliaAppl.this.getTopWindow(), CeciliaAppl.this.getTitle());
                synchronized (configReconnectDlg) {
                    if (dlg.displayIfNotVisible()) {
                        if (!dlg.getResult()) {
                            CeciliaAppl.this.getTopWindow().confirmQuitAndClose(true);
                        } else {
                            CeciliaAppl.this.setDBSession(new Object());
                        }
                    }
                }
            }
        });
    }
}

