/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.core.ConfigException;
import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ConfigReconnectDlg;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.LaunchIniReader;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.action.DelegateAction;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.cecilia.pref.GeneralCatsPreferencies;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.faulttree.FTPreferencies;
import com.dassault.cecilia.dbobj.fmea.gui.DBTableFMEAPrintPreferencies;
import com.dassault.cecilia.dbobj.general.icon.gui.IconFrameManager;
import com.dassault.cecilia.dbobj.general.log.GeneralLogsPreferencies;
import com.dassault.cecilia.dbobj.general.pref.DependenciesPrintPreferencies;
import com.dassault.cecilia.dbobj.mbsa.MBSAPreferencies;
import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisonsPanel;
import com.dassault.cecilia.io.GeneralIOPreferencies;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaMenus;
import com.dassault.cecilia.main.cecilia.CeciliaPlugable;
import com.dassault.cecilia.main.cecilia.CeciliaToolBars;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.OpenFolderList;
import com.dassault.cecilia.main.cecilia.ResMsgCecilia;
import com.dassault.cecilia.main.cecilia.actions.CriticityActions;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import com.dassault.cecilia.main.cecilia.actions.EglActions;
import com.dassault.cecilia.main.cecilia.actions.FolderActions;
import com.dassault.cecilia.main.cecilia.actions.GeneralsActions;
import com.dassault.cecilia.main.cecilia.actions.OcasActions;
import com.dassault.cecilia.main.cecilia.gui.AltaDesktopPane;
import com.dassault.cecilia.main.cecilia.gui.ArborButtonOperator;
import com.dassault.cecilia.main.cecilia.gui.CDesktopPane;
import com.dassault.cecilia.main.cecilia.gui.CFoldersPanel;
import com.dassault.cecilia.main.cecilia.gui.CHorizontalScrollBox;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import com.dassault.cecilia.main.cecilia.gui.CPanelInformations;
import com.dassault.cecilia.main.cecilia.gui.ConfirmCloseOrSaveDlg;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import com.dassault.cecilia.main.cecilia.gui.DesktopPreferencies;
import com.dassault.cecilia.main.cecilia.gui.DlgPreferencies;
import com.dassault.cecilia.main.cecilia.gui.OpenFoldersPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class CeciliaGUI
extends JFrame {
    private static Logger _LOG = Logger.getLogger(CeciliaGUI.class.getName());
    private DeclareActions _actions = new DeclareActions();
    CeciliaMenus _menus;
    CeciliaToolBars _toolbars;
    JPanel _panelToolBars;
    CHorizontalScrollBox _ctrlToolBars;
    ArborButtonOperator _ctrlArbor;
    CFoldersPanel _ctrlFolders;
    CDesktopPane _ctrlDesktop;
    CPanelInformations _panelInformations;
    IconFrameManager _iconFrame;
    DBComparaisonsPanel.DBComparaisonsFrame _comparaisonsFrame;
    DlgPreferencies _dlgPreferencies;
    CentralizedStepper _centralizedStepper;
    CeciliaAppl _application;
    CeciliaPlugable _plugable;
    OpenFoldersPanel _openedObjectsPane;
    DlgPreferenciesCreator _prefsUtility = new DlgPreferenciesCreator();

    public CeciliaGUI(CeciliaAppl appl) {
        this._application = appl;
        this._application.setTopWindow(this);
    }

    public CeciliaAppl getApplication() {
        return this._application;
    }

    public CeciliaPlugable getPlugable() {
        return this._plugable;
    }

    public CDesktopPane getDesktop() {
        return this._ctrlDesktop;
    }

    public CeciliaToolBars getToolbars() {
        return this._toolbars;
    }

    public CFoldersPanel getFolders() {
        return this._ctrlFolders;
    }

    public CentralizedStepper getCentralizedStepper() {
        return this._centralizedStepper;
    }

    public void init(StringBuffer logBuffer) {
        boolean launch;
        block11: {
            this._application.init(logBuffer);
            this.setTitle(this._application.getTitle());
            this.setIconImages(this._application.getIcons());
            this.setDefaultCloseOperation(0);
            launch = false;
            try {
                ConfigManager.getInstance().login();
            }
            catch (ConfigException e) {
                _LOG.severe(e.getMessage());
                JOptionPane.showMessageDialog(null, ResMsgVoc.msgFormat("CONFIG_STD_NOTFOUND", e.getMessage()), this._application.getTitle(), 0);
                break block11;
            }
            if (this._application.standardDatabaseConnection() && !(ConfigManager.getVersion() != ConfigManager.TypeVersion.DEMO && ConfigManager.getVersion() != ConfigManager.TypeVersion.READER ? ConfigManager.getVersion() != ConfigManager.TypeVersion.READER && !this._application.standardUserLogin(false, false) : !this._application.standardUserLoginForDemo())) {
                if (this._application.openSession()) {
                    if (ConfigManager.getVersion() == ConfigManager.TypeVersion.STD) {
                        this._application.addShedulerTask(new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (!CeciliaGUI.this._application.isDBSessionValid()) {
                                    ConfigReconnectDlg dlg;
                                    ConfigReconnectDlg configReconnectDlg = dlg = ConfigReconnectDlg.getInstance(CeciliaGUI.this, CeciliaGUI.this.getTitle());
                                    synchronized (configReconnectDlg) {
                                        if (!CeciliaGUI.this._application.isDBSessionValid() && dlg.displayIfNotVisible()) {
                                            if (!dlg.getResult()) {
                                                CeciliaGUI.this.confirmQuitAndClose(true);
                                            } else {
                                                CeciliaGUI.this._application.setDBSession(new Object());
                                            }
                                        }
                                    }
                                }
                            }
                        }, 1000L, 2000L);
                    }
                    this._plugable = new CeciliaPlugable(this._application, this);
                    DBPreference pref = this.getApplication().getDAOFactory().createPreferenceDAO().find(this.getApplication().getDBUser(), "Default");
                    if (pref != null && !pref.getValue().isEmpty()) {
                        try {
                            this._plugable.loadPreferencies(new StringReader(pref.getValue()));
                        }
                        catch (IOException e) {
                            _LOG.log(Level.SEVERE, "Probleme lors de la lecture des preferences de '" + this.getApplication().getDBUser().getName() + "'", e);
                        }
                    }
                    boolean resetPlugMng = this.loadPluginManager();
                    Preferencies prefs = this.getApplication().getPreferencies();
                    GeneralCatsPreferencies.createCategories(prefs);
                    prefs.addOptions(new GeneralTextPreferencies());
                    prefs.addOptions(new DesktopPreferencies());
                    prefs.addOptions(new GeneralLogsPreferencies());
                    prefs.addOptions(new GeneralIOPreferencies());
                    prefs.addOptions(prefs.createPLugCategorie("GENERAL/PRINT", "GENERAL", ResMsgCore.getString("PREF_GENERAL_PRINT_TITLE"), ResMsgCore.getString("PREF_GENERAL_PRINT_TITLE"), ResMsgCore.getString("PREF_GENERAL_PRINT_PANEL")));
                    prefs.addOptions(new DBTableFMEAPrintPreferencies());
                    prefs.addOptions(new DependenciesPrintPreferencies());
                    if (ConfigManager.getInstance().isValid()) {
                        FTPreferencies.createCategories(prefs);
                        MBSAPreferencies.createCategories(prefs, this._application);
                        this.makePanel();
                        this.attachPluginManager(resetPlugMng);
                        this.buildPluginPreferencies();
                        prefs.incRefresh();
                        this.getAction("DISTRIB_MANAGER").setEnabled(CECILIAClient.withOneOrMoreDistribClient());
                        this.prepareDlgPreferencies();
                        this.pack();
                        launch = true;
                    }
                }
            }
        }
        if (!launch) {
            this._application.exit(0);
        } else {
            this.setTitle(this._application.getTitle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadPluginManager() {
        File pluginFile = new File(PluginManager.PLUGIN_PATH, PluginManager.PLUGIN_FILE);
        if (!pluginFile.exists()) {
            _LOG.info("PluginManager - Le fichier de definission des plugins n'existe pas : " + pluginFile);
            File defaultPluginFile = new File(PluginManager.DEFAULT_PLUGIN_FILE);
            if (defaultPluginFile.exists()) {
                _LOG.info("PluginManager - Le fichier de definission des plugins de secours n'existe pas : " + defaultPluginFile);
                try {
                    FileUtility.copyFile((File)defaultPluginFile, (File)pluginFile);
                }
                catch (IOException e) {
                    _LOG.log(Level.WARNING, "PluginManager - Impossible de copier le fichier de plugins par defaut : " + pluginFile, e);
                }
            }
        }
        if (pluginFile.exists()) {
            boolean e;
            block12: {
                InputStream stream = null;
                try {
                    _LOG.finer("PluginManager - Chargement du fichier de definission des plugins: " + pluginFile);
                    stream = new BufferedInputStream(new FileInputStream(pluginFile));
                    boolean bl = e = !this._plugable.loadPluginManager(stream, pluginFile.getParent());
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        _LOG.log(Level.WARNING, "Impossible de lire le fichier des plugins : " + pluginFile, ioe);
                        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCecilia.getString("MSG_PLUGABLE_ERR_UNCOMPATIBLE_FILE"), this.getTitle(), 2);
                    }
                }
                stream.close();
            }
            return e;
        } else {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCecilia.msgFormat("MSG_PLUGABLE_ERR_DONT_EXIST", pluginFile), this.getTitle(), 1);
        }
        this._plugable.resetPluginManager(pluginFile);
        return true;
    }

    protected void attachPluginManager(boolean resetPluginManager) {
        File pluginFile = new File(PluginManager.PLUGIN_PATH, PluginManager.PLUGIN_FILE);
        if (!resetPluginManager && !this._plugable.attachPluginManager()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCecilia.getString("MSG_PLUGABLE_ERR_UNCOMPATIBLE_PLUGINS"), this.getTitle(), 2);
            this._plugable.resetPluginManager(pluginFile);
            resetPluginManager = true;
        }
        boolean canWrite = FileUtility.canWrite((File)pluginFile);
        this.setEnabledAction("PLUGIN_MANAGER", canWrite);
    }

    private void buildPluginPreferencies(Preferencies prefs, String pluginType) {
        List pluginKeys = this._plugable.getPlugins(pluginType);
        Iterator iterator = pluginKeys.iterator();
        int cpt = 0;
        while (iterator.hasNext()) {
            String pluginKey = (String)iterator.next();
            PluginModel plugin = this._plugable.getPlugin(pluginKey);
            if (!plugin.withOption(null)) continue;
            ++cpt;
        }
        Preferencies.Item catPref = prefs.getItem(pluginType);
        if (catPref != null) {
            ArrayList<Preferencies.Item> removesItem = new ArrayList<Preferencies.Item>();
            for (Preferencies.Item ipref : prefs.getAllItems()) {
                if (!pluginType.equals(ipref.getOwner())) continue;
                ipref.setOwner(null);
                removesItem.add(ipref);
            }
            prefs.removeItem(catPref);
            for (Preferencies.Item ipref : removesItem) {
                prefs.removeItem(ipref);
            }
        }
        if (cpt == 0) {
            return;
        }
        PluginWithOptions plug = prefs.createPLugCategorie(pluginType, null, "Plugins - " + pluginType, ResMsgCecilia.getString("OPT_PLUGIN_TITLE") + " " + pluginType, ResMsgCecilia.getString("OPT_PLUGIN_LEGEND") + " " + pluginType);
        prefs.addOptions(plug);
        for (String pluginKey : pluginKeys) {
            Preferencies.Item ipref;
            PluginModel plugin = this._plugable.getPlugin(pluginKey);
            if (!plugin.withOption(this._plugable) || (ipref = prefs.addOptions(plugin)) == null) continue;
            ipref.setOwner(pluginType);
        }
    }

    public void buildPluginPreferencies() {
        Preferencies prefs = this.getApplication().getPreferencies();
        this.buildPluginPreferencies(prefs, "PluginAction");
        this.buildPluginPreferencies(prefs, "PluginStepper");
        this.buildPluginPreferencies(prefs, "PluginTranslate");
        this.buildPluginPreferencies(prefs, "PluginTreatment");
        this.getApplication().getPreferencies().computeItems(this.getPlugable());
    }

    private void makePanel() {
        this.makeActions();
        this.makeMenu();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CeciliaGUI.this.confirmQuitAndClose();
                super.windowClosing(e);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        int posY = 0;
        this.getContentPane().add(this.makeTopPanel(), new GridBagConstraints(0, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add(this.makeCenterPanel(), new GridBagConstraints(0, posY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(this.makeBottomPanel(), new GridBagConstraints(0, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.getApplication().getPreferencies().addPreferenciesListener(this._ctrlDesktop.getDesktop());
        this._centralizedStepper.connectComponents();
        this._actions.setInitialEnabledActions(this._application.isReader());
    }

    private Component makeTopPanel() {
        this._panelToolBars = new JPanel(new GridBagLayout());
        this._ctrlToolBars = new CHorizontalScrollBox();
        this._ctrlToolBars.getPanelContainer().setLayout(new FlowLayout(0, 2, 2));
        this._toolbars = new CeciliaToolBars(this._actions, this.getApplication().isReader());
        this._toolbars.createBar(this._ctrlToolBars.getPanelContainer());
        this._panelToolBars.add((Component)this._ctrlToolBars, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        return this._panelToolBars;
    }

    private Component makeBottomPanel() {
        this._panelInformations = new CPanelInformations(this._application);
        return this._panelInformations;
    }

    private Component makeCenterPanel() {
        this._ctrlDesktop = new CDesktopPane(this._actions);
        JSplitPane result = new JSplitPane(1);
        result.setDividerLocation(200);
        result.setLeftComponent(this.makeLeftPanel());
        result.setRightComponent(this._ctrlDesktop);
        result.setOneTouchExpandable(true);
        return result;
    }

    private Component makeFoldersPanel() {
        DAOFolder daoFolder = this._application.getDAOFactory().createFolderDAO();
        DBFolder root = daoFolder.getRootID("ROOT");
        List<DBFolder> roots = root.getChildren();
        if (roots == null) {
            roots = daoFolder.findChildren(root);
        }
        this._ctrlFolders = new CFoldersPanel(this._application, this._application.getDBUser(), new ArrayList<DBFolder>(roots));
        return this._ctrlFolders;
    }

    private Component makeLeftPanel() {
        JSplitPane result = new JSplitPane(0);
        result.setDividerLocation(600);
        result.setOneTouchExpandable(true);
        result.setTopComponent(this.makeFoldersPanel());
        result.setBottomComponent(this.makeOpenedObjectsPane());
        return result;
    }

    private Component makeOpenedObjectsPane() {
        final OpenFolderList openFolders = this.getApplication().getOpenFolders();
        this._openedObjectsPane = new OpenFoldersPanel(openFolders);
        this.getDesktop().getDesktop().addChangeSelectedFrameListener(new AltaDesktopPane.ChangeSelectedFrameListener(){

            @Override
            public void selectChanged(AltaDesktopPane.ChangeSelectedFrameEvent event) {
                DBFolder folder = event.getFolder();
                if (folder != null) {
                    openFolders.selectOpenFolder(folder, event.getFrame());
                }
            }
        });
        return this._openedObjectsPane;
    }

    private void makeActions() {
        new GeneralsActions(this._application, this).make(this._actions);
        new OcasActions(this._application, this).make(this._actions);
        new CriticityActions(this._application, this).make(this._actions);
        new EglActions(this._application, this).make(this._actions);
        new FolderActions(this._application, this).make(this._actions);
        this._centralizedStepper = new CentralizedStepper(this._application, this);
        this._centralizedStepper.make(this._actions);
    }

    public CeciliaAction getAction(String key) {
        CeciliaAction action = this._actions.getAction(key);
        if (action == null) {
            _LOG.severe("Pas d'action de defini pour la cle : " + key);
        }
        return action;
    }

    public void setEnabledAction(String key, boolean enabled) {
        CeciliaAction action = this.getAction(key);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public DelegateAction getDelegateAction(String key) {
        CeciliaAction action = this.getAction(key);
        if (action != null) {
            if (action instanceof DelegateAction) {
                return (DelegateAction)action;
            }
            _LOG.severe("L'action n'est pas delegate : " + key);
        }
        return null;
    }

    public JComponent getComponentAction(String key) {
        JComponent component = this._toolbars.getComponent(key);
        if (component == null) {
            _LOG.severe("Pas de composant de defini pour la cle : " + key);
        }
        return component;
    }

    public JMenu getMenuAction(String key) {
        JMenu menu = this._menus.getMenu(key);
        if (menu == null) {
            _LOG.severe("Pas de menu de defini pour la cle : " + key);
        }
        return menu;
    }

    private void makeMenu() {
        this._menus = new CeciliaMenus(this._actions, this.getApplication().isDebugMode(), this.getApplication().isReader());
        this.setJMenuBar(this._menus.createBar());
    }

    public void refreshMenubarAndToolbars() {
        this._ctrlToolBars.revalidate();
        this._ctrlToolBars.repaint();
        this.getJMenuBar().validate();
        this.getJMenuBar().repaint();
    }

    public void displayComparatorManager(DBComparaisons compare, String wrapName1, String wrapName2) {
        if (this._comparaisonsFrame == null) {
            this._comparaisonsFrame = new DBComparaisonsPanel.DBComparaisonsFrame();
        }
        this._comparaisonsFrame.setComparisons(compare, wrapName1, wrapName2);
        this.showFrame(this._comparaisonsFrame);
    }

    public void displayIconManager() {
        if (this._iconFrame == null) {
            this._iconFrame = new IconFrameManager(this._application);
        }
        this.showFrame(this._iconFrame);
    }

    private void showFrame(CInternalFrame frame) {
        if (frame != null) {
            if (!frame.isVisible()) {
                frame.showView(this.getDesktop());
            } else {
                frame.toFront();
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private void prepareDlgPreferencies() {
        new Thread((Runnable)this._prefsUtility, "CreateDlgPreferencies").start();
    }

    public DlgPreferencies getDlgPreferencies() {
        if (this._dlgPreferencies == null) {
            CThread thread = new CThread(this){

                @Override
                protected void firstDo() {
                    CeciliaGUI.this._prefsUtility.createPreferencies();
                }
            };
            thread.realiseDo();
        }
        return this._dlgPreferencies;
    }

    public void displayPreferencies() {
        if (this._dlgPreferencies == null) {
            CThread thread = new CThread(this){

                @Override
                protected void firstDo() {
                    CeciliaGUI.this._prefsUtility.createPreferencies();
                }
            };
            thread.realiseDo();
        }
        this._dlgPreferencies.setVisible(true);
    }

    public void confirmQuitAndClose() {
        this.confirmQuitAndClose(false);
    }

    public void confirmQuitAndClose(boolean forceClose) {
        ArrayList errors = new ArrayList();
        if (!this.getPlugable().getTaskManager().requestExit(forceClose)) {
            return;
        }
        if (!this.confirmSaveAndClose(errors, forceClose)) {
            return;
        }
        if (!errors.isEmpty()) {
            DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError((Window)this);
            dlg.setTitle(ResMsgVoc.getString("VOC_ERROR") + " - " + this.getTitle());
            dlg.setErrors(errors);
            dlg.setModal(true);
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
            dlg.setVisible(true);
        }
        _LOG.info("Exit Cecilia !");
        this._application.close();
    }

    private boolean confirmSaveAndClose(List<GeneralError<DBFolder>> errors, boolean forceClose) {
        boolean showConfirmMessag = false;
        Collection<DBFolder> saveFolders = null;
        HashMap<DBFolder, DBInternalFrame> openFolders = new HashMap<DBFolder, DBInternalFrame>();
        for (OpenFolder openFolder : this._application.getOpenFolders().getOpenFolders()) {
            openFolders.put(openFolder.getDBFolder(), openFolder.getAccess());
        }
        if (!openFolders.isEmpty()) {
            ArrayList<DBFolder> possibleSavedFolders = new ArrayList<DBFolder>();
            for (Map.Entry entry : openFolders.entrySet()) {
                DBInternalFrame openAccess = (DBInternalFrame)entry.getValue();
                if (!openAccess.isModified() || openAccess.isReadOnly()) continue;
                possibleSavedFolders.add((DBFolder)entry.getKey());
            }
            if (!possibleSavedFolders.isEmpty()) {
                showConfirmMessag = true;
                ConfirmCloseOrSaveDlg dlg = new ConfirmCloseOrSaveDlg((Window)this, possibleSavedFolders, forceClose);
                dlg.setVisible(true);
                if (!forceClose && !dlg.getResult()) {
                    return false;
                }
                saveFolders = dlg.getSelectFolders();
            }
        }
        if (!showConfirmMessag && !forceClose) {
            showConfirmMessag = true;
            int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCecilia.getString("MSG_APP_CONFIRM_QUIT"), this.getTitle(), 2, -1);
            if (result != 0) {
                return false;
            }
        }
        if (saveFolders != null && !saveFolders.isEmpty()) {
            for (DBFolder dbFolder : saveFolders) {
                DBInternalFrame access = (DBInternalFrame)openFolders.get(dbFolder);
                if (access.verifyData() && access.save()) continue;
                errors.add(new GeneralError<DBFolder>(dbFolder, ResMsgCore.getString("MSG_ERR_SAVE_MODEL")));
            }
        }
        if (!openFolders.isEmpty()) {
            DAOObject daoObject = this._application.getDAOFactory().createObjectDAO();
            DBSession applSession = this._application.getDBSession();
            for (DBFolder dbFolder : openFolders.keySet()) {
                DBSession dbSession;
                if (!dbFolder.getObject().isLocked() || (dbSession = dbFolder.getObject().getLockedSession()) == null || !dbSession.equals(applSession) || daoObject.unlock(dbFolder.getObject(), applSession)) continue;
                errors.add(new GeneralError<DBFolder>(dbFolder, ResMsgCore.getString("MSG_ERR_UNLOCK_MODEL")));
            }
        }
        return true;
    }

    public static void main(String[] args) {
        StringBuffer logBuffer = new StringBuffer();
        LaunchIniReader.initLaunchIni("Cecilia", logBuffer);
        CeciliaAppl application = new CeciliaAppl(false);
        CeciliaGUI mainGUI = new CeciliaGUI(application);
        mainGUI.init(logBuffer);
        mainGUI.setMinimumSize(new Dimension(1366, 768));
        mainGUI.setLocationRelativeTo(null);
        mainGUI.setVisible(true);
    }

    private class DlgPreferenciesCreator
    implements Runnable {
        private DlgPreferenciesCreator() {
        }

        public synchronized void createPreferencies() {
            if (CeciliaGUI.this._dlgPreferencies == null) {
                CeciliaGUI.this._dlgPreferencies = new DlgPreferencies((Window)CeciliaGUI.this, CeciliaGUI.this.getApplication());
            }
        }

        @Override
        public void run() {
            this.createPreferencies();
        }
    }
}

